/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.datasourcemetadata;

import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Functions;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.metamx.common.guava.Sequence;
import org.apache.hive.druid.com.metamx.common.guava.Sequences;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceMetricEvent;
import org.apache.hive.druid.io.druid.query.BySegmentSkippingQueryRunner;
import org.apache.hive.druid.io.druid.query.CacheStrategy;
import org.apache.hive.druid.io.druid.query.DataSourceUtil;
import org.apache.hive.druid.io.druid.query.DruidMetrics;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryToolChest;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.aggregation.MetricManipulationFn;
import org.apache.hive.druid.io.druid.query.datasourcemetadata.DataSourceMetadataQuery;
import org.apache.hive.druid.io.druid.query.datasourcemetadata.DataSourceMetadataResultValue;
import org.apache.hive.druid.io.druid.timeline.LogicalSegment;
import org.joda.time.ReadableInterval;

public class DataSourceQueryQueryToolChest
extends QueryToolChest<Result<DataSourceMetadataResultValue>, DataSourceMetadataQuery> {
    private static final TypeReference<Result<DataSourceMetadataResultValue>> TYPE_REFERENCE = new TypeReference<Result<DataSourceMetadataResultValue>>(){};

    @Override
    public <T extends LogicalSegment> List<T> filterSegments(DataSourceMetadataQuery query, List<T> segments) {
        if (segments.size() <= 1) {
            return segments;
        }
        final LogicalSegment max = (LogicalSegment)segments.get(segments.size() - 1);
        return Lists.newArrayList(Iterables.filter(segments, new Predicate<T>(){

            @Override
            public boolean apply(T input) {
                return max != null && input.getInterval().overlaps((ReadableInterval)max.getInterval());
            }
        }));
    }

    @Override
    public QueryRunner<Result<DataSourceMetadataResultValue>> mergeResults(QueryRunner<Result<DataSourceMetadataResultValue>> runner) {
        return new BySegmentSkippingQueryRunner<Result<DataSourceMetadataResultValue>>(runner){

            @Override
            protected Sequence<Result<DataSourceMetadataResultValue>> doRun(QueryRunner<Result<DataSourceMetadataResultValue>> baseRunner, Query<Result<DataSourceMetadataResultValue>> input, Map<String, Object> context) {
                DataSourceMetadataQuery query = (DataSourceMetadataQuery)input;
                return Sequences.simple(query.mergeResults(Sequences.toList(baseRunner.run(query, context), Lists.newArrayList())));
            }
        };
    }

    @Override
    public ServiceMetricEvent.Builder makeMetricBuilder(DataSourceMetadataQuery query) {
        return DruidMetrics.makePartialQueryTimeMetric(query).setDimension("dataSource", DataSourceUtil.getMetricName(query.getDataSource())).setDimension("type", query.getType());
    }

    @Override
    public Function<Result<DataSourceMetadataResultValue>, Result<DataSourceMetadataResultValue>> makePreComputeManipulatorFn(DataSourceMetadataQuery query, MetricManipulationFn fn) {
        return Functions.identity();
    }

    @Override
    public TypeReference<Result<DataSourceMetadataResultValue>> getResultTypeReference() {
        return TYPE_REFERENCE;
    }

    @Override
    public CacheStrategy getCacheStrategy(DataSourceMetadataQuery query) {
        return null;
    }
}

