/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation.post;

import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.io.druid.query.aggregation.PostAggregator;

public class ConstantPostAggregator
implements PostAggregator {
    private final String name;
    private final Number constantValue;

    @JsonCreator
    public ConstantPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="value") Number constantValue) {
        this.name = name;
        this.constantValue = constantValue;
        Preconditions.checkNotNull(this.constantValue);
    }

    @Override
    public Set<String> getDependentFields() {
        return Sets.newHashSet();
    }

    @Override
    public Comparator getComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                return 0;
            }
        };
    }

    @Override
    public Object compute(Map<String, Object> combinedAggregators) {
        return this.constantValue;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="value")
    public Number getConstantValue() {
        return this.constantValue;
    }

    public String toString() {
        return "ConstantPostAggregator{name='" + this.name + '\'' + ", constantValue=" + this.constantValue + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstantPostAggregator that = (ConstantPostAggregator)o;
        if (this.constantValue != null && that.constantValue != null ? this.constantValue.doubleValue() != that.constantValue.doubleValue() : this.constantValue != that.constantValue) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.constantValue != null ? this.constantValue.hashCode() : 0);
        return result;
    }
}

