/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation;

import java.nio.ByteBuffer;
import org.apache.hive.druid.io.druid.query.aggregation.BufferAggregator;
import org.apache.hive.druid.io.druid.segment.LongColumnSelector;

public class LongSumBufferAggregator
implements BufferAggregator {
    private final LongColumnSelector selector;

    public LongSumBufferAggregator(LongColumnSelector selector) {
        this.selector = selector;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        buf.putLong(position, 0L);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position) {
        buf.putLong(position, buf.getLong(position) + this.selector.get());
    }

    @Override
    public Object get(ByteBuffer buf, int position) {
        return buf.getLong(position);
    }

    @Override
    public float getFloat(ByteBuffer buf, int position) {
        return buf.getLong(position);
    }

    @Override
    public long getLong(ByteBuffer buf, int position) {
        return buf.getLong(position);
    }

    @Override
    public void close() {
    }
}

