/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation;

import java.util.Comparator;
import org.apache.hive.druid.com.google.common.primitives.Longs;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.segment.LongColumnSelector;

public class LongSumAggregator
implements Aggregator {
    static final Comparator COMPARATOR = new Comparator(){

        public int compare(Object o, Object o1) {
            return Longs.compare(((Number)o).longValue(), ((Number)o1).longValue());
        }
    };
    private final LongColumnSelector selector;
    private final String name;
    private long sum;

    static long combineValues(Object lhs, Object rhs) {
        return ((Number)lhs).longValue() + ((Number)rhs).longValue();
    }

    public LongSumAggregator(String name, LongColumnSelector selector) {
        this.name = name;
        this.selector = selector;
        this.sum = 0L;
    }

    @Override
    public void aggregate() {
        this.sum += this.selector.get();
    }

    @Override
    public void reset() {
        this.sum = 0L;
    }

    @Override
    public Object get() {
        return this.sum;
    }

    @Override
    public float getFloat() {
        return this.sum;
    }

    @Override
    public long getLong() {
        return this.sum;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Aggregator clone() {
        return new LongSumAggregator(this.name, this.selector);
    }

    @Override
    public void close() {
    }
}

