/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation;

import java.util.Comparator;
import org.apache.hive.druid.com.google.common.primitives.Longs;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.query.aggregation.Histogram;
import org.apache.hive.druid.io.druid.segment.FloatColumnSelector;

public class HistogramAggregator
implements Aggregator {
    static final Comparator COMPARATOR = new Comparator(){

        public int compare(Object o, Object o1) {
            return Longs.compare(((Histogram)o).count, ((Histogram)o1).count);
        }
    };
    private final FloatColumnSelector selector;
    private final String name;
    private Histogram histogram;

    static Object combineHistograms(Object lhs, Object rhs) {
        return ((Histogram)lhs).fold((Histogram)rhs);
    }

    public HistogramAggregator(String name, FloatColumnSelector selector, float[] breaks) {
        this.name = name;
        this.selector = selector;
        this.histogram = new Histogram(breaks);
    }

    @Override
    public void aggregate() {
        this.histogram.offer(this.selector.get());
    }

    @Override
    public void reset() {
        this.histogram = new Histogram(this.histogram.breaks);
    }

    @Override
    public Object get() {
        return this.histogram;
    }

    @Override
    public float getFloat() {
        throw new UnsupportedOperationException("HistogramAggregator does not support getFloat()");
    }

    @Override
    public long getLong() {
        throw new UnsupportedOperationException("HistogramAggregator does not support getLong()");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void close() {
    }
}

