/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation;

import java.util.Comparator;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.query.aggregation.LongSumAggregator;

public class CountAggregator
implements Aggregator {
    static final Comparator COMPARATOR = LongSumAggregator.COMPARATOR;
    long count = 0L;
    private final String name;

    static Object combineValues(Object lhs, Object rhs) {
        return ((Number)lhs).longValue() + ((Number)rhs).longValue();
    }

    public CountAggregator(String name) {
        this.name = name;
    }

    @Override
    public void aggregate() {
        ++this.count;
    }

    @Override
    public void reset() {
        this.count = 0L;
    }

    @Override
    public Object get() {
        return this.count;
    }

    @Override
    public float getFloat() {
        return this.count;
    }

    @Override
    public long getLong() {
        return this.count;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Aggregator clone() {
        return new CountAggregator(this.name);
    }

    @Override
    public void close() {
    }
}

