/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.PostAggregator;

public class Queries {
    public static void verifyAggregations(List<AggregatorFactory> aggFactories, List<PostAggregator> postAggs) {
        Preconditions.checkNotNull(aggFactories, "aggregations cannot be null");
        HashSet<String> aggNames = Sets.newHashSet();
        for (AggregatorFactory aggFactory : aggFactories) {
            Preconditions.checkArgument(aggNames.add(aggFactory.getName()), "[%s] already defined", aggFactory.getName());
        }
        if (postAggs != null && !postAggs.isEmpty()) {
            HashSet<String> combinedAggNames = Sets.newHashSet(aggNames);
            for (PostAggregator postAgg : postAggs) {
                Set<String> dependencies = postAgg.getDependentFields();
                Sets.SetView<String> missing = Sets.difference(dependencies, combinedAggNames);
                Preconditions.checkArgument(missing.isEmpty(), "Missing fields [%s] for postAggregator [%s]", missing, postAgg.getName());
                Preconditions.checkArgument(combinedAggNames.add(postAgg.getName()), "[%s] already defined", postAgg.getName());
            }
        }
    }
}

