/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.data.input.impl;

import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.com.metamx.common.parsers.ParseException;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.data.input.MapBasedInputRow;
import org.apache.hive.druid.io.druid.data.input.impl.InputRowParser;
import org.apache.hive.druid.io.druid.data.input.impl.ParseSpec;
import org.joda.time.DateTime;

public class MapInputRowParser
implements InputRowParser<Map<String, Object>> {
    private final ParseSpec parseSpec;

    @JsonCreator
    public MapInputRowParser(@JsonProperty(value="parseSpec") ParseSpec parseSpec) {
        this.parseSpec = parseSpec;
    }

    @Override
    public InputRow parse(Map<String, Object> theMap) {
        DateTime timestamp;
        List<String> dimensions = this.parseSpec.getDimensionsSpec().hasCustomDimensions() ? this.parseSpec.getDimensionsSpec().getDimensionNames() : Lists.newArrayList(Sets.difference(theMap.keySet(), this.parseSpec.getDimensionsSpec().getDimensionExclusions()));
        try {
            timestamp = this.parseSpec.getTimestampSpec().extractTimestamp(theMap);
            if (timestamp == null) {
                String input = theMap.toString();
                throw new NullPointerException(String.format("Null timestamp in input: %s", input.length() < 100 ? input : input.substring(0, 100) + "..."));
            }
        }
        catch (Exception e) {
            throw new ParseException(e, "Unparseable timestamp found!", new Object[0]);
        }
        return new MapBasedInputRow(timestamp.getMillis(), dimensions, theMap);
    }

    @Override
    @JsonProperty
    public ParseSpec getParseSpec() {
        return this.parseSpec;
    }

    @Override
    public InputRowParser withParseSpec(ParseSpec parseSpec) {
        return new MapInputRowParser(parseSpec);
    }
}

