/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.data.input;

import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.data.input.ByteBufferInputRowParser;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.data.input.impl.MapInputRowParser;
import org.apache.hive.druid.io.druid.data.input.impl.ParseSpec;

@JsonTypeName(value="protobuf")
public class ProtoBufInputRowParser
implements ByteBufferInputRowParser {
    private static final Logger log = new Logger(ProtoBufInputRowParser.class);
    private final ParseSpec parseSpec;
    private final MapInputRowParser mapParser;
    private final String descriptorFileInClasspath;

    @JsonCreator
    public ProtoBufInputRowParser(@JsonProperty(value="parseSpec") ParseSpec parseSpec, @JsonProperty(value="descriptor") String descriptorFileInClasspath) {
        this.parseSpec = parseSpec;
        this.descriptorFileInClasspath = descriptorFileInClasspath;
        this.mapParser = new MapInputRowParser(this.parseSpec);
    }

    @Override
    public ParseSpec getParseSpec() {
        return this.parseSpec;
    }

    @Override
    public ProtoBufInputRowParser withParseSpec(ParseSpec parseSpec) {
        return new ProtoBufInputRowParser(parseSpec, this.descriptorFileInClasspath);
    }

    @Override
    public InputRow parse(ByteBuffer input) {
        Map<String, Object> theMap = this.buildStringKeyMap(input);
        return this.mapParser.parse(theMap);
    }

    private Map<String, Object> buildStringKeyMap(ByteBuffer input) {
        Descriptors.Descriptor descriptor = this.getDescriptor(this.descriptorFileInClasspath);
        HashMap<String, Object> theMap = Maps.newHashMap();
        try {
            DynamicMessage message = DynamicMessage.parseFrom((Descriptors.Descriptor)descriptor, (ByteString)ByteString.copyFrom((ByteBuffer)input));
            Map allFields = message.getAllFields();
            for (Map.Entry entry : allFields.entrySet()) {
                String name = ((Descriptors.FieldDescriptor)entry.getKey()).getName();
                if (theMap.containsKey(name)) continue;
                Object value = entry.getValue();
                if (value instanceof Descriptors.EnumValueDescriptor) {
                    Descriptors.EnumValueDescriptor desc = (Descriptors.EnumValueDescriptor)value;
                    value = desc.getName();
                }
                theMap.put(name, value);
            }
        }
        catch (InvalidProtocolBufferException e) {
            log.warn(e, "Problem with protobuf something", new Object[0]);
        }
        return theMap;
    }

    private Descriptors.Descriptor getDescriptor(String descriptorFileInClassPath) {
        try {
            InputStream fin = this.getClass().getClassLoader().getResourceAsStream(descriptorFileInClassPath);
            DescriptorProtos.FileDescriptorSet set = DescriptorProtos.FileDescriptorSet.parseFrom((InputStream)fin);
            Descriptors.FileDescriptor file = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)set.getFile(0), (Descriptors.FileDescriptor[])new Descriptors.FileDescriptor[0]);
            return (Descriptors.Descriptor)file.getMessageTypes().get(0);
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }
}

