/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.collections;

import java.io.IOException;
import java.util.PriorityQueue;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.com.metamx.common.guava.Accumulator;
import org.apache.hive.druid.com.metamx.common.guava.CloseQuietly;
import org.apache.hive.druid.com.metamx.common.guava.Sequence;
import org.apache.hive.druid.com.metamx.common.guava.Yielder;
import org.apache.hive.druid.com.metamx.common.guava.Yielders;
import org.apache.hive.druid.com.metamx.common.guava.YieldingAccumulator;
import org.apache.hive.druid.com.metamx.common.guava.YieldingAccumulators;

public class OrderedMergeSequence<T>
implements Sequence<T> {
    private final Ordering<T> ordering;
    private final Sequence<Sequence<T>> sequences;

    public OrderedMergeSequence(Ordering<T> ordering, Sequence<Sequence<T>> sequences) {
        this.ordering = ordering;
        this.sequences = sequences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <OutType> OutType accumulate(OutType initValue, Accumulator<OutType, T> accumulator) {
        Yielder<OutType> yielder = null;
        try {
            yielder = this.toYielder(initValue, YieldingAccumulators.fromAccumulator(accumulator));
            OutType OutType = yielder.get();
            return OutType;
        }
        finally {
            CloseQuietly.close(yielder);
        }
    }

    @Override
    public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
        PriorityQueue<Yielder<T>> pQueue = new PriorityQueue<Yielder<T>>(32, this.ordering.onResultOf(new Function<Yielder<T>, T>(){

            @Override
            public T apply(Yielder<T> input) {
                return input.get();
            }
        }));
        Yielder<Object> oldDudeAtCrosswalk = this.sequences.toYielder(null, new YieldingAccumulator<Yielder<T>, Sequence<T>>(){

            @Override
            public Yielder<T> accumulate(Yielder<T> accumulated, Sequence<T> in) {
                Yielder<Object> retVal = in.toYielder(null, new YieldingAccumulator<T, T>(){

                    @Override
                    public T accumulate(T accumulated, T in) {
                        this.yield();
                        return in;
                    }
                });
                if (retVal.isDone()) {
                    try {
                        retVal.close();
                    }
                    catch (IOException e) {
                        throw Throwables.propagate(e);
                    }
                    return null;
                }
                this.yield();
                return retVal;
            }
        });
        return this.makeYielder(pQueue, oldDudeAtCrosswalk, initValue, accumulator);
    }

    private <OutType> Yielder<OutType> makeYielder(final PriorityQueue<Yielder<T>> pQueue, Yielder<Yielder<T>> oldDudeAtCrosswalk, OutType initVal, final YieldingAccumulator<OutType, T> accumulator) {
        OutType retVal = initVal;
        while (!(accumulator.yielded() || pQueue.isEmpty() && oldDudeAtCrosswalk.isDone())) {
            Yielder<Object> yielder;
            if (oldDudeAtCrosswalk.isDone()) {
                yielder = (Yielder<T>)pQueue.remove();
            } else if (pQueue.isEmpty()) {
                yielder = oldDudeAtCrosswalk.get();
                oldDudeAtCrosswalk = oldDudeAtCrosswalk.next(null);
            } else {
                Yielder<T> queueYielder = pQueue.peek();
                Yielder<T> iterYielder = oldDudeAtCrosswalk.get();
                if (this.ordering.compare(queueYielder.get(), iterYielder.get()) <= 0) {
                    yielder = (Yielder)pQueue.remove();
                } else {
                    yielder = oldDudeAtCrosswalk.get();
                    oldDudeAtCrosswalk = oldDudeAtCrosswalk.next(null);
                }
            }
            retVal = accumulator.accumulate(retVal, yielder.get());
            yielder = yielder.next(null);
            if (yielder.isDone()) {
                try {
                    yielder.close();
                    continue;
                }
                catch (IOException e) {
                    throw Throwables.propagate(e);
                }
            }
            pQueue.add(yielder);
        }
        if (!accumulator.yielded()) {
            return Yielders.done(retVal, oldDudeAtCrosswalk);
        }
        final OutType yieldVal = retVal;
        final Yielder<Yielder<Object>> finalOldDudeAtCrosswalk = oldDudeAtCrosswalk;
        return new Yielder<OutType>(){

            @Override
            public OutType get() {
                return yieldVal;
            }

            @Override
            public Yielder<OutType> next(OutType initValue) {
                accumulator.reset();
                return OrderedMergeSequence.this.makeYielder(pQueue, finalOldDudeAtCrosswalk, initValue, accumulator);
            }

            @Override
            public boolean isDone() {
                return false;
            }

            @Override
            public void close() throws IOException {
                while (!pQueue.isEmpty()) {
                    ((Yielder)pQueue.remove()).close();
                }
            }
        };
    }
}

