/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.common;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.IllegalFormatException;
import org.apache.hive.druid.com.google.common.base.Charsets;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.metamx.common.logger.Logger;

public class StringUtils {
    private static final Logger log = new Logger(StringUtils.class);
    @Deprecated
    public static final Charset UTF8_CHARSET = Charsets.UTF_8;
    public static final String UTF8_STRING = Charsets.UTF_8.toString();

    public static String fromUtf8(byte[] bytes) {
        try {
            return new String(bytes, UTF8_STRING);
        }
        catch (UnsupportedEncodingException e) {
            throw Throwables.propagate(e);
        }
    }

    public static String fromUtf8(ByteBuffer buffer, int numBytes) {
        byte[] bytes = new byte[numBytes];
        buffer.get(bytes);
        return StringUtils.fromUtf8(bytes);
    }

    public static String fromUtf8(ByteBuffer buffer) {
        return StringUtils.fromUtf8(buffer, buffer.remaining());
    }

    public static byte[] toUtf8(String string) {
        try {
            return string.getBytes(UTF8_STRING);
        }
        catch (UnsupportedEncodingException e) {
            throw Throwables.propagate(e);
        }
    }

    public static String safeFormat(String message, Object ... formatArgs) {
        if (formatArgs == null || formatArgs.length == 0) {
            return message;
        }
        try {
            return String.format(message, formatArgs);
        }
        catch (IllegalFormatException e) {
            StringBuilder bob = new StringBuilder(message);
            for (Object formatArg : formatArgs) {
                bob.append("; ").append(formatArg);
            }
            return bob.toString();
        }
    }
}

