/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.collections.bitmap;

import it.uniroma3.mat.extendedset.intset.ConciseSet;
import it.uniroma3.mat.extendedset.intset.ImmutableConciseSet;
import it.uniroma3.mat.extendedset.intset.IntSet;
import java.nio.ByteBuffer;
import org.apache.hive.druid.com.metamx.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.com.metamx.collections.bitmap.MutableBitmap;
import org.roaringbitmap.IntIterator;

public class WrappedConciseBitmap
implements MutableBitmap {
    private ConciseSet bitmap;

    public WrappedConciseBitmap() {
        this.bitmap = new ConciseSet();
    }

    public WrappedConciseBitmap(ConciseSet conciseSet) {
        this.bitmap = conciseSet;
    }

    ConciseSet getBitmap() {
        return this.bitmap;
    }

    @Override
    public byte[] toBytes() {
        return ImmutableConciseSet.newImmutableFromMutable(this.bitmap).toBytes();
    }

    @Override
    public int compareTo(ImmutableBitmap other) {
        return this.bitmap.compareTo(((WrappedConciseBitmap)other).getBitmap());
    }

    @Override
    public void clear() {
        this.bitmap.clear();
    }

    @Override
    public void or(MutableBitmap mutableBitmap) {
        WrappedConciseBitmap other = (WrappedConciseBitmap)mutableBitmap;
        ConciseSet unwrappedOtherBitmap = other.bitmap;
        this.bitmap.addAll(unwrappedOtherBitmap);
    }

    @Override
    public void and(MutableBitmap mutableBitmap) {
        WrappedConciseBitmap other = (WrappedConciseBitmap)mutableBitmap;
        ConciseSet unwrappedOtherBitmap = other.bitmap;
        this.bitmap = this.bitmap.intersection(unwrappedOtherBitmap);
    }

    @Override
    public void xor(MutableBitmap mutableBitmap) {
        WrappedConciseBitmap other = (WrappedConciseBitmap)mutableBitmap;
        ConciseSet unwrappedOtherBitmap = other.bitmap;
        this.bitmap = this.bitmap.symmetricDifference(unwrappedOtherBitmap);
    }

    @Override
    public void andNot(MutableBitmap mutableBitmap) {
        WrappedConciseBitmap other = (WrappedConciseBitmap)mutableBitmap;
        ConciseSet unwrappedOtherBitmap = other.bitmap;
        this.bitmap = this.bitmap.difference(unwrappedOtherBitmap);
    }

    @Override
    public int getSizeInBytes() {
        return this.bitmap.getWords().length * 4;
    }

    @Override
    public void add(int entry) {
        this.bitmap.add(entry);
    }

    @Override
    public int size() {
        return this.bitmap.size();
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        buffer.put(this.toBytes());
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.bitmap.toString();
    }

    @Override
    public void remove(int entry) {
        this.bitmap.remove(entry);
    }

    @Override
    public IntIterator iterator() {
        final IntSet.IntIterator i = this.bitmap.iterator();
        return new IntIterator(){

            public IntIterator clone() {
                throw new UnsupportedOperationException("clone is not supported on ConciseSet iterator");
            }

            public boolean hasNext() {
                return i.hasNext();
            }

            public int next() {
                return i.next();
            }
        };
    }

    @Override
    public boolean isEmpty() {
        return this.bitmap.size() == 0;
    }

    @Override
    public ImmutableBitmap union(ImmutableBitmap otherBitmap) {
        WrappedConciseBitmap other = (WrappedConciseBitmap)otherBitmap;
        ConciseSet unwrappedOtherBitmap = other.bitmap;
        return new WrappedConciseBitmap(this.bitmap.clone().union(unwrappedOtherBitmap));
    }

    @Override
    public ImmutableBitmap intersection(ImmutableBitmap otherBitmap) {
        WrappedConciseBitmap other = (WrappedConciseBitmap)otherBitmap;
        ConciseSet unwrappedOtherBitmap = other.bitmap;
        return new WrappedConciseBitmap(this.bitmap.clone().intersection(unwrappedOtherBitmap));
    }

    @Override
    public ImmutableBitmap difference(ImmutableBitmap otherBitmap) {
        WrappedConciseBitmap other = (WrappedConciseBitmap)otherBitmap;
        ConciseSet unwrappedOtherBitmap = other.bitmap;
        return new WrappedConciseBitmap(this.bitmap.clone().difference(unwrappedOtherBitmap));
    }

    @Override
    public boolean get(int value) {
        return this.bitmap.contains(value);
    }
}

