/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma3.mat.extendedset.intset;

import it.uniroma3.mat.extendedset.utilities.BitCount;
import java.util.NoSuchElementException;

public class ConciseSetUtils {
    public static final int MAX_ALLOWED_INTEGER = 1040187422;
    public static final int MIN_ALLOWED_SET_BIT = 0;
    public static final int MAX_LITERAL_LENGTH = 31;
    public static final int ALL_ONES_LITERAL = -1;
    public static final int ALL_ZEROS_LITERAL = Integer.MIN_VALUE;
    public static final int ALL_ONES_WITHOUT_MSB = Integer.MAX_VALUE;
    public static final int SEQUENCE_BIT = 0x40000000;

    public static int maxLiteralLengthModulus(int n) {
        int m = (n & 0xC1F07C1F) + (n >>> 5 & 0xC1F07C1F);
        if ((m = (m >>> 15) + (m & Short.MAX_VALUE)) <= 31) {
            return m == 31 ? 0 : m;
        }
        if ((m = (m >>> 5) + (m & 0x1F)) <= 31) {
            return m == 31 ? 0 : m;
        }
        if ((m = (m >>> 5) + (m & 0x1F)) <= 31) {
            return m == 31 ? 0 : m;
        }
        if ((m = (m >>> 5) + (m & 0x1F)) <= 31) {
            return m == 31 ? 0 : m;
        }
        if ((m = (m >>> 5) + (m & 0x1F)) <= 31) {
            return m == 31 ? 0 : m;
        }
        return (m = (m >>> 5) + (m & 0x1F)) == 31 ? 0 : m;
    }

    public static int maxLiteralLengthMultiplication(int n) {
        return (n << 5) - n;
    }

    public static int maxLiteralLengthDivision(int n) {
        return n / 31;
    }

    public static boolean isLiteral(int word) {
        return (word & Integer.MIN_VALUE) != 0;
    }

    public static boolean isOneSequence(int word) {
        return (word & 0xC0000000) == 0x40000000;
    }

    public static boolean isZeroSequence(int word) {
        return (word & 0xC0000000) == 0;
    }

    public static boolean isSequenceWithNoBits(int word) {
        return (word & 0xBE000000) == 0;
    }

    public static int getSequenceCount(int word) {
        return word & 0x1FFFFFF;
    }

    public static int getSequenceNumWords(int word) {
        return ConciseSetUtils.getSequenceCount(word) + 1;
    }

    public static int getSequenceWithNoBits(int word) {
        return word & 0xC1FFFFFF;
    }

    public static int getLiteral(int word, boolean simulateWAH) {
        if (ConciseSetUtils.isLiteral(word)) {
            return word;
        }
        if (simulateWAH) {
            return ConciseSetUtils.isZeroSequence(word) ? Integer.MIN_VALUE : -1;
        }
        int literal = 1 << (word >>> 25) >>> 1;
        return ConciseSetUtils.isZeroSequence(word) ? Integer.MIN_VALUE | literal : 0xFFFFFFFF & ~literal;
    }

    public static int getLiteralFromZeroSeqFlipBit(int word) {
        int flipBit = ConciseSetUtils.getFlippedBit(word);
        if (flipBit > -1) {
            return Integer.MIN_VALUE | ConciseSetUtils.flipBitAsBinaryString(flipBit);
        }
        return Integer.MIN_VALUE;
    }

    public static int getLiteralFromOneSeqFlipBit(int word) {
        int flipBit = ConciseSetUtils.getFlippedBit(word);
        if (flipBit > -1) {
            return 0xFFFFFFFF ^ ConciseSetUtils.flipBitAsBinaryString(flipBit);
        }
        return -1;
    }

    public static int getFlippedBit(int word) {
        return (word >>> 25 & 0x1F) - 1;
    }

    public static int flipBitAsBinaryString(int flipBit) {
        return ((Number)Math.pow(2.0, flipBit)).intValue();
    }

    public static int getLiteralBitCount(int word) {
        return BitCount.count(ConciseSetUtils.getLiteralBits(word));
    }

    public static int getLiteralBits(int word) {
        return Integer.MAX_VALUE & word;
    }

    public static boolean isAllOnesLiteral(int word) {
        return (word & 0xFFFFFFFF) == -1;
    }

    public static boolean isAllZerosLiteral(int word) {
        return (word | Integer.MIN_VALUE) == Integer.MIN_VALUE;
    }

    public static boolean isLiteralWithSingleZeroBit(int word) {
        return ConciseSetUtils.isLiteral(word) && Integer.bitCount(~word) == 1;
    }

    public static boolean isLiteralWithSingleOneBit(int word) {
        return ConciseSetUtils.isLiteral(word) && Integer.bitCount(word) == 2;
    }

    public static int clearBitsAfterInLastWord(int lastWord, int lastSetBit) {
        return lastWord &= Integer.MIN_VALUE | -1 >>> 31 - lastSetBit;
    }

    public static int onesUntil(int bit) {
        return Integer.MIN_VALUE | (1 << bit) - 1;
    }

    public static LiteralAndZeroFillExpander newLiteralAndZeroFillExpander() {
        return new LiteralAndZeroFillExpander();
    }

    public static OneFillExpander newOneFillExpander() {
        return new OneFillExpander();
    }

    public static class OneFillExpander
    implements WordExpander {
        int firstInt = 1;
        int lastInt = -1;
        int current = 0;
        int exception = -1;

        @Override
        public boolean hasNext() {
            return this.current < this.lastInt;
        }

        @Override
        public boolean hasPrevious() {
            return this.current > this.firstInt;
        }

        @Override
        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.current;
            if (this.current == this.exception) {
                ++this.current;
            }
            return this.current;
        }

        @Override
        public int previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            --this.current;
            if (this.current == this.exception) {
                --this.current;
            }
            return this.current;
        }

        @Override
        public void skipAllAfter(int i) {
            if (i >= this.current) {
                return;
            }
            this.current = i + 1;
        }

        @Override
        public void skipAllBefore(int i) {
            if (i <= this.current) {
                return;
            }
            this.current = i - 1;
        }

        @Override
        public void reset(int offset, int word, boolean fromBeginning) {
            if (!ConciseSetUtils.isOneSequence(word)) {
                throw new RuntimeException("NOT a sequence of ones!");
            }
            this.firstInt = offset;
            this.lastInt = offset + ConciseSetUtils.maxLiteralLengthMultiplication(ConciseSetUtils.getSequenceCount(word) + 1) - 1;
            this.exception = offset + ((0x3FFFFFFF & word) >>> 25) - 1;
            if (this.exception == this.firstInt) {
                ++this.firstInt;
            }
            if (this.exception == this.lastInt) {
                --this.lastInt;
            }
            this.current = fromBeginning ? this.firstInt - 1 : this.lastInt + 1;
        }

        @Override
        public WordExpander clone() {
            OneFillExpander retVal = new OneFillExpander();
            retVal.firstInt = this.firstInt;
            retVal.lastInt = this.lastInt;
            retVal.current = this.current;
            retVal.exception = this.exception;
            return retVal;
        }
    }

    public static class LiteralAndZeroFillExpander
    implements WordExpander {
        final int[] buffer = new int[31];
        int len = 0;
        int current = 0;

        @Override
        public boolean hasNext() {
            return this.current < this.len;
        }

        @Override
        public boolean hasPrevious() {
            return this.current > 0;
        }

        @Override
        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.buffer[this.current++];
        }

        @Override
        public int previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return this.buffer[--this.current];
        }

        @Override
        public void skipAllAfter(int i) {
            while (this.hasPrevious() && this.buffer[this.current - 1] > i) {
                --this.current;
            }
        }

        @Override
        public void skipAllBefore(int i) {
            while (this.hasNext() && this.buffer[this.current] < i) {
                ++this.current;
            }
        }

        @Override
        public void reset(int offset, int word, boolean fromBeginning) {
            if (ConciseSetUtils.isLiteral(word)) {
                this.len = 0;
                for (int i = 0; i < 31; ++i) {
                    if ((word & 1 << i) == 0) continue;
                    this.buffer[this.len++] = offset + i;
                }
                this.current = fromBeginning ? 0 : this.len;
            } else if (ConciseSetUtils.isZeroSequence(word)) {
                if (ConciseSetUtils.isSequenceWithNoBits(word)) {
                    this.len = 0;
                    this.current = 0;
                } else {
                    this.len = 1;
                    this.buffer[0] = offset + ((0x3FFFFFFF & word) >>> 25) - 1;
                    this.current = fromBeginning ? 0 : 1;
                }
            } else {
                throw new RuntimeException("sequence of ones!");
            }
        }

        @Override
        public WordExpander clone() {
            LiteralAndZeroFillExpander retVal = new LiteralAndZeroFillExpander();
            System.arraycopy(this.buffer, 0, retVal.buffer, 0, this.buffer.length);
            retVal.len = this.len;
            retVal.current = this.current;
            return retVal;
        }
    }

    public static interface WordExpander {
        public boolean hasNext();

        public boolean hasPrevious();

        public int next();

        public int previous();

        public void skipAllAfter(int var1);

        public void skipAllBefore(int var1);

        public void reset(int var1, int var2, boolean var3);

        public WordExpander clone();
    }
}

