/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.metrics;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.junit.Assert;

public class MetricsTestUtils {
    public static final MetricsCategory COUNTER = new MetricsCategory("counters", "count");
    public static final MetricsCategory TIMER = new MetricsCategory("timers", "count");
    public static final MetricsCategory GAUGE = new MetricsCategory("gauges", "value");
    public static final MetricsCategory METER = new MetricsCategory("meters", "count");

    public static void verifyMetricsJson(String json, MetricsCategory category, String metricsName, Object expectedValue) throws Exception {
        JsonNode jsonNode = MetricsTestUtils.getJsonNode(json, category, metricsName);
        Assert.assertEquals((Object)expectedValue.toString(), (Object)jsonNode.asText());
    }

    public static void verifyMetricsJson(String json, MetricsCategory category, String metricsName, Double expectedValue, Double delta) throws Exception {
        JsonNode jsonNode = MetricsTestUtils.getJsonNode(json, category, metricsName);
        Assert.assertEquals((double)expectedValue, (double)Double.valueOf(jsonNode.asText()), (double)delta);
    }

    public static JsonNode getJsonNode(String json, MetricsCategory category, String metricsName) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode rootNode = objectMapper.readTree(json);
        JsonNode categoryNode = rootNode.path(category.category);
        JsonNode metricsNode = categoryNode.path(metricsName);
        return metricsNode.path(category.metricsHandle);
    }

    public static byte[] getFileData(String path, int timeoutInterval, int tries) throws Exception {
        File file = new File(path);
        do {
            Thread.sleep(timeoutInterval);
        } while (--tries > 0 && !file.exists());
        return Files.readAllBytes(Paths.get(path, new String[0]));
    }

    static class MetricsCategory {
        String category;
        String metricsHandle;

        MetricsCategory(String category, String metricsHandle) {
            this.category = category;
            this.metricsHandle = metricsHandle;
        }
    }
}

