/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.log;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.PrintStream;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.common.log.ProgressMonitor;
import org.apache.hadoop.hive.conf.HiveConf;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.internal.CLibrary;

public class InPlaceUpdate {
    public static final int MIN_TERMINAL_WIDTH = 94;
    private static final String HEADER_FORMAT = "%16s%10s %13s  %5s  %9s  %7s  %7s  %6s  %6s  ";
    private static final String VERTEX_FORMAT = "%-16s%10s %13s  %5s  %9s  %7s  %7s  %6s  %6s  ";
    private static final String FOOTER_FORMAT = "%-15s  %-30s %-4s  %-25s";
    private static final int PROGRESS_BAR_CHARS = 30;
    private static final String SEPARATOR = new String(new char[94]).replace("\u0000", "-");
    private final DecimalFormat secondsFormatter = new DecimalFormat("#0.00");
    private int lines = 0;
    private PrintStream out;

    public InPlaceUpdate(PrintStream out) {
        this.out = out;
    }

    public InPlaceUpdate() {
        this(System.out);
    }

    public static void reprintLine(PrintStream out, String line) {
        out.print(Ansi.ansi().eraseLine(Ansi.Erase.ALL).a(line).a('\n').toString());
        out.flush();
    }

    public static void rePositionCursor(PrintStream ps) {
        ps.print(Ansi.ansi().cursorUp(0).toString());
        ps.flush();
    }

    private void reprintLine(String line) {
        InPlaceUpdate.reprintLine(this.out, line);
        ++this.lines;
    }

    private void reprintLineWithColorAsBold(String line, Ansi.Color color) {
        this.out.print(Ansi.ansi().eraseLine(Ansi.Erase.ALL).fg(color).bold().a(line).a('\n').boldOff().reset().toString());
        this.out.flush();
        ++this.lines;
    }

    private void reprintMultiLine(String line) {
        int numLines = line.split("\r\n|\r|\n").length;
        this.out.print(Ansi.ansi().eraseLine(Ansi.Erase.ALL).a(line).a('\n').toString());
        this.out.flush();
        this.lines += numLines;
    }

    private void repositionCursor() {
        if (this.lines > 0) {
            this.out.print(Ansi.ansi().cursorUp(this.lines).toString());
            this.out.flush();
            this.lines = 0;
        }
    }

    private String getInPlaceProgressBar(double percent) {
        int i;
        StringWriter bar = new StringWriter();
        bar.append("[");
        int remainingChars = 26;
        int completed = (int)((double)remainingChars * percent);
        int pending = remainingChars - completed;
        for (i = 0; i < completed; ++i) {
            bar.append("=");
        }
        bar.append(">>");
        for (i = 0; i < pending; ++i) {
            bar.append("-");
        }
        bar.append("]");
        return bar.toString();
    }

    public void render(ProgressMonitor monitor) {
        if (monitor == null) {
            return;
        }
        this.repositionCursor();
        this.reprintLine(SEPARATOR);
        this.reprintLineWithColorAsBold(String.format(HEADER_FORMAT, monitor.headers().toArray()), Ansi.Color.CYAN);
        this.reprintLine(SEPARATOR);
        List printReady = Lists.transform(monitor.rows(), (Function)new Function<List<String>, String>(){

            @Nullable
            public String apply(@Nullable List<String> row) {
                return String.format(InPlaceUpdate.VERTEX_FORMAT, row.toArray());
            }
        });
        this.reprintMultiLine(StringUtils.join((Collection)printReady, (String)"\n"));
        String progressStr = (int)(monitor.progressedPercentage() * 100.0) + "%";
        float et = (float)(System.currentTimeMillis() - monitor.startTime()) / 1000.0f;
        String elapsedTime = "ELAPSED TIME: " + this.secondsFormatter.format(et) + " s";
        String footer = String.format(FOOTER_FORMAT, monitor.footerSummary(), this.getInPlaceProgressBar(monitor.progressedPercentage()), progressStr, elapsedTime);
        this.reprintLine(SEPARATOR);
        this.reprintLineWithColorAsBold(footer, Ansi.Color.RED);
        this.reprintLine(SEPARATOR);
    }

    public static boolean canRenderInPlace(HiveConf conf) {
        String engine = HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_EXECUTION_ENGINE);
        boolean inPlaceUpdates = false;
        if (engine.equals("tez")) {
            inPlaceUpdates = HiveConf.getBoolVar(conf, HiveConf.ConfVars.TEZ_EXEC_INPLACE_PROGRESS);
        }
        if (engine.equals("spark")) {
            inPlaceUpdates = HiveConf.getBoolVar(conf, HiveConf.ConfVars.SPARK_EXEC_INPLACE_PROGRESS);
        }
        return inPlaceUpdates && InPlaceUpdate.isUnixTerminal();
    }

    private static boolean isUnixTerminal() {
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows")) {
            return false;
        }
        try {
            if (CLibrary.isatty((int)CLibrary.STDOUT_FILENO) == 0) {
                return false;
            }
            if (CLibrary.isatty((int)CLibrary.STDERR_FILENO) == 0) {
                return false;
            }
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError ignore) {
            return false;
        }
        return true;
    }
}

