/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.metrics.metrics2;

import com.codahale.metrics.MetricRegistry;
import org.apache.hadoop.hive.common.metrics.MetricsTestUtils;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.common.metrics.common.MetricsVariable;
import org.apache.hadoop.hive.common.metrics.metrics2.CodahaleMetrics;
import org.apache.hadoop.hive.conf.HiveConf;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestMetricVariableRatioGauge {
    public static MetricRegistry metricRegistry;

    @Before
    public void before() throws Exception {
        HiveConf conf = new HiveConf();
        conf.set("fs.defaultFS", "file:///");
        conf.setVar(HiveConf.ConfVars.HIVE_METRICS_CLASS, CodahaleMetrics.class.getCanonicalName());
        conf.setVar(HiveConf.ConfVars.HIVE_METRICS_JSON_FILE_INTERVAL, "60000m");
        MetricsFactory.init((HiveConf)conf);
        metricRegistry = ((CodahaleMetrics)MetricsFactory.getInstance()).getMetricRegistry();
    }

    @After
    public void after() throws Exception {
        MetricsFactory.close();
    }

    @Test
    public void testRatioIsCalculated() throws Exception {
        NumericVariable num = new NumericVariable(10);
        NumericVariable ord = new NumericVariable(5);
        MetricsFactory.getInstance().addRatio("rat", (MetricsVariable)num, (MetricsVariable)ord);
        String json = ((CodahaleMetrics)MetricsFactory.getInstance()).dumpJson();
        MetricsTestUtils.verifyMetricsJson(json, MetricsTestUtils.GAUGE, "rat", 2.0);
    }

    @Test
    public void testRatioIsCalculatedNonExact() throws Exception {
        NumericVariable num = new NumericVariable(20);
        NumericVariable ord = new NumericVariable(3);
        MetricsFactory.getInstance().addRatio("rat", (MetricsVariable)num, (MetricsVariable)ord);
        String json = ((CodahaleMetrics)MetricsFactory.getInstance()).dumpJson();
        MetricsTestUtils.verifyMetricsJson(json, MetricsTestUtils.GAUGE, "rat", 6.6666, 1.0E-4);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMissingNumeratorRatio() throws Exception {
        MetricsFactory.getInstance().addRatio("rat", null, (MetricsVariable)new NumericVariable(5));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMissingDenominatorRatio() throws Exception {
        MetricsFactory.getInstance().addRatio("rat", (MetricsVariable)new NumericVariable(5), null);
    }

    @Test
    public void testEmptyRatio() throws Exception {
        NumericVariable num = new NumericVariable(null);
        NumericVariable ord = new NumericVariable(null);
        MetricsFactory.getInstance().addRatio("rat", (MetricsVariable)num, (MetricsVariable)ord);
        String json = ((CodahaleMetrics)MetricsFactory.getInstance()).dumpJson();
        MetricsTestUtils.verifyMetricsJson(json, MetricsTestUtils.GAUGE, "rat", "NaN");
    }

    @Test
    public void testZeroRatio() throws Exception {
        NumericVariable num = new NumericVariable(10);
        NumericVariable ord = new NumericVariable(0);
        MetricsFactory.getInstance().addRatio("rat", (MetricsVariable)num, (MetricsVariable)ord);
        String json = ((CodahaleMetrics)MetricsFactory.getInstance()).dumpJson();
        MetricsTestUtils.verifyMetricsJson(json, MetricsTestUtils.GAUGE, "rat", "NaN");
    }

    private class NumericVariable
    implements MetricsVariable<Integer> {
        private final Integer value;

        public NumericVariable(Integer value) {
            this.value = value;
        }

        public Integer getValue() {
            return this.value;
        }
    }
}

