/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.common.util;

import org.junit.Ignore;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runner.notification.StoppedByUserException;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class RetryTestRunner
extends BlockJUnit4ClassRunner {
    static final int DEFAULT_RETRY_COUNT = 2;
    private final int retryCount;
    private int failedAttempts = 0;

    public RetryTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
        this.retryCount = 2;
    }

    public void run(RunNotifier notifier) {
        Description description = this.getDescription();
        EachTestNotifier testNotifier = new EachTestNotifier(notifier, description);
        Statement statement = this.classBlock(notifier);
        try {
            statement.evaluate();
        }
        catch (AssumptionViolatedException e) {
            testNotifier.fireTestIgnored();
        }
        catch (StoppedByUserException e) {
            throw e;
        }
        catch (Throwable e) {
            this.retry(description, testNotifier, statement, e);
        }
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        Description description = this.describeChild(method);
        if (method.getAnnotation(Ignore.class) != null) {
            notifier.fireTestIgnored(description);
        } else {
            this.runTestUnit(this.methodBlock(method), description, notifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTestUnit(Statement statement, Description description, RunNotifier notifier) {
        EachTestNotifier eachNotifier = new EachTestNotifier(notifier, description);
        eachNotifier.fireTestStarted();
        try {
            statement.evaluate();
        }
        catch (AssumptionViolatedException e) {
            eachNotifier.addFailedAssumption(e);
        }
        catch (Throwable e) {
            this.retry(description, eachNotifier, statement, e);
        }
        finally {
            eachNotifier.fireTestFinished();
        }
    }

    private void retry(Description description, EachTestNotifier notifier, Statement statement, Throwable currentThrowable) {
        Throwable caughtThrowable = currentThrowable;
        while (this.retryCount > this.failedAttempts) {
            try {
                System.out.println(description + " Caught: " + (currentThrowable == null ? "exception" : currentThrowable.getMessage()) + ". Retrying test " + this.failedAttempts + "/" + this.retryCount);
                statement.evaluate();
                return;
            }
            catch (Throwable t) {
                ++this.failedAttempts;
                caughtThrowable = t;
            }
        }
        notifier.addFailure(caughtThrowable);
    }
}

