/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.type;

import com.google.code.tempusfugit.concurrency.ConcurrentRule;
import com.google.code.tempusfugit.concurrency.RepeatingRule;
import com.google.code.tempusfugit.concurrency.annotations.Concurrent;
import com.google.code.tempusfugit.concurrency.annotations.Repeating;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TestHiveIntervalDayTime {
    @Rule
    public ConcurrentRule concurrentRule = new ConcurrentRule();
    @Rule
    public RepeatingRule repeatingRule = new RepeatingRule();

    @Test
    @Concurrent(count=4)
    @Repeating(repetition=100)
    public void testGetters() throws Exception {
        HiveIntervalDayTime i1 = new HiveIntervalDayTime(3, 4, 5, 6, 7);
        Assert.assertEquals((long)3L, (long)i1.getDays());
        Assert.assertEquals((long)4L, (long)i1.getHours());
        Assert.assertEquals((long)5L, (long)i1.getMinutes());
        Assert.assertEquals((long)6L, (long)i1.getSeconds());
        Assert.assertEquals((long)7L, (long)i1.getNanos());
    }

    @Test
    @Concurrent(count=4)
    @Repeating(repetition=100)
    public void testCompare() throws Exception {
        HiveIntervalDayTime i1 = new HiveIntervalDayTime(3, 4, 5, 6, 7);
        HiveIntervalDayTime i2 = new HiveIntervalDayTime(3, 4, 5, 6, 7);
        HiveIntervalDayTime i3 = new HiveIntervalDayTime(3, 4, 8, 9, 10);
        HiveIntervalDayTime i4 = new HiveIntervalDayTime(3, 4, 8, 9, 5);
        Assert.assertEquals((String)(i1 + " compareTo " + i1), (long)0L, (long)i1.compareTo(i1));
        Assert.assertEquals((String)(i1 + " compareTo " + i2), (long)0L, (long)i1.compareTo(i2));
        Assert.assertEquals((String)(i2 + " compareTo " + i1), (long)0L, (long)i2.compareTo(i1));
        Assert.assertEquals((String)(i3 + " compareTo " + i3), (long)0L, (long)i3.compareTo(i3));
        Assert.assertTrue((String)(i1 + " compareTo " + i3), (0 > i1.compareTo(i3) ? 1 : 0) != 0);
        Assert.assertTrue((String)(i3 + " compareTo " + i1), (0 < i3.compareTo(i1) ? 1 : 0) != 0);
        Assert.assertTrue((String)(i1 + " equals " + i1), (boolean)i1.equals((Object)i1));
        Assert.assertTrue((String)(i1 + " equals " + i2), (boolean)i1.equals((Object)i2));
        Assert.assertFalse((String)(i1 + " equals " + i3), (boolean)i1.equals((Object)i3));
        Assert.assertFalse((String)(i3 + " equals " + i1), (boolean)i3.equals((Object)i1));
        Assert.assertFalse((String)(i3 + " equals " + i4), (boolean)i3.equals((Object)i4));
        Assert.assertEquals((String)(i1 + " hashCode " + i1), (long)i1.hashCode(), (long)i1.hashCode());
        Assert.assertEquals((String)(i1 + " hashCode " + i1), (long)i1.hashCode(), (long)i2.hashCode());
    }

    @Test
    @Concurrent(count=4)
    @Repeating(repetition=100)
    public void testValueOf() throws Exception {
        String[] invalidValues;
        HiveIntervalDayTime i1 = HiveIntervalDayTime.valueOf((String)"3 04:05:06.123456");
        Assert.assertEquals((long)3L, (long)i1.getDays());
        Assert.assertEquals((long)4L, (long)i1.getHours());
        Assert.assertEquals((long)5L, (long)i1.getMinutes());
        Assert.assertEquals((long)6L, (long)i1.getSeconds());
        Assert.assertEquals((long)123456000L, (long)i1.getNanos());
        HiveIntervalDayTime i2 = HiveIntervalDayTime.valueOf((String)"+3 04:05:06");
        Assert.assertEquals((long)3L, (long)i2.getDays());
        Assert.assertEquals((long)4L, (long)i2.getHours());
        Assert.assertEquals((long)5L, (long)i2.getMinutes());
        Assert.assertEquals((long)6L, (long)i2.getSeconds());
        Assert.assertEquals((long)0L, (long)i2.getNanos());
        HiveIntervalDayTime i3 = HiveIntervalDayTime.valueOf((String)"-12 13:14:15.987654321");
        Assert.assertEquals((long)-12L, (long)i3.getDays());
        Assert.assertEquals((long)-13L, (long)i3.getHours());
        Assert.assertEquals((long)-14L, (long)i3.getMinutes());
        Assert.assertEquals((long)-15L, (long)i3.getSeconds());
        Assert.assertEquals((long)-987654321L, (long)i3.getNanos());
        HiveIntervalDayTime i4 = HiveIntervalDayTime.valueOf((String)"-0 0:0:0.000000012");
        Assert.assertEquals((long)0L, (long)i4.getDays());
        Assert.assertEquals((long)0L, (long)i4.getHours());
        Assert.assertEquals((long)0L, (long)i4.getMinutes());
        Assert.assertEquals((long)0L, (long)i4.getSeconds());
        Assert.assertEquals((long)-12L, (long)i4.getNanos());
        for (String invalidValue : invalidValues = new String[]{null, "abc", "0-11", "0 60:0:0", "0 0:60:0"}) {
            boolean caughtException = false;
            try {
                HiveIntervalDayTime.valueOf((String)invalidValue);
                Assert.fail((String)"Expected exception");
            }
            catch (IllegalArgumentException err) {
                caughtException = true;
            }
            Assert.assertTrue((String)"Expected exception", (boolean)caughtException);
        }
    }

    @Test
    @Concurrent(count=4)
    @Repeating(repetition=100)
    public void testToString() throws Exception {
        Assert.assertEquals((Object)"0 00:00:00.000000000", (Object)HiveIntervalDayTime.valueOf((String)"0 00:00:00").toString());
        Assert.assertEquals((Object)"3 04:05:06.123456000", (Object)HiveIntervalDayTime.valueOf((String)"3 04:05:06.123456").toString());
        Assert.assertEquals((Object)"-3 04:05:06.123456000", (Object)HiveIntervalDayTime.valueOf((String)"-3 04:05:06.123456").toString());
        Assert.assertEquals((Object)"1 00:00:00.000000000", (Object)HiveIntervalDayTime.valueOf((String)"1 00:00:00").toString());
        Assert.assertEquals((Object)"-1 00:00:00.000000000", (Object)HiveIntervalDayTime.valueOf((String)"-1 00:00:00").toString());
        Assert.assertEquals((Object)"0 00:00:00.880000000", (Object)HiveIntervalDayTime.valueOf((String)"0 00:00:00.88").toString());
        Assert.assertEquals((Object)"-0 00:00:00.880000000", (Object)HiveIntervalDayTime.valueOf((String)"-0 00:00:00.88").toString());
        Assert.assertEquals((Object)"-3 04:05:06.000000007", (Object)new HiveIntervalDayTime(-3, -4, -5, -6, -7).toString());
        Assert.assertEquals((Object)"3 04:05:06.000000007", (Object)new HiveIntervalDayTime(3, 4, 5, 6, 7).toString());
    }

    @Test
    @Concurrent(count=4)
    @Repeating(repetition=100)
    public void testNormalize() throws Exception {
        HiveIntervalDayTime i1 = new HiveIntervalDayTime(50, 48, 3, 5400, 2000000123);
        Assert.assertEquals((Object)HiveIntervalDayTime.valueOf((String)"52 1:33:2.000000123"), (Object)i1);
        Assert.assertEquals((long)52L, (long)i1.getDays());
        Assert.assertEquals((long)1L, (long)i1.getHours());
        Assert.assertEquals((long)33L, (long)i1.getMinutes());
        Assert.assertEquals((long)2L, (long)i1.getSeconds());
        Assert.assertEquals((long)123L, (long)i1.getNanos());
        Assert.assertEquals((Object)HiveIntervalDayTime.valueOf((String)"0 0:0:0"), (Object)new HiveIntervalDayTime(0, 0, 0, 0, 0));
        Assert.assertEquals((Object)HiveIntervalDayTime.valueOf((String)"0 0:0:0"), (Object)new HiveIntervalDayTime(2, -48, 0, 1, -1000000000));
        Assert.assertEquals((Object)HiveIntervalDayTime.valueOf((String)"0 0:0:0"), (Object)new HiveIntervalDayTime(-2, 48, 0, -1, 1000000000));
        Assert.assertEquals((Object)HiveIntervalDayTime.valueOf((String)"1 0:0:0"), (Object)new HiveIntervalDayTime(-1, 48, 0, 0, 0));
        Assert.assertEquals((Object)HiveIntervalDayTime.valueOf((String)"-1 0:0:0"), (Object)new HiveIntervalDayTime(1, -48, 0, 0, 0));
        Assert.assertEquals((Object)HiveIntervalDayTime.valueOf((String)"0 23:59:59.999999999"), (Object)new HiveIntervalDayTime(1, 0, 0, 0, -1));
        Assert.assertEquals((Object)HiveIntervalDayTime.valueOf((String)"-0 23:59:59.999999999"), (Object)new HiveIntervalDayTime(-1, 0, 0, 0, 1));
        Assert.assertEquals((Object)HiveIntervalDayTime.valueOf((String)"1 10:11:0"), (Object)new HiveIntervalDayTime(-1, 10, 11, 172800, 0));
        i1 = new HiveIntervalDayTime(480, 480, 0, 5400, 2000000123);
        Assert.assertEquals((long)500L, (long)i1.getDays());
        Assert.assertEquals((long)1L, (long)i1.getHours());
        Assert.assertEquals((long)30L, (long)i1.getMinutes());
        Assert.assertEquals((long)2L, (long)i1.getSeconds());
        Assert.assertEquals((long)123L, (long)i1.getNanos());
    }
}

