/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.io;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.io.HdfsUtils;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestHdfsUtils {
    @Test
    public void testSetFullFileStatusFailInheritGroup() throws IOException {
        Configuration conf = new Configuration();
        conf.set("dfs.namenode.acls.enabled", "false");
        HdfsUtils.HadoopFileStatus mockHadoopFileStatus = (HdfsUtils.HadoopFileStatus)Mockito.mock(HdfsUtils.HadoopFileStatus.class);
        FileStatus mockSourceStatus = (FileStatus)Mockito.mock(FileStatus.class);
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)mockSourceStatus.getGroup()).thenReturn((Object)"fakeGroup1");
        Mockito.when((Object)mockHadoopFileStatus.getFileStatus()).thenReturn((Object)mockSourceStatus);
        ((FileSystem)Mockito.doThrow(RuntimeException.class).when((Object)fs)).setOwner((Path)Matchers.any(Path.class), (String)Matchers.any(String.class), (String)Matchers.any(String.class));
        HdfsUtils.setFullFileStatus((Configuration)conf, (HdfsUtils.HadoopFileStatus)mockHadoopFileStatus, (String)"fakeGroup2", (FileSystem)fs, (Path)new Path("fakePath"), (boolean)false);
        ((FileSystem)Mockito.verify((Object)fs)).setOwner((Path)Matchers.any(Path.class), (String)Matchers.any(String.class), (String)Matchers.any(String.class));
    }

    @Test
    public void testSetFullFileStatusFailInheritAcls() throws IOException {
        Configuration conf = new Configuration();
        conf.set("dfs.namenode.acls.enabled", "true");
        HdfsUtils.HadoopFileStatus mockHadoopFileStatus = (HdfsUtils.HadoopFileStatus)Mockito.mock(HdfsUtils.HadoopFileStatus.class);
        FileStatus mockSourceStatus = (FileStatus)Mockito.mock(FileStatus.class);
        AclStatus mockAclStatus = (AclStatus)Mockito.mock(AclStatus.class);
        FileSystem mockFs = (FileSystem)Mockito.mock(FileSystem.class);
        ArrayList<AclEntry> acls = new ArrayList<AclEntry>();
        acls.add(new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(AclEntryType.USER).setPermission(FsAction.ALL).build());
        acls.add(new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(AclEntryType.GROUP).setPermission(FsAction.READ_EXECUTE).build());
        acls.add(new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(AclEntryType.OTHER).setPermission(FsAction.NONE).build());
        Mockito.when((Object)mockSourceStatus.getPermission()).thenReturn((Object)new FsPermission(777));
        Mockito.when((Object)mockAclStatus.toString()).thenReturn((Object)"");
        Mockito.when((Object)mockHadoopFileStatus.getFileStatus()).thenReturn((Object)mockSourceStatus);
        Mockito.when((Object)mockHadoopFileStatus.getAclEntries()).thenReturn(acls);
        Mockito.when((Object)mockHadoopFileStatus.getAclStatus()).thenReturn((Object)mockAclStatus);
        ((FileSystem)Mockito.doThrow(RuntimeException.class).when((Object)mockFs)).setAcl((Path)Matchers.any(Path.class), (List)Matchers.any(List.class));
        HdfsUtils.setFullFileStatus((Configuration)conf, (HdfsUtils.HadoopFileStatus)mockHadoopFileStatus, (FileSystem)mockFs, (Path)new Path("fakePath"), (boolean)false);
        ((FileSystem)Mockito.verify((Object)mockFs)).setAcl((Path)Matchers.any(Path.class), (List)Matchers.any(List.class));
    }

    @Test
    public void testSetFullFileStatusFailInheritPerms() throws IOException {
        Configuration conf = new Configuration();
        conf.set("dfs.namenode.acls.enabled", "false");
        HdfsUtils.HadoopFileStatus mockHadoopFileStatus = (HdfsUtils.HadoopFileStatus)Mockito.mock(HdfsUtils.HadoopFileStatus.class);
        FileStatus mockSourceStatus = (FileStatus)Mockito.mock(FileStatus.class);
        FileSystem mockFs = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)mockSourceStatus.getPermission()).thenReturn((Object)new FsPermission(777));
        Mockito.when((Object)mockHadoopFileStatus.getFileStatus()).thenReturn((Object)mockSourceStatus);
        ((FileSystem)Mockito.doThrow(RuntimeException.class).when((Object)mockFs)).setPermission((Path)Matchers.any(Path.class), (FsPermission)Matchers.any(FsPermission.class));
        HdfsUtils.setFullFileStatus((Configuration)conf, (HdfsUtils.HadoopFileStatus)mockHadoopFileStatus, (FileSystem)mockFs, (Path)new Path("fakePath"), (boolean)false);
        ((FileSystem)Mockito.verify((Object)mockFs)).setPermission((Path)Matchers.any(Path.class), (FsPermission)Matchers.any(FsPermission.class));
    }

    @Test
    public void testSetFullFileStatusFailInheritGroupRecursive() throws Exception {
        Configuration conf = new Configuration();
        conf.set("dfs.namenode.acls.enabled", "false");
        String fakeSourceGroup = "fakeGroup1";
        String fakeTargetGroup = "fakeGroup2";
        Path fakeTarget = new Path("fakePath");
        HdfsUtils.HadoopFileStatus mockHadoopFileStatus = (HdfsUtils.HadoopFileStatus)Mockito.mock(HdfsUtils.HadoopFileStatus.class);
        FileStatus mockSourceStatus = (FileStatus)Mockito.mock(FileStatus.class);
        FsShell mockFsShell = (FsShell)Mockito.mock(FsShell.class);
        Mockito.when((Object)mockSourceStatus.getGroup()).thenReturn((Object)fakeSourceGroup);
        Mockito.when((Object)mockHadoopFileStatus.getFileStatus()).thenReturn((Object)mockSourceStatus);
        ((FsShell)Mockito.doThrow(RuntimeException.class).when((Object)mockFsShell)).run((String[])Matchers.any(String[].class));
        HdfsUtils.setFullFileStatus((Configuration)conf, (HdfsUtils.HadoopFileStatus)mockHadoopFileStatus, (String)fakeTargetGroup, (FileSystem)((FileSystem)Mockito.mock(FileSystem.class)), (Path)fakeTarget, (boolean)true, (FsShell)mockFsShell);
        ((FsShell)Mockito.verify((Object)mockFsShell)).run(new String[]{"-chgrp", "-R", fakeSourceGroup, fakeTarget.toString()});
    }

    @Test
    public void testSetFullFileStatusFailInheritAclsRecursive() throws Exception {
        Configuration conf = new Configuration();
        conf.set("dfs.namenode.acls.enabled", "true");
        Path fakeTarget = new Path("fakePath");
        HdfsUtils.HadoopFileStatus mockHadoopFileStatus = (HdfsUtils.HadoopFileStatus)Mockito.mock(HdfsUtils.HadoopFileStatus.class);
        FileStatus mockSourceStatus = (FileStatus)Mockito.mock(FileStatus.class);
        FsShell mockFsShell = (FsShell)Mockito.mock(FsShell.class);
        AclStatus mockAclStatus = (AclStatus)Mockito.mock(AclStatus.class);
        Mockito.when((Object)mockSourceStatus.getPermission()).thenReturn((Object)new FsPermission(777));
        Mockito.when((Object)mockAclStatus.toString()).thenReturn((Object)"");
        Mockito.when((Object)mockHadoopFileStatus.getFileStatus()).thenReturn((Object)mockSourceStatus);
        Mockito.when((Object)mockHadoopFileStatus.getAclEntries()).thenReturn(new ArrayList());
        Mockito.when((Object)mockHadoopFileStatus.getAclStatus()).thenReturn((Object)mockAclStatus);
        ((FsShell)Mockito.doThrow(RuntimeException.class).when((Object)mockFsShell)).run((String[])Matchers.any(String[].class));
        HdfsUtils.setFullFileStatus((Configuration)conf, (HdfsUtils.HadoopFileStatus)mockHadoopFileStatus, (String)"", (FileSystem)((FileSystem)Mockito.mock(FileSystem.class)), (Path)fakeTarget, (boolean)true, (FsShell)mockFsShell);
        ((FsShell)Mockito.verify((Object)mockFsShell)).run(new String[]{"-setfacl", "-R", "--set", (String)Matchers.any(String.class), fakeTarget.toString()});
    }

    @Test
    public void testSetFullFileStatusFailInheritPermsRecursive() throws Exception {
        Configuration conf = new Configuration();
        conf.set("dfs.namenode.acls.enabled", "false");
        Path fakeTarget = new Path("fakePath");
        HdfsUtils.HadoopFileStatus mockHadoopFileStatus = (HdfsUtils.HadoopFileStatus)Mockito.mock(HdfsUtils.HadoopFileStatus.class);
        FileStatus mockSourceStatus = (FileStatus)Mockito.mock(FileStatus.class);
        FsShell mockFsShell = (FsShell)Mockito.mock(FsShell.class);
        Mockito.when((Object)mockSourceStatus.getPermission()).thenReturn((Object)new FsPermission(777));
        Mockito.when((Object)mockHadoopFileStatus.getFileStatus()).thenReturn((Object)mockSourceStatus);
        ((FsShell)Mockito.doThrow(RuntimeException.class).when((Object)mockFsShell)).run((String[])Matchers.any(String[].class));
        HdfsUtils.setFullFileStatus((Configuration)conf, (HdfsUtils.HadoopFileStatus)mockHadoopFileStatus, (String)"", (FileSystem)((FileSystem)Mockito.mock(FileSystem.class)), (Path)fakeTarget, (boolean)true, (FsShell)mockFsShell);
        ((FsShell)Mockito.verify((Object)mockFsShell)).run(new String[]{"-chmod", "-R", (String)Matchers.any(String.class), fakeTarget.toString()});
    }

    @Test
    public void testSkipSetFullFileStatusIfBlobStore() throws IOException {
        Configuration conf = new Configuration();
        conf.set(HiveConf.ConfVars.HIVE_BLOBSTORE_SUPPORTED_SCHEMES.varname, "s3a");
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)fs.getUri()).thenReturn((Object)URI.create("s3a:///"));
        HdfsUtils.setFullFileStatus((Configuration)conf, null, null, (FileSystem)fs, null, (boolean)false);
        ((FileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getFileStatus((Path)Matchers.any(Path.class));
        ((FileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).listStatus((Path[])Matchers.any(Path[].class));
        ((FileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).setPermission((Path)Matchers.any(Path.class), (FsPermission)Matchers.any(FsPermission.class));
        ((FileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).setAcl((Path)Matchers.any(Path.class), Matchers.anyList());
        ((FileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).setOwner((Path)Matchers.any(Path.class), (String)Matchers.any(String.class), (String)Matchers.any(String.class));
    }
}

