/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.sql.Connection;
import java.sql.SQLException;
import junit.framework.Assert;
import org.apache.hive.beeline.BeeLine;
import org.apache.hive.beeline.BeeLineOpts;
import org.apache.hive.beeline.ClientCommandHookFactory;
import org.apache.hive.beeline.ClientHook;
import org.apache.hive.beeline.DatabaseConnection;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class TestClientCommandHookFactory {
    public BeeLine setupMockData(boolean isBeeLine, boolean showDbInPrompt) {
        BeeLine mockBeeLine = (BeeLine)Mockito.mock(BeeLine.class);
        DatabaseConnection mockDatabaseConnection = (DatabaseConnection)Mockito.mock(DatabaseConnection.class);
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        try {
            Mockito.when((Object)mockConnection.getSchema()).thenReturn((Object)"newDatabase");
            Mockito.when((Object)mockDatabaseConnection.getConnection()).thenReturn((Object)mockConnection);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Mockito.when((Object)mockBeeLine.getDatabaseConnection()).thenReturn((Object)mockDatabaseConnection);
        BeeLineOpts mockBeeLineOpts = (BeeLineOpts)Mockito.mock(BeeLineOpts.class);
        Mockito.when((Object)mockBeeLineOpts.getShowDbInPrompt()).thenReturn((Object)showDbInPrompt);
        Mockito.when((Object)mockBeeLine.getOpts()).thenReturn((Object)mockBeeLineOpts);
        Mockito.when((Object)mockBeeLine.isBeeLine()).thenReturn((Object)isBeeLine);
        return mockBeeLine;
    }

    @Test
    public void testGetHookCli() {
        BeeLine beeLine = this.setupMockData(false, false);
        Assert.assertNull((Object)ClientCommandHookFactory.get().getHook(beeLine, "set a;"));
        Assert.assertTrue((boolean)(ClientCommandHookFactory.get().getHook(beeLine, "set a=b;") instanceof ClientCommandHookFactory.SetCommandHook));
        Assert.assertTrue((boolean)(ClientCommandHookFactory.get().getHook(beeLine, "USE a.b") instanceof ClientCommandHookFactory.UseCommandHook));
        Assert.assertNull((Object)ClientCommandHookFactory.get().getHook(beeLine, "coNNect a.b"));
        Assert.assertNull((Object)ClientCommandHookFactory.get().getHook(beeLine, "gO 1"));
        Assert.assertNull((Object)ClientCommandHookFactory.get().getHook(beeLine, "g"));
    }

    @Test
    public void testGetHookBeeLineWithShowDbInPrompt() {
        BeeLine beeLine = this.setupMockData(true, true);
        Assert.assertNull((Object)ClientCommandHookFactory.get().getHook(beeLine, "set a;"));
        Assert.assertNull((Object)ClientCommandHookFactory.get().getHook(beeLine, "set a=b;"));
        Assert.assertTrue((boolean)(ClientCommandHookFactory.get().getHook(beeLine, "USE a.b") instanceof ClientCommandHookFactory.UseCommandHook));
        Assert.assertTrue((boolean)(ClientCommandHookFactory.get().getHook(beeLine, "coNNect a.b") instanceof ClientCommandHookFactory.ConnectCommandHook));
        Assert.assertTrue((boolean)(ClientCommandHookFactory.get().getHook(beeLine, "gO 1") instanceof ClientCommandHookFactory.GoCommandHook));
        Assert.assertNull((Object)ClientCommandHookFactory.get().getHook(beeLine, "g"));
    }

    @Test
    public void testGetHookBeeLineWithoutShowDbInPrompt() {
        BeeLine beeLine = this.setupMockData(true, false);
        Assert.assertNull((Object)ClientCommandHookFactory.get().getHook(beeLine, "set a;"));
        Assert.assertNull((Object)ClientCommandHookFactory.get().getHook(beeLine, "set a=b;"));
        Assert.assertNull((Object)ClientCommandHookFactory.get().getHook(beeLine, "USE a.b"));
        Assert.assertNull((Object)ClientCommandHookFactory.get().getHook(beeLine, "coNNect a.b"));
        Assert.assertNull((Object)ClientCommandHookFactory.get().getHook(beeLine, "gO 1"));
        Assert.assertNull((Object)ClientCommandHookFactory.get().getHook(beeLine, "g"));
    }

    @Test
    public void testUseHook() {
        BeeLine beeLine = this.setupMockData(true, true);
        ClientHook hook = ClientCommandHookFactory.get().getHook(beeLine, "USE newDatabase1");
        Assert.assertTrue((boolean)(hook instanceof ClientCommandHookFactory.UseCommandHook));
        hook.postHook(beeLine);
        ArgumentCaptor argument = ArgumentCaptor.forClass(String.class);
        ((BeeLine)Mockito.verify((Object)beeLine)).setCurrentDatabase((String)argument.capture());
        Assert.assertEquals((String)"newDatabase1", (String)((String)argument.getValue()));
    }

    @Test
    public void testConnectHook() {
        BeeLine beeLine = this.setupMockData(true, true);
        ClientHook hook = ClientCommandHookFactory.get().getHook(beeLine, "coNNect jdbc:hive2://localhost:10000/newDatabase2 a a");
        Assert.assertTrue((boolean)(hook instanceof ClientCommandHookFactory.ConnectCommandHook));
        hook.postHook(beeLine);
        ArgumentCaptor argument = ArgumentCaptor.forClass(String.class);
        ((BeeLine)Mockito.verify((Object)beeLine)).setCurrentDatabase((String)argument.capture());
        Assert.assertEquals((String)"newDatabase2", (String)((String)argument.getValue()));
    }

    @Test
    public void testGoHook() {
        BeeLine beeLine = this.setupMockData(true, true);
        ClientHook hook = ClientCommandHookFactory.get().getHook(beeLine, "go 1");
        Assert.assertTrue((boolean)(hook instanceof ClientCommandHookFactory.GoCommandHook));
        hook.postHook(beeLine);
        ArgumentCaptor argument = ArgumentCaptor.forClass(String.class);
        ((BeeLine)Mockito.verify((Object)beeLine)).setCurrentDatabase((String)argument.capture());
        Assert.assertEquals((String)"newDatabase", (String)((String)argument.getValue()));
    }
}

