/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline.cli;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.hive.beeline.cli.HiveCli;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHiveCli {
    private static final Logger LOG = LoggerFactory.getLogger((String)TestHiveCli.class.getName());
    private static final int ERRNO_OK = 0;
    private static final int ERRNO_ARGS = 1;
    private static final int ERRNO_OTHER = 2;
    private static final String SOURCE_CONTEXT = "create table if not exists test.testSrcTbl(sc1 string);";
    private static final String SOURCE_CONTEXT2 = "create table if not exists test.testSrcTbl2(sc2 string);";
    private static final String SOURCE_CONTEXT3 = "create table if not exists test.testSrcTbl3(sc3 string);";
    private static final String SOURCE_CONTEXT4 = "show tables;!ls;show tables;\nquit;";
    static final String CMD = "create database if not exists test;\ncreate table if not exists test.testTbl(a string, b string);\n";
    private HiveCli cli;
    private OutputStream os;
    private PrintStream ps;
    private OutputStream errS;
    private PrintStream errPs;
    private File tmp = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCMD(String[] args, String input, int retCode) {
        InputStream inputStream = null;
        int ret = 0;
        try {
            if (input != null) {
                inputStream = IOUtils.toInputStream((String)input);
            }
            ret = this.cli.runWithArgs(args, inputStream);
        }
        catch (Throwable e) {
            LOG.error("Failed to execute command due to the error: " + e);
        }
        finally {
            if (retCode != ret) {
                LOG.error("Failed due to the error:" + this.errS.toString());
                Assert.fail((String)("Supported return code is " + retCode + " while the actual is " + ret));
            }
        }
    }

    private void verifyCMD(String CMD, String keywords, OutputStream os, String[] options, int retCode, boolean contains) {
        this.executeCMD(options, CMD, retCode);
        String output = os.toString();
        LOG.debug(output);
        if (contains) {
            Assert.assertTrue((String)("The expected keyword \"" + keywords + "\" occur in the output: " + output), (boolean)output.contains(keywords));
        } else {
            Assert.assertFalse((String)("The expected keyword \"" + keywords + "\" should be excluded occurred in the output: " + output), (boolean)output.contains(keywords));
        }
    }

    @Test
    public void testInValidCmd() {
        this.verifyCMD("!lss\n", "Failed to execute lss", this.errS, null, 2, true);
    }

    @Test
    public void testCmd() {
        this.verifyCMD("show tables;!ls;show tables;\n", "src", this.os, null, 0, true);
    }

    @Test
    public void testCommentStripping() {
        this.verifyCMD("!ls --abcdefghijklmnopqrstuvwxyz\n", "src", this.os, null, 0, true);
    }

    @Test
    public void testSetPromptValue() {
        this.verifyCMD("set hive.cli.prompt=MYCLI;SHOW\nTABLES;", "MYCLI> ", this.os, null, 0, true);
    }

    @Test
    public void testSetHeaderValue() {
        this.verifyCMD("create database if not exists test;\ncreate table if not exists test.testTbl(a string, b string);\nset hive.cli.print.header=true;\n select * from test.testTbl;\n", "testtbl.a testtbl.b", this.os, null, 0, true);
    }

    @Test
    public void testHelp() {
        this.verifyCMD(null, "usage: hive", this.os, new String[]{"-H"}, 1, true);
    }

    @Test
    public void testInvalidDatabaseOptions() {
        this.verifyCMD("\nshow tables;\nquit;\n", "Database does not exist: invalidDB", this.errS, new String[]{"--database", "invalidDB"}, 0, true);
    }

    @Test
    public void testDatabaseOptions() {
        this.verifyCMD("\nshow tables;\nquit;", "testtbl", this.os, new String[]{"--database", "test"}, 0, true);
    }

    @Test
    public void testSourceCmd() {
        File f = this.generateTmpFile(SOURCE_CONTEXT);
        this.verifyCMD("source " + f.getPath() + ";desc testSrcTbl;\nquit;\n", "sc1", this.os, new String[]{"--database", "test"}, 0, true);
        f.delete();
    }

    @Test
    public void testSourceCmd2() {
        File f = this.generateTmpFile(SOURCE_CONTEXT3);
        this.verifyCMD("source " + f.getPath() + ";desc testSrcTbl3;\nquit;\n", "sc3", this.os, new String[]{"--database", "test"}, 0, true);
        f.delete();
    }

    @Test
    public void testSourceCmd3() {
        File f = this.generateTmpFile(SOURCE_CONTEXT4);
        this.verifyCMD("source " + f.getPath() + ";desc testSrcTbl4;\nquit;\n", "src", this.os, new String[]{"--database", "test"}, 2, true);
        f.delete();
    }

    @Test
    public void testSqlFromCmd() {
        this.verifyCMD(null, "", this.os, new String[]{"-e", "show databases;"}, 0, true);
    }

    @Test
    public void testSqlFromCmdWithDBName() {
        this.verifyCMD(null, "testtbl", this.os, new String[]{"-e", "show tables;", "--database", "test"}, 0, true);
    }

    @Test
    public void testInvalidOptions() {
        this.verifyCMD(null, "The '-e' and '-f' options cannot be specified simultaneously", this.errS, new String[]{"-e", "show tables;", "-f", "path/to/file"}, 1, true);
    }

    @Test
    public void testInvalidOptions2() {
        this.verifyCMD(null, "Unrecognized option: -k", this.errS, new String[]{"-k"}, 1, true);
    }

    @Test
    public void testVariables() {
        this.verifyCMD("set system:xxx=5;\nset system:yyy=${system:xxx};\nset system:yyy;", "", this.os, null, 0, true);
    }

    @Test
    public void testVariablesForSource() {
        File f = this.generateTmpFile(SOURCE_CONTEXT2);
        this.verifyCMD("set hiveconf:zzz=" + f.getAbsolutePath() + ";\nsource ${hiveconf:zzz};\ndesc testSrcTbl2;", "sc2", this.os, new String[]{"--database", "test"}, 0, true);
        f.delete();
    }

    @Test
    public void testErrOutput() {
        this.verifyCMD("show tables;set system:xxx=5;set system:yyy=${system:xxx};\nlss;", "cannot recognize input near 'lss' '<EOF>' '<EOF>'", this.errS, null, 2, true);
    }

    @Test
    public void testUseCurrentDB1() {
        this.verifyCMD("create database if not exists testDB; set hive.cli.print.current.db=true;use testDB;\nuse default;drop if exists testDB;", "hive (testDB)>", this.os, null, 2, true);
    }

    @Test
    public void testUseCurrentDB2() {
        this.verifyCMD("create database if not exists testDB; set hive.cli.print.current.db=true;use\ntestDB;\nuse default;drop if exists testDB;", "hive (testDB)>", this.os, null, 2, true);
    }

    @Test
    public void testUseCurrentDB3() {
        this.verifyCMD("create database if not exists testDB; set hive.cli.print.current.db=true;use  testDB;\nuse default;drop if exists testDB;", "hive (testDB)>", this.os, null, 2, true);
    }

    @Test
    public void testUseInvalidDB() {
        this.verifyCMD("set hive.cli.print.current.db=true;use invalidDB;", "hive (invalidDB)>", this.os, null, 2, false);
    }

    @Test
    public void testNoErrorDB() {
        this.verifyCMD(null, "Error: Method not supported (state=,code=0)", this.errS, new String[]{"-e", "show tables;"}, 0, false);
    }

    private void redirectOutputStream() {
        this.os = new ByteArrayOutputStream();
        this.ps = new PrintStream(this.os);
        this.errS = new ByteArrayOutputStream();
        this.errPs = new PrintStream(this.errS);
        System.setOut(this.ps);
        System.setErr(this.errPs);
    }

    private void initFromFile() {
        this.tmp = this.generateTmpFile(CMD);
        if (this.tmp == null) {
            Assert.fail((String)"Fail to create the initial file");
        }
        this.executeCMD(new String[]{"-f", "\"" + this.tmp.getAbsolutePath() + "\""}, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File generateTmpFile(String context) {
        File file = null;
        BufferedWriter bw = null;
        try {
            file = File.createTempFile("test", ".sql");
            bw = new BufferedWriter(new FileWriter(file));
            bw.write(context);
        }
        catch (IOException e) {
            try {
                LOG.error("Failed to write tmp file due to the exception: " + e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bw);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)bw);
        }
        IOUtils.closeQuietly((Writer)bw);
        return file;
    }

    @Before
    public void setup() {
        System.setProperty("datanucleus.schema.autoCreateAll", "true");
        this.cli = new HiveCli();
        this.redirectOutputStream();
        this.initFromFile();
    }

    @After
    public void tearDown() {
        this.tmp.delete();
    }
}

