/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo;

import java.util.List;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.mock.MockInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.accumulo.AccumuloConnectionParameters;
import org.apache.hadoop.hive.accumulo.AccumuloDefaultIndexScanner;
import org.apache.hadoop.hive.accumulo.AccumuloIndexLexicoder;
import org.apache.hadoop.hive.accumulo.AccumuloStorageHandler;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAccumuloDefaultIndexScanner {
    private static final Logger LOG = LoggerFactory.getLogger(TestAccumuloDefaultIndexScanner.class);
    private static final Value EMPTY_VALUE = new Value();

    private static void addRow(BatchWriter writer, String rowId, String cf, String cq) throws MutationsRejectedException {
        Mutation mut = new Mutation((CharSequence)rowId);
        mut.put(new Text(cf), new Text(cq), EMPTY_VALUE);
        writer.addMutation(mut);
    }

    private static void addRow(BatchWriter writer, Integer rowId, String cf, String cq) throws MutationsRejectedException {
        Mutation mut = new Mutation(AccumuloIndexLexicoder.encodeValue((byte[])String.valueOf(rowId).getBytes(), (String)"int", (boolean)true));
        mut.put(new Text(cf), new Text(cq), EMPTY_VALUE);
        writer.addMutation(mut);
    }

    private static void addRow(BatchWriter writer, boolean rowId, String cf, String cq) throws MutationsRejectedException {
        Mutation mut = new Mutation((CharSequence)String.valueOf(rowId));
        mut.put(new Text(cf), new Text(cq), EMPTY_VALUE);
        writer.addMutation(mut);
    }

    public static AccumuloDefaultIndexScanner buildMockHandler(int maxMatches) {
        try {
            String table = "table";
            Text emptyText = new Text("");
            Configuration conf = new Configuration();
            conf.set("accumulo.indextable.name", table);
            conf.setInt("accumulo.index.rows.max", maxMatches);
            conf.set("accumulo.indexed.columns", "*");
            conf.set("columns", "rid,name,age,cars,mgr");
            conf.set("accumulo.columns.mapping", ":rowId,name:name,age:age,cars:cars,mgr:mgr");
            AccumuloDefaultIndexScanner handler = new AccumuloDefaultIndexScanner();
            handler.init(conf);
            MockInstance inst = new MockInstance("test_instance");
            Connector conn = inst.getConnector("root", (AuthenticationToken)new PasswordToken((CharSequence)""));
            if (!conn.tableOperations().exists(table)) {
                conn.tableOperations().create(table);
                BatchWriterConfig batchConfig = new BatchWriterConfig();
                BatchWriter writer = conn.createBatchWriter(table, batchConfig);
                TestAccumuloDefaultIndexScanner.addRow(writer, "fred", "name_name", "row1");
                TestAccumuloDefaultIndexScanner.addRow(writer, "25", "age_age", "row1");
                TestAccumuloDefaultIndexScanner.addRow(writer, 5, "cars_cars", "row1");
                TestAccumuloDefaultIndexScanner.addRow(writer, true, "mgr_mgr", "row1");
                TestAccumuloDefaultIndexScanner.addRow(writer, "bill", "name_name", "row2");
                TestAccumuloDefaultIndexScanner.addRow(writer, "20", "age_age", "row2");
                TestAccumuloDefaultIndexScanner.addRow(writer, 2, "cars_cars", "row2");
                TestAccumuloDefaultIndexScanner.addRow(writer, false, "mgr_mgr", "row2");
                TestAccumuloDefaultIndexScanner.addRow(writer, "sally", "name_name", "row3");
                TestAccumuloDefaultIndexScanner.addRow(writer, "23", "age_age", "row3");
                TestAccumuloDefaultIndexScanner.addRow(writer, 6, "cars_cars", "row3");
                TestAccumuloDefaultIndexScanner.addRow(writer, true, "mgr_mgr", "row3");
                TestAccumuloDefaultIndexScanner.addRow(writer, "rob", "name_name", "row4");
                TestAccumuloDefaultIndexScanner.addRow(writer, "60", "age_age", "row4");
                TestAccumuloDefaultIndexScanner.addRow(writer, 1, "cars_cars", "row4");
                TestAccumuloDefaultIndexScanner.addRow(writer, false, "mgr_mgr", "row4");
                writer.close();
            }
            AccumuloConnectionParameters connectionParams = (AccumuloConnectionParameters)Mockito.mock(AccumuloConnectionParameters.class);
            AccumuloStorageHandler storageHandler = (AccumuloStorageHandler)Mockito.mock(AccumuloStorageHandler.class);
            Mockito.when((Object)connectionParams.getConnector()).thenReturn((Object)conn);
            handler.setConnectParams(connectionParams);
            return handler;
        }
        catch (AccumuloException | AccumuloSecurityException | TableExistsException | TableNotFoundException e) {
            LOG.error(e.getLocalizedMessage(), e);
            return null;
        }
    }

    @Test
    public void testMatchNone() {
        AccumuloDefaultIndexScanner handler = TestAccumuloDefaultIndexScanner.buildMockHandler(10);
        List ranges = handler.getIndexRowRanges("name", new Range((CharSequence)"mike"));
        Assert.assertEquals((long)0L, (long)ranges.size());
    }

    @Test
    public void testMatchRange() {
        AccumuloDefaultIndexScanner handler = TestAccumuloDefaultIndexScanner.buildMockHandler(10);
        List ranges = handler.getIndexRowRanges("age", new Range((CharSequence)"10", (CharSequence)"50"));
        Assert.assertEquals((long)3L, (long)ranges.size());
        Assert.assertTrue((String)"does not contain row1", (boolean)ranges.contains(new Range((CharSequence)"row1")));
        Assert.assertTrue((String)"does not contain row2", (boolean)ranges.contains(new Range((CharSequence)"row2")));
        Assert.assertTrue((String)"does not contain row3", (boolean)ranges.contains(new Range((CharSequence)"row3")));
    }

    public void testTooManyMatches() {
        AccumuloDefaultIndexScanner handler = TestAccumuloDefaultIndexScanner.buildMockHandler(2);
        List ranges = handler.getIndexRowRanges("age", new Range((CharSequence)"10", (CharSequence)"50"));
        Assert.assertNull((String)"ranges should be null", (Object)ranges);
    }

    @Test
    public void testMatchExact() {
        AccumuloDefaultIndexScanner handler = TestAccumuloDefaultIndexScanner.buildMockHandler(10);
        List ranges = handler.getIndexRowRanges("age", new Range((CharSequence)"20"));
        Assert.assertEquals((long)1L, (long)ranges.size());
        Assert.assertTrue((String)"does not contain row2", (boolean)ranges.contains(new Range((CharSequence)"row2")));
    }

    @Test
    public void testValidIndex() {
        Configuration conf = new Configuration();
        conf.set("accumulo.indexed.columns", "name,age,phone,email");
        conf.set("accumulo.indextable.name", "contact");
        AccumuloDefaultIndexScanner handler = new AccumuloDefaultIndexScanner();
        handler.init(conf);
        Assert.assertTrue((String)"name is not identified as an index", (boolean)handler.isIndexed("name"));
        Assert.assertTrue((String)"age is not identified as an index", (boolean)handler.isIndexed("age"));
        Assert.assertTrue((String)"phone is not identified as an index", (boolean)handler.isIndexed("phone"));
        Assert.assertTrue((String)"email is not identified as an index", (boolean)handler.isIndexed("email"));
    }

    @Test
    public void testInvalidIndex() {
        Configuration conf = new Configuration();
        conf.set("accumulo.indexed.columns", "name,age,phone,email");
        conf.set("accumulo.indextable.name", "contact");
        AccumuloDefaultIndexScanner handler = new AccumuloDefaultIndexScanner();
        handler.init(conf);
        Assert.assertFalse((String)"mobile is identified as an index", (boolean)handler.isIndexed("mobile"));
        Assert.assertFalse((String)"mail is identified as an index", (boolean)handler.isIndexed("mail"));
    }

    @Test
    public void testMissingTable() {
        Configuration conf = new Configuration();
        conf.set("accumulo.indexed.columns", "name,age,phone,email");
        AccumuloDefaultIndexScanner handler = new AccumuloDefaultIndexScanner();
        handler.init(conf);
        Assert.assertFalse((String)"name is identified as an index", (boolean)handler.isIndexed("name"));
        Assert.assertFalse((String)"age is identified as an index", (boolean)handler.isIndexed("age"));
    }

    @Test
    public void testWildcardIndex() {
        Configuration conf = new Configuration();
        conf.set("accumulo.indexed.columns", "*");
        conf.set("accumulo.indextable.name", "contact");
        AccumuloDefaultIndexScanner handler = new AccumuloDefaultIndexScanner();
        handler.init(conf);
        Assert.assertTrue((String)"name is not identified as an index", (boolean)handler.isIndexed("name"));
        Assert.assertTrue((String)"age is not identified as an index", (boolean)handler.isIndexed("age"));
    }

    @Test
    public void testNullIndex() {
        Configuration conf = new Configuration();
        conf.set("accumulo.indextable.name", "contact");
        AccumuloDefaultIndexScanner handler = new AccumuloDefaultIndexScanner();
        handler.init(conf);
        Assert.assertTrue((String)"name is not identified as an index", (boolean)handler.isIndexed("name"));
    }

    @Test
    public void testEmptyIndex() {
        Configuration conf = new Configuration();
        conf.set("accumulo.indexed.columns", "");
        conf.set("accumulo.indextable.name", "contact");
        AccumuloDefaultIndexScanner handler = new AccumuloDefaultIndexScanner();
        handler.init(conf);
        Assert.assertFalse((String)"name is identified as an index", (boolean)handler.isIndexed("name"));
    }
}

