/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.hadoop.hive.accumulo.AccumuloHiveRow;
import org.apache.hadoop.hive.accumulo.LazyAccumuloMap;
import org.apache.hadoop.hive.accumulo.columns.ColumnEncoding;
import org.apache.hadoop.hive.accumulo.columns.HiveAccumuloMapColumnMapping;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazyInteger;
import org.apache.hadoop.hive.serde2.lazy.LazyString;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestLazyAccumuloMap {
    protected byte[] toBytes(int i) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream((OutputStream)baos);
        out.writeInt(i);
        out.close();
        return baos.toByteArray();
    }

    @Test
    public void testStringMapWithProjection() throws SerDeException {
        AccumuloHiveRow row = new AccumuloHiveRow("row");
        row.add("cf1", "foo", "bar".getBytes());
        row.add("cf1", "bar", "foo".getBytes());
        row.add("cf2", "foo1", "bar1".getBytes());
        row.add("cf3", "bar1", "foo1".getBytes());
        HiveAccumuloMapColumnMapping mapping = new HiveAccumuloMapColumnMapping("cf1", null, ColumnEncoding.STRING, ColumnEncoding.STRING, "column", TypeInfoFactory.getMapTypeInfo((TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.stringTypeInfo).toString());
        Text nullSequence = new Text("\\N");
        ObjectInspector oi = LazyFactory.createLazyObjectInspector((TypeInfo)((TypeInfo)TypeInfoUtils.getTypeInfosFromTypeString((String)"map<string,string>").get(0)), (byte[])new byte[]{1, 2}, (int)0, (Text)nullSequence, (boolean)false, (byte)0);
        LazyAccumuloMap map = new LazyAccumuloMap((LazyMapObjectInspector)oi);
        map.init(row, mapping);
        Assert.assertEquals((long)2L, (long)map.getMapSize());
        Object o = map.getMapValueElement((Object)new Text("foo"));
        Assert.assertNotNull((Object)o);
        Assert.assertEquals((Object)new Text("bar"), (Object)((LazyString)o).getWritableObject());
        o = map.getMapValueElement((Object)new Text("bar"));
        Assert.assertNotNull((Object)o);
        Assert.assertEquals((Object)new Text("foo"), (Object)((LazyString)o).getWritableObject());
    }

    @Test
    public void testIntMap() throws SerDeException, IOException {
        AccumuloHiveRow row = new AccumuloHiveRow("row");
        row.add(new Text("cf1"), new Text("1"), "2".getBytes());
        row.add(new Text("cf1"), new Text("2"), "4".getBytes());
        row.add(new Text("cf1"), new Text("3"), "6".getBytes());
        HiveAccumuloMapColumnMapping mapping = new HiveAccumuloMapColumnMapping("cf1", null, ColumnEncoding.STRING, ColumnEncoding.STRING, "column", TypeInfoFactory.getMapTypeInfo((TypeInfo)TypeInfoFactory.intTypeInfo, (TypeInfo)TypeInfoFactory.intTypeInfo).toString());
        Text nullSequence = new Text("\\N");
        ObjectInspector oi = LazyFactory.createLazyObjectInspector((TypeInfo)((TypeInfo)TypeInfoUtils.getTypeInfosFromTypeString((String)"map<int,int>").get(0)), (byte[])new byte[]{1, 2}, (int)0, (Text)nullSequence, (boolean)false, (byte)0);
        LazyAccumuloMap map = new LazyAccumuloMap((LazyMapObjectInspector)oi);
        map.init(row, mapping);
        Assert.assertEquals((long)3L, (long)map.getMapSize());
        Object o = map.getMapValueElement((Object)new IntWritable(1));
        Assert.assertNotNull((Object)o);
        Assert.assertEquals((Object)new IntWritable(2), (Object)((LazyInteger)o).getWritableObject());
        o = map.getMapValueElement((Object)new IntWritable(2));
        Assert.assertNotNull((Object)o);
        Assert.assertEquals((Object)new IntWritable(4), (Object)((LazyInteger)o).getWritableObject());
        o = map.getMapValueElement((Object)new IntWritable(3));
        Assert.assertNotNull((Object)o);
        Assert.assertEquals((Object)new IntWritable(6), (Object)((LazyInteger)o).getWritableObject());
    }

    @Test
    public void testBinaryIntMap() throws SerDeException, IOException {
        AccumuloHiveRow row = new AccumuloHiveRow("row");
        row.add(new Text("cf1"), new Text(this.toBytes(1)), this.toBytes(2));
        row.add(new Text("cf1"), new Text(this.toBytes(2)), this.toBytes(4));
        row.add(new Text("cf1"), new Text(this.toBytes(3)), this.toBytes(6));
        HiveAccumuloMapColumnMapping mapping = new HiveAccumuloMapColumnMapping("cf1", null, ColumnEncoding.BINARY, ColumnEncoding.BINARY, "column", TypeInfoFactory.getMapTypeInfo((TypeInfo)TypeInfoFactory.intTypeInfo, (TypeInfo)TypeInfoFactory.intTypeInfo).toString());
        Text nullSequence = new Text("\\N");
        ObjectInspector oi = LazyFactory.createLazyObjectInspector((TypeInfo)((TypeInfo)TypeInfoUtils.getTypeInfosFromTypeString((String)"map<int,int>").get(0)), (byte[])new byte[]{1, 2}, (int)0, (Text)nullSequence, (boolean)false, (byte)0);
        LazyAccumuloMap map = new LazyAccumuloMap((LazyMapObjectInspector)oi);
        map.init(row, mapping);
        Assert.assertEquals((long)3L, (long)map.getMapSize());
        Object o = map.getMapValueElement((Object)new IntWritable(1));
        Assert.assertNotNull((Object)o);
        Assert.assertEquals((Object)new IntWritable(2), (Object)((LazyInteger)o).getWritableObject());
        o = map.getMapValueElement((Object)new IntWritable(2));
        Assert.assertNotNull((Object)o);
        Assert.assertEquals((Object)new IntWritable(4), (Object)((LazyInteger)o).getWritableObject());
        o = map.getMapValueElement((Object)new IntWritable(3));
        Assert.assertNotNull((Object)o);
        Assert.assertEquals((Object)new IntWritable(6), (Object)((LazyInteger)o).getWritableObject());
    }

    @Test
    public void testMixedSerializationMap() throws SerDeException, IOException {
        AccumuloHiveRow row = new AccumuloHiveRow("row");
        row.add(new Text("cf1"), new Text(this.toBytes(1)), "2".getBytes());
        row.add(new Text("cf1"), new Text(this.toBytes(2)), "4".getBytes());
        row.add(new Text("cf1"), new Text(this.toBytes(3)), "6".getBytes());
        HiveAccumuloMapColumnMapping mapping = new HiveAccumuloMapColumnMapping("cf1", null, ColumnEncoding.BINARY, ColumnEncoding.STRING, "column", TypeInfoFactory.getMapTypeInfo((TypeInfo)TypeInfoFactory.intTypeInfo, (TypeInfo)TypeInfoFactory.intTypeInfo).toString());
        Text nullSequence = new Text("\\N");
        ObjectInspector oi = LazyFactory.createLazyObjectInspector((TypeInfo)((TypeInfo)TypeInfoUtils.getTypeInfosFromTypeString((String)"map<int,int>").get(0)), (byte[])new byte[]{1, 2}, (int)0, (Text)nullSequence, (boolean)false, (byte)0);
        LazyAccumuloMap map = new LazyAccumuloMap((LazyMapObjectInspector)oi);
        map.init(row, mapping);
        Assert.assertEquals((long)3L, (long)map.getMapSize());
        Object o = map.getMapValueElement((Object)new IntWritable(1));
        Assert.assertNotNull((Object)o);
        Assert.assertEquals((Object)new IntWritable(2), (Object)((LazyInteger)o).getWritableObject());
        o = map.getMapValueElement((Object)new IntWritable(2));
        Assert.assertNotNull((Object)o);
        Assert.assertEquals((Object)new IntWritable(4), (Object)((LazyInteger)o).getWritableObject());
        o = map.getMapValueElement((Object)new IntWritable(3));
        Assert.assertNotNull((Object)o);
        Assert.assertEquals((Object)new IntWritable(6), (Object)((LazyInteger)o).getWritableObject());
    }
}

