/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo;

import java.util.List;
import java.util.Set;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.accumulo.AccumuloDefaultIndexScanner;
import org.apache.hadoop.hive.accumulo.AccumuloIndexScanner;
import org.apache.hadoop.hive.accumulo.AccumuloIndexScannerException;
import org.apache.hadoop.hive.accumulo.serde.AccumuloIndexParameters;
import org.junit.Assert;
import org.junit.Test;

public class TestAccumuloIndexParameters {
    @Test
    public void testDefaultScanner() {
        try {
            AccumuloIndexScanner scanner = new AccumuloIndexParameters(new Configuration()).createScanner();
            Assert.assertTrue((boolean)(scanner instanceof AccumuloDefaultIndexScanner));
        }
        catch (AccumuloIndexScannerException e) {
            Assert.fail((String)"Unexpected exception thrown");
        }
    }

    @Test
    public void testUserHandler() throws AccumuloIndexScannerException {
        Configuration conf = new Configuration();
        conf.set("accumulo.index.scanner", MockAccumuloIndexScanner.class.getName());
        AccumuloIndexScanner scanner = new AccumuloIndexParameters(conf).createScanner();
        Assert.assertTrue((boolean)(scanner instanceof MockAccumuloIndexScanner));
    }

    @Test
    public void testBadHandler() {
        Configuration conf = new Configuration();
        conf.set("accumulo.index.scanner", "a.class.does.not.exist.IndexHandler");
        try {
            AccumuloIndexScanner accumuloIndexScanner = new AccumuloIndexParameters(conf).createScanner();
        }
        catch (AccumuloIndexScannerException e) {
            return;
        }
        Assert.fail((String)"Failed to throw exception for class not found");
    }

    @Test
    public void getIndexColumns() {
        Configuration conf = new Configuration();
        conf.set("accumulo.indexed.columns", "a,b,c");
        Set cols = new AccumuloIndexParameters(conf).getIndexColumns();
        Assert.assertEquals((long)3L, (long)cols.size());
        Assert.assertTrue((String)"Missing column a", (boolean)cols.contains("a"));
        Assert.assertTrue((String)"Missing column b", (boolean)cols.contains("b"));
        Assert.assertTrue((String)"Missing column c", (boolean)cols.contains("c"));
    }

    @Test
    public void getMaxIndexRows() {
        Configuration conf = new Configuration();
        conf.setInt("accumulo.index.rows.max", 10);
        int maxRows = new AccumuloIndexParameters(conf).getMaxIndexRows();
        Assert.assertEquals((long)10L, (long)maxRows);
    }

    @Test
    public void getAuths() {
        Configuration conf = new Configuration();
        conf.set("accumulo.authorizations", "public,open");
        Authorizations auths = new AccumuloIndexParameters(conf).getTableAuths();
        Assert.assertEquals((long)2L, (long)auths.size());
        Assert.assertTrue((String)"Missing auth public", (boolean)auths.contains("public"));
        Assert.assertTrue((String)"Missing auth open", (boolean)auths.contains("open"));
    }

    public static class MockAccumuloIndexScanner
    implements AccumuloIndexScanner {
        public void init(Configuration conf) {
        }

        public boolean isIndexed(String columnName) {
            return false;
        }

        public List<Range> getIndexRowRanges(String column, Range indexRange) {
            return null;
        }
    }
}

