/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.predicate;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.accumulo.columns.ColumnEncoding;
import org.apache.hadoop.hive.accumulo.columns.ColumnMapper;
import org.apache.hadoop.hive.accumulo.predicate.AccumuloPredicateHandler;
import org.apache.hadoop.hive.accumulo.predicate.NoSuchCompareOpException;
import org.apache.hadoop.hive.accumulo.predicate.NoSuchPrimitiveComparisonException;
import org.apache.hadoop.hive.accumulo.predicate.PushdownTuple;
import org.apache.hadoop.hive.accumulo.predicate.compare.DoubleCompare;
import org.apache.hadoop.hive.accumulo.predicate.compare.Equal;
import org.apache.hadoop.hive.accumulo.predicate.compare.GreaterThan;
import org.apache.hadoop.hive.accumulo.predicate.compare.GreaterThanOrEqual;
import org.apache.hadoop.hive.accumulo.predicate.compare.IntCompare;
import org.apache.hadoop.hive.accumulo.predicate.compare.LessThan;
import org.apache.hadoop.hive.accumulo.predicate.compare.LessThanOrEqual;
import org.apache.hadoop.hive.accumulo.predicate.compare.LongCompare;
import org.apache.hadoop.hive.accumulo.predicate.compare.NotEqual;
import org.apache.hadoop.hive.accumulo.predicate.compare.StringCompare;
import org.apache.hadoop.hive.accumulo.serde.TooManyAccumuloColumnsException;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.index.IndexSearchCondition;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotNull;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestAccumuloPredicateHandler {
    private AccumuloPredicateHandler handler = AccumuloPredicateHandler.getInstance();
    private JobConf conf;
    private ColumnMapper columnMapper;

    @Before
    public void setup() throws TooManyAccumuloColumnsException {
        FunctionRegistry.getFunctionNames();
        this.conf = new JobConf();
        List<String> columnNames = Arrays.asList("field1", "rid");
        List<TypeInfo> columnTypes = Arrays.asList(TypeInfoFactory.stringTypeInfo, TypeInfoFactory.stringTypeInfo);
        this.conf.set("columns", Joiner.on((char)',').join(columnNames));
        this.conf.set("columns.types", "string,string");
        String columnMappingStr = "cf:f1,:rowID";
        this.conf.set("accumulo.columns.mapping", columnMappingStr);
        this.columnMapper = new ColumnMapper(columnMappingStr, ColumnEncoding.STRING.getName(), columnNames, columnTypes);
    }

    @Test
    public void testGetRowIDSearchCondition() {
        ExprNodeColumnDesc column = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, "rid", null, false);
        ExprNodeConstantDesc constant = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (Object)"hi");
        ArrayList children = Lists.newArrayList();
        children.add(column);
        children.add(constant);
        ExprNodeGenericFuncDesc node = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPEqual(), (List)children);
        Assert.assertNotNull((Object)node);
        String filterExpr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)node);
        this.conf.set("hive.io.filter.expr.serialized", filterExpr);
        List sConditions = this.handler.getSearchConditions((Configuration)this.conf);
        Assert.assertEquals((long)sConditions.size(), (long)1L);
    }

    @Test
    public void testRangeEqual() throws SerDeException {
        ExprNodeColumnDesc column = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, "rid", null, false);
        ExprNodeConstantDesc constant = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (Object)"aaa");
        ArrayList children = Lists.newArrayList();
        children.add(column);
        children.add(constant);
        ExprNodeGenericFuncDesc node = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPEqual(), (List)children);
        Assert.assertNotNull((Object)node);
        String filterExpr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)node);
        this.conf.set("hive.io.filter.expr.serialized", filterExpr);
        List ranges = this.handler.getRanges((Configuration)this.conf, this.columnMapper);
        Assert.assertEquals((long)ranges.size(), (long)1L);
        Range range = (Range)ranges.iterator().next();
        Assert.assertTrue((boolean)range.isStartKeyInclusive());
        Assert.assertFalse((boolean)range.isEndKeyInclusive());
        Assert.assertTrue((boolean)range.contains(new Key(new Text("aaa"))));
        Assert.assertTrue((boolean)range.afterEndKey(new Key(new Text("aab"))));
        Assert.assertTrue((boolean)range.beforeStartKey(new Key(new Text("aa"))));
    }

    @Test
    public void testRangeGreaterThan() throws SerDeException {
        ExprNodeColumnDesc column = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, "rid", null, false);
        ExprNodeConstantDesc constant = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (Object)"aaa");
        ArrayList children = Lists.newArrayList();
        children.add(column);
        children.add(constant);
        ExprNodeGenericFuncDesc node = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPGreaterThan(), (List)children);
        Assert.assertNotNull((Object)node);
        String filterExpr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)node);
        this.conf.set("hive.io.filter.expr.serialized", filterExpr);
        List ranges = this.handler.getRanges((Configuration)this.conf, this.columnMapper);
        Assert.assertEquals((long)ranges.size(), (long)1L);
        Range range = (Range)ranges.iterator().next();
        Assert.assertTrue((boolean)range.isStartKeyInclusive());
        Assert.assertFalse((boolean)range.isEndKeyInclusive());
        Assert.assertFalse((boolean)range.contains(new Key(new Text("aaa"))));
        Assert.assertFalse((boolean)range.afterEndKey(new Key(new Text("ccccc"))));
        Assert.assertTrue((boolean)range.contains(new Key(new Text("aab"))));
        Assert.assertTrue((boolean)range.beforeStartKey(new Key(new Text("aa"))));
        Assert.assertTrue((boolean)range.beforeStartKey(new Key(new Text("aaa"))));
    }

    @Test
    public void rangeGreaterThanOrEqual() throws SerDeException {
        ExprNodeColumnDesc column = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, "rid", null, false);
        ExprNodeConstantDesc constant = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (Object)"aaa");
        ArrayList children = Lists.newArrayList();
        children.add(column);
        children.add(constant);
        ExprNodeGenericFuncDesc node = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPEqualOrGreaterThan(), (List)children);
        Assert.assertNotNull((Object)node);
        String filterExpr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)node);
        this.conf.set("hive.io.filter.expr.serialized", filterExpr);
        List ranges = this.handler.getRanges((Configuration)this.conf, this.columnMapper);
        Assert.assertEquals((long)ranges.size(), (long)1L);
        Range range = (Range)ranges.iterator().next();
        Assert.assertTrue((boolean)range.isStartKeyInclusive());
        Assert.assertFalse((boolean)range.isEndKeyInclusive());
        Assert.assertTrue((boolean)range.contains(new Key(new Text("aaa"))));
        Assert.assertFalse((boolean)range.afterEndKey(new Key(new Text("ccccc"))));
        Assert.assertTrue((boolean)range.contains(new Key(new Text("aab"))));
        Assert.assertTrue((boolean)range.beforeStartKey(new Key(new Text("aa"))));
    }

    @Test
    public void rangeLessThan() throws SerDeException {
        ExprNodeColumnDesc column = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, "rid", null, false);
        ExprNodeConstantDesc constant = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (Object)"aaa");
        ArrayList children = Lists.newArrayList();
        children.add(column);
        children.add(constant);
        ExprNodeGenericFuncDesc node = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPLessThan(), (List)children);
        Assert.assertNotNull((Object)node);
        String filterExpr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)node);
        this.conf.set("hive.io.filter.expr.serialized", filterExpr);
        List ranges = this.handler.getRanges((Configuration)this.conf, this.columnMapper);
        Assert.assertEquals((long)ranges.size(), (long)1L);
        Range range = (Range)ranges.iterator().next();
        Assert.assertTrue((boolean)range.isStartKeyInclusive());
        Assert.assertFalse((boolean)range.isEndKeyInclusive());
        Assert.assertFalse((boolean)range.contains(new Key(new Text("aaa"))));
        Assert.assertTrue((boolean)range.afterEndKey(new Key(new Text("ccccc"))));
        Assert.assertTrue((boolean)range.contains(new Key(new Text("aa"))));
        Assert.assertTrue((boolean)range.afterEndKey(new Key(new Text("aab"))));
        Assert.assertTrue((boolean)range.afterEndKey(new Key(new Text("aaa"))));
    }

    @Test
    public void rangeLessThanOrEqual() throws SerDeException {
        ExprNodeColumnDesc column = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, "rid", null, false);
        ExprNodeConstantDesc constant = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (Object)"aaa");
        ArrayList children = Lists.newArrayList();
        children.add(column);
        children.add(constant);
        ExprNodeGenericFuncDesc node = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPEqualOrLessThan(), (List)children);
        Assert.assertNotNull((Object)node);
        String filterExpr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)node);
        this.conf.set("hive.io.filter.expr.serialized", filterExpr);
        List ranges = this.handler.getRanges((Configuration)this.conf, this.columnMapper);
        Assert.assertEquals((long)ranges.size(), (long)1L);
        Range range = (Range)ranges.iterator().next();
        Assert.assertTrue((boolean)range.isStartKeyInclusive());
        Assert.assertFalse((boolean)range.isEndKeyInclusive());
        Assert.assertTrue((boolean)range.contains(new Key(new Text("aaa"))));
        Assert.assertTrue((boolean)range.afterEndKey(new Key(new Text("ccccc"))));
        Assert.assertTrue((boolean)range.contains(new Key(new Text("aa"))));
        Assert.assertTrue((boolean)range.afterEndKey(new Key(new Text("aab"))));
        Assert.assertFalse((boolean)range.afterEndKey(new Key(new Text("aaa"))));
    }

    @Test
    public void testDisjointRanges() throws SerDeException {
        ExprNodeColumnDesc column = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, "rid", null, false);
        ExprNodeConstantDesc constant = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (Object)"aaa");
        ArrayList children = Lists.newArrayList();
        children.add(column);
        children.add(constant);
        ExprNodeGenericFuncDesc node = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPEqualOrLessThan(), (List)children);
        Assert.assertNotNull((Object)node);
        ExprNodeColumnDesc column2 = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, "rid", null, false);
        ExprNodeConstantDesc constant2 = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (Object)"bbb");
        ArrayList children2 = Lists.newArrayList();
        children2.add(column2);
        children2.add(constant2);
        ExprNodeGenericFuncDesc node2 = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPGreaterThan(), (List)children2);
        Assert.assertNotNull((Object)node2);
        ArrayList bothFilters = Lists.newArrayList();
        bothFilters.add(node);
        bothFilters.add(node2);
        ExprNodeGenericFuncDesc both = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPAnd(), (List)bothFilters);
        String filterExpr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)both);
        this.conf.set("hive.io.filter.expr.serialized", filterExpr);
        List ranges = this.handler.getRanges((Configuration)this.conf, this.columnMapper);
        Assert.assertEquals((long)0L, (long)ranges.size());
    }

    @Test
    public void testMultipleRanges() throws SerDeException {
        ExprNodeColumnDesc column = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, "rid", null, false);
        ExprNodeConstantDesc constant = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (Object)"aaa");
        ArrayList children = Lists.newArrayList();
        children.add(column);
        children.add(constant);
        ExprNodeGenericFuncDesc node = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPEqualOrGreaterThan(), (List)children);
        Assert.assertNotNull((Object)node);
        ExprNodeColumnDesc column2 = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, "rid", null, false);
        ExprNodeConstantDesc constant2 = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (Object)"bbb");
        ArrayList children2 = Lists.newArrayList();
        children2.add(column2);
        children2.add(constant2);
        ExprNodeGenericFuncDesc node2 = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPLessThan(), (List)children2);
        Assert.assertNotNull((Object)node2);
        ArrayList bothFilters = Lists.newArrayList();
        bothFilters.add(node);
        bothFilters.add(node2);
        ExprNodeGenericFuncDesc both = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPAnd(), (List)bothFilters);
        String filterExpr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)both);
        this.conf.set("hive.io.filter.expr.serialized", filterExpr);
        List ranges = this.handler.getRanges((Configuration)this.conf, this.columnMapper);
        Assert.assertEquals((long)1L, (long)ranges.size());
        Range range = (Range)ranges.get(0);
        Assert.assertEquals((Object)new Range(new Key((CharSequence)"aaa"), true, new Key((CharSequence)"bbb"), false), (Object)range);
    }

    @Test
    public void testPushdownTuple() throws SerDeException, NoSuchPrimitiveComparisonException, NoSuchCompareOpException {
        ExprNodeColumnDesc column = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.intTypeInfo, "field1", null, false);
        ExprNodeConstantDesc constant = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (Object)5);
        ArrayList children = Lists.newArrayList();
        children.add(column);
        children.add(constant);
        ExprNodeGenericFuncDesc node = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPEqual(), (List)children);
        Assert.assertNotNull((Object)node);
        String filterExpr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)node);
        this.conf.set("hive.io.filter.expr.serialized", filterExpr);
        List sConditions = this.handler.getSearchConditions((Configuration)this.conf);
        Assert.assertEquals((long)sConditions.size(), (long)1L);
        IndexSearchCondition sc = (IndexSearchCondition)sConditions.get(0);
        PushdownTuple tuple = new PushdownTuple((IndexSearchCondition)sConditions.get(0), this.handler.getPrimitiveComparison(sc.getColumnDesc().getTypeString(), sc), this.handler.getCompareOp(sc.getComparisonOp(), sc));
        byte[] expectedVal = new byte[4];
        ByteBuffer.wrap(expectedVal).putInt(5);
        Assert.assertArrayEquals((byte[])tuple.getConstVal(), (byte[])expectedVal);
        Assert.assertEquals(tuple.getcOpt().getClass(), Equal.class);
        Assert.assertEquals(tuple.getpCompare().getClass(), IntCompare.class);
    }

    @Test(expected=NoSuchPrimitiveComparisonException.class)
    public void testPushdownColumnTypeNotSupported() throws SerDeException, NoSuchPrimitiveComparisonException, NoSuchCompareOpException {
        ExprNodeColumnDesc column = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.floatTypeInfo, "field1", null, false);
        ExprNodeConstantDesc constant = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.floatTypeInfo, (Object)Float.valueOf(5.5f));
        ArrayList children = Lists.newArrayList();
        children.add(column);
        children.add(constant);
        ExprNodeGenericFuncDesc node = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPEqual(), (List)children);
        Assert.assertNotNull((Object)node);
        String filterExpr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)node);
        this.conf.set("hive.io.filter.expr.serialized", filterExpr);
        List sConditions = this.handler.getSearchConditions((Configuration)this.conf);
        Assert.assertEquals((long)sConditions.size(), (long)1L);
        IndexSearchCondition sc = (IndexSearchCondition)sConditions.get(0);
        this.handler.getPrimitiveComparison(sc.getColumnDesc().getTypeString(), sc);
    }

    @Test
    public void testPushdownComparisonOptNotSupported() {
        try {
            ExprNodeColumnDesc column = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, "field1", null, false);
            ArrayList children = Lists.newArrayList();
            children.add(column);
            ExprNodeGenericFuncDesc node = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPNotNull(), (List)children);
            Assert.assertNotNull((Object)node);
            String filterExpr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)node);
            this.conf.set("hive.io.filter.expr.serialized", filterExpr);
            List sConditions = this.handler.getSearchConditions((Configuration)this.conf);
            Assert.assertEquals((long)sConditions.size(), (long)1L);
            IndexSearchCondition sc = (IndexSearchCondition)sConditions.get(0);
            new PushdownTuple(sc, this.handler.getPrimitiveComparison(sc.getColumnDesc().getTypeString(), sc), this.handler.getCompareOp(sc.getComparisonOp(), sc));
            Assert.fail((String)"Should fail: compare op not registered for index analyzer. Should leave undesirable residual predicate");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Unexpected residual predicate: field1 is not null"));
        }
        catch (Exception e) {
            Assert.fail((String)StringUtils.stringifyException((Throwable)e));
        }
    }

    @Test
    public void testIteratorIgnoreRowIDFields() {
        ExprNodeColumnDesc column = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, "rid", null, false);
        ExprNodeConstantDesc constant = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (Object)"aaa");
        ArrayList children = Lists.newArrayList();
        children.add(column);
        children.add(constant);
        ExprNodeGenericFuncDesc node = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPEqualOrLessThan(), (List)children);
        Assert.assertNotNull((Object)node);
        ExprNodeColumnDesc column2 = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, "rid", null, false);
        ExprNodeConstantDesc constant2 = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (Object)"bbb");
        ArrayList children2 = Lists.newArrayList();
        children2.add(column2);
        children2.add(constant2);
        ExprNodeGenericFuncDesc node2 = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPGreaterThan(), (List)children2);
        Assert.assertNotNull((Object)node2);
        ArrayList bothFilters = Lists.newArrayList();
        bothFilters.add(node);
        bothFilters.add(node2);
        ExprNodeGenericFuncDesc both = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPAnd(), (List)bothFilters);
        String filterExpr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)both);
        this.conf.set("hive.io.filter.expr.serialized", filterExpr);
        try {
            List iterators = this.handler.getIterators((Configuration)this.conf, this.columnMapper);
            Assert.assertEquals((long)iterators.size(), (long)0L);
        }
        catch (SerDeException e) {
            StringUtils.stringifyException((Throwable)e);
        }
    }

    @Test
    public void testIgnoreIteratorPushdown() throws TooManyAccumuloColumnsException {
        this.conf = new JobConf();
        List<String> columnNames = Arrays.asList("field1", "field2", "rid");
        List<TypeInfo> columnTypes = Arrays.asList(TypeInfoFactory.stringTypeInfo, TypeInfoFactory.intTypeInfo, TypeInfoFactory.stringTypeInfo);
        this.conf.set("columns", Joiner.on((char)',').join(columnNames));
        this.conf.set("columns.types", "string,int,string");
        String columnMappingStr = "cf:f1,cf:f2,:rowID";
        this.conf.set("accumulo.columns.mapping", columnMappingStr);
        this.columnMapper = new ColumnMapper(columnMappingStr, ColumnEncoding.STRING.getName(), columnNames, columnTypes);
        ExprNodeColumnDesc column = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, "field1", null, false);
        ExprNodeConstantDesc constant = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (Object)"aaa");
        ArrayList children = Lists.newArrayList();
        children.add(column);
        children.add(constant);
        ExprNodeGenericFuncDesc node = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPEqualOrLessThan(), (List)children);
        Assert.assertNotNull((Object)node);
        ExprNodeColumnDesc column2 = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.intTypeInfo, "field2", null, false);
        ExprNodeConstantDesc constant2 = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (Object)5);
        ArrayList children2 = Lists.newArrayList();
        children2.add(column2);
        children2.add(constant2);
        ExprNodeGenericFuncDesc node2 = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPGreaterThan(), (List)children2);
        Assert.assertNotNull((Object)node2);
        ArrayList bothFilters = Lists.newArrayList();
        bothFilters.add(node);
        bothFilters.add(node2);
        ExprNodeGenericFuncDesc both = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPAnd(), (List)bothFilters);
        String filterExpr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)both);
        this.conf.set("hive.io.filter.expr.serialized", filterExpr);
        this.conf.setBoolean("accumulo.iterator.pushdown", false);
        try {
            List iterators = this.handler.getIterators((Configuration)this.conf, this.columnMapper);
            Assert.assertEquals((long)iterators.size(), (long)0L);
        }
        catch (Exception e) {
            Assert.fail((String)StringUtils.stringifyException((Throwable)e));
        }
    }

    @Test
    public void testCreateIteratorSettings() throws Exception {
        String optKey;
        this.conf = new JobConf();
        List<String> columnNames = Arrays.asList("field1", "field2", "rid");
        List<TypeInfo> columnTypes = Arrays.asList(TypeInfoFactory.stringTypeInfo, TypeInfoFactory.intTypeInfo, TypeInfoFactory.stringTypeInfo);
        this.conf.set("columns", Joiner.on((char)',').join(columnNames));
        this.conf.set("columns.types", "string,int,string");
        this.conf.set("accumulo.default.storage", ColumnEncoding.BINARY.getName());
        String columnMappingStr = "cf:f1,cf:f2,:rowID";
        this.conf.set("accumulo.columns.mapping", columnMappingStr);
        this.columnMapper = new ColumnMapper(columnMappingStr, ColumnEncoding.STRING.getName(), columnNames, columnTypes);
        ExprNodeColumnDesc column = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, "field1", null, false);
        ExprNodeConstantDesc constant = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (Object)"aaa");
        ArrayList children = Lists.newArrayList();
        children.add(column);
        children.add(constant);
        ExprNodeGenericFuncDesc node = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPEqualOrLessThan(), (List)children);
        Assert.assertNotNull((Object)node);
        ExprNodeColumnDesc column2 = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.intTypeInfo, "field2", null, false);
        ExprNodeConstantDesc constant2 = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (Object)5);
        ArrayList children2 = Lists.newArrayList();
        children2.add(column2);
        children2.add(constant2);
        ExprNodeGenericFuncDesc node2 = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPGreaterThan(), (List)children2);
        Assert.assertNotNull((Object)node2);
        ArrayList bothFilters = Lists.newArrayList();
        bothFilters.add(node);
        bothFilters.add(node2);
        ExprNodeGenericFuncDesc both = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPAnd(), (List)bothFilters);
        String filterExpr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)both);
        this.conf.set("hive.io.filter.expr.serialized", filterExpr);
        List iterators = this.handler.getIterators((Configuration)this.conf, this.columnMapper);
        Assert.assertEquals((long)iterators.size(), (long)2L);
        IteratorSetting is1 = (IteratorSetting)iterators.get(0);
        IteratorSetting is2 = (IteratorSetting)iterators.get(1);
        boolean foundQual = false;
        boolean foundPCompare = false;
        boolean foundCOpt = false;
        boolean foundConst = false;
        for (Map.Entry option : is1.getOptions().entrySet()) {
            optKey = (String)option.getKey();
            if (optKey.equals("accumulo.filter.iterator.qual")) {
                foundQual = true;
                Assert.assertEquals(option.getValue(), (Object)"cf:f1");
                continue;
            }
            if (optKey.equals("accumulo.filter.iterator.const.val")) {
                foundConst = true;
                Assert.assertEquals(option.getValue(), (Object)new String(Base64.encodeBase64((byte[])"aaa".getBytes())));
                continue;
            }
            if (optKey.equals("accumulo.filter.iterator.compare.opt.class")) {
                foundCOpt = true;
                Assert.assertEquals(option.getValue(), (Object)LessThanOrEqual.class.getName());
                continue;
            }
            if (!optKey.equals("accumulo.filter.iterator.p.compare.class")) continue;
            foundPCompare = true;
            Assert.assertEquals(option.getValue(), (Object)StringCompare.class.getName());
        }
        Assert.assertTrue((boolean)(foundConst & foundCOpt & foundPCompare & foundQual));
        foundQual = false;
        foundPCompare = false;
        foundCOpt = false;
        foundConst = false;
        for (Map.Entry option : is2.getOptions().entrySet()) {
            optKey = (String)option.getKey();
            if (optKey.equals("accumulo.filter.iterator.qual")) {
                foundQual = true;
                Assert.assertEquals(option.getValue(), (Object)"cf:f2");
                continue;
            }
            if (optKey.equals("accumulo.filter.iterator.const.val")) {
                foundConst = true;
                byte[] intVal = new byte[4];
                ByteBuffer.wrap(intVal).putInt(5);
                Assert.assertEquals(option.getValue(), (Object)new String(Base64.encodeBase64((byte[])intVal)));
                continue;
            }
            if (optKey.equals("accumulo.filter.iterator.compare.opt.class")) {
                foundCOpt = true;
                Assert.assertEquals(option.getValue(), (Object)GreaterThan.class.getName());
                continue;
            }
            if (!optKey.equals("accumulo.filter.iterator.p.compare.class")) continue;
            foundPCompare = true;
            Assert.assertEquals(option.getValue(), (Object)IntCompare.class.getName());
        }
        Assert.assertTrue((boolean)(foundConst & foundCOpt & foundPCompare & foundQual));
    }

    @Test
    public void testBasicOptLookup() throws NoSuchCompareOpException {
        boolean foundEqual = false;
        boolean foundNotEqual = false;
        boolean foundGreaterThanOrEqual = false;
        boolean foundGreaterThan = false;
        boolean foundLessThanOrEqual = false;
        boolean foundLessThan = false;
        for (String opt : this.handler.cOpKeyset()) {
            Class compOpt = this.handler.getCompareOpClass(opt);
            if (compOpt.getName().equals(Equal.class.getName())) {
                foundEqual = true;
                continue;
            }
            if (compOpt.getName().equals(NotEqual.class.getName())) {
                foundNotEqual = true;
                continue;
            }
            if (compOpt.getName().equals(GreaterThan.class.getName())) {
                foundGreaterThan = true;
                continue;
            }
            if (compOpt.getName().equals(GreaterThanOrEqual.class.getName())) {
                foundGreaterThanOrEqual = true;
                continue;
            }
            if (compOpt.getName().equals(LessThan.class.getName())) {
                foundLessThan = true;
                continue;
            }
            if (!compOpt.getName().equals(LessThanOrEqual.class.getName())) continue;
            foundLessThanOrEqual = true;
        }
        Assert.assertTrue((String)"Did not find Equal comparison op", (boolean)foundEqual);
        Assert.assertTrue((String)"Did not find NotEqual comparison op", (boolean)foundNotEqual);
        Assert.assertTrue((String)"Did not find GreaterThan comparison op", (boolean)foundGreaterThan);
        Assert.assertTrue((String)"Did not find GreaterThanOrEqual comparison op", (boolean)foundGreaterThanOrEqual);
        Assert.assertTrue((String)"Did not find LessThan comparison op", (boolean)foundLessThan);
        Assert.assertTrue((String)"Did not find LessThanOrEqual comparison op", (boolean)foundLessThanOrEqual);
    }

    @Test(expected=NoSuchCompareOpException.class)
    public void testNoOptFound() throws NoSuchCompareOpException {
        this.handler.getCompareOpClass("blah");
    }

    @Test
    public void testPrimitiveComparsionLookup() throws NoSuchPrimitiveComparisonException {
        boolean foundLong = false;
        boolean foundString = false;
        boolean foundInt = false;
        boolean foundDouble = false;
        for (String type : this.handler.pComparisonKeyset()) {
            Class pCompare = this.handler.getPrimitiveComparisonClass(type);
            if (pCompare.getName().equals(DoubleCompare.class.getName())) {
                foundDouble = true;
                continue;
            }
            if (pCompare.getName().equals(LongCompare.class.getName())) {
                foundLong = true;
                continue;
            }
            if (pCompare.getName().equals(IntCompare.class.getName())) {
                foundInt = true;
                continue;
            }
            if (!pCompare.getName().equals(StringCompare.class.getName())) continue;
            foundString = true;
        }
        Assert.assertTrue((String)"Did not find DoubleCompare op", (boolean)foundDouble);
        Assert.assertTrue((String)"Did not find LongCompare op", (boolean)foundLong);
        Assert.assertTrue((String)"Did not find IntCompare op", (boolean)foundInt);
        Assert.assertTrue((String)"Did not find StringCompare op", (boolean)foundString);
    }

    @Test
    public void testRowRangeIntersection() throws SerDeException {
        ExprNodeColumnDesc column = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, "rid", null, false);
        ExprNodeConstantDesc constant = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (Object)"f");
        ArrayList children = Lists.newArrayList();
        children.add(column);
        children.add(constant);
        ExprNodeGenericFuncDesc node = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPEqualOrGreaterThan(), (List)children);
        Assert.assertNotNull((Object)node);
        ExprNodeColumnDesc column2 = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, "rid", null, false);
        ExprNodeConstantDesc constant2 = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (Object)"m");
        ArrayList children2 = Lists.newArrayList();
        children2.add(column2);
        children2.add(constant2);
        ExprNodeGenericFuncDesc node2 = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPEqualOrLessThan(), (List)children2);
        Assert.assertNotNull((Object)node2);
        ArrayList bothFilters = Lists.newArrayList();
        bothFilters.add(node);
        bothFilters.add(node2);
        ExprNodeGenericFuncDesc both = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPAnd(), (List)bothFilters);
        String filterExpr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)both);
        this.conf.set("hive.io.filter.expr.serialized", filterExpr);
        List ranges = this.handler.getRanges((Configuration)this.conf, this.columnMapper);
        Assert.assertEquals((long)1L, (long)ranges.size());
        Assert.assertEquals((Object)new Range(new Key((CharSequence)"f"), true, new Key((CharSequence)"m\u0000"), false), ranges.get(0));
    }

    @Test
    public void testRowRangeGeneration() throws SerDeException {
        List<String> columnNames = Arrays.asList("key", "column");
        List<TypeInfo> columnTypes = Arrays.asList(TypeInfoFactory.stringTypeInfo, TypeInfoFactory.stringTypeInfo);
        this.conf.set("columns", Joiner.on((char)',').join(columnNames));
        this.conf.set("columns.types", "string,string");
        String columnMappingStr = ":rowID,cf:f1";
        this.conf.set("accumulo.columns.mapping", columnMappingStr);
        this.columnMapper = new ColumnMapper(columnMappingStr, ColumnEncoding.STRING.getName(), columnNames, columnTypes);
        ExprNodeColumnDesc column = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.intTypeInfo, "key", null, false);
        ExprNodeConstantDesc constant = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (Object)100);
        ArrayList children = Lists.newArrayList();
        children.add(constant);
        children.add(column);
        ExprNodeGenericFuncDesc node = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPLessThan(), (List)children);
        Assert.assertNotNull((Object)node);
        String filterExpr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)node);
        this.conf.set("hive.io.filter.expr.serialized", filterExpr);
        List ranges = this.handler.getRanges((Configuration)this.conf, this.columnMapper);
        Assert.assertEquals((long)1L, (long)ranges.size());
        Assert.assertEquals((Object)new Range(new Text("100"), false, null, false), ranges.get(0));
    }

    @Test
    public void testBinaryRangeGeneration() throws Exception {
        List<String> columnNames = Arrays.asList("key", "column");
        List<TypeInfo> columnTypes = Arrays.asList(TypeInfoFactory.intTypeInfo, TypeInfoFactory.stringTypeInfo);
        this.conf.set("columns", Joiner.on((char)',').join(columnNames));
        this.conf.set("columns.types", "int,string");
        String columnMappingStr = ":rowID#b,cf:f1";
        this.conf.set("accumulo.columns.mapping", columnMappingStr);
        this.columnMapper = new ColumnMapper(columnMappingStr, ColumnEncoding.STRING.getName(), columnNames, columnTypes);
        int intValue = 100;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JavaIntObjectInspector intOI = (JavaIntObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"int"));
        LazyUtils.writePrimitive((OutputStream)baos, (Object)intValue, (PrimitiveObjectInspector)intOI);
        ExprNodeColumnDesc column = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.intTypeInfo, "key", null, false);
        ExprNodeConstantDesc constant = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (Object)intValue);
        ArrayList children = Lists.newArrayList();
        children.add(constant);
        children.add(column);
        ExprNodeGenericFuncDesc node = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPLessThan(), (List)children);
        Assert.assertNotNull((Object)node);
        String filterExpr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)node);
        this.conf.set("hive.io.filter.expr.serialized", filterExpr);
        List ranges = this.handler.getRanges((Configuration)this.conf, this.columnMapper);
        Assert.assertEquals((long)1L, (long)ranges.size());
        Assert.assertEquals((Object)new Range(new Text(baos.toByteArray()), false, null, false), ranges.get(0));
    }

    @Test
    public void testNullRangeGeneratorOutput() throws SerDeException {
        AccumuloPredicateHandler mockHandler = (AccumuloPredicateHandler)Mockito.mock(AccumuloPredicateHandler.class);
        ExprNodeDesc root = (ExprNodeDesc)Mockito.mock(ExprNodeDesc.class);
        String hiveRowIdColumnName = "rid";
        Mockito.when((Object)mockHandler.getRanges((Configuration)this.conf, this.columnMapper)).thenCallRealMethod();
        Mockito.when((Object)mockHandler.generateRanges((Configuration)this.conf, this.columnMapper, hiveRowIdColumnName, root)).thenReturn(null);
        Mockito.when((Object)mockHandler.getExpression((Configuration)this.conf)).thenReturn((Object)root);
        Assert.assertEquals(Arrays.asList(new Range()), (Object)mockHandler.getRanges((Configuration)this.conf, this.columnMapper));
    }

    @Test
    public void testEmptyListRangeGeneratorOutput() throws SerDeException {
        AccumuloPredicateHandler mockHandler = (AccumuloPredicateHandler)Mockito.mock(AccumuloPredicateHandler.class);
        ExprNodeDesc root = (ExprNodeDesc)Mockito.mock(ExprNodeDesc.class);
        String hiveRowIdColumnName = "rid";
        Mockito.when((Object)mockHandler.getRanges((Configuration)this.conf, this.columnMapper)).thenCallRealMethod();
        Mockito.when((Object)mockHandler.generateRanges((Configuration)this.conf, this.columnMapper, hiveRowIdColumnName, root)).thenReturn(Collections.emptyList());
        Mockito.when((Object)mockHandler.getExpression((Configuration)this.conf)).thenReturn((Object)root);
        Assert.assertEquals(Collections.emptyList(), (Object)mockHandler.getRanges((Configuration)this.conf, this.columnMapper));
    }

    @Test
    public void testSingleRangeGeneratorOutput() throws SerDeException {
        AccumuloPredicateHandler mockHandler = (AccumuloPredicateHandler)Mockito.mock(AccumuloPredicateHandler.class);
        ExprNodeDesc root = (ExprNodeDesc)Mockito.mock(ExprNodeDesc.class);
        String hiveRowIdColumnName = "rid";
        Range r = new Range((CharSequence)"a");
        Mockito.when((Object)mockHandler.getRanges((Configuration)this.conf, this.columnMapper)).thenCallRealMethod();
        Mockito.when((Object)mockHandler.generateRanges((Configuration)this.conf, this.columnMapper, hiveRowIdColumnName, root)).thenReturn((Object)r);
        Mockito.when((Object)mockHandler.getExpression((Configuration)this.conf)).thenReturn((Object)root);
        Assert.assertEquals(Collections.singletonList(r), (Object)mockHandler.getRanges((Configuration)this.conf, this.columnMapper));
    }

    @Test
    public void testManyRangesGeneratorOutput() throws SerDeException {
        AccumuloPredicateHandler mockHandler = (AccumuloPredicateHandler)Mockito.mock(AccumuloPredicateHandler.class);
        ExprNodeDesc root = (ExprNodeDesc)Mockito.mock(ExprNodeDesc.class);
        String hiveRowIdColumnName = "rid";
        Range r1 = new Range((CharSequence)"a");
        Range r2 = new Range((CharSequence)"z");
        Mockito.when((Object)mockHandler.getRanges((Configuration)this.conf, this.columnMapper)).thenCallRealMethod();
        Mockito.when((Object)mockHandler.generateRanges((Configuration)this.conf, this.columnMapper, hiveRowIdColumnName, root)).thenReturn(Arrays.asList(r1, r2));
        Mockito.when((Object)mockHandler.getExpression((Configuration)this.conf)).thenReturn((Object)root);
        Assert.assertEquals(Arrays.asList(r1, r2), (Object)mockHandler.getRanges((Configuration)this.conf, this.columnMapper));
    }
}

