/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.mr;

import com.google.common.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.mock.MockInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.util.Pair;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.accumulo.AccumuloConnectionParameters;
import org.apache.hadoop.hive.accumulo.AccumuloHiveRow;
import org.apache.hadoop.hive.accumulo.HiveAccumuloHelper;
import org.apache.hadoop.hive.accumulo.columns.ColumnEncoding;
import org.apache.hadoop.hive.accumulo.columns.ColumnMapper;
import org.apache.hadoop.hive.accumulo.columns.HiveAccumuloColumnMapping;
import org.apache.hadoop.hive.accumulo.columns.HiveAccumuloRowIdColumnMapping;
import org.apache.hadoop.hive.accumulo.mr.HiveAccumuloSplit;
import org.apache.hadoop.hive.accumulo.mr.HiveAccumuloTableInputFormat;
import org.apache.hadoop.hive.accumulo.predicate.AccumuloPredicateHandler;
import org.apache.hadoop.hive.accumulo.predicate.PrimitiveComparisonFilter;
import org.apache.hadoop.hive.accumulo.predicate.compare.DoubleCompare;
import org.apache.hadoop.hive.accumulo.predicate.compare.Equal;
import org.apache.hadoop.hive.accumulo.predicate.compare.GreaterThan;
import org.apache.hadoop.hive.accumulo.predicate.compare.GreaterThanOrEqual;
import org.apache.hadoop.hive.accumulo.predicate.compare.IntCompare;
import org.apache.hadoop.hive.accumulo.predicate.compare.LessThan;
import org.apache.hadoop.hive.accumulo.predicate.compare.LongCompare;
import org.apache.hadoop.hive.accumulo.predicate.compare.StringCompare;
import org.apache.hadoop.hive.accumulo.serde.TooManyAccumuloColumnsException;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.mockito.Mockito;

public class TestHiveAccumuloTableInputFormat {
    public static final String USER = "user";
    public static final String PASS = "password";
    public static final String TEST_TABLE = "table1";
    public static final Text COLUMN_FAMILY = new Text("cf");
    private static final Text NAME = new Text("name");
    private static final Text SID = new Text("sid");
    private static final Text DEGREES = new Text("dgrs");
    private static final Text MILLIS = new Text("mills");
    private Instance mockInstance;
    private Connector con;
    private HiveAccumuloTableInputFormat inputformat;
    private JobConf conf;
    private List<String> columnNames;
    private List<TypeInfo> columnTypes;
    @Rule
    public TestName test = new TestName();

    @Before
    public void createMockKeyValues() throws Exception {
        this.mockInstance = new MockInstance(this.test.getMethodName());
        this.inputformat = new HiveAccumuloTableInputFormat();
        this.conf = new JobConf();
        this.conf.set("accumulo.table.name", TEST_TABLE);
        this.conf.set("accumulo.mock.instance", "true");
        this.conf.set("accumulo.instance.name", this.test.getMethodName());
        this.conf.set("accumulo.user.name", USER);
        this.conf.set("accumulo.user.pass", PASS);
        this.conf.set("accumulo.zookeepers", "localhost:5181");
        this.columnNames = Arrays.asList("name", "sid", "dgrs", "mills");
        this.columnTypes = Arrays.asList(TypeInfoFactory.stringTypeInfo, TypeInfoFactory.intTypeInfo, TypeInfoFactory.doubleTypeInfo, TypeInfoFactory.longTypeInfo);
        this.conf.set("accumulo.columns.mapping", "cf:name,cf:sid,cf:dgrs,cf:mills");
        this.conf.set("columns", "name,sid,dgrs,mills");
        this.conf.set("columns.types", "string,int,double,bigint");
        this.con = this.mockInstance.getConnector(USER, (AuthenticationToken)new PasswordToken(PASS.getBytes()));
        this.con.tableOperations().create(TEST_TABLE);
        this.con.securityOperations().changeUserAuthorizations(USER, new Authorizations(new String[]{"blah"}));
        BatchWriterConfig writerConf = new BatchWriterConfig();
        BatchWriter writer = this.con.createBatchWriter(TEST_TABLE, writerConf);
        Mutation m1 = new Mutation(new Text("r1"));
        m1.put(COLUMN_FAMILY, NAME, new Value("brian".getBytes()));
        m1.put(COLUMN_FAMILY, SID, new Value(this.parseIntBytes("1")));
        m1.put(COLUMN_FAMILY, DEGREES, new Value(this.parseDoubleBytes("44.5")));
        m1.put(COLUMN_FAMILY, MILLIS, new Value(this.parseLongBytes("555")));
        Mutation m2 = new Mutation(new Text("r2"));
        m2.put(COLUMN_FAMILY, NAME, new Value("mark".getBytes()));
        m2.put(COLUMN_FAMILY, SID, new Value(this.parseIntBytes("2")));
        m2.put(COLUMN_FAMILY, DEGREES, new Value(this.parseDoubleBytes("55.5")));
        m2.put(COLUMN_FAMILY, MILLIS, new Value(this.parseLongBytes("666")));
        Mutation m3 = new Mutation(new Text("r3"));
        m3.put(COLUMN_FAMILY, NAME, new Value("dennis".getBytes()));
        m3.put(COLUMN_FAMILY, SID, new Value(this.parseIntBytes("3")));
        m3.put(COLUMN_FAMILY, DEGREES, new Value(this.parseDoubleBytes("65.5")));
        m3.put(COLUMN_FAMILY, MILLIS, new Value(this.parseLongBytes("777")));
        writer.addMutation(m1);
        writer.addMutation(m2);
        writer.addMutation(m3);
        writer.close();
    }

    private byte[] parseIntBytes(String s) throws IOException {
        int val = Integer.parseInt(s);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        DataOutputStream out = new DataOutputStream(baos);
        out.writeInt(val);
        out.close();
        return baos.toByteArray();
    }

    private byte[] parseLongBytes(String s) throws IOException {
        long val = Long.parseLong(s);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8);
        DataOutputStream out = new DataOutputStream(baos);
        out.writeLong(val);
        out.close();
        return baos.toByteArray();
    }

    private byte[] parseDoubleBytes(String s) throws IOException {
        double val = Double.parseDouble(s);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8);
        DataOutputStream out = new DataOutputStream(baos);
        out.writeDouble(val);
        out.close();
        return baos.toByteArray();
    }

    @Test
    public void testHiveAccumuloRecord() throws Exception {
        FileInputFormat.addInputPath((JobConf)this.conf, (Path)new Path("unused"));
        InputSplit[] splits = this.inputformat.getSplits(this.conf, 0);
        Assert.assertEquals((long)splits.length, (long)1L);
        RecordReader reader = this.inputformat.getRecordReader(splits[0], this.conf, null);
        Text rowId = new Text("r1");
        AccumuloHiveRow row = new AccumuloHiveRow();
        row.add(COLUMN_FAMILY.toString(), NAME.toString(), "brian".getBytes());
        row.add(COLUMN_FAMILY.toString(), SID.toString(), this.parseIntBytes("1"));
        row.add(COLUMN_FAMILY.toString(), DEGREES.toString(), this.parseDoubleBytes("44.5"));
        row.add(COLUMN_FAMILY.toString(), MILLIS.toString(), this.parseLongBytes("555"));
        Assert.assertTrue((boolean)reader.next((Object)rowId, (Object)row));
        Assert.assertEquals((Object)rowId.toString(), (Object)row.getRowId());
        Assert.assertTrue((boolean)row.hasFamAndQual(COLUMN_FAMILY, NAME));
        Assert.assertArrayEquals((byte[])"brian".getBytes(), (byte[])row.getValue(COLUMN_FAMILY, NAME));
        Assert.assertTrue((boolean)row.hasFamAndQual(COLUMN_FAMILY, SID));
        Assert.assertArrayEquals((byte[])this.parseIntBytes("1"), (byte[])row.getValue(COLUMN_FAMILY, SID));
        Assert.assertTrue((boolean)row.hasFamAndQual(COLUMN_FAMILY, DEGREES));
        Assert.assertArrayEquals((byte[])this.parseDoubleBytes("44.5"), (byte[])row.getValue(COLUMN_FAMILY, DEGREES));
        Assert.assertTrue((boolean)row.hasFamAndQual(COLUMN_FAMILY, MILLIS));
        Assert.assertArrayEquals((byte[])this.parseLongBytes("555"), (byte[])row.getValue(COLUMN_FAMILY, MILLIS));
    }

    @Test
    public void testGetOnlyName() throws Exception {
        FileInputFormat.addInputPath((JobConf)this.conf, (Path)new Path("unused"));
        InputSplit[] splits = this.inputformat.getSplits(this.conf, 0);
        Assert.assertEquals((long)splits.length, (long)1L);
        RecordReader reader = this.inputformat.getRecordReader(splits[0], this.conf, null);
        Text rowId = new Text("r1");
        AccumuloHiveRow row = new AccumuloHiveRow();
        Assert.assertTrue((boolean)reader.next((Object)rowId, (Object)row));
        Assert.assertEquals((Object)row.getRowId(), (Object)rowId.toString());
        Assert.assertTrue((boolean)row.hasFamAndQual(COLUMN_FAMILY, NAME));
        Assert.assertArrayEquals((byte[])row.getValue(COLUMN_FAMILY, NAME), (byte[])"brian".getBytes());
        rowId = new Text("r2");
        Assert.assertTrue((boolean)reader.next((Object)rowId, (Object)row));
        Assert.assertEquals((Object)row.getRowId(), (Object)rowId.toString());
        Assert.assertTrue((boolean)row.hasFamAndQual(COLUMN_FAMILY, NAME));
        Assert.assertArrayEquals((byte[])row.getValue(COLUMN_FAMILY, NAME), (byte[])"mark".getBytes());
        rowId = new Text("r3");
        Assert.assertTrue((boolean)reader.next((Object)rowId, (Object)row));
        Assert.assertEquals((Object)row.getRowId(), (Object)rowId.toString());
        Assert.assertTrue((boolean)row.hasFamAndQual(COLUMN_FAMILY, NAME));
        Assert.assertArrayEquals((byte[])row.getValue(COLUMN_FAMILY, NAME), (byte[])"dennis".getBytes());
        Assert.assertFalse((boolean)reader.next((Object)rowId, (Object)row));
    }

    @Test
    public void testDegreesAndMillis() throws Exception {
        Connector con = this.mockInstance.getConnector(USER, (AuthenticationToken)new PasswordToken(PASS.getBytes()));
        Scanner scan = con.createScanner(TEST_TABLE, new Authorizations(new String[]{"blah"}));
        IteratorSetting is = new IteratorSetting(1, "accumulo_filter_compare_iterator_1", PrimitiveComparisonFilter.class);
        is.addOption("accumulo.filter.iterator.p.compare.class", DoubleCompare.class.getName());
        is.addOption("accumulo.filter.iterator.compare.opt.class", GreaterThanOrEqual.class.getName());
        is.addOption("accumulo.filter.iterator.const.val", new String(Base64.encodeBase64((byte[])this.parseDoubleBytes("55.6"))));
        is.addOption("accumulo.filter.iterator.qual", "cf:dgrs");
        scan.addScanIterator(is);
        IteratorSetting is2 = new IteratorSetting(2, "accumulo_filter_compare_iterator_2", PrimitiveComparisonFilter.class);
        is2.addOption("accumulo.filter.iterator.p.compare.class", LongCompare.class.getName());
        is2.addOption("accumulo.filter.iterator.compare.opt.class", LessThan.class.getName());
        is2.addOption("accumulo.filter.iterator.const.val", new String(Base64.encodeBase64((byte[])this.parseLongBytes("778"))));
        is2.addOption("accumulo.filter.iterator.qual", "cf:mills");
        scan.addScanIterator(is2);
        boolean foundDennis = false;
        int totalCount = 0;
        for (Map.Entry kv : scan) {
            boolean foundName = false;
            boolean foundSid = false;
            boolean foundDegrees = false;
            boolean foundMillis = false;
            SortedMap items = PrimitiveComparisonFilter.decodeRow((Key)((Key)kv.getKey()), (Value)((Value)kv.getValue()));
            for (Map.Entry item : items.entrySet()) {
                SortedMap nestedItems = PrimitiveComparisonFilter.decodeRow((Key)((Key)item.getKey()), (Value)((Value)item.getValue()));
                for (Map.Entry nested : nestedItems.entrySet()) {
                    if (((Key)nested.getKey()).getRow().toString().equals("r3")) {
                        foundDennis = true;
                    }
                    if (((Key)nested.getKey()).getColumnQualifier().equals((Object)NAME)) {
                        foundName = true;
                        continue;
                    }
                    if (((Key)nested.getKey()).getColumnQualifier().equals((Object)SID)) {
                        foundSid = true;
                        continue;
                    }
                    if (((Key)nested.getKey()).getColumnQualifier().equals((Object)DEGREES)) {
                        foundDegrees = true;
                        continue;
                    }
                    if (!((Key)nested.getKey()).getColumnQualifier().equals((Object)MILLIS)) continue;
                    foundMillis = true;
                }
            }
            ++totalCount;
            Assert.assertTrue((boolean)(foundDegrees & foundMillis & foundName & foundSid));
        }
        Assert.assertTrue((boolean)foundDennis);
        Assert.assertEquals((long)totalCount, (long)1L);
    }

    @Test
    public void testGreaterThan1Sid() throws Exception {
        Connector con = this.mockInstance.getConnector(USER, (AuthenticationToken)new PasswordToken(PASS.getBytes()));
        Scanner scan = con.createScanner(TEST_TABLE, new Authorizations(new String[]{"blah"}));
        IteratorSetting is = new IteratorSetting(1, "accumulo_filter_compare_iterator_1", PrimitiveComparisonFilter.class);
        is.addOption("accumulo.filter.iterator.p.compare.class", IntCompare.class.getName());
        is.addOption("accumulo.filter.iterator.compare.opt.class", GreaterThan.class.getName());
        is.addOption("accumulo.filter.iterator.const.val", new String(Base64.encodeBase64((byte[])this.parseIntBytes("1"))));
        is.addOption("accumulo.filter.iterator.qual", "cf:sid");
        scan.addScanIterator(is);
        boolean foundMark = false;
        boolean foundDennis = false;
        int totalCount = 0;
        for (Map.Entry kv : scan) {
            boolean foundName = false;
            boolean foundSid = false;
            boolean foundDegrees = false;
            boolean foundMillis = false;
            SortedMap items = PrimitiveComparisonFilter.decodeRow((Key)((Key)kv.getKey()), (Value)((Value)kv.getValue()));
            for (Map.Entry item : items.entrySet()) {
                if (((Key)item.getKey()).getRow().toString().equals("r2")) {
                    foundMark = true;
                } else if (((Key)item.getKey()).getRow().toString().equals("r3")) {
                    foundDennis = true;
                }
                if (((Key)item.getKey()).getColumnQualifier().equals((Object)NAME)) {
                    foundName = true;
                    continue;
                }
                if (((Key)item.getKey()).getColumnQualifier().equals((Object)SID)) {
                    foundSid = true;
                    continue;
                }
                if (((Key)item.getKey()).getColumnQualifier().equals((Object)DEGREES)) {
                    foundDegrees = true;
                    continue;
                }
                if (!((Key)item.getKey()).getColumnQualifier().equals((Object)MILLIS)) continue;
                foundMillis = true;
            }
            ++totalCount;
            Assert.assertTrue((boolean)(foundDegrees & foundMillis & foundName & foundSid));
        }
        Assert.assertTrue((boolean)(foundDennis & foundMark));
        Assert.assertEquals((long)totalCount, (long)2L);
    }

    @Test
    public void testNameEqualBrian() throws Exception {
        Connector con = this.mockInstance.getConnector(USER, (AuthenticationToken)new PasswordToken(PASS.getBytes()));
        Scanner scan = con.createScanner(TEST_TABLE, new Authorizations(new String[]{"blah"}));
        IteratorSetting is = new IteratorSetting(1, "accumulo_filter_compare_iterator_1", PrimitiveComparisonFilter.class);
        is.addOption("accumulo.filter.iterator.p.compare.class", StringCompare.class.getName());
        is.addOption("accumulo.filter.iterator.compare.opt.class", Equal.class.getName());
        is.addOption("accumulo.filter.iterator.const.val", new String(Base64.encodeBase64((byte[])"brian".getBytes())));
        is.addOption("accumulo.filter.iterator.qual", "cf:name");
        scan.addScanIterator(is);
        boolean foundName = false;
        boolean foundSid = false;
        boolean foundDegrees = false;
        boolean foundMillis = false;
        for (Map.Entry kv : scan) {
            SortedMap items = PrimitiveComparisonFilter.decodeRow((Key)((Key)kv.getKey()), (Value)((Value)kv.getValue()));
            for (Map.Entry item : items.entrySet()) {
                Assert.assertEquals((Object)((Key)item.getKey()).getRow().toString(), (Object)"r1");
                if (((Key)item.getKey()).getColumnQualifier().equals((Object)NAME)) {
                    foundName = true;
                    Assert.assertArrayEquals((byte[])((Value)item.getValue()).get(), (byte[])"brian".getBytes());
                    continue;
                }
                if (((Key)item.getKey()).getColumnQualifier().equals((Object)SID)) {
                    foundSid = true;
                    Assert.assertArrayEquals((byte[])((Value)item.getValue()).get(), (byte[])this.parseIntBytes("1"));
                    continue;
                }
                if (((Key)item.getKey()).getColumnQualifier().equals((Object)DEGREES)) {
                    foundDegrees = true;
                    Assert.assertArrayEquals((byte[])((Value)item.getValue()).get(), (byte[])this.parseDoubleBytes("44.5"));
                    continue;
                }
                if (!((Key)item.getKey()).getColumnQualifier().equals((Object)MILLIS)) continue;
                foundMillis = true;
                Assert.assertArrayEquals((byte[])((Value)item.getValue()).get(), (byte[])this.parseLongBytes("555"));
            }
        }
        Assert.assertTrue((boolean)(foundDegrees & foundMillis & foundName & foundSid));
    }

    @Test
    public void testGetNone() throws Exception {
        FileInputFormat.addInputPath((JobConf)this.conf, (Path)new Path("unused"));
        this.conf.set("accumulo.columns.mapping", "cf:f1");
        InputSplit[] splits = this.inputformat.getSplits(this.conf, 0);
        Assert.assertEquals((long)splits.length, (long)1L);
        RecordReader reader = this.inputformat.getRecordReader(splits[0], this.conf, null);
        Text rowId = new Text("r1");
        AccumuloHiveRow row = new AccumuloHiveRow();
        row.setRowId("r1");
        Assert.assertFalse((boolean)reader.next((Object)rowId, (Object)row));
    }

    @Test
    public void testIteratorNotInSplitsCompensation() throws Exception {
        FileInputFormat.addInputPath((JobConf)this.conf, (Path)new Path("unused"));
        InputSplit[] splits = this.inputformat.getSplits(this.conf, 0);
        Assert.assertEquals((long)1L, (long)splits.length);
        InputSplit split = splits[0];
        IteratorSetting is = new IteratorSetting(1, "accumulo_filter_compare_iterator_1", PrimitiveComparisonFilter.class);
        is.addOption("accumulo.filter.iterator.p.compare.class", StringCompare.class.getName());
        is.addOption("accumulo.filter.iterator.compare.opt.class", Equal.class.getName());
        is.addOption("accumulo.filter.iterator.const.val", new String(Base64.encodeBase64((byte[])new byte[]{48})));
        is.addOption("accumulo.filter.iterator.qual", "cf:cq");
        AccumuloPredicateHandler predicateHandler = (AccumuloPredicateHandler)Mockito.mock(AccumuloPredicateHandler.class);
        Mockito.when((Object)predicateHandler.getIterators((Configuration)Mockito.any(JobConf.class), (ColumnMapper)Mockito.any(ColumnMapper.class))).thenReturn(Arrays.asList(is));
        this.inputformat.predicateHandler = predicateHandler;
        this.inputformat.getRecordReader(split, this.conf, null);
        List settingsOnSplit = ((HiveAccumuloSplit)split).getSplit().getIterators();
        Assert.assertEquals((long)1L, (long)settingsOnSplit.size());
        Assert.assertEquals((Object)is, settingsOnSplit.get(0));
    }

    @Test
    public void testColumnMappingsToPairs() {
        ArrayList<Object> mappings = new ArrayList<Object>();
        HashSet<Pair> columns = new HashSet<Pair>();
        mappings.add(new HiveAccumuloRowIdColumnMapping(":rowID", ColumnEncoding.STRING, "row", TypeInfoFactory.stringTypeInfo.toString()));
        mappings.add(new HiveAccumuloColumnMapping("person", "name", ColumnEncoding.STRING, "col1", TypeInfoFactory.stringTypeInfo.toString()));
        mappings.add(new HiveAccumuloColumnMapping("person", "age", ColumnEncoding.STRING, "col2", TypeInfoFactory.stringTypeInfo.toString()));
        mappings.add(new HiveAccumuloColumnMapping("person", "height", ColumnEncoding.STRING, "col3", TypeInfoFactory.stringTypeInfo.toString()));
        mappings.add(new HiveAccumuloColumnMapping("city", "name", ColumnEncoding.STRING, "col4", TypeInfoFactory.stringTypeInfo.toString()));
        columns.add(new Pair((Object)new Text("person"), (Object)new Text("name")));
        columns.add(new Pair((Object)new Text("person"), (Object)new Text("age")));
        columns.add(new Pair((Object)new Text("person"), (Object)new Text("height")));
        columns.add(new Pair((Object)new Text("city"), (Object)new Text("name")));
        Assert.assertEquals(columns, (Object)this.inputformat.getPairCollection(mappings));
    }

    @Test
    public void testConfigureMockAccumuloInputFormat() throws Exception {
        AccumuloConnectionParameters accumuloParams = new AccumuloConnectionParameters((Configuration)this.conf);
        ColumnMapper columnMapper = new ColumnMapper(this.conf.get("accumulo.columns.mapping"), this.conf.get("accumulo.default.storage"), this.columnNames, this.columnTypes);
        HashSet cfCqPairs = this.inputformat.getPairCollection(columnMapper.getColumnMappings());
        List iterators = Collections.emptyList();
        Set<Range> ranges = Collections.singleton(new Range());
        HiveAccumuloTableInputFormat mockInputFormat = (HiveAccumuloTableInputFormat)Mockito.mock(HiveAccumuloTableInputFormat.class);
        HiveAccumuloHelper helper = (HiveAccumuloHelper)Mockito.mock(HiveAccumuloHelper.class);
        Mockito.when((Object)mockInputFormat.getHelper()).thenReturn((Object)helper);
        ((HiveAccumuloTableInputFormat)Mockito.doCallRealMethod().when((Object)mockInputFormat)).configure(this.conf, this.mockInstance, this.con, accumuloParams, columnMapper, iterators, ranges);
        ((HiveAccumuloTableInputFormat)Mockito.doCallRealMethod().when((Object)mockInputFormat)).getPairCollection(columnMapper.getColumnMappings());
        mockInputFormat.configure(this.conf, this.mockInstance, this.con, accumuloParams, columnMapper, iterators, ranges);
        ((HiveAccumuloHelper)Mockito.verify((Object)helper)).setInputFormatMockInstance(this.conf, this.mockInstance.getInstanceName());
        ((HiveAccumuloHelper)Mockito.verify((Object)helper)).setInputFormatConnectorInfo(this.conf, USER, (AuthenticationToken)new PasswordToken((CharSequence)PASS));
        ((HiveAccumuloTableInputFormat)Mockito.verify((Object)mockInputFormat)).setInputTableName(this.conf, TEST_TABLE);
        ((HiveAccumuloTableInputFormat)Mockito.verify((Object)mockInputFormat)).setScanAuthorizations(this.conf, this.con.securityOperations().getUserAuthorizations(USER));
        ((HiveAccumuloTableInputFormat)Mockito.verify((Object)mockInputFormat)).addIterators(this.conf, iterators);
        ((HiveAccumuloTableInputFormat)Mockito.verify((Object)mockInputFormat)).setRanges(this.conf, ranges);
        ((HiveAccumuloTableInputFormat)Mockito.verify((Object)mockInputFormat)).fetchColumns(this.conf, (Set)cfCqPairs);
    }

    @Test
    public void testConfigureAccumuloInputFormat() throws Exception {
        AccumuloConnectionParameters accumuloParams = new AccumuloConnectionParameters((Configuration)this.conf);
        ColumnMapper columnMapper = new ColumnMapper(this.conf.get("accumulo.columns.mapping"), this.conf.get("accumulo.default.storage"), this.columnNames, this.columnTypes);
        HashSet cfCqPairs = this.inputformat.getPairCollection(columnMapper.getColumnMappings());
        List iterators = Collections.emptyList();
        Set<Range> ranges = Collections.singleton(new Range());
        String instanceName = "realInstance";
        String zookeepers = "host1:5181,host2:5181,host3:5181";
        ZooKeeperInstance zkInstance = (ZooKeeperInstance)Mockito.mock(ZooKeeperInstance.class);
        HiveAccumuloTableInputFormat mockInputFormat = (HiveAccumuloTableInputFormat)Mockito.mock(HiveAccumuloTableInputFormat.class);
        HiveAccumuloHelper helper = (HiveAccumuloHelper)Mockito.mock(HiveAccumuloHelper.class);
        Mockito.when((Object)zkInstance.getInstanceName()).thenReturn((Object)instanceName);
        Mockito.when((Object)zkInstance.getZooKeepers()).thenReturn((Object)zookeepers);
        Mockito.when((Object)mockInputFormat.getHelper()).thenReturn((Object)helper);
        ((HiveAccumuloTableInputFormat)Mockito.doCallRealMethod().when((Object)mockInputFormat)).configure(this.conf, (Instance)zkInstance, this.con, accumuloParams, columnMapper, iterators, ranges);
        ((HiveAccumuloTableInputFormat)Mockito.doCallRealMethod().when((Object)mockInputFormat)).getPairCollection(columnMapper.getColumnMappings());
        mockInputFormat.configure(this.conf, (Instance)zkInstance, this.con, accumuloParams, columnMapper, iterators, ranges);
        ((HiveAccumuloHelper)Mockito.verify((Object)helper)).setInputFormatZooKeeperInstance(this.conf, instanceName, zookeepers, false);
        ((HiveAccumuloHelper)Mockito.verify((Object)helper)).setInputFormatConnectorInfo(this.conf, USER, (AuthenticationToken)new PasswordToken((CharSequence)PASS));
        ((HiveAccumuloTableInputFormat)Mockito.verify((Object)mockInputFormat)).setInputTableName(this.conf, TEST_TABLE);
        ((HiveAccumuloTableInputFormat)Mockito.verify((Object)mockInputFormat)).setScanAuthorizations(this.conf, this.con.securityOperations().getUserAuthorizations(USER));
        ((HiveAccumuloTableInputFormat)Mockito.verify((Object)mockInputFormat)).addIterators(this.conf, iterators);
        ((HiveAccumuloTableInputFormat)Mockito.verify((Object)mockInputFormat)).setRanges(this.conf, ranges);
        ((HiveAccumuloTableInputFormat)Mockito.verify((Object)mockInputFormat)).fetchColumns(this.conf, (Set)cfCqPairs);
    }

    @Test
    public void testConfigureAccumuloInputFormatWithAuthorizations() throws Exception {
        AccumuloConnectionParameters accumuloParams = new AccumuloConnectionParameters((Configuration)this.conf);
        this.conf.set("accumulo.authorizations", "foo,bar");
        ColumnMapper columnMapper = new ColumnMapper(this.conf.get("accumulo.columns.mapping"), this.conf.get("accumulo.default.storage"), this.columnNames, this.columnTypes);
        HashSet cfCqPairs = this.inputformat.getPairCollection(columnMapper.getColumnMappings());
        List iterators = Collections.emptyList();
        Set<Range> ranges = Collections.singleton(new Range());
        String instanceName = "realInstance";
        String zookeepers = "host1:5181,host2:5181,host3:5181";
        ZooKeeperInstance zkInstance = (ZooKeeperInstance)Mockito.mock(ZooKeeperInstance.class);
        HiveAccumuloTableInputFormat mockInputFormat = (HiveAccumuloTableInputFormat)Mockito.mock(HiveAccumuloTableInputFormat.class);
        HiveAccumuloHelper helper = (HiveAccumuloHelper)Mockito.mock(HiveAccumuloHelper.class);
        Mockito.when((Object)zkInstance.getInstanceName()).thenReturn((Object)instanceName);
        Mockito.when((Object)zkInstance.getZooKeepers()).thenReturn((Object)zookeepers);
        Mockito.when((Object)mockInputFormat.getHelper()).thenReturn((Object)helper);
        ((HiveAccumuloTableInputFormat)Mockito.doCallRealMethod().when((Object)mockInputFormat)).configure(this.conf, (Instance)zkInstance, this.con, accumuloParams, columnMapper, iterators, ranges);
        ((HiveAccumuloTableInputFormat)Mockito.doCallRealMethod().when((Object)mockInputFormat)).getPairCollection(columnMapper.getColumnMappings());
        mockInputFormat.configure(this.conf, (Instance)zkInstance, this.con, accumuloParams, columnMapper, iterators, ranges);
        ((HiveAccumuloHelper)Mockito.verify((Object)helper)).setInputFormatZooKeeperInstance(this.conf, instanceName, zookeepers, false);
        ((HiveAccumuloHelper)Mockito.verify((Object)helper)).setInputFormatConnectorInfo(this.conf, USER, (AuthenticationToken)new PasswordToken((CharSequence)PASS));
        ((HiveAccumuloTableInputFormat)Mockito.verify((Object)mockInputFormat)).setInputTableName(this.conf, TEST_TABLE);
        ((HiveAccumuloTableInputFormat)Mockito.verify((Object)mockInputFormat)).setScanAuthorizations(this.conf, new Authorizations(new String[]{"foo,bar"}));
        ((HiveAccumuloTableInputFormat)Mockito.verify((Object)mockInputFormat)).addIterators(this.conf, iterators);
        ((HiveAccumuloTableInputFormat)Mockito.verify((Object)mockInputFormat)).setRanges(this.conf, ranges);
        ((HiveAccumuloTableInputFormat)Mockito.verify((Object)mockInputFormat)).fetchColumns(this.conf, (Set)cfCqPairs);
    }

    @Test
    public void testConfigureAccumuloInputFormatWithIterators() throws Exception {
        AccumuloConnectionParameters accumuloParams = new AccumuloConnectionParameters((Configuration)this.conf);
        ColumnMapper columnMapper = new ColumnMapper(this.conf.get("accumulo.columns.mapping"), this.conf.get("accumulo.default.storage"), this.columnNames, this.columnTypes);
        HashSet cfCqPairs = this.inputformat.getPairCollection(columnMapper.getColumnMappings());
        ArrayList<IteratorSetting> iterators = new ArrayList<IteratorSetting>();
        Set<Range> ranges = Collections.singleton(new Range());
        String instanceName = "realInstance";
        String zookeepers = "host1:5181,host2:5181,host3:5181";
        IteratorSetting cfg = new IteratorSetting(50, PrimitiveComparisonFilter.class);
        cfg.addOption("accumulo.filter.iterator.p.compare.class", StringCompare.class.getName());
        cfg.addOption("accumulo.filter.iterator.compare.opt.class", Equal.class.getName());
        cfg.addOption("accumulo.filter.iterator.const.val", "dave");
        cfg.addOption("accumulo.filter.iterator.qual", "person:name");
        iterators.add(cfg);
        cfg = new IteratorSetting(50, PrimitiveComparisonFilter.class);
        cfg.addOption("accumulo.filter.iterator.p.compare.class", IntCompare.class.getName());
        cfg.addOption("accumulo.filter.iterator.compare.opt.class", Equal.class.getName());
        cfg.addOption("accumulo.filter.iterator.const.val", "50");
        cfg.addOption("accumulo.filter.iterator.qual", "person:age");
        iterators.add(cfg);
        ZooKeeperInstance zkInstance = (ZooKeeperInstance)Mockito.mock(ZooKeeperInstance.class);
        HiveAccumuloTableInputFormat mockInputFormat = (HiveAccumuloTableInputFormat)Mockito.mock(HiveAccumuloTableInputFormat.class);
        HiveAccumuloHelper helper = (HiveAccumuloHelper)Mockito.mock(HiveAccumuloHelper.class);
        Mockito.when((Object)zkInstance.getInstanceName()).thenReturn((Object)instanceName);
        Mockito.when((Object)zkInstance.getZooKeepers()).thenReturn((Object)zookeepers);
        Mockito.when((Object)mockInputFormat.getHelper()).thenReturn((Object)helper);
        ((HiveAccumuloTableInputFormat)Mockito.doCallRealMethod().when((Object)mockInputFormat)).configure(this.conf, (Instance)zkInstance, this.con, accumuloParams, columnMapper, iterators, ranges);
        ((HiveAccumuloTableInputFormat)Mockito.doCallRealMethod().when((Object)mockInputFormat)).getPairCollection(columnMapper.getColumnMappings());
        mockInputFormat.configure(this.conf, (Instance)zkInstance, this.con, accumuloParams, columnMapper, iterators, ranges);
        ((HiveAccumuloHelper)Mockito.verify((Object)helper)).setInputFormatZooKeeperInstance(this.conf, instanceName, zookeepers, false);
        ((HiveAccumuloHelper)Mockito.verify((Object)helper)).setInputFormatConnectorInfo(this.conf, USER, (AuthenticationToken)new PasswordToken((CharSequence)PASS));
        ((HiveAccumuloTableInputFormat)Mockito.verify((Object)mockInputFormat)).setInputTableName(this.conf, TEST_TABLE);
        ((HiveAccumuloTableInputFormat)Mockito.verify((Object)mockInputFormat)).setScanAuthorizations(this.conf, this.con.securityOperations().getUserAuthorizations(USER));
        ((HiveAccumuloTableInputFormat)Mockito.verify((Object)mockInputFormat)).addIterators(this.conf, iterators);
        ((HiveAccumuloTableInputFormat)Mockito.verify((Object)mockInputFormat)).setRanges(this.conf, ranges);
        ((HiveAccumuloTableInputFormat)Mockito.verify((Object)mockInputFormat)).fetchColumns(this.conf, (Set)cfCqPairs);
    }

    @Test
    public void testConfigureAccumuloInputFormatWithEmptyColumns() throws Exception {
        AccumuloConnectionParameters accumuloParams = new AccumuloConnectionParameters((Configuration)this.conf);
        ColumnMapper columnMapper = new ColumnMapper(this.conf.get("accumulo.columns.mapping"), this.conf.get("accumulo.default.storage"), this.columnNames, this.columnTypes);
        HashSet cfCqPairs = Sets.newHashSet();
        ArrayList<IteratorSetting> iterators = new ArrayList<IteratorSetting>();
        Set<Range> ranges = Collections.singleton(new Range());
        String instanceName = "realInstance";
        String zookeepers = "host1:5181,host2:5181,host3:5181";
        IteratorSetting cfg = new IteratorSetting(50, PrimitiveComparisonFilter.class);
        cfg.addOption("accumulo.filter.iterator.p.compare.class", StringCompare.class.getName());
        cfg.addOption("accumulo.filter.iterator.compare.opt.class", Equal.class.getName());
        cfg.addOption("accumulo.filter.iterator.const.val", "dave");
        cfg.addOption("accumulo.filter.iterator.qual", "person:name");
        iterators.add(cfg);
        cfg = new IteratorSetting(50, PrimitiveComparisonFilter.class);
        cfg.addOption("accumulo.filter.iterator.p.compare.class", IntCompare.class.getName());
        cfg.addOption("accumulo.filter.iterator.compare.opt.class", Equal.class.getName());
        cfg.addOption("accumulo.filter.iterator.const.val", "50");
        cfg.addOption("accumulo.filter.iterator.qual", "person:age");
        iterators.add(cfg);
        ZooKeeperInstance zkInstance = (ZooKeeperInstance)Mockito.mock(ZooKeeperInstance.class);
        HiveAccumuloTableInputFormat mockInputFormat = (HiveAccumuloTableInputFormat)Mockito.mock(HiveAccumuloTableInputFormat.class);
        HiveAccumuloHelper helper = (HiveAccumuloHelper)Mockito.mock(HiveAccumuloHelper.class);
        Mockito.when((Object)zkInstance.getInstanceName()).thenReturn((Object)instanceName);
        Mockito.when((Object)zkInstance.getZooKeepers()).thenReturn((Object)zookeepers);
        Mockito.when((Object)mockInputFormat.getPairCollection(columnMapper.getColumnMappings())).thenReturn((Object)cfCqPairs);
        Mockito.when((Object)mockInputFormat.getHelper()).thenReturn((Object)helper);
        ((HiveAccumuloTableInputFormat)Mockito.doCallRealMethod().when((Object)mockInputFormat)).configure(this.conf, (Instance)zkInstance, this.con, accumuloParams, columnMapper, iterators, ranges);
        ((HiveAccumuloTableInputFormat)Mockito.doCallRealMethod().when((Object)mockInputFormat)).getPairCollection(columnMapper.getColumnMappings());
        mockInputFormat.configure(this.conf, (Instance)zkInstance, this.con, accumuloParams, columnMapper, iterators, ranges);
        ((HiveAccumuloHelper)Mockito.verify((Object)helper)).setInputFormatZooKeeperInstance(this.conf, instanceName, zookeepers, false);
        ((HiveAccumuloHelper)Mockito.verify((Object)helper)).setInputFormatConnectorInfo(this.conf, USER, (AuthenticationToken)new PasswordToken((CharSequence)PASS));
        ((HiveAccumuloTableInputFormat)Mockito.verify((Object)mockInputFormat)).setInputTableName(this.conf, TEST_TABLE);
        ((HiveAccumuloTableInputFormat)Mockito.verify((Object)mockInputFormat)).setScanAuthorizations(this.conf, this.con.securityOperations().getUserAuthorizations(USER));
        ((HiveAccumuloTableInputFormat)Mockito.verify((Object)mockInputFormat)).addIterators(this.conf, iterators);
        ((HiveAccumuloTableInputFormat)Mockito.verify((Object)mockInputFormat)).setRanges(this.conf, ranges);
    }

    @Test
    public void testGetProtectedField() throws Exception {
        FileInputFormat.addInputPath((JobConf)this.conf, (Path)new Path("unused"));
        BatchWriterConfig writerConf = new BatchWriterConfig();
        BatchWriter writer = this.con.createBatchWriter(TEST_TABLE, writerConf);
        Authorizations origAuths = this.con.securityOperations().getUserAuthorizations(USER);
        this.con.securityOperations().changeUserAuthorizations(USER, new Authorizations(new String[]{origAuths.toString() + ",foo"}));
        Mutation m = new Mutation((CharSequence)"r4");
        m.put(COLUMN_FAMILY, NAME, new ColumnVisibility("foo"), new Value("frank".getBytes()));
        m.put(COLUMN_FAMILY, SID, new ColumnVisibility("foo"), new Value(this.parseIntBytes("4")));
        m.put(COLUMN_FAMILY, DEGREES, new ColumnVisibility("foo"), new Value(this.parseDoubleBytes("60.6")));
        m.put(COLUMN_FAMILY, MILLIS, new ColumnVisibility("foo"), new Value(this.parseLongBytes("777")));
        writer.addMutation(m);
        writer.close();
        this.conf.set("accumulo.authorizations", "foo");
        InputSplit[] splits = this.inputformat.getSplits(this.conf, 0);
        Assert.assertEquals((long)splits.length, (long)1L);
        RecordReader reader = this.inputformat.getRecordReader(splits[0], this.conf, null);
        Text rowId = new Text("r1");
        AccumuloHiveRow row = new AccumuloHiveRow();
        Assert.assertTrue((boolean)reader.next((Object)rowId, (Object)row));
        Assert.assertEquals((Object)row.getRowId(), (Object)rowId.toString());
        Assert.assertTrue((boolean)row.hasFamAndQual(COLUMN_FAMILY, NAME));
        Assert.assertArrayEquals((byte[])row.getValue(COLUMN_FAMILY, NAME), (byte[])"brian".getBytes());
        rowId = new Text("r2");
        Assert.assertTrue((boolean)reader.next((Object)rowId, (Object)row));
        Assert.assertEquals((Object)row.getRowId(), (Object)rowId.toString());
        Assert.assertTrue((boolean)row.hasFamAndQual(COLUMN_FAMILY, NAME));
        Assert.assertArrayEquals((byte[])row.getValue(COLUMN_FAMILY, NAME), (byte[])"mark".getBytes());
        rowId = new Text("r3");
        Assert.assertTrue((boolean)reader.next((Object)rowId, (Object)row));
        Assert.assertEquals((Object)row.getRowId(), (Object)rowId.toString());
        Assert.assertTrue((boolean)row.hasFamAndQual(COLUMN_FAMILY, NAME));
        Assert.assertArrayEquals((byte[])row.getValue(COLUMN_FAMILY, NAME), (byte[])"dennis".getBytes());
        rowId = new Text("r4");
        Assert.assertTrue((boolean)reader.next((Object)rowId, (Object)row));
        Assert.assertEquals((Object)row.getRowId(), (Object)rowId.toString());
        Assert.assertTrue((boolean)row.hasFamAndQual(COLUMN_FAMILY, NAME));
        Assert.assertArrayEquals((byte[])row.getValue(COLUMN_FAMILY, NAME), (byte[])"frank".getBytes());
        Assert.assertFalse((boolean)reader.next((Object)rowId, (Object)row));
    }

    @Test
    public void testMapColumnPairs() throws TooManyAccumuloColumnsException {
        ColumnMapper columnMapper = new ColumnMapper(":rowID,cf:*", this.conf.get("accumulo.default.storage"), Arrays.asList("row", "col"), Arrays.asList(TypeInfoFactory.stringTypeInfo, TypeInfoFactory.getMapTypeInfo((TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.stringTypeInfo)));
        HashSet pairs = this.inputformat.getPairCollection(columnMapper.getColumnMappings());
        Assert.assertEquals((long)1L, (long)pairs.size());
        Pair cfCq = (Pair)pairs.iterator().next();
        Assert.assertEquals((Object)"cf", (Object)((Text)cfCq.getFirst()).toString());
        Assert.assertNull((Object)cfCq.getSecond());
    }
}

