/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.mr;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.mock.MockInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.hive.accumulo.AccumuloConnectionParameters;
import org.apache.hadoop.hive.accumulo.HiveAccumuloHelper;
import org.apache.hadoop.hive.accumulo.columns.ColumnEncoding;
import org.apache.hadoop.hive.accumulo.mr.HiveAccumuloTableOutputFormat;
import org.apache.hadoop.hive.accumulo.serde.AccumuloRowSerializer;
import org.apache.hadoop.hive.accumulo.serde.AccumuloSerDe;
import org.apache.hadoop.hive.accumulo.serde.AccumuloSerDeParameters;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazySerDeParameters;
import org.apache.hadoop.hive.serde2.lazy.LazyStruct;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyMapObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazySimpleStructObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.mockito.Mockito;

public class TestHiveAccumuloTableOutputFormat {
    protected JobConf conf;
    protected String user = "root";
    protected String password = "password";
    protected String instanceName = "instance";
    protected String zookeepers = "host1:2181,host2:2181,host3:2181";
    protected String outputTable = "output";
    @Rule
    public TestName test = new TestName();

    @Before
    public void setup() throws IOException {
        this.conf = new JobConf();
        this.conf.set("accumulo.user.name", this.user);
        this.conf.set("accumulo.user.pass", this.password);
        this.conf.set("accumulo.instance.name", this.instanceName);
        this.conf.set("accumulo.zookeepers", this.zookeepers);
        this.conf.set("accumulo.table.name", this.outputTable);
        System.setProperty("java.security.krb5.realm", "accumulo");
        System.setProperty("java.security.krb5.kdc", "fake");
    }

    @After
    public void cleanup() {
        System.setProperty("java.security.krb5.realm", "");
        System.setProperty("java.security.krb5.kdc", "");
    }

    @Test
    public void testBasicConfiguration() throws IOException, AccumuloSecurityException {
        HiveAccumuloTableOutputFormat outputFormat = (HiveAccumuloTableOutputFormat)Mockito.mock(HiveAccumuloTableOutputFormat.class);
        ((HiveAccumuloTableOutputFormat)Mockito.doCallRealMethod().when((Object)outputFormat)).configureAccumuloOutputFormat(this.conf);
        ((HiveAccumuloTableOutputFormat)Mockito.doCallRealMethod().when((Object)outputFormat)).getConnectionParams(this.conf);
        outputFormat.configureAccumuloOutputFormat(this.conf);
        ((HiveAccumuloTableOutputFormat)Mockito.verify((Object)outputFormat)).setConnectorInfoWithErrorChecking(this.conf, this.user, (AuthenticationToken)new PasswordToken((CharSequence)this.password));
        ((HiveAccumuloTableOutputFormat)Mockito.verify((Object)outputFormat)).setZooKeeperInstanceWithErrorChecking(this.conf, this.instanceName, this.zookeepers, false);
        ((HiveAccumuloTableOutputFormat)Mockito.verify((Object)outputFormat)).setDefaultAccumuloTableName(this.conf, this.outputTable);
    }

    @Test
    public void testSaslConfiguration() throws IOException, AccumuloException, AccumuloSecurityException {
        HiveAccumuloTableOutputFormat outputFormat = (HiveAccumuloTableOutputFormat)Mockito.mock(HiveAccumuloTableOutputFormat.class);
        AuthenticationToken authToken = (AuthenticationToken)Mockito.mock(AuthenticationToken.class);
        Token hadoopToken = (Token)Mockito.mock(Token.class);
        HiveAccumuloHelper helper = (HiveAccumuloHelper)Mockito.mock(HiveAccumuloHelper.class);
        AccumuloConnectionParameters cnxnParams = (AccumuloConnectionParameters)Mockito.mock(AccumuloConnectionParameters.class);
        Connector connector = (Connector)Mockito.mock(Connector.class);
        this.conf.set("hadoop.security.authentication", "kerberos");
        this.conf.set("hadoop.security.custom.auth.principal.class", "javax.security.auth.kerberos.KerberosPrincipal");
        this.conf.set("hadoop.security.custom.rpc.auth.method.class", "org.apache.hadoop.security.rpcauth.KerberosAuthMethod");
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        UserGroupInformation user1 = UserGroupInformation.createUserForTesting((String)this.user, (String[])new String[0]);
        Mockito.when((Object)outputFormat.getCurrentUser()).thenReturn((Object)user1);
        this.conf.unset("accumulo.user.pass");
        ((HiveAccumuloTableOutputFormat)Mockito.doCallRealMethod().when((Object)outputFormat)).configureAccumuloOutputFormat(this.conf);
        Mockito.when((Object)outputFormat.getHelper()).thenReturn((Object)helper);
        Mockito.when((Object)outputFormat.getConnectionParams(this.conf)).thenReturn((Object)cnxnParams);
        Mockito.when((Object)cnxnParams.getConnector()).thenReturn((Object)connector);
        Mockito.when((Object)helper.getDelegationToken(connector)).thenReturn((Object)authToken);
        Mockito.when((Object)helper.getHadoopToken(authToken)).thenReturn((Object)hadoopToken);
        Mockito.when((Object)cnxnParams.useSasl()).thenReturn((Object)true);
        Mockito.when((Object)cnxnParams.getAccumuloUserName()).thenReturn((Object)this.user);
        Mockito.when((Object)cnxnParams.getAccumuloInstanceName()).thenReturn((Object)this.instanceName);
        Mockito.when((Object)cnxnParams.getZooKeepers()).thenReturn((Object)this.zookeepers);
        Mockito.when((Object)outputFormat.hasKerberosCredentials(user1)).thenReturn((Object)true);
        outputFormat.configureAccumuloOutputFormat(this.conf);
        ((HiveAccumuloTableOutputFormat)Mockito.verify((Object)outputFormat)).setZooKeeperInstanceWithErrorChecking(this.conf, this.instanceName, this.zookeepers, true);
        ((HiveAccumuloTableOutputFormat)Mockito.verify((Object)outputFormat)).setConnectorInfoWithErrorChecking(this.conf, this.user, authToken);
        ((HiveAccumuloTableOutputFormat)Mockito.verify((Object)outputFormat)).setDefaultAccumuloTableName(this.conf, this.outputTable);
        ((HiveAccumuloHelper)Mockito.verify((Object)helper)).mergeTokenIntoJobConf(this.conf, hadoopToken);
        Collection tokens = user1.getTokens();
        Assert.assertEquals((long)1L, (long)tokens.size());
        Assert.assertEquals((Object)hadoopToken, tokens.iterator().next());
    }

    @Test
    public void testMockInstance() throws IOException, AccumuloSecurityException {
        HiveAccumuloTableOutputFormat outputFormat = (HiveAccumuloTableOutputFormat)Mockito.mock(HiveAccumuloTableOutputFormat.class);
        this.conf.setBoolean("accumulo.mock.instance", true);
        this.conf.unset("accumulo.zookeepers");
        ((HiveAccumuloTableOutputFormat)Mockito.doCallRealMethod().when((Object)outputFormat)).configureAccumuloOutputFormat(this.conf);
        ((HiveAccumuloTableOutputFormat)Mockito.doCallRealMethod().when((Object)outputFormat)).getConnectionParams(this.conf);
        outputFormat.configureAccumuloOutputFormat(this.conf);
        ((HiveAccumuloTableOutputFormat)Mockito.verify((Object)outputFormat)).setConnectorInfoWithErrorChecking(this.conf, this.user, (AuthenticationToken)new PasswordToken((CharSequence)this.password));
        ((HiveAccumuloTableOutputFormat)Mockito.verify((Object)outputFormat)).setMockInstanceWithErrorChecking(this.conf, this.instanceName);
        ((HiveAccumuloTableOutputFormat)Mockito.verify((Object)outputFormat)).setDefaultAccumuloTableName(this.conf, this.outputTable);
    }

    @Test
    public void testWriteToMockInstance() throws Exception {
        MockInstance inst = new MockInstance(this.test.getMethodName());
        Connector conn = inst.getConnector("root", (AuthenticationToken)new PasswordToken((CharSequence)""));
        HiveAccumuloTableOutputFormat outputFormat = new HiveAccumuloTableOutputFormat();
        String table = this.test.getMethodName();
        conn.tableOperations().create(table);
        JobConf conf = new JobConf();
        conf.set("accumulo.instance.name", inst.getInstanceName());
        conf.set("accumulo.user.name", "root");
        conf.set("accumulo.user.pass", "");
        conf.setBoolean("accumulo.mock.instance", true);
        conf.set("accumulo.table.name", this.test.getMethodName());
        LocalFileSystem local = FileSystem.getLocal((Configuration)conf);
        outputFormat.checkOutputSpecs((FileSystem)local, conf);
        RecordWriter recordWriter = outputFormat.getRecordWriter((FileSystem)local, conf, null, null);
        List<String> names = Arrays.asList("row", "col1", "col2");
        List<TypeInfo> types = Arrays.asList(TypeInfoFactory.stringTypeInfo, TypeInfoFactory.stringTypeInfo, TypeInfoFactory.stringTypeInfo);
        Properties tableProperties = new Properties();
        tableProperties.setProperty("accumulo.columns.mapping", ":rowID,cf:cq1,cf:cq2");
        tableProperties.setProperty("field.delim", " ");
        tableProperties.setProperty("columns", Joiner.on((char)',').join(names));
        tableProperties.setProperty("columns.types", Joiner.on((char)',').join(types));
        AccumuloSerDeParameters accumuloSerDeParams = new AccumuloSerDeParameters(new Configuration(), tableProperties, AccumuloSerDe.class.getSimpleName());
        LazySerDeParameters serDeParams = accumuloSerDeParams.getSerDeParameters();
        AccumuloRowSerializer serializer = new AccumuloRowSerializer(0, serDeParams, accumuloSerDeParams.getColumnMappings(), AccumuloSerDeParameters.DEFAULT_VISIBILITY_LABEL, accumuloSerDeParams.getRowIdFactory());
        PrimitiveTypeInfo stringTypeInfo = TypeInfoFactory.getPrimitiveTypeInfo((String)"string");
        LazySimpleStructObjectInspector structOI = (LazySimpleStructObjectInspector)LazyFactory.createLazyStructInspector(Arrays.asList("row", "cq1", "cq2"), Arrays.asList(stringTypeInfo, stringTypeInfo, stringTypeInfo), (byte[])serDeParams.getSeparators(), (Text)serDeParams.getNullSequence(), (boolean)serDeParams.isLastColumnTakesRest(), (boolean)serDeParams.isEscaped(), (byte)serDeParams.getEscapeChar());
        LazyStruct struct = (LazyStruct)LazyFactory.createLazyObject((ObjectInspector)structOI);
        ByteArrayRef bytes = new ByteArrayRef();
        bytes.setData("row value1 value2".getBytes());
        struct.init(bytes, 0, bytes.getData().length);
        Mutation m = serializer.serialize((Object)struct, (ObjectInspector)structOI);
        recordWriter.write((Object)new Text(table), (Object)m);
        recordWriter.close(null);
        Iterator iter = conn.createScanner(table, new Authorizations()).iterator();
        Assert.assertTrue((String)"Iterator did not have an element as expected", (boolean)iter.hasNext());
        Map.Entry entry = (Map.Entry)iter.next();
        Key k = (Key)entry.getKey();
        Value v = (Value)entry.getValue();
        Assert.assertEquals((Object)"row", (Object)k.getRow().toString());
        Assert.assertEquals((Object)"cf", (Object)k.getColumnFamily().toString());
        Assert.assertEquals((Object)"cq1", (Object)k.getColumnQualifier().toString());
        Assert.assertEquals((Object)"", (Object)k.getColumnVisibility().toString());
        Assert.assertEquals((Object)"value1", (Object)new String(v.get()));
        Assert.assertTrue((String)"Iterator did not have an element as expected", (boolean)iter.hasNext());
        entry = (Map.Entry)iter.next();
        k = (Key)entry.getKey();
        v = (Value)entry.getValue();
        Assert.assertEquals((Object)"row", (Object)k.getRow().toString());
        Assert.assertEquals((Object)"cf", (Object)k.getColumnFamily().toString());
        Assert.assertEquals((Object)"cq2", (Object)k.getColumnQualifier().toString());
        Assert.assertEquals((Object)"", (Object)k.getColumnVisibility().toString());
        Assert.assertEquals((Object)"value2", (Object)new String(v.get()));
        Assert.assertFalse((String)"Iterator unexpectedly had more data", (boolean)iter.hasNext());
    }

    @Test
    public void testWriteToMockInstanceWithVisibility() throws Exception {
        MockInstance inst = new MockInstance(this.test.getMethodName());
        Connector conn = inst.getConnector("root", (AuthenticationToken)new PasswordToken((CharSequence)""));
        Authorizations auths = new Authorizations(new String[]{"foo"});
        conn.securityOperations().changeUserAuthorizations("root", auths);
        HiveAccumuloTableOutputFormat outputFormat = new HiveAccumuloTableOutputFormat();
        String table = this.test.getMethodName();
        conn.tableOperations().create(table);
        JobConf conf = new JobConf();
        conf.set("accumulo.instance.name", inst.getInstanceName());
        conf.set("accumulo.user.name", "root");
        conf.set("accumulo.user.pass", "");
        conf.setBoolean("accumulo.mock.instance", true);
        conf.set("accumulo.table.name", this.test.getMethodName());
        LocalFileSystem local = FileSystem.getLocal((Configuration)conf);
        outputFormat.checkOutputSpecs((FileSystem)local, conf);
        RecordWriter recordWriter = outputFormat.getRecordWriter((FileSystem)local, conf, null, null);
        List<String> names = Arrays.asList("row", "col1", "col2");
        List<TypeInfo> types = Arrays.asList(TypeInfoFactory.stringTypeInfo, TypeInfoFactory.stringTypeInfo, TypeInfoFactory.stringTypeInfo);
        Properties tableProperties = new Properties();
        tableProperties.setProperty("accumulo.columns.mapping", ":rowID,cf:cq1,cf:cq2");
        tableProperties.setProperty("field.delim", " ");
        tableProperties.setProperty("columns", Joiner.on((char)',').join(names));
        tableProperties.setProperty("columns.types", Joiner.on((char)',').join(types));
        AccumuloSerDeParameters accumuloSerDeParams = new AccumuloSerDeParameters(new Configuration(), tableProperties, AccumuloSerDe.class.getSimpleName());
        LazySerDeParameters serDeParams = accumuloSerDeParams.getSerDeParameters();
        AccumuloRowSerializer serializer = new AccumuloRowSerializer(0, serDeParams, accumuloSerDeParams.getColumnMappings(), new ColumnVisibility("foo"), accumuloSerDeParams.getRowIdFactory());
        LazySimpleStructObjectInspector structOI = (LazySimpleStructObjectInspector)LazyFactory.createLazyStructInspector(Arrays.asList("row", "cq1", "cq2"), Arrays.asList(TypeInfoFactory.stringTypeInfo, TypeInfoFactory.stringTypeInfo, TypeInfoFactory.stringTypeInfo), (byte[])serDeParams.getSeparators(), (Text)serDeParams.getNullSequence(), (boolean)serDeParams.isLastColumnTakesRest(), (boolean)serDeParams.isEscaped(), (byte)serDeParams.getEscapeChar());
        LazyStruct struct = (LazyStruct)LazyFactory.createLazyObject((ObjectInspector)structOI);
        ByteArrayRef bytes = new ByteArrayRef();
        bytes.setData("row value1 value2".getBytes());
        struct.init(bytes, 0, bytes.getData().length);
        Mutation m = serializer.serialize((Object)struct, (ObjectInspector)structOI);
        recordWriter.write((Object)new Text(table), (Object)m);
        recordWriter.close(null);
        Iterator iter = conn.createScanner(table, auths).iterator();
        Assert.assertTrue((String)"Iterator did not have an element as expected", (boolean)iter.hasNext());
        Map.Entry entry = (Map.Entry)iter.next();
        Key k = (Key)entry.getKey();
        Value v = (Value)entry.getValue();
        Assert.assertEquals((Object)"row", (Object)k.getRow().toString());
        Assert.assertEquals((Object)"cf", (Object)k.getColumnFamily().toString());
        Assert.assertEquals((Object)"cq1", (Object)k.getColumnQualifier().toString());
        Assert.assertEquals((Object)"foo", (Object)k.getColumnVisibility().toString());
        Assert.assertEquals((Object)"value1", (Object)new String(v.get()));
        Assert.assertTrue((String)"Iterator did not have an element as expected", (boolean)iter.hasNext());
        entry = (Map.Entry)iter.next();
        k = (Key)entry.getKey();
        v = (Value)entry.getValue();
        Assert.assertEquals((Object)"row", (Object)k.getRow().toString());
        Assert.assertEquals((Object)"cf", (Object)k.getColumnFamily().toString());
        Assert.assertEquals((Object)"cq2", (Object)k.getColumnQualifier().toString());
        Assert.assertEquals((Object)"foo", (Object)k.getColumnVisibility().toString());
        Assert.assertEquals((Object)"value2", (Object)new String(v.get()));
        Assert.assertFalse((String)"Iterator unexpectedly had more data", (boolean)iter.hasNext());
    }

    @Test
    public void testWriteMap() throws Exception {
        MockInstance inst = new MockInstance(this.test.getMethodName());
        Connector conn = inst.getConnector("root", (AuthenticationToken)new PasswordToken((CharSequence)""));
        HiveAccumuloTableOutputFormat outputFormat = new HiveAccumuloTableOutputFormat();
        String table = this.test.getMethodName();
        conn.tableOperations().create(table);
        JobConf conf = new JobConf();
        conf.set("accumulo.instance.name", inst.getInstanceName());
        conf.set("accumulo.user.name", "root");
        conf.set("accumulo.user.pass", "");
        conf.setBoolean("accumulo.mock.instance", true);
        conf.set("accumulo.table.name", this.test.getMethodName());
        LocalFileSystem local = FileSystem.getLocal((Configuration)conf);
        outputFormat.checkOutputSpecs((FileSystem)local, conf);
        RecordWriter recordWriter = outputFormat.getRecordWriter((FileSystem)local, conf, null, null);
        List<String> names = Arrays.asList("row", "col1");
        List<TypeInfo> types = Arrays.asList(TypeInfoFactory.stringTypeInfo, TypeInfoFactory.stringTypeInfo);
        Properties tableProperties = new Properties();
        tableProperties.setProperty("accumulo.columns.mapping", ":rowID,cf:*");
        tableProperties.setProperty("field.delim", " ");
        tableProperties.setProperty("columns", Joiner.on((char)',').join(names));
        tableProperties.setProperty("columns.types", Joiner.on((char)',').join(types));
        AccumuloSerDeParameters accumuloSerDeParams = new AccumuloSerDeParameters(new Configuration(), tableProperties, AccumuloSerDe.class.getSimpleName());
        LazySerDeParameters serDeParams = accumuloSerDeParams.getSerDeParameters();
        AccumuloRowSerializer serializer = new AccumuloRowSerializer(0, serDeParams, accumuloSerDeParams.getColumnMappings(), AccumuloSerDeParameters.DEFAULT_VISIBILITY_LABEL, accumuloSerDeParams.getRowIdFactory());
        PrimitiveTypeInfo stringTypeInfo = TypeInfoFactory.getPrimitiveTypeInfo((String)"string");
        LazyStringObjectInspector stringOI = (LazyStringObjectInspector)LazyFactory.createLazyObjectInspector((TypeInfo)stringTypeInfo, (byte[])new byte[]{0}, (int)0, (Text)serDeParams.getNullSequence(), (boolean)serDeParams.isEscaped(), (byte)serDeParams.getEscapeChar());
        LazyMapObjectInspector mapOI = LazyObjectInspectorFactory.getLazySimpleMapObjectInspector((ObjectInspector)stringOI, (ObjectInspector)stringOI, (byte)44, (byte)58, (Text)serDeParams.getNullSequence(), (boolean)serDeParams.isEscaped(), (byte)serDeParams.getEscapeChar());
        LazySimpleStructObjectInspector structOI = LazyObjectInspectorFactory.getLazySimpleStructObjectInspector(Arrays.asList("row", "data"), Arrays.asList(stringOI, mapOI), (byte)32, (Text)serDeParams.getNullSequence(), (boolean)serDeParams.isLastColumnTakesRest(), (boolean)serDeParams.isEscaped(), (byte)serDeParams.getEscapeChar());
        LazyStruct struct = (LazyStruct)LazyFactory.createLazyObject((ObjectInspector)structOI);
        ByteArrayRef bytes = new ByteArrayRef();
        bytes.setData("row cq1:value1,cq2:value2".getBytes());
        struct.init(bytes, 0, bytes.getData().length);
        Mutation m = serializer.serialize((Object)struct, (ObjectInspector)structOI);
        recordWriter.write((Object)new Text(table), (Object)m);
        recordWriter.close(null);
        Iterator iter = conn.createScanner(table, new Authorizations()).iterator();
        Assert.assertTrue((String)"Iterator did not have an element as expected", (boolean)iter.hasNext());
        Map.Entry entry = (Map.Entry)iter.next();
        Key k = (Key)entry.getKey();
        Value v = (Value)entry.getValue();
        Assert.assertEquals((Object)"row", (Object)k.getRow().toString());
        Assert.assertEquals((Object)"cf", (Object)k.getColumnFamily().toString());
        Assert.assertEquals((Object)"cq1", (Object)k.getColumnQualifier().toString());
        Assert.assertEquals((Object)AccumuloSerDeParameters.DEFAULT_VISIBILITY_LABEL, (Object)k.getColumnVisibilityParsed());
        Assert.assertEquals((Object)"value1", (Object)new String(v.get()));
        Assert.assertTrue((String)"Iterator did not have an element as expected", (boolean)iter.hasNext());
        entry = (Map.Entry)iter.next();
        k = (Key)entry.getKey();
        v = (Value)entry.getValue();
        Assert.assertEquals((Object)"row", (Object)k.getRow().toString());
        Assert.assertEquals((Object)"cf", (Object)k.getColumnFamily().toString());
        Assert.assertEquals((Object)"cq2", (Object)k.getColumnQualifier().toString());
        Assert.assertEquals((Object)AccumuloSerDeParameters.DEFAULT_VISIBILITY_LABEL, (Object)k.getColumnVisibilityParsed());
        Assert.assertEquals((Object)"value2", (Object)new String(v.get()));
        Assert.assertFalse((String)"Iterator unexpectedly had more data", (boolean)iter.hasNext());
    }

    @Test
    public void testBinarySerializationOnStringFallsBackToUtf8() throws Exception {
        MockInstance inst = new MockInstance(this.test.getMethodName());
        Connector conn = inst.getConnector("root", (AuthenticationToken)new PasswordToken((CharSequence)""));
        HiveAccumuloTableOutputFormat outputFormat = new HiveAccumuloTableOutputFormat();
        String table = this.test.getMethodName();
        conn.tableOperations().create(table);
        JobConf conf = new JobConf();
        conf.set("accumulo.instance.name", inst.getInstanceName());
        conf.set("accumulo.user.name", "root");
        conf.set("accumulo.user.pass", "");
        conf.setBoolean("accumulo.mock.instance", true);
        conf.set("accumulo.table.name", this.test.getMethodName());
        LocalFileSystem local = FileSystem.getLocal((Configuration)conf);
        outputFormat.checkOutputSpecs((FileSystem)local, conf);
        RecordWriter recordWriter = outputFormat.getRecordWriter((FileSystem)local, conf, null, null);
        List<String> names = Arrays.asList("row", "col1", "col2");
        List<TypeInfo> types = Arrays.asList(TypeInfoFactory.stringTypeInfo, TypeInfoFactory.stringTypeInfo, TypeInfoFactory.stringTypeInfo);
        Properties tableProperties = new Properties();
        tableProperties.setProperty("accumulo.columns.mapping", ":rowID,cf:cq1,cf:cq2");
        tableProperties.setProperty("field.delim", " ");
        tableProperties.setProperty("columns", Joiner.on((char)',').join(names));
        tableProperties.setProperty("columns.types", Joiner.on((char)',').join(types));
        tableProperties.setProperty("accumulo.default.storage", ColumnEncoding.BINARY.getName());
        AccumuloSerDeParameters accumuloSerDeParams = new AccumuloSerDeParameters(new Configuration(), tableProperties, AccumuloSerDe.class.getSimpleName());
        LazySerDeParameters serDeParams = accumuloSerDeParams.getSerDeParameters();
        AccumuloRowSerializer serializer = new AccumuloRowSerializer(0, serDeParams, accumuloSerDeParams.getColumnMappings(), AccumuloSerDeParameters.DEFAULT_VISIBILITY_LABEL, accumuloSerDeParams.getRowIdFactory());
        PrimitiveTypeInfo stringTypeInfo = TypeInfoFactory.getPrimitiveTypeInfo((String)"string");
        LazySimpleStructObjectInspector structOI = (LazySimpleStructObjectInspector)LazyFactory.createLazyStructInspector(Arrays.asList("row", "cq1", "cq2"), Arrays.asList(stringTypeInfo, stringTypeInfo, stringTypeInfo), (byte[])serDeParams.getSeparators(), (Text)serDeParams.getNullSequence(), (boolean)serDeParams.isLastColumnTakesRest(), (boolean)serDeParams.isEscaped(), (byte)serDeParams.getEscapeChar());
        LazyStruct struct = (LazyStruct)LazyFactory.createLazyObject((ObjectInspector)structOI);
        ByteArrayRef bytes = new ByteArrayRef();
        bytes.setData("row value1 value2".getBytes());
        struct.init(bytes, 0, bytes.getData().length);
        Mutation m = serializer.serialize((Object)struct, (ObjectInspector)structOI);
        recordWriter.write((Object)new Text(table), (Object)m);
        recordWriter.close(null);
        Iterator iter = conn.createScanner(table, new Authorizations()).iterator();
        Assert.assertTrue((String)"Iterator did not have an element as expected", (boolean)iter.hasNext());
        Map.Entry entry = (Map.Entry)iter.next();
        Key k = (Key)entry.getKey();
        Value v = (Value)entry.getValue();
        Assert.assertEquals((Object)"row", (Object)k.getRow().toString());
        Assert.assertEquals((Object)"cf", (Object)k.getColumnFamily().toString());
        Assert.assertEquals((Object)"cq1", (Object)k.getColumnQualifier().toString());
        Assert.assertEquals((Object)"", (Object)k.getColumnVisibility().toString());
        Assert.assertEquals((Object)"value1", (Object)new String(v.get()));
        Assert.assertTrue((String)"Iterator did not have an element as expected", (boolean)iter.hasNext());
        entry = (Map.Entry)iter.next();
        k = (Key)entry.getKey();
        v = (Value)entry.getValue();
        Assert.assertEquals((Object)"row", (Object)k.getRow().toString());
        Assert.assertEquals((Object)"cf", (Object)k.getColumnFamily().toString());
        Assert.assertEquals((Object)"cq2", (Object)k.getColumnQualifier().toString());
        Assert.assertEquals((Object)"", (Object)k.getColumnVisibility().toString());
        Assert.assertEquals((Object)"value2", (Object)new String(v.get()));
        Assert.assertFalse((String)"Iterator unexpectedly had more data", (boolean)iter.hasNext());
    }
}

