/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.encryptiontool;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hive.encryptiontool.EncryptionTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionCli {
    private static final Logger LOG = LoggerFactory.getLogger((String)EncryptionCli.class.getName());
    private static final HelpFormatter HELP_FORMATTER = new HelpFormatter();
    private static final String TOOL_NAME = "encryptconf";
    private static final Options CMD_LINE_OPTIONS = new Options();
    private static final String HELP = "help";
    private static final String KEY_STORE_NAME = "keystorename";
    private static final String KEY_STORE_PATH = "keyStorePath";
    private static final String PROPERTY = "property";
    private static final String ALIAS_EXISTS = "aliasExists";
    private static final String OVERWRITE = "overwrite";
    private static final String EMPTY_STRING = "";
    @VisibleForTesting
    private static final String IN_TEST_MODE = "inTestMode";

    private EncryptionCli() {
    }

    private static void printHelp() {
        HELP_FORMATTER.printHelp(TOOL_NAME, CMD_LINE_OPTIONS);
    }

    public static void main(String[] args) {
        GnuParser cmdParser = new GnuParser();
        CommandLine line = null;
        try {
            line = cmdParser.parse(CMD_LINE_OPTIONS, args);
        }
        catch (ParseException e) {
            EncryptionCli.printHelp();
            throw new IllegalArgumentException("encryptconf: Parsing failed.  Reason: " + e.getLocalizedMessage());
        }
        if (line == null) {
            throw new IllegalArgumentException("encryptconf: parsing failed.  Reason: unknown");
        }
        if (line.hasOption(HELP) || EncryptionCli.hasEmptyOptionsOnly(line)) {
            EncryptionCli.printHelp();
        } else if (EncryptionCli.isValidKeyStoreConfiguration(line)) {
            String[] hiveVars = line.getOptionValues(PROPERTY);
            if (hiveVars.length != 2) {
                EncryptionCli.printHelp();
                throw new IllegalArgumentException("encryptconf: property takes in 2 required arguments separated by = ;was passed " + hiveVars.length + " arguments");
            }
            String propertyName = hiveVars[0];
            String propertyValue = hiveVars[1];
            String pathToKeyStore = line.getOptionValue(KEY_STORE_PATH);
            try {
                LOG.info("Creating keystore... ");
                boolean isLocalFs = EncryptionCli.isTestMode(line);
                if (line.hasOption(OVERWRITE)) {
                    EncryptionTool.deleteIfExists(propertyName, pathToKeyStore, isLocalFs);
                }
                EncryptionTool.encryptPassword(propertyName, propertyValue, pathToKeyStore, isLocalFs);
            }
            catch (IOException e) {
                EncryptionCli.printHelp();
                throw new IllegalArgumentException("encryptconf: Error while creating credential keystore. Reason: " + e.getLocalizedMessage());
            }
            LOG.info("KeyStore successfully created");
        } else if (EncryptionCli.isAliasExist(line)) {
            String pathToKeyStore = line.getOptionValue(KEY_STORE_PATH);
            String alias = line.getOptionValue(ALIAS_EXISTS);
            try {
                EncryptionCli.printBool(EncryptionTool.aliasExists(alias, pathToKeyStore, EncryptionCli.isTestMode(line)));
            }
            catch (IOException e) {
                EncryptionCli.printHelp();
                throw new IllegalArgumentException(String.format("%s: Error while checking alias for existence. Reason: %s", TOOL_NAME, e.getLocalizedMessage()));
            }
        }
        if (EncryptionCli.noActionArgument(line)) {
            throw new IllegalArgumentException(String.format("%s: Invalid arguments. No %s or %s argument.", TOOL_NAME, PROPERTY, ALIAS_EXISTS));
        }
        if (EncryptionCli.noKeyStoreArgument(line)) {
            throw new IllegalArgumentException("encryptconf: Invalid arguments. No -keyStorePath argument.");
        }
    }

    private static boolean hasEmptyOptionsOnly(CommandLine line) {
        Option[] options;
        for (Option option : options = line.getOptions()) {
            if (option.getValue().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidKeyStoreConfiguration(CommandLine line) {
        return line.hasOption(KEY_STORE_PATH) && line.hasOption(PROPERTY);
    }

    private static boolean isAliasExist(CommandLine line) {
        return line.hasOption(KEY_STORE_PATH) && line.hasOption(ALIAS_EXISTS);
    }

    private static boolean noActionArgument(CommandLine line) {
        return line.hasOption(KEY_STORE_PATH) && !line.hasOption(PROPERTY) && !line.hasOption(ALIAS_EXISTS);
    }

    private static boolean noKeyStoreArgument(CommandLine line) {
        return !line.hasOption(KEY_STORE_PATH) && line.hasOption(PROPERTY);
    }

    private static boolean isTestMode(CommandLine line) {
        return line.hasOption(IN_TEST_MODE);
    }

    private static void printBool(boolean value) {
        System.out.print(Boolean.toString(value));
    }

    static {
        LOG.info("Initializing HiveEncryptTool");
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Print help information");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)HELP));
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Used for testing only");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)IN_TEST_MODE));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)KEY_STORE_NAME);
        OptionBuilder.withDescription((String)"Create KeyStore to store properties from *.xml using valid path in MapRFS");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)KEY_STORE_PATH));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"alias name");
        OptionBuilder.withDescription((String)"Check for alias existence using valid path in MapRFS");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)ALIAS_EXISTS));
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.withDescription((String)"Key, value of property that should be written to keystore");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)PROPERTY));
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Overwrites property if it exists");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)OVERWRITE));
    }
}

