/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.conftool;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import org.apache.hive.conftool.HiveHaException;

public final class ConfCommonUtilities {
    private ConfCommonUtilities() {
    }

    public static boolean exists(String path) {
        if (path != null && !path.isEmpty()) {
            return new File(path).exists();
        }
        return false;
    }

    public static void replaceLine(String path, String prefix, String target) {
        try (BufferedReader file = new BufferedReader(new FileReader(path));
             FileOutputStream fileOut = new FileOutputStream(path);){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = file.readLine()) != null) {
                if (line.startsWith(prefix)) {
                    line = target;
                }
                sb.append(line);
                sb.append('\n');
            }
            fileOut.write(sb.toString().getBytes());
        }
        catch (Exception e) {
            throw new HiveHaException(String.format("Error reading file %s", path));
        }
    }

    public static void changeGroup(String file, GroupPrincipal group) throws IOException {
        if (ConfCommonUtilities.exists(file)) {
            Files.getFileAttributeView(Path.of(file, new String[0]), PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS).setGroup(group);
        }
    }

    public static GroupPrincipal findGroupByName(String groupName) throws IOException {
        UserPrincipalLookupService lookupService = FileSystems.getDefault().getUserPrincipalLookupService();
        return lookupService.lookupPrincipalByGroupName(groupName);
    }

    public static void changeOwner(String file, UserPrincipal user) throws IOException {
        if (ConfCommonUtilities.exists(file)) {
            Files.setOwner(Path.of(file, new String[0]), user);
        }
    }

    public static UserPrincipal findUserByName(String userName) throws IOException {
        UserPrincipalLookupService lookupService = FileSystems.getDefault().getUserPrincipalLookupService();
        return lookupService.lookupPrincipalByName(userName);
    }

    public static GroupPrincipal readGroup(String file) throws IOException {
        if (ConfCommonUtilities.exists(file)) {
            return Files.readAttributes(Path.of(file, new String[0]), PosixFileAttributes.class, LinkOption.NOFOLLOW_LINKS).group();
        }
        return null;
    }

    public static String normalize(String input) {
        if (input != null) {
            return input.replace("\n", "");
        }
        return "";
    }
}

