/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.conftool;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.UserPrincipal;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.beeline.HiveSchemaTool;
import org.apache.hive.common.util.MapRSecurityUtil;
import org.apache.hive.conftool.AuthMethod;
import org.apache.hive.conftool.ConfCommonUtilities;
import org.apache.hive.conftool.ConfTool;
import org.apache.hive.conftool.ConfToolParseUtil;
import org.apache.hive.conftool.HiveHaException;
import org.apache.hive.conftool.HiveHomeException;
import org.apache.hive.conftool.PropertyProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class ConfCli {
    private static final Logger LOG = LoggerFactory.getLogger((String)ConfCli.class.getName());
    private static final String MAPR_HOME = MapRSecurityUtil.getMapRHome();
    private static final String MAPR_ROLES = ConfCli.findMapRRoles();
    private static final String HIVE_HOME = ConfCli.findHiveHome();
    private static final String HIVE_CONF = ConfCli.findHiveConf();
    private static final String HIVE_BIN = ConfCli.findHiveBin();

    private ConfCli() {
    }

    public static void main(String[] args) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        if (PropertyProcessor.requiresArgProcessing(args)) {
            PropertyProcessor.processArgs(args);
        } else {
            ConfCli.configureRegularXmlFiles();
        }
    }

    private static void configureRegularXmlFiles() throws ParserConfigurationException, IOException, SAXException, TransformerException {
        String pathToHiveSite = ConfCli.findHiveSite();
        String pathToWebHCatSite = ConfCli.findWebHCatSite();
        String headers = ConfCli.findHeaders();
        AuthMethod authMethod = AuthMethod.parse(MapRSecurityUtil.getAuthMethod());
        String adminUser = MapRSecurityUtil.findAdminUser();
        Document hiveSite = ConfToolParseUtil.readDocument(pathToHiveSite);
        Document webHCatSite = ConfToolParseUtil.readDocument(pathToWebHCatSite);
        ConfCli.saveAuthMethodFlag(authMethod);
        if (ConfCli.securityHasToBeConfigured()) {
            ConfCli.configureSecurity(hiveSite, webHCatSite, authMethod, headers, adminUser);
        }
        if (ConfCli.isHiveServer2HA()) {
            ConfCli.configureHiveServer2HA(hiveSite);
        }
        ConfCli.initDerbySchema(hiveSite);
        ConfCli.configureHiveServer2MetricAndReport(hiveSite);
        ConfCli.configureMetastoreMetricAndReport(hiveSite);
        ConfCli.configureReporterType(hiveSite);
        ConfToolParseUtil.saveToFile(hiveSite, pathToHiveSite);
        ConfToolParseUtil.saveToFile(webHCatSite, pathToWebHCatSite);
    }

    private static void configureReporterType(Document hiveSite) {
        if (ConfCli.isHiveNotConfiguredYet()) {
            LOG.info("Configuring report type");
            ConfTool.configureMetricsReporterType(hiveSite, true, "JSON_FILE,JMX");
        }
    }

    private static void configureMetastoreMetricAndReport(Document hiveSite) {
        if (ConfCli.isHiveNotConfiguredYet()) {
            LOG.info("Configuring Metastore metric and report location");
            ConfTool.configureMetastoreMetrics(hiveSite, true);
            ConfTool.configureHiveMetastoreMetricsFileLocation(hiveSite, true, "/tmp/hivemetastore_report.json");
        }
    }

    private static void configureHiveServer2MetricAndReport(Document hiveSite) {
        if (ConfCli.isHiveNotConfiguredYet()) {
            LOG.info("Configuring HiveServer2 metric and report location");
            ConfTool.configureHs2Metrics(hiveSite, true);
            ConfTool.configureHiveServer2MetricsFileLocation(hiveSite, true, "/tmp/hiveserver2_report.json");
        }
    }

    private static void configureHiveServer2HA(Document hiveSite) {
        int numHiveServer2 = ConfCli.findNumHiveServer2();
        String zookeeperQuorum = ConfCli.findZookeeperQuorum();
        LOG.info("Configuring HiveServer2 HA for zookeeper quorum {} and amount of HiveServers2 is {}", (Object)zookeeperQuorum, (Object)numHiveServer2);
        ConfTool.enableHs2Ha(hiveSite, zookeeperQuorum);
        ConfCli.setNumberOfHiveServer2inWardenFile(numHiveServer2);
    }

    private static void saveAuthMethodFlag(AuthMethod authMethod) throws FileNotFoundException {
        try (PrintWriter out = new PrintWriter(HIVE_CONF + File.separator + ".authMethod");){
            out.println(authMethod.value());
        }
    }

    private static void initDerbySchema(Document hiveSite) throws IOException {
        if (!ConfCli.isConnectionUrlConfigured(hiveSite) && ConfCli.isHiveNotConfiguredYet()) {
            LOG.info("Start processing derby DB schema");
            String derbyDefaultName = ConfCli.findDefaultDerbyName();
            if (ConfCommonUtilities.exists(derbyDefaultName)) {
                LOG.info("Deleting {}", (Object)derbyDefaultName);
                FileUtils.deleteDirectory((File)new File(derbyDefaultName));
            }
            String connectionUrl = String.format("jdbc:derby:;databaseName=%s/metastore_db;create=true", HIVE_BIN);
            ConfTool.setConnectionUrl(hiveSite, connectionUrl);
            ConfCli.setAdminGroupTo(HIVE_BIN);
            ConfCli.setAdminOwnerTo(HIVE_BIN);
            ConfCli.runDerbySchemaTool(connectionUrl);
            if (ConfCli.hasMetastore() && !ConfCli.isMetastoreUrisConfigured(hiveSite)) {
                ConfTool.initMetaStoreUri(hiveSite);
            }
        }
    }

    private static void runDerbySchemaTool(String connectionUrl) {
        LOG.info("Starting schema tool for derby DB");
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.submit(() -> {
            HiveConf hiveConf = new HiveConf(HiveSchemaTool.class);
            hiveConf.setVar(HiveConf.ConfVars.METASTORECONNECTURLKEY, connectionUrl);
            HiveSchemaTool.main((String[])new String[]{"-dbType", "derby", "-initSchema"}, (HiveConf)hiveConf, (String)HIVE_HOME);
        });
    }

    private static boolean isMetastoreUrisConfigured(Document hiveSite) {
        return ConfTool.propertyExists(hiveSite, "hive.metastore.uris");
    }

    private static boolean hasMetastore() {
        return ConfCommonUtilities.exists(MAPR_ROLES + File.separator + "hivemetastore");
    }

    private static void setAdminOwnerTo(String path) throws IOException {
        String adminUser = MapRSecurityUtil.findAdminUser();
        LOG.info("Setting owner {} for path {}", (Object)adminUser, (Object)path);
        UserPrincipal adminGroup = ConfCommonUtilities.findUserByName(adminUser);
        ConfCommonUtilities.changeOwner(path, adminGroup);
    }

    private static void setAdminGroupTo(String path) throws IOException {
        String adminUser = MapRSecurityUtil.findAdminUser();
        LOG.info("Setting group {} for path {}", (Object)adminUser, (Object)path);
        GroupPrincipal adminGroup = ConfCommonUtilities.findGroupByName(adminUser);
        ConfCommonUtilities.changeGroup(path, adminGroup);
    }

    private static boolean isConnectionUrlConfigured(Document hiveSite) {
        return ConfTool.propertyExists(hiveSite, "javax.jdo.option.ConnectionURL");
    }

    private static String findDefaultDerbyName() {
        return HIVE_BIN + File.separator + "metastore_db";
    }

    private static boolean securityHasToBeConfigured() throws IOException {
        return (ConfCli.isAuthMethodChanged() || ConfCli.isHiveNotConfiguredYet()) && !ConfCli.isCustomSecurity();
    }

    private static boolean isAuthMethodChanged() throws IOException {
        String authMethodPath = HIVE_CONF + File.separator + ".authMethod";
        String authMethodPathBackup = HIVE_CONF + File.separator + ".authMethod.backup";
        if (ConfCommonUtilities.exists(authMethodPath) && ConfCommonUtilities.exists(authMethodPathBackup)) {
            String currentAuthMethod;
            String authMethodBackup = Files.readString(Path.of(authMethodPathBackup, new String[0]));
            return !authMethodBackup.equals(currentAuthMethod = Files.readString(Path.of(authMethodPath, new String[0])));
        }
        LOG.warn("No HIVE_HOME/conf/.authMethod or HIVE_HOME/conf/.authMethod.backup files");
        return false;
    }

    private static boolean isHiveNotConfiguredYet() {
        return ConfCommonUtilities.exists(ConfCli.findHiveConf() + File.separator + ".not_configured_yet");
    }

    private static boolean isCustomSecurity() {
        return ConfCommonUtilities.exists(ConfCli.findHiveConf() + File.separator + ".customSecure");
    }

    private static String findHiveHome() {
        Object hiveHome = System.getenv("HIVE_HOME");
        if (hiveHome == null && (hiveHome = System.getProperty("hive.home.dir")) == null) {
            String hiveVersion = null;
            try {
                hiveVersion = Files.readString(Path.of(MAPR_HOME + File.separator + "hive" + File.separator + "hiveversion", new String[0]));
            }
            catch (IOException e) {
                throw new HiveHomeException("Can not find HIVE_HOME");
            }
            hiveHome = MAPR_HOME + File.separator + "hive" + File.separator + "hive-" + hiveVersion;
        }
        return ConfCommonUtilities.normalize((String)hiveHome);
    }

    private static boolean isHiveServer2HA() {
        return ConfCommonUtilities.exists(HIVE_CONF + File.separator + "enable_hs2_ha");
    }

    private static int findNumHiveServer2() {
        String path = HIVE_CONF + File.separator + "num_hs2";
        if (ConfCommonUtilities.exists(path)) {
            try {
                return Integer.parseInt(Files.readString(Path.of(path, new String[0])));
            }
            catch (IOException e) {
                throw new HiveHaException(String.format("Error reading %s", path));
            }
        }
        return 1;
    }

    private static String findZookeeperQuorum() {
        String path = HIVE_CONF + File.separator + "zk_hosts";
        if (ConfCommonUtilities.exists(path)) {
            try {
                return Files.readString(Path.of(path, new String[0]));
            }
            catch (IOException e) {
                throw new HiveHaException(String.format("Error reading %s", path));
            }
        }
        return "localhost";
    }

    private static void setNumberOfHiveServer2inWardenFile(int numHiveServer2) {
        String path = MAPR_HOME + File.separator + File.separator + "conf" + File.separator + "conf.d" + File.separator + "warden.hs2.conf";
        if (ConfCommonUtilities.exists(path)) {
            ConfCommonUtilities.replaceLine(path, "services=", String.format("services=hs2:%d:cldb", numHiveServer2));
        }
    }

    private static void configureSecurity(Document hiveSite, Document webHCatSite, AuthMethod authMethod, String headers, String adminUser) {
        LOG.info("Configuring security");
        ConfTool.setMetaStoreUseThriftSasl(hiveSite, authMethod);
        ConfTool.setEncryption(hiveSite, authMethod);
        ConfTool.setMetaStoreUgi(hiveSite, authMethod);
        ConfTool.setMetaStoreAuthManager(hiveSite, authMethod);
        ConfTool.setMetaStoreAuthPreEventListener(hiveSite, authMethod);
        ConfTool.setHs2WebUiPamSsl(hiveSite, authMethod);
        ConfTool.setHs2Ssl(hiveSite, authMethod);
        ConfTool.setWebUiHeaders(hiveSite, authMethod, headers);
        ConfTool.configureTokenAuth(hiveSite, authMethod);
        ConfTool.setAdminUser(hiveSite, adminUser, authMethod);
        ConfTool.setRestrictedList(hiveSite, authMethod);
        ConfTool.setFallbackAuthorizer(hiveSite, authMethod);
        ConfTool.setWebHCatSsl(webHCatSite, authMethod);
        ConfTool.setWebHCatHeaders(webHCatSite, authMethod, headers);
    }

    private static String findHiveConf() {
        return HIVE_HOME + File.separator + "conf";
    }

    private static String findHiveBin() {
        return HIVE_HOME + File.separator + "bin";
    }

    private static String findMapRRoles() {
        return MAPR_HOME + File.separator + "roles";
    }

    private static String findHiveSite() {
        return HIVE_CONF + File.separator + "hive-site.xml";
    }

    private static String findWebHCatSite() {
        return HIVE_HOME + File.separator + "hcatalog" + File.separator + "etc" + File.separator + "webhcat" + File.separator + "webhcat-site.xml";
    }

    private static String findHeaders() {
        return HIVE_CONF + File.separator + "headers.xml";
    }
}

