/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.conftool;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.FipsUtil;
import org.apache.hive.conftool.AuthMethod;
import org.apache.hive.conftool.ConfToolUtil;
import org.apache.hive.scram.ScramUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class ConfTool {
    private static final Logger LOG = LoggerFactory.getLogger((String)ConfTool.class.getName());
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String PROPERTY = "property";
    private static final String CONFIGURATION = "configuration";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String AUTH_CONF = "auth-conf";
    private static final String THRIFT_LOCAL_HOST = "thrift://localhost:9083";
    private static final String METASTORE_SECURE_AUTH_MANAGER = "org.apache.hadoop.hive.ql.security.authorization.StorageBasedAuthorizationProvider";
    private static final HiveConf.ConfVars[] IMMUTABLE_OPTIONS = new HiveConf.ConfVars[]{HiveConf.ConfVars.PREEXECHOOKS, HiveConf.ConfVars.POSTEXECHOOKS, HiveConf.ConfVars.ONFAILUREHOOKS, HiveConf.ConfVars.QUERYREDACTORHOOKS, HiveConf.ConfVars.SEMANTIC_ANALYZER_HOOK, HiveConf.ConfVars.HIVE_QUERY_LIFETIME_HOOKS, HiveConf.ConfVars.HIVE_DRIVER_RUN_HOOKS, HiveConf.ConfVars.HIVE_SERVER2_SESSION_HOOK};
    private static final String OPTIONS_AS_LIST = ConfTool.getDefaultList() + "," + ConfTool.buildMapRList(IMMUTABLE_OPTIONS);
    private static final String FALLBACK_HIVE_AUTHORIZER_FACTORY = "org.apache.hadoop.hive.ql.security.authorization.plugin.fallback.FallbackHiveAuthorizerFactory";
    private static final String METASTORE_AUTH_PRE_EVENT_LISTENER = "org.apache.hadoop.hive.ql.security.authorization.AuthorizationPreEventListener";
    private static final String EMPTY = "";

    private ConfTool() {
    }

    static void setMetaStoreUseThriftSasl(Document doc, AuthMethod authMethod) {
        switch (authMethod) {
            case CUSTOM: {
                return;
            }
            case MAPRSASL: 
            case KERBEROS: {
                LOG.info(String.format("Configuring Hive for %s", new Object[]{authMethod}));
                ConfTool.set(doc, HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL, TRUE);
                break;
            }
            case NONE: {
                LOG.info("Configuring Hive for no security");
                ConfTool.set(doc, HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL, FALSE);
                break;
            }
            default: {
                return;
            }
        }
    }

    static void setMetaStoreUseThriftSasl(String pathToHiveSite, AuthMethod authMethod) throws TransformerException, IOException, SAXException, ParserConfigurationException {
        Document doc = ConfTool.readDocument(pathToHiveSite);
        LOG.info("Reading hive-site.xml from path : {}", (Object)pathToHiveSite);
        ConfTool.setMetaStoreUseThriftSasl(doc, authMethod);
        ConfTool.saveToFile(doc, pathToHiveSite);
    }

    static void setMetaStoreUgi(Document doc, AuthMethod authMethod) {
        switch (authMethod) {
            case CUSTOM: {
                return;
            }
            case MAPRSASL: 
            case KERBEROS: {
                LOG.info("Configuring metastore not to use UGI");
                ConfTool.set(doc, HiveConf.ConfVars.METASTORE_EXECUTE_SET_UGI, FALSE);
                break;
            }
            case NONE: {
                LOG.info("Configuring metastore to use UGI. Default is true, so removing property from hive-site.xml to enable it");
                ConfTool.remove(doc, HiveConf.ConfVars.METASTORE_EXECUTE_SET_UGI);
                break;
            }
            default: {
                return;
            }
        }
    }

    static void setMetaStoreUgi(String pathToHiveSite, AuthMethod authMethod) throws TransformerException, IOException, SAXException, ParserConfigurationException {
        Document doc = ConfTool.readDocument(pathToHiveSite);
        ConfTool.setMetaStoreUgi(doc, authMethod);
        ConfTool.saveToFile(doc, pathToHiveSite);
    }

    static void setMetaStoreAuthManager(Document doc, AuthMethod authMethod) {
        switch (authMethod) {
            case CUSTOM: {
                return;
            }
            case MAPRSASL: 
            case KERBEROS: {
                LOG.info("Configuring metastore authorization manager to StorageBasedAuthorizationProvider");
                ConfTool.set(doc, HiveConf.ConfVars.HIVE_METASTORE_AUTHORIZATION_MANAGER, METASTORE_SECURE_AUTH_MANAGER);
                break;
            }
            case NONE: {
                LOG.info("Configuring metastore authorization manager to default. Removing property from hive-site.xml");
                ConfTool.remove(doc, HiveConf.ConfVars.HIVE_METASTORE_AUTHORIZATION_MANAGER);
                break;
            }
            default: {
                return;
            }
        }
    }

    static void setMetaStoreAuthManager(String pathToHiveSite, AuthMethod authMethod) throws TransformerException, IOException, SAXException, ParserConfigurationException {
        Document doc = ConfTool.readDocument(pathToHiveSite);
        LOG.info("Reading hive-site.xml from path : {}", (Object)pathToHiveSite);
        ConfTool.setMetaStoreAuthManager(doc, authMethod);
        ConfTool.saveToFile(doc, pathToHiveSite);
    }

    static void setHs2WebUiPamSsl(Document doc, AuthMethod authMethod) {
        switch (authMethod) {
            case CUSTOM: {
                return;
            }
            case MAPRSASL: 
            case KERBEROS: {
                LOG.info("Configuring Hive for HiveServer2 web UI PAM authentication and SSL encryption");
                ConfTool.set(doc, HiveConf.ConfVars.HIVE_SERVER2_WEBUI_USE_PAM, TRUE);
                ConfTool.set(doc, HiveConf.ConfVars.HIVE_SERVER2_WEBUI_USE_SSL, TRUE);
                break;
            }
            case NONE: {
                LOG.info("Disabling PAM authentication and SSL encryption for HiveServer2 web UI");
                ConfTool.remove(doc, HiveConf.ConfVars.HIVE_SERVER2_WEBUI_USE_PAM);
                ConfTool.remove(doc, HiveConf.ConfVars.HIVE_SERVER2_WEBUI_USE_SSL);
                ConfTool.remove(doc, HiveConf.ConfVars.HIVE_SERVER2_WEBUI_SSL_KEYSTORE_PATH);
                break;
            }
            default: {
                return;
            }
        }
    }

    static void setHs2WebUiPamSsl(String pathToHiveSite, AuthMethod authMethod) throws TransformerException, IOException, SAXException, ParserConfigurationException {
        Document doc = ConfTool.readDocument(pathToHiveSite);
        LOG.info("Reading hive-site.xml from path : {}", (Object)pathToHiveSite);
        ConfTool.setHs2WebUiPamSsl(doc, authMethod);
        ConfTool.saveToFile(doc, pathToHiveSite);
    }

    static void setWebHCatSsl(Document doc, AuthMethod authMethod) {
        switch (authMethod) {
            case CUSTOM: {
                return;
            }
            case MAPRSASL: 
            case KERBEROS: {
                LOG.info("Configuring webHCat for SSL encryption");
                ConfTool.set(doc, "templeton.use.ssl", TRUE);
                break;
            }
            case NONE: {
                LOG.info("Removing SSL encryption for webHCat");
                ConfTool.remove(doc, "templeton.use.ssl");
                break;
            }
            default: {
                return;
            }
        }
    }

    static void setWebHCatSsl(String pathToWebHCatSite, AuthMethod authMethod) throws TransformerException, IOException, SAXException, ParserConfigurationException {
        Document doc = ConfTool.readDocument(pathToWebHCatSite);
        LOG.info("Reading webhcat-site.xml from path : {}", (Object)pathToWebHCatSite);
        switch (authMethod) {
            case CUSTOM: {
                return;
            }
            case MAPRSASL: 
            case KERBEROS: {
                LOG.info("Configuring webHCat for SSL encryption");
                ConfTool.set(doc, "templeton.use.ssl", TRUE);
                break;
            }
            case NONE: {
                LOG.info("Removing SSL encryption for webHCat");
                ConfTool.remove(doc, "templeton.use.ssl");
                break;
            }
            default: {
                return;
            }
        }
        ConfTool.saveToFile(doc, pathToWebHCatSite);
    }

    static void setWebHCatHeaders(String pathToWebHCatSite, AuthMethod authMethod, String headers) throws TransformerException, IOException, SAXException, ParserConfigurationException {
        Document doc = ConfTool.readDocument(pathToWebHCatSite);
        LOG.info("Reading webhcat-site.xml from path : {}", (Object)pathToWebHCatSite);
        ConfTool.setWebHCatHeaders(doc, authMethod, headers);
        ConfTool.saveToFile(doc, pathToWebHCatSite);
    }

    static void setWebHCatHeaders(Document doc, AuthMethod authMethod, String headers) {
        switch (authMethod) {
            case CUSTOM: {
                return;
            }
            case MAPRSASL: 
            case KERBEROS: {
                LOG.info("Configuring webHCat security headers");
                ConfTool.set(doc, "templeton.jetty.response.headers.file", headers);
                break;
            }
            case NONE: {
                LOG.info("Removing webHCat security headers");
                ConfTool.remove(doc, "templeton.jetty.response.headers.file");
                break;
            }
            default: {
                return;
            }
        }
    }

    static void setHs2Ssl(Document doc, AuthMethod authMethod) {
        switch (authMethod) {
            case CUSTOM: {
                return;
            }
            case MAPRSASL: 
            case KERBEROS: {
                LOG.info("Configuring HS2 for  SSL encryption");
                ConfTool.set(doc, HiveConf.ConfVars.HIVE_SERVER2_USE_SSL, TRUE);
                break;
            }
            case NONE: {
                ConfTool.remove(doc, HiveConf.ConfVars.HIVE_SERVER2_USE_SSL);
                break;
            }
            default: {
                return;
            }
        }
    }

    static void setWebUiHeaders(String pathToHiveSite, AuthMethod authMethod, String headers) throws TransformerException, IOException, SAXException, ParserConfigurationException {
        Document doc = ConfTool.readDocument(pathToHiveSite);
        LOG.info("Reading hive-site.xml from path : {}", (Object)pathToHiveSite);
        ConfTool.setWebUiHeaders(doc, authMethod, headers);
        ConfTool.saveToFile(doc, pathToHiveSite);
    }

    static void setWebUiHeaders(Document doc, AuthMethod authMethod, String headers) {
        switch (authMethod) {
            case CUSTOM: {
                return;
            }
            case MAPRSASL: 
            case KERBEROS: {
                LOG.info("Configuring HS2 Web UI security headers");
                ConfTool.set(doc, HiveConf.ConfVars.HIVE_SERVER2_WEBUI_JETTY_RESPONSE_HEADERS_FILE, headers);
                break;
            }
            case NONE: {
                LOG.info("Removing HS2 Web UI security headers");
                ConfTool.remove(doc, HiveConf.ConfVars.HIVE_SERVER2_WEBUI_JETTY_RESPONSE_HEADERS_FILE);
                break;
            }
            default: {
                return;
            }
        }
    }

    static void setHMetaSsl(Document doc, AuthMethod authMethod) {
        switch (authMethod) {
            case CUSTOM: {
                return;
            }
            case MAPRSASL: 
            case KERBEROS: {
                LOG.info("Configuring Hive Metastore for  SSL encryption");
                ConfTool.set(doc, HiveConf.ConfVars.HIVE_METASTORE_USE_SSL, TRUE);
                break;
            }
            case NONE: {
                ConfTool.remove(doc, HiveConf.ConfVars.HIVE_METASTORE_USE_SSL);
                break;
            }
            default: {
                return;
            }
        }
    }

    static void setHs2Ssl(String pathToHiveSite, AuthMethod authMethod) throws TransformerException, IOException, SAXException, ParserConfigurationException {
        Document doc = ConfTool.readDocument(pathToHiveSite);
        ConfTool.setHs2Ssl(doc, authMethod);
        ConfTool.saveToFile(doc, pathToHiveSite);
    }

    static void setHMetaSsl(String pathToHiveSite, AuthMethod authMethod) throws TransformerException, IOException, SAXException, ParserConfigurationException {
        Document doc = ConfTool.readDocument(pathToHiveSite);
        ConfTool.setHMetaSsl(doc, authMethod);
        ConfTool.saveToFile(doc, pathToHiveSite);
    }

    static void setAdminUser(String pathToHiveSite, String adminUser, AuthMethod authMethod) throws SAXException, TransformerException, ParserConfigurationException, IOException {
        Document doc = ConfTool.readDocument(pathToHiveSite);
        ConfTool.setAdminUser(doc, adminUser, authMethod);
        ConfTool.saveToFile(doc, pathToHiveSite);
    }

    static void setAdminUser(Document doc, String adminUser, AuthMethod authMethod) {
        switch (authMethod) {
            case CUSTOM: {
                return;
            }
            case MAPRSASL: 
            case KERBEROS: {
                ConfTool.appendProperty(doc, HiveConf.ConfVars.USERS_IN_ADMIN_ROLE.varname, adminUser);
                break;
            }
            case NONE: {
                ConfTool.delProperty(doc, HiveConf.ConfVars.USERS_IN_ADMIN_ROLE.varname);
            }
        }
    }

    static void setEncryption(Document doc, AuthMethod authMethod) {
        switch (authMethod) {
            case CUSTOM: {
                return;
            }
            case MAPRSASL: 
            case KERBEROS: {
                LOG.info("Configuring auth-conf by default");
                ConfTool.set(doc, HiveConf.ConfVars.HIVE_SERVER2_THRIFT_SASL_QOP, AUTH_CONF);
                break;
            }
            case NONE: {
                LOG.info("Removing auth-conf");
                ConfTool.remove(doc, HiveConf.ConfVars.HIVE_SERVER2_THRIFT_SASL_QOP);
                break;
            }
            default: {
                return;
            }
        }
    }

    static void setEncryption(String pathToHiveSite, AuthMethod authMethod) throws TransformerException, IOException, SAXException, ParserConfigurationException {
        Document doc = ConfTool.readDocument(pathToHiveSite);
        LOG.info("Reading hive-site.xml from path : {}", (Object)pathToHiveSite);
        ConfTool.setEncryption(doc, authMethod);
        ConfTool.saveToFile(doc, pathToHiveSite);
    }

    static void setMetaStoreAuthPreEventListener(String pathToHiveSite, AuthMethod authMethod) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        Document doc = ConfTool.readDocument(pathToHiveSite);
        LOG.info("Reading hive-site.xml from path : {}", (Object)pathToHiveSite);
        ConfTool.setMetaStoreAuthPreEventListener(doc, authMethod);
        ConfTool.saveToFile(doc, pathToHiveSite);
    }

    static void setMetaStoreAuthPreEventListener(Document doc, AuthMethod authMethod) {
        switch (authMethod) {
            case CUSTOM: {
                return;
            }
            case MAPRSASL: 
            case KERBEROS: {
                ConfTool.set(doc, HiveConf.ConfVars.METASTORE_PRE_EVENT_LISTENERS, METASTORE_AUTH_PRE_EVENT_LISTENER);
                break;
            }
            case NONE: {
                ConfTool.remove(doc, HiveConf.ConfVars.METASTORE_PRE_EVENT_LISTENERS);
                break;
            }
            default: {
                return;
            }
        }
    }

    static void setFallbackAuthorizer(String pathToHiveSite, AuthMethod authMethod) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        Document doc = ConfTool.readDocument(pathToHiveSite);
        LOG.info("Reading hive-site.xml from path : {}", (Object)pathToHiveSite);
        ConfTool.setFallbackAuthorizer(doc, authMethod);
        ConfTool.saveToFile(doc, pathToHiveSite);
    }

    static void setFallbackAuthorizer(Document doc, AuthMethod authMethod) throws TransformerException {
        switch (authMethod) {
            case CUSTOM: {
                return;
            }
            case MAPRSASL: 
            case KERBEROS: {
                ConfTool.set(doc, HiveConf.ConfVars.HIVE_AUTHORIZATION_ENABLED, TRUE);
                ConfTool.set(doc, HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, FALLBACK_HIVE_AUTHORIZER_FACTORY);
                break;
            }
            case NONE: {
                ConfTool.remove(doc, HiveConf.ConfVars.HIVE_AUTHORIZATION_ENABLED);
                ConfTool.remove(doc, HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER);
                break;
            }
            default: {
                return;
            }
        }
    }

    static void enableHs2Ha(Document doc, String zookeeperQuorum) {
        LOG.info("Enabling Zookeeper HA");
        ConfTool.set(doc, HiveConf.ConfVars.HIVE_SERVER2_SUPPORT_DYNAMIC_SERVICE_DISCOVERY, TRUE);
        ConfTool.set(doc, HiveConf.ConfVars.HIVE_ZOOKEEPER_QUORUM, zookeeperQuorum);
    }

    static void enableHs2Ha(String pathToHiveSite, String zookeeperQuorum) throws ParserConfigurationException, IOException, SAXException, TransformerException {
        Document doc = ConfTool.readDocument(pathToHiveSite);
        LOG.info("Reading hive-site.xml from path : {}", (Object)pathToHiveSite);
        ConfTool.enableHs2Ha(doc, zookeeperQuorum);
        ConfTool.saveToFile(doc, pathToHiveSite);
    }

    static boolean exists(String pathToHiveSite, String property) throws IOException, SAXException, ParserConfigurationException {
        Document doc = ConfTool.readDocument(pathToHiveSite);
        return ConfTool.propertyExists(doc, property);
    }

    public static Map<String, String> readAllProperties(String pathToHiveSite) throws IOException, SAXException, ParserConfigurationException {
        Document doc = ConfTool.readDocument(pathToHiveSite);
        return ConfTool.readAllProperties(doc);
    }

    static void delProperty(String pathToHiveSite, String property) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        Document doc = ConfTool.readDocument(pathToHiveSite);
        LOG.info("Reading xml from path : {}", (Object)pathToHiveSite);
        LOG.info("Removing {} property from {}", (Object)property, (Object)pathToHiveSite);
        ConfTool.delProperty(doc, property);
        ConfTool.saveToFile(doc, pathToHiveSite);
    }

    static void delProperty(Document doc, String property) {
        ConfTool.remove(doc, property);
    }

    static void setRestrictedList(String pathToHiveSite, AuthMethod authMethod) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        Document doc = ConfTool.readDocument(pathToHiveSite);
        LOG.info("Reading hive-site.xml from path : {}", (Object)pathToHiveSite);
        ConfTool.setRestrictedList(doc, authMethod);
        ConfTool.saveToFile(doc, pathToHiveSite);
    }

    static void setRestrictedList(Document doc, AuthMethod authMethod) {
        switch (authMethod) {
            case CUSTOM: {
                return;
            }
            case MAPRSASL: 
            case KERBEROS: {
                LOG.info("Enabling additional options for restricted list : {}", (Object)OPTIONS_AS_LIST);
                ConfTool.set(doc, HiveConf.ConfVars.HIVE_CONF_RESTRICTED_LIST, OPTIONS_AS_LIST);
                break;
            }
            case NONE: {
                LOG.info("Disabling additional options for restricted list");
                ConfTool.remove(doc, HiveConf.ConfVars.HIVE_CONF_RESTRICTED_LIST);
                break;
            }
        }
    }

    static void configureHs2Metrics(String pathToHiveSite, boolean isMetricsEnabled) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        Document doc = ConfTool.readDocument(pathToHiveSite);
        LOG.info("Reading hive-site.xml from path : {}", (Object)pathToHiveSite);
        ConfTool.configureHs2Metrics(doc, isMetricsEnabled);
        ConfTool.saveToFile(doc, pathToHiveSite);
    }

    static void configureHs2Metrics(Document doc, boolean isMetricsEnabled) {
        if (isMetricsEnabled) {
            LOG.info("Enabling metrics for HiveServer2");
            ConfTool.set(doc, HiveConf.ConfVars.HIVE_SERVER2_METRICS_ENABLED, TRUE);
        } else {
            LOG.info("Disabling metrics for HiveServer2");
            ConfTool.set(doc, HiveConf.ConfVars.HIVE_SERVER2_METRICS_ENABLED, FALSE);
        }
    }

    static void configureMetricsReporterType(String pathToHiveSite, boolean isReporterEnabled, String reporterType) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        Document doc = ConfTool.readDocument(pathToHiveSite);
        LOG.info("Reading hive-site.xml from path : {}", (Object)pathToHiveSite);
        ConfTool.configureMetricsReporterType(doc, isReporterEnabled, reporterType);
        ConfTool.saveToFile(doc, pathToHiveSite);
    }

    static void configureMetricsReporterType(Document doc, boolean isReporterEnabled, String reporterType) {
        if (isReporterEnabled) {
            LOG.info("Configuring metrics reporter : {}", (Object)reporterType);
            ConfTool.set(doc, HiveConf.ConfVars.HIVE_METRICS_REPORTER, reporterType);
        } else {
            LOG.info("Removing metrics reporter");
            ConfTool.remove(doc, HiveConf.ConfVars.HIVE_METRICS_REPORTER);
        }
    }

    static void configureHiveServer2MetricsFileLocation(String pathToHiveSite, boolean isReporterEnabled, String fileLocation) throws SAXException, TransformerException, ParserConfigurationException, IOException {
        ConfTool.configureMetricsFileLocation(pathToHiveSite, isReporterEnabled, HiveConf.ConfVars.HIVE_SERVER2_METRICS_JSON_FILE_LOCATION, fileLocation);
    }

    static void configureHiveMetastoreMetricsFileLocation(String pathToHiveSite, boolean isReporterEnabled, String fileLocation) throws SAXException, TransformerException, ParserConfigurationException, IOException {
        ConfTool.configureMetricsFileLocation(pathToHiveSite, isReporterEnabled, HiveConf.ConfVars.HIVE_METASTORE_METRICS_JSON_FILE_LOCATION, fileLocation);
    }

    static void configureMetricsFileLocation(String pathToHiveSite, boolean isReporterEnabled, HiveConf.ConfVars servicePropertyName, String fileLocation) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        Document doc = ConfTool.readDocument(pathToHiveSite);
        LOG.info("Reading hive-site.xml from path : {}", (Object)pathToHiveSite);
        ConfTool.configureMetricsFileLocation(doc, isReporterEnabled, servicePropertyName, fileLocation);
        ConfTool.saveToFile(doc, pathToHiveSite);
    }

    static void configureMetricsFileLocation(Document doc, boolean isReporterEnabled, HiveConf.ConfVars servicePropertyName, String fileLocation) {
        if (isReporterEnabled) {
            LOG.info("Configuring metrics file location : {}", (Object)fileLocation);
            ConfTool.set(doc, servicePropertyName, fileLocation);
        } else {
            LOG.info("Removing metrics file location");
            ConfTool.remove(doc, servicePropertyName);
        }
    }

    static void configureMetastoreMetrics(String pathToHiveSite, boolean isMetricsEnabled) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        Document doc = ConfTool.readDocument(pathToHiveSite);
        LOG.info("Reading hive-site.xml from path : {}", (Object)pathToHiveSite);
        ConfTool.configureMetastoreMetrics(doc, isMetricsEnabled);
        ConfTool.saveToFile(doc, pathToHiveSite);
    }

    static void configureMetastoreMetrics(Document doc, boolean isMetricsEnabled) {
        if (isMetricsEnabled) {
            LOG.info("Enabling metrics for Metastore");
            ConfTool.set(doc, HiveConf.ConfVars.METASTORE_METRICS, TRUE);
        } else {
            LOG.info("Disabling metrics for Metastore");
            ConfTool.set(doc, HiveConf.ConfVars.METASTORE_METRICS, FALSE);
        }
    }

    static void addProperty(Document doc, String property, String value) {
        if (ConfTool.propertyExists(doc, property)) {
            ConfTool.setPropertyInternal(doc, property, value);
        } else {
            ConfTool.addPropertyInternal(doc, property, value);
        }
    }

    static void addProperty(String pathToHiveSite, String property, String value) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        Document doc = ConfTool.readDocument(pathToHiveSite);
        ConfTool.addProperty(doc, property, value);
        ConfTool.saveToFile(doc, pathToHiveSite);
    }

    static void appendProperty(String pathToHiveSite, String property, String value) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        Document doc = ConfTool.readDocument(pathToHiveSite);
        ConfTool.appendProperty(doc, property, value);
        ConfTool.saveToFile(doc, pathToHiveSite);
    }

    static String getProperty(String pathToHiveSite, String property) throws IOException, SAXException, ParserConfigurationException {
        Document doc = ConfTool.readDocument(pathToHiveSite);
        return ConfTool.getProperty(doc, property);
    }

    static void initMetaStoreUri(String pathToHiveSite) throws ParserConfigurationException, IOException, SAXException, TransformerException {
        Document doc = ConfTool.readDocument(pathToHiveSite);
        LOG.info("Reading hive-site.xml from path : {}", (Object)pathToHiveSite);
        ConfTool.set(doc, HiveConf.ConfVars.METASTOREURIS, THRIFT_LOCAL_HOST);
        ConfTool.saveToFile(doc, pathToHiveSite);
    }

    static void setConnectionUrl(Document doc, String connectionUrl) {
        LOG.info("Configuring connection URL : {}");
        ConfTool.set(doc, HiveConf.ConfVars.METASTORECONNECTURLKEY, connectionUrl);
    }

    static void setConnectionUrl(String pathToHiveSite, String connectionUrl) throws ParserConfigurationException, IOException, SAXException, TransformerException {
        Document doc = ConfTool.readDocument(pathToHiveSite);
        LOG.info("Reading hive-site.xml from path : {}", (Object)pathToHiveSite);
        ConfTool.setConnectionUrl(doc, connectionUrl);
        ConfTool.saveToFile(doc, pathToHiveSite);
    }

    static void configureTokenAuth(String pathToHiveSite, AuthMethod authMethod) throws ParserConfigurationException, IOException, SAXException, TransformerException {
        Document doc = ConfTool.readDocument(pathToHiveSite);
        switch (authMethod) {
            case CUSTOM: {
                return;
            }
            case MAPRSASL: 
            case KERBEROS: {
                if (FipsUtil.isFips() || ScramUtil.isHadoopConfiguredForScram()) {
                    ConfTool.set(doc, HiveConf.ConfVars.HIVE_DELEGATION_TOKEN_AUTHENTICATION, "SCRAM");
                    LOG.info("Configured delegation token authentication as SCRAM");
                    break;
                }
                ConfTool.set(doc, HiveConf.ConfVars.HIVE_DELEGATION_TOKEN_AUTHENTICATION, "DIGEST");
                LOG.info("Configured delegation token authentication as DIGEST");
                break;
            }
            case NONE: {
                ConfTool.remove(doc, HiveConf.ConfVars.HIVE_DELEGATION_TOKEN_AUTHENTICATION);
                LOG.info("Removed delegation token authentication");
            }
        }
        ConfTool.saveToFile(doc, pathToHiveSite);
    }

    private static Document readDocument(String pathToHiveSite) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        return docBuilder.parse(pathToHiveSite);
    }

    @VisibleForTesting
    static void appendProperty(Document doc, String property, String value) {
        if (ConfTool.propertyExists(doc, property)) {
            LOG.info("Property {} exists in xml file. Append value: {}", (Object)property, (Object)value);
            String oldPropertyValue = ConfTool.getProperty(doc, property);
            if (!new HashSet<String>(Arrays.asList(oldPropertyValue.split(","))).contains(value)) {
                if (!oldPropertyValue.isEmpty()) {
                    value = Joiner.on((String)",").join((Object)oldPropertyValue, (Object)value, new Object[0]);
                }
                ConfTool.setPropertyInternal(doc, property, value);
            }
        } else {
            LOG.info("Property {} does not exist in xml file", (Object)property);
            ConfTool.addPropertyInternal(doc, property, value);
        }
    }

    private static void set(Document doc, String property, String value) {
        if (ConfTool.propertyExists(doc, property)) {
            LOG.info("Property {} exists in xml file", (Object)property);
            ConfTool.setPropertyInternal(doc, property, value);
        } else {
            LOG.info("Property {} does not exist in xml file", (Object)property);
            ConfTool.addPropertyInternal(doc, property, value);
        }
    }

    private static void set(Document doc, HiveConf.ConfVars confVars, String value) {
        ConfTool.set(doc, confVars.varname, value);
    }

    private static void remove(Document doc, HiveConf.ConfVars confVars) {
        ConfTool.remove(doc, confVars.varname);
    }

    private static void remove(Document doc, String property) {
        if (ConfTool.propertyExists(doc, property)) {
            LOG.info("Property {} exists in hive-site.xml", (Object)property);
            ConfTool.removeProperty(doc, property);
        }
    }

    private static void saveToFile(Document doc, String filepath) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(new StreamSource(ConfToolUtil.getTransformerLocation()));
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(new File(filepath));
        transformer.transform(source, result);
    }

    @VisibleForTesting
    static void addProperty(Document doc, HiveConf.ConfVars confVars, String value) {
        ConfTool.addPropertyInternal(doc, confVars.varname, value);
    }

    private static void addPropertyInternal(Document doc, String property, String value) {
        LOG.info("Adding property to hive-site.xml: {} = {}", (Object)property, (Object)(ConfTool.isPassword(property) ? ConfTool.hidePassword(value) : value));
        Element element = doc.createElement(PROPERTY);
        ConfTool.addName(doc, element, property);
        ConfTool.addValue(doc, element, value);
        ConfTool.getConfigurationNode(doc).appendChild(element);
    }

    @VisibleForTesting
    static void removeProperty(Document doc, HiveConf.ConfVars confVars) {
        ConfTool.removeProperty(doc, confVars.varname);
    }

    private static void removeProperty(Document doc, String property) {
        LOG.info("Removing property from hive-site.xml: {}", (Object)property);
        Node configuration = ConfTool.getConfigurationNode(doc);
        NodeList childNodes = configuration.getChildNodes();
        int length = childNodes.getLength();
        for (int i = 0; i <= length - 1; ++i) {
            Node node = childNodes.item(i);
            NodeList nameValueDesc = node.getChildNodes();
            int childLength = nameValueDesc.getLength();
            for (int j = 0; j <= childLength - 1; ++j) {
                Node childNode = nameValueDesc.item(j);
                if (!NAME.equals(childNode.getNodeName()) || !property.equals(childNode.getTextContent())) continue;
                if (node.getNextSibling() != null && node.getNextSibling().getNodeType() == 3 && node.getNextSibling().getNodeValue().trim().isEmpty()) {
                    configuration.removeChild(node.getNextSibling());
                }
                configuration.removeChild(node);
                return;
            }
        }
    }

    @VisibleForTesting
    static Node getConfigurationNode(Document doc) {
        NodeList nodes = doc.getChildNodes();
        int length = nodes.getLength();
        for (int i = 0; i <= length - 1; ++i) {
            Node node = nodes.item(i);
            if (!CONFIGURATION.equals(node.getNodeName())) continue;
            return node;
        }
        throw new IllegalArgumentException("No <configuration> tag");
    }

    private static void addName(Document doc, Node node, String property) {
        Element element = doc.createElement(NAME);
        element.appendChild(doc.createTextNode(property));
        node.appendChild(element);
    }

    private static void addValue(Document doc, Node property, String value) {
        Element name = doc.createElement(VALUE);
        name.appendChild(doc.createTextNode(value));
        property.appendChild(name);
    }

    @VisibleForTesting
    static boolean propertyExists(Document doc, HiveConf.ConfVars confVars) {
        return ConfTool.propertyExists(doc, confVars.varname);
    }

    @VisibleForTesting
    static boolean propertyExists(Document doc, String property) {
        LOG.info("Checking that property exists in hive-site.xml : {}", (Object)property);
        Node configuration = ConfTool.getConfigurationNode(doc);
        NodeList properties = configuration.getChildNodes();
        int length = properties.getLength();
        for (int i = 0; i <= length - 1; ++i) {
            Node node = properties.item(i);
            NodeList nameValueDesc = node.getChildNodes();
            int childLength = nameValueDesc.getLength();
            for (int j = 0; j <= childLength - 1; ++j) {
                Node childNode = nameValueDesc.item(j);
                if (!NAME.equals(childNode.getNodeName()) || !property.equals(childNode.getTextContent())) continue;
                return true;
            }
        }
        return false;
    }

    private static Map<String, String> readAllProperties(Document doc) {
        LOG.info("Reading all properties from hive-site.xml");
        HashMap<String, String> result = new HashMap<String, String>();
        Node configuration = ConfTool.getConfigurationNode(doc);
        NodeList properties = configuration.getChildNodes();
        int length = properties.getLength();
        for (int i = 0; i <= length - 1; ++i) {
            Node node = properties.item(i);
            NodeList nameValueDesc = node.getChildNodes();
            int childLength = nameValueDesc.getLength();
            String name = EMPTY;
            String value = EMPTY;
            for (int j = 0; j <= childLength - 1; ++j) {
                Node childNode = nameValueDesc.item(j);
                if (NAME.equals(childNode.getNodeName())) {
                    name = childNode.getTextContent();
                }
                if (!VALUE.equals(childNode.getNodeName())) continue;
                value = childNode.getTextContent();
            }
            if (name.isEmpty()) continue;
            result.put(name, value);
        }
        return result;
    }

    private static boolean isPassword(String property) {
        String propertyLowCase = property.toLowerCase();
        return propertyLowCase.contains("password") || propertyLowCase.contains("passwd");
    }

    private static String hidePassword(String password) {
        return StringUtils.repeat((String)"*", (int)password.length());
    }

    @VisibleForTesting
    static void setProperty(Document doc, HiveConf.ConfVars confVars, String value) {
        ConfTool.set(doc, confVars.varname, value);
    }

    private static void setPropertyInternal(Document doc, String property, String value) {
        LOG.info("Setting value to existing property in xml file: {} = {}", (Object)property, (Object)(ConfTool.isPassword(property) ? ConfTool.hidePassword(value) : value));
        Node configuration = ConfTool.getConfigurationNode(doc);
        NodeList properties = configuration.getChildNodes();
        int length = properties.getLength();
        for (int i = 0; i <= length - 1; ++i) {
            Node node = properties.item(i);
            NodeList nameValueDesc = node.getChildNodes();
            int childLength = nameValueDesc.getLength();
            for (int j = 0; j <= childLength - 1; ++j) {
                Node childNode = nameValueDesc.item(j);
                if (!NAME.equals(childNode.getNodeName()) || !property.equals(childNode.getTextContent())) continue;
                ConfTool.writeValue(nameValueDesc, value);
            }
        }
    }

    @VisibleForTesting
    static String getProperty(Document doc, HiveConf.ConfVars confVars) {
        return ConfTool.getProperty(doc, confVars.varname);
    }

    @VisibleForTesting
    static String getProperty(Document doc, String property) {
        Node configuration = ConfTool.getConfigurationNode(doc);
        NodeList properties = configuration.getChildNodes();
        int length = properties.getLength();
        for (int i = 0; i <= length - 1; ++i) {
            Node node = properties.item(i);
            NodeList nameValueDesc = node.getChildNodes();
            int childLength = nameValueDesc.getLength();
            for (int j = 0; j <= childLength - 1; ++j) {
                Node childNode = nameValueDesc.item(j);
                if (!NAME.equals(childNode.getNodeName()) || !property.equals(childNode.getTextContent())) continue;
                return ConfTool.readValue(nameValueDesc);
            }
        }
        return EMPTY;
    }

    private static void writeValue(NodeList nameValueDesc, String value) {
        int childLength = nameValueDesc.getLength();
        for (int j = 0; j <= childLength - 1; ++j) {
            Node childNode = nameValueDesc.item(j);
            if (!VALUE.equals(childNode.getNodeName())) continue;
            childNode.setTextContent(value);
        }
    }

    private static String readValue(NodeList nameValueDesc) {
        int childLength = nameValueDesc.getLength();
        for (int j = 0; j <= childLength - 1; ++j) {
            Node childNode = nameValueDesc.item(j);
            if (!VALUE.equals(childNode.getNodeName())) continue;
            return childNode.getTextContent();
        }
        return EMPTY;
    }

    private static String buildMapRList(HiveConf.ConfVars[] options) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (HiveConf.ConfVars option : options) {
            if (first) {
                sb.append(option.varname);
                first = false;
                continue;
            }
            sb.append(",");
            sb.append(option.varname);
        }
        return sb.toString();
    }

    private static String getDefaultList() {
        return HiveConf.ConfVars.HIVE_CONF_RESTRICTED_LIST.getDefaultValue();
    }
}

