/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift2;

import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.LoginContext;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.thrift2.generated.TColumnValue;
import org.apache.hadoop.hbase.thrift2.generated.TGet;
import org.apache.hadoop.hbase.thrift2.generated.THBaseService;
import org.apache.hadoop.hbase.thrift2.generated.TPut;
import org.apache.hadoop.hbase.thrift2.generated.TResult;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSaslClientTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.layered.TFramedTransport;

public class DemoClient {
    private static String host = "localhost";
    private static int port = 9090;
    private static boolean secure = false;
    private static String user = null;

    public static void main(String[] args) throws Exception {
        Configuration conf;
        String principal;
        System.out.println("Thrift2 Demo");
        System.out.println("Usage: DemoClient [host=localhost] [port=9090] [secure=false]");
        System.out.println("This demo assumes you have a table called \"example\" with a column family called \"family1\"");
        if (args.length >= 1) {
            host = args[0];
        }
        if (args.length >= 2) {
            port = Integer.parseInt(args[1]);
        }
        if ((principal = (conf = HBaseConfiguration.create()).get("hbase.thrift.kerberos.principal")) != null) {
            secure = true;
            int slashIdx = principal.indexOf("/");
            int atIdx = principal.indexOf("@");
            int idx = slashIdx != -1 ? slashIdx : (atIdx != -1 ? atIdx : principal.length());
            user = principal.substring(0, idx);
        }
        if (args.length >= 3) {
            secure = Boolean.parseBoolean(args[2]);
        }
        final DemoClient client = new DemoClient();
        Subject.doAs(DemoClient.getSubject(), new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                client.run();
                return null;
            }
        });
    }

    public void run() throws Exception {
        int timeout = 10000;
        boolean framed = false;
        TSocket transport = new TSocket(host, port, timeout);
        if (framed) {
            transport = new TFramedTransport((TTransport)transport);
        } else if (secure) {
            HashMap<String, String> saslProperties = new HashMap<String, String>();
            saslProperties.put("javax.security.sasl.qop", "auth-conf,auth-int,auth");
            transport = new TSaslClientTransport("GSSAPI", null, user != null ? user : "hbase", host, saslProperties, null, (TTransport)transport);
        }
        TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
        THBaseService.Client client = new THBaseService.Client((TProtocol)protocol);
        transport.open();
        ByteBuffer table = ByteBuffer.wrap("example".getBytes());
        TPut put2 = new TPut();
        put2.setRow("row1".getBytes());
        TColumnValue columnValue = new TColumnValue();
        columnValue.setFamily("family1".getBytes());
        columnValue.setQualifier("qualifier1".getBytes());
        columnValue.setValue("value1".getBytes());
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>();
        columnValues.add(columnValue);
        put2.setColumnValues(columnValues);
        client.put(table, put2);
        TGet get2 = new TGet();
        get2.setRow("row1".getBytes());
        TResult result = client.get(table, get2);
        System.out.print("row = " + new String(result.getRow()));
        for (TColumnValue resultColumnValue : result.getColumnValues()) {
            System.out.print("family = " + new String(resultColumnValue.getFamily()));
            System.out.print("qualifier = " + new String(resultColumnValue.getFamily()));
            System.out.print("value = " + new String(resultColumnValue.getValue()));
            System.out.print("timestamp = " + resultColumnValue.getTimestamp());
        }
        transport.close();
    }

    static Subject getSubject() throws Exception {
        if (!secure) {
            return new Subject();
        }
        LoginContext context = new LoginContext("", new Subject(), null, new javax.security.auth.login.Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("useKeyTab", "false");
                options.put("storeKey", "false");
                options.put("doNotPrompt", "true");
                options.put("useTicketCache", "true");
                options.put("renewTGT", "true");
                options.put("refreshKrb5Config", "true");
                options.put("isInitiator", "true");
                String ticketCache = System.getenv("KRB5CCNAME");
                if (ticketCache != null) {
                    options.put("ticketCache", ticketCache);
                }
                options.put("debug", "true");
                return new AppConfigurationEntry[]{new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
            }
        });
        context.login();
        return context.getSubject();
    }
}

