/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import org.apache.hadoop.hbase.thrift.generated.AlreadyExists;
import org.apache.hadoop.hbase.thrift.generated.ColumnDescriptor;
import org.apache.hadoop.hbase.thrift.generated.Hbase;
import org.apache.hadoop.hbase.thrift.generated.TCell;
import org.apache.hadoop.hbase.thrift.generated.TRowResult;
import org.apache.hadoop.hbase.util.Base64;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.THttpClient;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class HttpDoAsClient {
    protected static int port;
    protected static String host;
    CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
    private static boolean secure;
    protected static String doAsUser;
    protected static String principal;

    public static void main(String[] args) throws Exception {
        if (args.length < 3 || args.length > 4) {
            System.out.println("Invalid arguments!");
            System.out.println("Usage: HttpDoAsClient host port doAsUserName [security=true]");
            System.exit(-1);
        }
        host = args[0];
        port = Integer.parseInt(args[1]);
        doAsUser = args[2];
        if (args.length > 3) {
            secure = Boolean.parseBoolean(args[3]);
            principal = HttpDoAsClient.getSubject().getPrincipals().iterator().next().getName();
        }
        final HttpDoAsClient client = new HttpDoAsClient();
        Subject.doAs(HttpDoAsClient.getSubject(), new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                client.run();
                return null;
            }
        });
    }

    HttpDoAsClient() {
    }

    private String utf8(byte[] buf) {
        try {
            return this.decoder.decode(ByteBuffer.wrap(buf)).toString();
        }
        catch (CharacterCodingException e) {
            return "[INVALID UTF-8]";
        }
    }

    private byte[] bytes(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void run() throws Exception {
        TSocket transport = new TSocket(host, port);
        transport.open();
        String url = "http://" + host + ":" + port;
        THttpClient httpClient = new THttpClient(url);
        httpClient.open();
        TBinaryProtocol protocol = new TBinaryProtocol((TTransport)httpClient);
        Hbase.Client client = new Hbase.Client((TProtocol)protocol);
        byte[] t = this.bytes("demo_table");
        System.out.println("scanning tables...");
        for (ByteBuffer name : this.refresh(client, httpClient).getTableNames()) {
            System.out.println("  found: " + this.utf8(name.array()));
            if (!this.utf8(name.array()).equals(this.utf8(t))) continue;
            if (this.refresh(client, httpClient).isTableEnabled(name)) {
                System.out.println("    disabling table: " + this.utf8(name.array()));
                this.refresh(client, httpClient).disableTable(name);
            }
            System.out.println("    deleting table: " + this.utf8(name.array()));
            this.refresh(client, httpClient).deleteTable(name);
        }
        ArrayList<ColumnDescriptor> columns = new ArrayList<ColumnDescriptor>();
        ColumnDescriptor col = new ColumnDescriptor();
        col.name = ByteBuffer.wrap(this.bytes("entry:"));
        col.timeToLive = Integer.MAX_VALUE;
        col.maxVersions = 10;
        columns.add(col);
        col = new ColumnDescriptor();
        col.name = ByteBuffer.wrap(this.bytes("unused:"));
        col.timeToLive = Integer.MAX_VALUE;
        columns.add(col);
        System.out.println("creating table: " + this.utf8(t));
        try {
            this.refresh(client, httpClient).createTable(ByteBuffer.wrap(t), columns);
        }
        catch (AlreadyExists ae) {
            System.out.println("WARN: " + ae.message);
        }
        System.out.println("column families in " + this.utf8(t) + ": ");
        Map<ByteBuffer, ColumnDescriptor> columnMap = this.refresh(client, httpClient).getColumnDescriptors(ByteBuffer.wrap(t));
        for (ColumnDescriptor col2 : columnMap.values()) {
            System.out.println("  column: " + this.utf8(col2.name.array()) + ", maxVer: " + Integer.toString(col2.maxVersions));
        }
        transport.close();
        httpClient.close();
    }

    private Hbase.Client refresh(Hbase.Client client, THttpClient httpClient) {
        httpClient.setCustomHeader("doAs", doAsUser);
        if (secure) {
            try {
                httpClient.setCustomHeader("Authorization", this.generateTicket());
            }
            catch (GSSException e) {
                e.printStackTrace();
            }
        }
        return client;
    }

    private String generateTicket() throws GSSException {
        GSSManager manager = GSSManager.getInstance();
        Oid krb5PrincipalOid = new Oid("1.2.840.113554.1.2.2.1");
        Oid KERB_V5_OID = new Oid("1.2.840.113554.1.2.2");
        GSSName clientName = manager.createName(principal, krb5PrincipalOid);
        GSSCredential clientCred = manager.createCredential(clientName, 28800, KERB_V5_OID, 1);
        GSSName serverName = manager.createName(principal, krb5PrincipalOid);
        GSSContext context = manager.createContext(serverName, KERB_V5_OID, clientCred, 0);
        context.requestMutualAuth(true);
        context.requestConf(false);
        context.requestInteg(true);
        byte[] outToken = context.initSecContext(new byte[0], 0, 0);
        StringBuffer outputBuffer = new StringBuffer();
        outputBuffer.append("Negotiate ");
        outputBuffer.append(Base64.encodeBytes((byte[])outToken).replace("\n", ""));
        System.out.print("Ticket is: " + outputBuffer);
        return outputBuffer.toString();
    }

    private void printVersions(ByteBuffer row, List<TCell> versions) {
        StringBuilder rowStr = new StringBuilder();
        for (TCell cell : versions) {
            rowStr.append(this.utf8(cell.value.array()));
            rowStr.append("; ");
        }
        System.out.println("row: " + this.utf8(row.array()) + ", values: " + rowStr);
    }

    private void printRow(TRowResult rowResult) {
        TreeMap<String, TCell> sorted = new TreeMap<String, TCell>();
        for (Map.Entry<ByteBuffer, TCell> column : rowResult.columns.entrySet()) {
            sorted.put(this.utf8(column.getKey().array()), column.getValue());
        }
        StringBuilder rowStr = new StringBuilder();
        for (Map.Entry entry : sorted.entrySet()) {
            rowStr.append((String)entry.getKey());
            rowStr.append(" => ");
            rowStr.append(this.utf8(((TCell)entry.getValue()).value.array()));
            rowStr.append("; ");
        }
        System.out.println("row: " + this.utf8(rowResult.row.array()) + ", cols: " + rowStr);
    }

    static Subject getSubject() throws Exception {
        if (!secure) {
            return new Subject();
        }
        LoginContext context = new LoginContext("", new Subject(), null, new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("useKeyTab", "false");
                options.put("storeKey", "false");
                options.put("doNotPrompt", "true");
                options.put("useTicketCache", "true");
                options.put("renewTGT", "true");
                options.put("refreshKrb5Config", "true");
                options.put("isInitiator", "true");
                String ticketCache = System.getenv("KRB5CCNAME");
                if (ticketCache != null) {
                    options.put("ticketCache", ticketCache);
                }
                options.put("debug", "true");
                return new AppConfigurationEntry[]{new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
            }
        });
        context.login();
        return context.getSubject();
    }

    static {
        secure = false;
        doAsUser = null;
        principal = null;
    }
}

