/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark.datasources;

import org.apache.hadoop.hbase.spark.datasources.BoundRange;
import org.apache.hadoop.hbase.spark.datasources.BoundRanges;
import org.apache.hadoop.hbase.spark.datasources.BytesEncoder;
import org.apache.hadoop.hbase.spark.datasources.JavaBytesEncoder$;
import org.apache.hadoop.hbase.spark.hbase.package$;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Double$;
import scala.Enumeration;
import scala.Float$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001\u0002\u0011\"\u00019BQ!\u000f\u0001\u0005\u0002iBq\u0001\u0010\u0001C\u0002\u0013\u0005Q\b\u0003\u0004E\u0001\u0001\u0006IA\u0010\u0005\b\u000b\u0002\u0001\r\u0011\"\u0001G\u0011\u001dQ\u0005\u00011A\u0005\u0002-Ca!\u0015\u0001!B\u00139\u0005\"\u0002*\u0001\t\u0003\u0019\u0006bB,\u0001\u0005\u0004%\ta\u0015\u0005\u00071\u0002\u0001\u000b\u0011\u0002+\t\u000fe\u0003!\u0019!C\u0001'\"1!\f\u0001Q\u0001\nQCqa\u0017\u0001C\u0002\u0013\u00051\u000b\u0003\u0004]\u0001\u0001\u0006I\u0001\u0016\u0005\b;\u0002\u0011\r\u0011\"\u0001T\u0011\u0019q\u0006\u0001)A\u0005)\"9q\f\u0001b\u0001\n\u0003\u0019\u0006B\u00021\u0001A\u0003%A\u000bC\u0004b\u0001\t\u0007I\u0011A*\t\r\t\u0004\u0001\u0015!\u0003U\u0011\u001d\u0019\u0007A1A\u0005\u0002MCa\u0001\u001a\u0001!\u0002\u0013!\u0006bB3\u0001\u0005\u0004%\ta\u0015\u0005\u0007M\u0002\u0001\u000b\u0011\u0002+\t\u000f\u001d\u0004!\u0019!C\u0001'\"1\u0001\u000e\u0001Q\u0001\nQCq!\u001b\u0001C\u0002\u0013\u00051\u000b\u0003\u0004k\u0001\u0001\u0006I\u0001\u0016\u0005\u0006W\u0002!\t\u0001\u001c\u0005\u0006q\u0002!\t!\u001f\u0005\b\u0003_\u0001A\u0011IA\u0019\u0011\u001d\t\u0019\u0006\u0001C!\u0003+\u0012ABT1jm\u0016,enY8eKJT!AI\u0012\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0003I\u0015\nQa\u001d9be.T!AJ\u0014\u0002\u000b!\u0014\u0017m]3\u000b\u0005!J\u0013A\u00025bI>|\u0007O\u0003\u0002+W\u00051\u0011\r]1dQ\u0016T\u0011\u0001L\u0001\u0004_J<7\u0001A\n\u0004\u0001=*\u0004C\u0001\u00194\u001b\u0005\t$\"\u0001\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\n$AB!osJ+g\r\u0005\u00027o5\t\u0011%\u0003\u00029C\ta!)\u001f;fg\u0016s7m\u001c3fe\u00061A(\u001b8jiz\"\u0012a\u000f\t\u0003m\u0001\ta\u0001\\8hO\u0016\u0014X#\u0001 \u0011\u0005}\u0012U\"\u0001!\u000b\u0005\u0005[\u0013!B:mMRR\u0017BA\"A\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013\u0001B2pI\u0016,\u0012a\u0012\t\u0003a!K!!S\u0019\u0003\u0007%sG/\u0001\u0005d_\u0012,w\fJ3r)\tau\n\u0005\u00021\u001b&\u0011a*\r\u0002\u0005+:LG\u000fC\u0004Q\u000b\u0005\u0005\t\u0019A$\u0002\u0007a$\u0013'A\u0003d_\u0012,\u0007%\u0001\u0005oKb$8i\u001c3f+\u0005!\u0006C\u0001\u0019V\u0013\t1\u0016G\u0001\u0003CsR,\u0017A\u0003\"p_2,\u0017M\\#oG\u0006Y!i\\8mK\u0006tWI\\2!\u0003!\u0019\u0006n\u001c:u\u000b:\u001c\u0017!C*i_J$XI\\2!\u0003\u0019Ie\u000e^#oG\u00069\u0011J\u001c;F]\u000e\u0004\u0013a\u0002'p]\u001e,enY\u0001\t\u0019>tw-\u00128dA\u0005Aa\t\\8bi\u0016s7-A\u0005GY>\fG/\u00128dA\u0005IAi\\;cY\u0016,enY\u0001\u000b\t>,(\r\\3F]\u000e\u0004\u0013!C*ue&tw-\u00128d\u0003)\u0019FO]5oO\u0016s7\rI\u0001\n\u0005&t\u0017M]=F]\u000e\f!BQ5oCJLXI\\2!\u00031!\u0016.\\3ti\u0006l\u0007/\u00128d\u00035!\u0016.\\3ti\u0006l\u0007/\u00128dA\u0005QQK\\6o_^tWI\\2\u0002\u0017Us7N\\8x]\u0016s7\rI\u0001\u0007e\u0006tw-Z:\u0015\u00055\u001c\bc\u0001\u0019oa&\u0011q.\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005Y\n\u0018B\u0001:\"\u0005-\u0011u.\u001e8e%\u0006tw-Z:\t\u000bQd\u0002\u0019A;\u0002\u0005%t\u0007C\u0001\u0019w\u0013\t9\u0018GA\u0002B]f\fqaY8na\u0006\u0014X\rF\u0002{{~\u0004\"\u0001M>\n\u0005q\f$a\u0002\"p_2,\u0017M\u001c\u0005\u0006}v\u0001\raR\u0001\u0002G\"9\u0011\u0011A\u000fA\u0002\u0005\r\u0011aA8qgB!\u0011QAA\u0015\u001d\u0011\t9!!\n\u000f\t\u0005%\u00111\u0005\b\u0005\u0003\u0017\t\tC\u0004\u0003\u0002\u000e\u0005}a\u0002BA\b\u0003;qA!!\u0005\u0002\u001c9!\u00111CA\r\u001b\t\t)BC\u0002\u0002\u00185\na\u0001\u0010:p_Rt\u0014\"\u0001\u0017\n\u0005)Z\u0013B\u0001\u0015*\u0013\t1s%\u0003\u0002%K%\u0011!eI\u0005\u0004\u0003O\t\u0013\u0001\u0005&bm\u0006\u0014\u0015\u0010^3t\u000b:\u001cw\u000eZ3s\u0013\u0011\tY#!\f\u0003!)\u000bg/\u0019\"zi\u0016\u001cXI\\2pI\u0016\u0014(bAA\u0014C\u00051QM\\2pI\u0016$b!a\r\u0002:\u0005=\u0003\u0003\u0002\u0019\u00026QK1!a\u000e2\u0005\u0015\t%O]1z\u0011\u001d\tYD\ba\u0001\u0003{\t!\u0001\u001a;\u0011\t\u0005}\u00121J\u0007\u0003\u0003\u0003RA!a\u0011\u0002F\u0005)A/\u001f9fg*!\u0011qIA%\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003I%JA!!\u0014\u0002B\tAA)\u0019;b)f\u0004X\r\u0003\u0004\u0002Ry\u0001\r!^\u0001\u0006m\u0006dW/Z\u0001\u0007M&dG/\u001a:\u0015\u001fi\f9&a\u0017\u0002`\u0005\r\u0014qMA6\u0003_Bq!!\u0017 \u0001\u0004\t\u0019$A\u0003j]B,H\u000f\u0003\u0004\u0002^}\u0001\raR\u0001\b_\u001a47/\u001a;2\u0011\u0019\t\tg\ba\u0001\u000f\u00069A.\u001a8hi\"\f\u0004bBA3?\u0001\u0007\u00111G\u0001\fM&dG/\u001a:CsR,7\u000f\u0003\u0004\u0002j}\u0001\raR\u0001\b_\u001a47/\u001a;3\u0011\u0019\tig\ba\u0001\u000f\u00069A.\u001a8hi\"\u0014\u0004bBA\u0001?\u0001\u0007\u00111\u0001")
public class NaiveEncoder
implements BytesEncoder {
    private final Logger logger = LoggerFactory.getLogger(NaiveEncoder.class);
    private int code = 0;
    private final byte BooleanEnc = this.nextCode();
    private final byte ShortEnc = this.nextCode();
    private final byte IntEnc = this.nextCode();
    private final byte LongEnc = this.nextCode();
    private final byte FloatEnc = this.nextCode();
    private final byte DoubleEnc = this.nextCode();
    private final byte StringEnc = this.nextCode();
    private final byte BinaryEnc = this.nextCode();
    private final byte TimestampEnc = this.nextCode();
    private final byte UnknownEnc = this.nextCode();

    public Logger logger() {
        return this.logger;
    }

    public int code() {
        return this.code;
    }

    public void code_$eq(int x$1) {
        this.code = x$1;
    }

    public byte nextCode() {
        this.code_$eq(this.code() + 1);
        return (byte)(this.code() - 1);
    }

    public byte BooleanEnc() {
        return this.BooleanEnc;
    }

    public byte ShortEnc() {
        return this.ShortEnc;
    }

    public byte IntEnc() {
        return this.IntEnc;
    }

    public byte LongEnc() {
        return this.LongEnc;
    }

    public byte FloatEnc() {
        return this.FloatEnc;
    }

    public byte DoubleEnc() {
        return this.DoubleEnc;
    }

    public byte StringEnc() {
        return this.StringEnc;
    }

    public byte BinaryEnc() {
        return this.BinaryEnc;
    }

    public byte TimestampEnc() {
        return this.TimestampEnc;
    }

    public byte UnknownEnc() {
        return this.UnknownEnc;
    }

    @Override
    public Option<BoundRanges> ranges(Object in) {
        None$ none$;
        Object object = in;
        if (object instanceof Integer) {
            Some some;
            Integer n = (Integer)object;
            byte[] b = Bytes.toBytes((int)Predef$.MODULE$.Integer2int(n));
            if (Predef$.MODULE$.Integer2int(n) >= 0) {
                this.logger().debug(new StringBuilder(25).append("range is 0 to ").append(n).append(" and ").append(Integer.MIN_VALUE).append(" to -1").toString());
                some = new Some((Object)new BoundRanges((BoundRange[])((Object[])new BoundRange[]{new BoundRange(Bytes.toBytes((int)0), b), new BoundRange(Bytes.toBytes((int)Integer.MIN_VALUE), Bytes.toBytes((int)-1))}), (BoundRange[])((Object[])new BoundRange[]{new BoundRange(b, Bytes.toBytes((int)Integer.MAX_VALUE))}), b));
            } else {
                some = new Some((Object)new BoundRanges((BoundRange[])((Object[])new BoundRange[]{new BoundRange(Bytes.toBytes((int)Integer.MIN_VALUE), b)}), (BoundRange[])((Object[])new BoundRange[]{new BoundRange(b, Bytes.toBytes((int)Predef$.MODULE$.Integer2int(Predef$.MODULE$.int2Integer(-1)))), new BoundRange(Bytes.toBytes((int)0), Bytes.toBytes((int)Integer.MAX_VALUE))}), b));
            }
            none$ = some;
        } else if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            byte[] b = Bytes.toBytes((long)l);
            none$ = l >= 0L ? new Some((Object)new BoundRanges((BoundRange[])((Object[])new BoundRange[]{new BoundRange(Bytes.toBytes((long)0L), b), new BoundRange(Bytes.toBytes((long)Long.MIN_VALUE), Bytes.toBytes((long)-1L))}), (BoundRange[])((Object[])new BoundRange[]{new BoundRange(b, Bytes.toBytes((long)Long.MAX_VALUE))}), b)) : new Some((Object)new BoundRanges((BoundRange[])((Object[])new BoundRange[]{new BoundRange(Bytes.toBytes((long)Long.MIN_VALUE), b)}), (BoundRange[])((Object[])new BoundRange[]{new BoundRange(b, Bytes.toBytes((long)-1L)), new BoundRange(Bytes.toBytes((long)0L), Bytes.toBytes((long)Long.MAX_VALUE))}), b));
        } else if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            byte[] b = Bytes.toBytes((short)s);
            none$ = s >= 0 ? new Some((Object)new BoundRanges((BoundRange[])((Object[])new BoundRange[]{new BoundRange(Bytes.toBytes((short)0), b), new BoundRange(Bytes.toBytes((short)Short.MIN_VALUE), Bytes.toBytes((short)-1))}), (BoundRange[])((Object[])new BoundRange[]{new BoundRange(b, Bytes.toBytes((short)Short.MAX_VALUE))}), b)) : new Some((Object)new BoundRanges((BoundRange[])((Object[])new BoundRange[]{new BoundRange(Bytes.toBytes((short)Short.MIN_VALUE), b)}), (BoundRange[])((Object[])new BoundRange[]{new BoundRange(b, Bytes.toBytes((short)-1)), new BoundRange(Bytes.toBytes((short)0), Bytes.toBytes((short)Short.MAX_VALUE))}), b));
        } else if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            byte[] b = Bytes.toBytes((double)d);
            none$ = d >= 0.0 ? new Some((Object)new BoundRanges((BoundRange[])((Object[])new BoundRange[]{new BoundRange(Bytes.toBytes((double)0.0), b), new BoundRange(Bytes.toBytes((double)-0.0), Bytes.toBytes((double)Double$.MODULE$.MinValue()))}), (BoundRange[])((Object[])new BoundRange[]{new BoundRange(b, Bytes.toBytes((double)Double.MAX_VALUE))}), b)) : new Some((Object)new BoundRanges((BoundRange[])((Object[])new BoundRange[]{new BoundRange(b, Bytes.toBytes((double)Double$.MODULE$.MinValue()))}), (BoundRange[])((Object[])new BoundRange[]{new BoundRange(Bytes.toBytes((double)-0.0), b), new BoundRange(Bytes.toBytes((double)0.0), Bytes.toBytes((double)Double.MAX_VALUE))}), b));
        } else if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            byte[] b = Bytes.toBytes((float)f);
            none$ = f >= 0.0f ? new Some((Object)new BoundRanges((BoundRange[])((Object[])new BoundRange[]{new BoundRange(Bytes.toBytes((float)0.0f), b), new BoundRange(Bytes.toBytes((float)-0.0f), Bytes.toBytes((float)Float$.MODULE$.MinValue()))}), (BoundRange[])((Object[])new BoundRange[]{new BoundRange(b, Bytes.toBytes((float)Float.MAX_VALUE))}), b)) : new Some((Object)new BoundRanges((BoundRange[])((Object[])new BoundRange[]{new BoundRange(b, Bytes.toBytes((float)Float$.MODULE$.MinValue()))}), (BoundRange[])((Object[])new BoundRange[]{new BoundRange(Bytes.toBytes((float)-0.0f), b), new BoundRange(Bytes.toBytes((float)0.0f), Bytes.toBytes((float)Float.MAX_VALUE))}), b));
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            BoundRange[] boundRangeArray = (BoundRange[])((Object[])new BoundRange[]{new BoundRange(package$.MODULE$.bytesMin(), byArray)});
            BoundRange[] boundRangeArray2 = new BoundRange[1];
            package$.MODULE$.bytesMax();
            boundRangeArray2[0] = new BoundRange(byArray, null);
            none$ = new Some((Object)new BoundRanges(boundRangeArray, (BoundRange[])((Object[])boundRangeArray2), byArray));
        } else if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte((Object)object);
            byte[] b = new byte[]{by};
            BoundRange[] boundRangeArray = (BoundRange[])((Object[])new BoundRange[]{new BoundRange(package$.MODULE$.bytesMin(), b)});
            BoundRange[] boundRangeArray3 = new BoundRange[1];
            package$.MODULE$.bytesMax();
            boundRangeArray3[0] = new BoundRange(b, null);
            none$ = new Some((Object)new BoundRanges(boundRangeArray, (BoundRange[])((Object[])boundRangeArray3), b));
        } else if (object instanceof String) {
            String string = (String)object;
            byte[] b = Bytes.toBytes((String)string);
            BoundRange[] boundRangeArray = (BoundRange[])((Object[])new BoundRange[]{new BoundRange(package$.MODULE$.bytesMin(), b)});
            BoundRange[] boundRangeArray4 = new BoundRange[1];
            package$.MODULE$.bytesMax();
            boundRangeArray4[0] = new BoundRange(b, null);
            none$ = new Some((Object)new BoundRanges(boundRangeArray, (BoundRange[])((Object[])boundRangeArray4), b));
        } else if (object instanceof UTF8String) {
            UTF8String uTF8String = (UTF8String)object;
            byte[] b = uTF8String.getBytes();
            BoundRange[] boundRangeArray = (BoundRange[])((Object[])new BoundRange[]{new BoundRange(package$.MODULE$.bytesMin(), b)});
            BoundRange[] boundRangeArray5 = new BoundRange[1];
            package$.MODULE$.bytesMax();
            boundRangeArray5[0] = new BoundRange(b, null);
            none$ = new Some((Object)new BoundRanges(boundRangeArray, (BoundRange[])((Object[])boundRangeArray5), b));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public boolean compare(int c, Enumeration.Value ops) {
        boolean bl;
        Enumeration.Value value = ops;
        Enumeration.Value value2 = JavaBytesEncoder$.MODULE$.Greater();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            bl = c > 0;
        } else {
            Enumeration.Value value4 = JavaBytesEncoder$.MODULE$.GreaterEqual();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                bl = c >= 0;
            } else {
                Enumeration.Value value6 = JavaBytesEncoder$.MODULE$.Less();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    bl = c < 0;
                } else {
                    Enumeration.Value value8 = JavaBytesEncoder$.MODULE$.LessEqual();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        bl = c <= 0;
                    } else {
                        throw new MatchError((Object)value);
                    }
                }
            }
        }
        return bl;
    }

    @Override
    public byte[] encode(DataType dt, Object value) {
        byte[] byArray;
        DataType dataType = dt;
        if (BooleanType$.MODULE$.equals(dataType)) {
            byte[] result = new byte[2];
            result[0] = this.BooleanEnc();
            boolean bl = BoxesRunTime.unboxToBoolean((Object)value);
            if (bl) {
                result[1] = -1;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (!bl) {
                result[1] = 0;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
            }
            byArray = result;
        } else if (ShortType$.MODULE$.equals(dataType)) {
            byte[] result = new byte[3];
            result[0] = this.ShortEnc();
            Bytes.putShort((byte[])result, (int)1, (short)BoxesRunTime.unboxToShort((Object)value));
            byArray = result;
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            byte[] result = new byte[5];
            result[0] = this.IntEnc();
            Bytes.putInt((byte[])result, (int)1, (int)BoxesRunTime.unboxToInt((Object)value));
            byArray = result;
        } else {
            boolean bl = LongType$.MODULE$.equals(dataType) ? true : TimestampType$.MODULE$.equals(dataType);
            if (bl) {
                byte[] result = new byte[9];
                result[0] = this.LongEnc();
                Bytes.putLong((byte[])result, (int)1, (long)BoxesRunTime.unboxToLong((Object)value));
                byArray = result;
            } else if (FloatType$.MODULE$.equals(dataType)) {
                byte[] result = new byte[5];
                result[0] = this.FloatEnc();
                Bytes.putFloat((byte[])result, (int)1, (float)BoxesRunTime.unboxToFloat((Object)value));
                byArray = result;
            } else if (DoubleType$.MODULE$.equals(dataType)) {
                byte[] result = new byte[9];
                result[0] = this.DoubleEnc();
                Bytes.putDouble((byte[])result, (int)1, (double)BoxesRunTime.unboxToDouble((Object)value));
                byArray = result;
            } else if (BinaryType$.MODULE$.equals(dataType)) {
                byte[] byArray2;
                Object object = value;
                if (object instanceof byte[]) {
                    byte[] byArray3 = (byte[])object;
                    byte[] result = new byte[byArray3.length + 1];
                    result[0] = this.BinaryEnc();
                    System.arraycopy(byArray3, 0, result, 1, byArray3.length);
                    byArray2 = result;
                } else if (object instanceof Bytes[]) {
                    Bytes[] bytesArray = (Bytes[])object;
                    byte[] result = new byte[bytesArray.length + 1];
                    result[0] = this.BinaryEnc();
                    System.arraycopy(bytesArray, 0, result, 1, bytesArray.length);
                    byArray2 = result;
                } else {
                    throw new MatchError(object);
                }
                byArray = byArray2;
            } else if (StringType$.MODULE$.equals(dataType)) {
                byte[] bytes = Bytes.toBytes((String)((String)value));
                byte[] result = new byte[bytes.length + 1];
                result[0] = this.StringEnc();
                System.arraycopy(bytes, 0, result, 1, bytes.length);
                byArray = result;
            } else {
                byte[] bytes = Bytes.toBytes((String)value.toString());
                byte[] result = new byte[bytes.length + 1];
                result[0] = this.UnknownEnc();
                System.arraycopy(bytes, 0, result, 1, bytes.length);
                byArray = result;
            }
        }
        return byArray;
    }

    @Override
    public boolean filter(byte[] input, int offset1, int length1, byte[] filterBytes, int offset2, int length2, Enumeration.Value ops) {
        boolean bl;
        byte by = filterBytes[offset2];
        if (this.ShortEnc() == by) {
            short in = Bytes.toShort((byte[])input, (int)offset1);
            short value = Bytes.toShort((byte[])filterBytes, (int)(offset2 + 1));
            bl = this.compare(Predef$.MODULE$.short2Short(in).compareTo(Predef$.MODULE$.short2Short(value)), ops);
        } else if (this.IntEnc() == by) {
            int in = Bytes.toInt((byte[])input, (int)offset1);
            int value = Bytes.toInt((byte[])filterBytes, (int)(offset2 + 1));
            bl = this.compare(Predef$.MODULE$.int2Integer(in).compareTo(Predef$.MODULE$.int2Integer(value)), ops);
        } else {
            boolean bl2 = this.LongEnc() == by ? true : this.TimestampEnc() == by;
            if (bl2) {
                int in = Bytes.toInt((byte[])input, (int)offset1);
                int value = Bytes.toInt((byte[])filterBytes, (int)(offset2 + 1));
                bl = this.compare(Predef$.MODULE$.int2Integer(in).compareTo(Predef$.MODULE$.int2Integer(value)), ops);
            } else if (this.FloatEnc() == by) {
                float in = Bytes.toFloat((byte[])input, (int)offset1);
                float value = Bytes.toFloat((byte[])filterBytes, (int)(offset2 + 1));
                bl = this.compare(Predef$.MODULE$.float2Float(in).compareTo(Predef$.MODULE$.float2Float(value)), ops);
            } else if (this.DoubleEnc() == by) {
                double in = Bytes.toDouble((byte[])input, (int)offset1);
                double value = Bytes.toDouble((byte[])filterBytes, (int)(offset2 + 1));
                bl = this.compare(Predef$.MODULE$.double2Double(in).compareTo(Predef$.MODULE$.double2Double(value)), ops);
            } else {
                bl = this.compare(Bytes.compareTo((byte[])input, (int)offset1, (int)length1, (byte[])filterBytes, (int)(offset2 + 1), (int)(length2 - 1)), ops);
            }
        }
        return bl;
    }
}

