/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapred.TableOutputFormat;
import org.apache.hadoop.hbase.spark.AndLogicExpression;
import org.apache.hadoop.hbase.spark.DefaultSourceStaticUtils$;
import org.apache.hadoop.hbase.spark.DynamicLogicExpression;
import org.apache.hadoop.hbase.spark.EqualLogicExpression;
import org.apache.hadoop.hbase.spark.GreaterThanLogicExpression;
import org.apache.hadoop.hbase.spark.GreaterThanOrEqualLogicExpression;
import org.apache.hadoop.hbase.spark.HBaseConnectionCache$;
import org.apache.hadoop.hbase.spark.HBaseContext;
import org.apache.hadoop.hbase.spark.HBaseContext$;
import org.apache.hadoop.hbase.spark.HBaseRelation$;
import org.apache.hadoop.hbase.spark.IsNullLogicExpression;
import org.apache.hadoop.hbase.spark.LatestHBaseContextCache$;
import org.apache.hadoop.hbase.spark.LessThanLogicExpression;
import org.apache.hadoop.hbase.spark.LessThanOrEqualLogicExpression;
import org.apache.hadoop.hbase.spark.OrLogicExpression;
import org.apache.hadoop.hbase.spark.PassThroughLogicExpression;
import org.apache.hadoop.hbase.spark.RowKeyFilter;
import org.apache.hadoop.hbase.spark.RowKeyFilter$;
import org.apache.hadoop.hbase.spark.ScanRange;
import org.apache.hadoop.hbase.spark.SmartConnection;
import org.apache.hadoop.hbase.spark.SparkSQLPushDownFilter;
import org.apache.hadoop.hbase.spark.datasources.BoundRanges;
import org.apache.hadoop.hbase.spark.datasources.BytesEncoder;
import org.apache.hadoop.hbase.spark.datasources.HBaseSparkConf$;
import org.apache.hadoop.hbase.spark.datasources.HBaseTableScanRDD;
import org.apache.hadoop.hbase.spark.datasources.JavaBytesEncoder$;
import org.apache.hadoop.hbase.spark.datasources.SerializableConfiguration;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapred.JobConf;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.datasources.hbase.Field;
import org.apache.spark.sql.datasources.hbase.HBaseTableCatalog;
import org.apache.spark.sql.datasources.hbase.HBaseTableCatalog$;
import org.apache.spark.sql.datasources.hbase.Utils$;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.InsertableRelation;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.PrunedFilteredScan;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.MutableList;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r\u0005f\u0001B'O\u0001fC\u0001B\u001d\u0001\u0003\u0016\u0004%\ta\u001d\u0005\n\u0003\u000b\u0001!\u0011#Q\u0001\nQD!\"a\u0004\u0001\u0005+\u0007I\u0011AA\t\u0011)\t)\u0003\u0001B\tB\u0003%\u00111\u0003\u0005\u000b\u0003O\u0001!Q1A\u0005\u0002\u0005%\u0002BCA\u001a\u0001\t\u0005\t\u0015!\u0003\u0002,!9\u0011q\u0007\u0001\u0005\u0002\u0005e\u0002\"CA$\u0001\t\u0007I\u0011AA%\u0011!\t9\u0006\u0001Q\u0001\n\u0005-\u0003\"CA-\u0001\t\u0007I\u0011AA.\u0011!\t)\u0007\u0001Q\u0001\n\u0005u\u0003\"CA4\u0001\t\u0007I\u0011AA.\u0011!\tI\u0007\u0001Q\u0001\n\u0005u\u0003\"CA6\u0001\t\u0007I\u0011AA.\u0011!\ti\u0007\u0001Q\u0001\n\u0005u\u0003\"CA8\u0001\t\u0007I\u0011AA9\u0011!\tY\b\u0001Q\u0001\n\u0005M\u0004\"CA?\u0001\t\u0007I\u0011AA@\u0011!\tI\t\u0001Q\u0001\n\u0005\u0005\u0005\"CAF\u0001\t\u0007I\u0011AAG\u0011\u001d\ty\t\u0001Q\u0001\n}D\u0011\"!%\u0001\u0005\u0004%\t!a%\t\u0011\u0005\u0005\u0006\u0001)A\u0005\u0003+C\u0011\"!*\u0001\u0005\u0004%\t!a*\t\u0011\u0005U\u0006\u0001)A\u0005\u0003SCq!a.\u0001\t\u0003\ti\tC\u0005\u0002:\u0002\u0011\r\u0011\"\u0001\u0002<\"A\u0011Q\u0018\u0001!\u0002\u0013\t\u0019\tC\u0005\u0002@\u0002\u0011\r\u0011\"\u0001\u0002\u000e\"9\u0011\u0011\u0019\u0001!\u0002\u0013y\b\"CAb\u0001\t\u0007I\u0011AA^\u0011!\t)\r\u0001Q\u0001\n\u0005\r\u0005\"CAd\u0001\t\u0007I\u0011AA^\u0011!\tI\r\u0001Q\u0001\n\u0005\r\u0005\"CAf\u0001\t\u0007I\u0011AA^\u0011!\ti\r\u0001Q\u0001\n\u0005\r\u0005\"CAh\u0001\t\u0007I\u0011AAi\u0011!\t\u0019\u000e\u0001Q\u0001\n\u0005U\u0004\"CAk\u0001\t\u0007I\u0011AAi\u0011!\t9\u000e\u0001Q\u0001\n\u0005U\u0004\"CAm\u0001\t\u0007I\u0011AAi\u0011!\tY\u000e\u0001Q\u0001\n\u0005U\u0004\"CAo\u0001\t\u0007I\u0011AAp\u0011!\t9\u000f\u0001Q\u0001\n\u0005\u0005\b\"CAu\u0001\t\u0007I\u0011AAv\u0011!\t\u0019\u0010\u0001Q\u0001\n\u00055\bbBA{\u0001\u0011\u0005\u0011q\u001f\u0005\n\u0005\u000b\u0001!\u0019!C!\u0005\u000fA\u0001B!\u0003\u0001A\u0003%\u0011\u0011\u0004\u0005\b\u0005\u0017\u0001A\u0011\u0001B\u0007\u0011\u001d\u0011)\u0002\u0001C!\u0005/AqAa\u0010\u0001\t\u0003\u0011\t\u0005C\u0004\u0003j\u0001!\tAa\u001b\t\u000f\t\u001d\u0005\u0001\"\u0001\u0003\n\"9!1\u0016\u0001\u0005\u0002\t5\u0006b\u0002BZ\u0001\u0011\u0005#Q\u0017\u0005\b\u0005#\u0004A\u0011\u0001Bj\u0011\u001d\u0011Y\u000f\u0001C\u0001\u0005[D\u0011ba\u0003\u0001\u0003\u0003%\ta!\u0004\t\u0013\r]\u0001!%A\u0005\u0002\re\u0001\"CB\u0018\u0001E\u0005I\u0011AB\u0019\u0011%\u0019)\u0004AA\u0001\n\u0003\u001a9\u0004C\u0005\u0004H\u0001\t\t\u0011\"\u0001\u0002R\"I1\u0011\n\u0001\u0002\u0002\u0013\u000511\n\u0005\n\u0007#\u0002\u0011\u0011!C!\u0007'B\u0011b!\u0018\u0001\u0003\u0003%\taa\u0018\t\u0013\r\r\u0004!!A\u0005B\r\u0015\u0004\"CB4\u0001\u0005\u0005I\u0011IB5\u0011%\u0019Y\u0007AA\u0001\n\u0003\u001aigB\u0005\u0004r9\u000b\t\u0011#\u0001\u0004t\u0019AQJTA\u0001\u0012\u0003\u0019)\bC\u0004\u00028\u001d#\ta! \t\u0013\r\u001dt)!A\u0005F\r%\u0004\"CB@\u000f\u0006\u0005I\u0011QBA\u0011%\u0019YiRA\u0001\n\u0003\u001bi\tC\u0005\u0004\u0018\u001e\u000b\t\u0011\"\u0003\u0004\u001a\ni\u0001JQ1tKJ+G.\u0019;j_:T!a\u0014)\u0002\u000bM\u0004\u0018M]6\u000b\u0005E\u0013\u0016!\u00025cCN,'BA*U\u0003\u0019A\u0017\rZ8pa*\u0011QKV\u0001\u0007CB\f7\r[3\u000b\u0003]\u000b1a\u001c:h\u0007\u0001\u0019b\u0001\u0001.dM&|\u0007CA.b\u001b\u0005a&BA/_\u0003\u001d\u0019x.\u001e:dKNT!a\u00181\u0002\u0007M\fHN\u0003\u0002P)&\u0011!\r\u0018\u0002\r\u0005\u0006\u001cXMU3mCRLwN\u001c\t\u00037\u0012L!!\u001a/\u0003%A\u0013XO\\3e\r&dG/\u001a:fIN\u001b\u0017M\u001c\t\u00037\u001eL!\u0001\u001b/\u0003%%s7/\u001a:uC\ndWMU3mCRLwN\u001c\t\u0003U6l\u0011a\u001b\u0006\u0002Y\u0006)1oY1mC&\u0011an\u001b\u0002\b!J|G-^2u!\tQ\u0007/\u0003\u0002rW\na1+\u001a:jC2L'0\u00192mK\u0006Q\u0001/\u0019:b[\u0016$XM]:\u0016\u0003Q\u0004B!\u001e?\u0000\u007f:\u0011aO\u001f\t\u0003o.l\u0011\u0001\u001f\u0006\u0003sb\u000ba\u0001\u0010:p_Rt\u0014BA>l\u0003\u0019\u0001&/\u001a3fM&\u0011QP \u0002\u0004\u001b\u0006\u0004(BA>l!\r)\u0018\u0011A\u0005\u0004\u0003\u0007q(AB*ue&tw-A\u0006qCJ\fW.\u001a;feN\u0004\u0003f\u0001\u0002\u0002\nA\u0019!.a\u0003\n\u0007\u000551NA\u0005ue\u0006t7/[3oi\u0006\u0019Ro]3s'B,7-\u001b4jK\u0012\u001c6\r[3nCV\u0011\u00111\u0003\t\u0006U\u0006U\u0011\u0011D\u0005\u0004\u0003/Y'AB(qi&|g\u000e\u0005\u0003\u0002\u001c\u0005\u0005RBAA\u000f\u0015\r\tyBX\u0001\u0006if\u0004Xm]\u0005\u0005\u0003G\tiB\u0001\u0006TiJ,8\r\u001e+za\u0016\fA#^:feN\u0003XmY5gS\u0016$7k\u00195f[\u0006\u0004\u0013AC:rY\u000e{g\u000e^3yiV\u0011\u00111\u0006\t\u0005\u0003[\ty#D\u0001_\u0013\r\t\tD\u0018\u0002\u000b'Fc5i\u001c8uKb$\u0018aC:rY\u000e{g\u000e^3yi\u0002B3ABA\u0005\u0003\u0019a\u0014N\\5u}Q1\u00111HA\"\u0003\u000b\"B!!\u0010\u0002BA\u0019\u0011q\b\u0001\u000e\u00039Cq!a\n\b\u0001\u0004\tY\u0003C\u0003s\u000f\u0001\u0007A\u000fC\u0004\u0002\u0010\u001d\u0001\r!a\u0005\u0002\r1|wmZ3s+\t\tY\u0005\u0005\u0003\u0002N\u0005MSBAA(\u0015\r\t\tFV\u0001\u0006g24GG[\u0005\u0005\u0003+\nyE\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!\u0003%!\u0018.\\3ti\u0006l\u0007/\u0006\u0002\u0002^A)!.!\u0006\u0002`A\u0019!.!\u0019\n\u0007\u0005\r4N\u0001\u0003M_:<\u0017A\u0003;j[\u0016\u001cH/Y7qA\u0005aQ.\u001b8US6,7\u000f^1na\u0006iQ.\u001b8US6,7\u000f^1na\u0002\nA\"\\1y)&lWm\u001d;b[B\fQ\"\\1y)&lWm\u001d;b[B\u0004\u0013aC7bqZ+'o]5p]N,\"!a\u001d\u0011\u000b)\f)\"!\u001e\u0011\u0007)\f9(C\u0002\u0002z-\u00141!\u00138u\u00031i\u0017\r\u001f,feNLwN\\:!\u00035iWM]4f)>d\u0015\r^3tiV\u0011\u0011\u0011\u0011\t\u0006U\u0006U\u00111\u0011\t\u0004U\u0006\u0015\u0015bAADW\n9!i\\8mK\u0006t\u0017AD7fe\u001e,Gk\u001c'bi\u0016\u001cH\u000fI\u0001\u000fK:\u001cw\u000eZ3s\u00072\u001ch*Y7f+\u0005y\u0018aD3oG>$WM]\"mg:\u000bW.\u001a\u0011\u0002\u000f\u0015t7m\u001c3feV\u0011\u0011Q\u0013\t\u0005\u0003/\u000bi*\u0004\u0002\u0002\u001a*\u0019\u00111\u0014(\u0002\u0017\u0011\fG/Y:pkJ\u001cWm]\u0005\u0005\u0003?\u000bIJ\u0001\u0007CsR,7/\u00128d_\u0012,'/\u0001\u0005f]\u000e|G-\u001a:!Q\r9\u0012\u0011B\u0001\bG\u0006$\u0018\r\\8h+\t\tI\u000b\u0005\u0003\u0002,\u0006EVBAAW\u0015\r\t\u0016q\u0016\u0006\u0004\u00037s\u0016\u0002BAZ\u0003[\u0013\u0011\u0003\u0013\"bg\u0016$\u0016M\u00197f\u0007\u0006$\u0018\r\\8h\u0003!\u0019\u0017\r^1m_\u001e\u0004\u0013!\u0003;bE2,g*Y7f\u0003!I7/T1q%\u0012\u0013UCAAB\u0003%I7/T1q%\u0012\u0013\u0005%A\bd_:4\u0017n\u001a*fg>,(oY3t\u0003A\u0019wN\u001c4jOJ+7o\\;sG\u0016\u001c\b%A\bvg\u0016D%)Y:f\u0007>tG/\u001a=u\u0003A)8/\u001a%CCN,7i\u001c8uKb$\b%A\fvg\u0016\u0004Vo\u001d5E_^t7i\u001c7v[:4\u0015\u000e\u001c;fe\u0006ARo]3QkNDGi\\<o\u0007>dW/\u001c8GS2$XM\u001d\u0011\u0002!\tdwnY6DC\u000eDW-\u00128bE2,\u0017!\u00052m_\u000e\\7)Y2iK\u0016s\u0017M\u00197fA\u0005I1-Y2iKNK'0Z\u000b\u0003\u0003k\n!bY1dQ\u0016\u001c\u0016N_3!\u0003!\u0011\u0017\r^2i\u001dVl\u0017!\u00032bi\u000eDg*^7!\u0003-\u0011W\u000f\\6HKR\u001c\u0016N_3\u0002\u0019\t,Hn[$fiNK'0\u001a\u0011\u0002\u0019!\u0014\u0017m]3D_:$X\r\u001f;\u0016\u0005\u0005\u0005\b\u0003BA \u0003GL1!!:O\u00051A%)Y:f\u0007>tG/\u001a=u\u00035A'-Y:f\u0007>tG/\u001a=uA\u0005YqO]1qa\u0016$7i\u001c8g+\t\ti\u000f\u0005\u0003\u0002\u0018\u0006=\u0018\u0002BAy\u00033\u0013\u0011dU3sS\u0006d\u0017N_1cY\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u0006aqO]1qa\u0016$7i\u001c8gA\u0005I\u0001NY1tK\u000e{gNZ\u000b\u0003\u0003s\u0004B!a?\u0003\u00025\u0011\u0011Q \u0006\u0004\u0003\u007f\u0014\u0016\u0001B2p]\u001aLAAa\u0001\u0002~\ni1i\u001c8gS\u001e,(/\u0019;j_:\faa]2iK6\fWCAA\r\u0003\u001d\u00198\r[3nC\u0002\n1b\u0019:fCR,G+\u00192mKR\u0011!q\u0002\t\u0004U\nE\u0011b\u0001B\nW\n!QK\\5u\u0003\u0019Ign]3siR1!q\u0002B\r\u0005wAqAa\u00074\u0001\u0004\u0011i\"\u0001\u0003eCR\f\u0007\u0003\u0002B\u0010\u0005kqAA!\t\u000329!!1\u0005B\u0018\u001d\u0011\u0011)C!\f\u000f\t\t\u001d\"1\u0006\b\u0004o\n%\u0012\"A,\n\u0005U3\u0016BA(U\u0013\ty\u0006-C\u0002\u00034y\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u00038\te\"!\u0003#bi\u00064%/Y7f\u0015\r\u0011\u0019D\u0018\u0005\b\u0005{\u0019\u0004\u0019AAB\u0003%yg/\u001a:xe&$X-A\u000bhKRLe\u000eZ3yK\u0012\u0004&o\u001c6fGRLwN\\:\u0015\t\t\r#q\f\t\u0007\u0005\u000b\u0012iEa\u0015\u000f\t\t\u001d#1\n\b\u0004o\n%\u0013\"\u00017\n\u0007\tM2.\u0003\u0003\u0003P\tE#aA*fc*\u0019!1G6\u0011\u000f)\u0014)F!\u0017\u0002v%\u0019!qK6\u0003\rQ+\b\u000f\\33!\u0011\tYKa\u0017\n\t\tu\u0013Q\u0016\u0002\u0006\r&,G\u000e\u001a\u0005\b\u0005C\"\u0004\u0019\u0001B2\u0003=\u0011X-];je\u0016$7i\u001c7v[:\u001c\b\u0003\u00026\u0003f}L1Aa\u001al\u0005\u0015\t%O]1z\u0003-\u0001\u0018M]:f%><8*Z=\u0015\r\t5$Q\u000fBA!\u0019)HP!\u0017\u0003pA\u0019!N!\u001d\n\u0007\tM4NA\u0002B]fDqAa\u001e6\u0001\u0004\u0011I(A\u0002s_^\u0004RA\u001bB3\u0005w\u00022A\u001bB?\u0013\r\u0011yh\u001b\u0002\u0005\u0005f$X\rC\u0004\u0003\u0004V\u0002\rA!\"\u0002\u0013-,\u0017PR5fY\u0012\u001c\bC\u0002B#\u0005\u001b\u0012I&A\u0005ck&dGMU8xgR1!1\u0012BL\u00057\u0003R!\u001eBG\u0005#K1Aa$\u007f\u0005\r\u0019V\r\u001e\t\u0005\u0003[\u0011\u0019*C\u0002\u0003\u0016z\u00131AU8x\u0011\u001d\u0011IJ\u000ea\u0001\u0005\u000b\u000baAZ5fY\u0012\u001c\bb\u0002BOm\u0001\u0007!qT\u0001\u0007e\u0016\u001cX\u000f\u001c;\u0011\t\t\u0005&qU\u0007\u0003\u0005GS1A!*Q\u0003\u0019\u0019G.[3oi&!!\u0011\u0016BR\u0005\u0019\u0011Vm];mi\u0006A!-^5mIJ{w\u000f\u0006\u0004\u0003\u0012\n=&\u0011\u0017\u0005\b\u00053;\u0004\u0019\u0001BC\u0011\u001d\u0011ij\u000ea\u0001\u0005?\u000b\u0011BY;jY\u0012\u001c6-\u00198\u0015\r\t]&1\u0019Bc!\u0019\u0011ILa0\u0003\u00126\u0011!1\u0018\u0006\u0004\u0005{\u0003\u0017a\u0001:eI&!!\u0011\u0019B^\u0005\r\u0011F\t\u0012\u0005\b\u0005CB\u0004\u0019\u0001B2\u0011\u001d\u00119\r\u000fa\u0001\u0005\u0013\fqAZ5mi\u0016\u00148\u000fE\u0003k\u0005K\u0012Y\rE\u0002\\\u0005\u001bL1Aa4]\u0005\u00191\u0015\u000e\u001c;fe\u0006y\"-^5mIB+8\u000f\u001b#po:\u0004&/\u001a3jG\u0006$Xm\u001d*fg>,(oY3\u0015\t\tU'\u0011\u001e\t\nU\n]'1\u001cBq\u0005OL1A!7l\u0005\u0019!V\u000f\u001d7fgA!\u0011q\bBo\u0013\r\u0011yN\u0014\u0002\r%><8*Z=GS2$XM\u001d\t\u0005\u0003\u007f\u0011\u0019/C\u0002\u0003f:\u0013a\u0003R=oC6L7\rT8hS\u000e,\u0005\u0010\u001d:fgNLwN\u001c\t\u0006U\n\u0015$\u0011\u0010\u0005\b\u0005\u000fL\u0004\u0019\u0001Be\u0003Q!(/\u00198tm\u0016\u00148/\u001a$jYR,'\u000f\u0016:fKRA!\u0011\u001dBx\u0005g\u001c9\u0001C\u0004\u0003rj\u0002\rAa7\u0002%A\f'/\u001a8u%><8*Z=GS2$XM\u001d\u0005\b\u0005kT\u0004\u0019\u0001B|\u0003)1\u0018\r\\;f\u0003J\u0014\u0018-\u001f\t\u0007\u0005s\u001c\u0019A!\u001f\u000e\u0005\tm(\u0002\u0002B\u007f\u0005\u007f\fq!\\;uC\ndWMC\u0002\u0004\u0002-\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0019)Aa?\u0003\u00175+H/\u00192mK2K7\u000f\u001e\u0005\b\u0007\u0013Q\u0004\u0019\u0001Bf\u0003\u00191\u0017\u000e\u001c;fe\u0006!1m\u001c9z)\u0019\u0019yaa\u0005\u0004\u0016Q!\u0011QHB\t\u0011\u001d\t9c\u000fa\u0001\u0003WAqA]\u001e\u0011\u0002\u0003\u0007A\u000fC\u0005\u0002\u0010m\u0002\n\u00111\u0001\u0002\u0014\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAB\u000eU\r!8QD\u0016\u0003\u0007?\u0001Ba!\t\u0004,5\u001111\u0005\u0006\u0005\u0007K\u00199#A\u0005v]\u000eDWmY6fI*\u00191\u0011F6\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004.\r\r\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAB\u001aU\u0011\t\u0019b!\b\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0019I\u0004\u0005\u0003\u0004<\r\u0015SBAB\u001f\u0015\u0011\u0019yd!\u0011\u0002\t1\fgn\u001a\u0006\u0003\u0007\u0007\nAA[1wC&!\u00111AB\u001f\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$BAa\u001c\u0004N!I1q\n!\u0002\u0002\u0003\u0007\u0011QO\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\rU\u0003CBB,\u00073\u0012y'\u0004\u0002\u0003\u0000&!11\fB\u0000\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\r5\u0011\r\u0005\n\u0007\u001f\u0012\u0015\u0011!a\u0001\u0005_\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003k\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0007s\ta!Z9vC2\u001cH\u0003BAB\u0007_B\u0011ba\u0014F\u0003\u0003\u0005\rAa\u001c\u0002\u001b!\u0013\u0015m]3SK2\fG/[8o!\r\tydR\n\u0005\u000f\u000e]t\u000eE\u0002k\u0007sJ1aa\u001fl\u0005\u0019\te.\u001f*fMR\u001111O\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0007\u0007\u001b9i!#\u0015\t\u0005u2Q\u0011\u0005\b\u0003OQ\u0005\u0019AA\u0016\u0011\u0015\u0011(\n1\u0001u\u0011\u001d\tyA\u0013a\u0001\u0003'\tq!\u001e8baBd\u0017\u0010\u0006\u0003\u0004\u0010\u000eM\u0005#\u00026\u0002\u0016\rE\u0005C\u00026\u0003VQ\f\u0019\u0002C\u0005\u0004\u0016.\u000b\t\u00111\u0001\u0002>\u0005\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u00077\u0003Baa\u000f\u0004\u001e&!1qTB\u001f\u0005\u0019y%M[3di\u0002")
public class HBaseRelation
extends BaseRelation
implements PrunedFilteredScan,
InsertableRelation,
Product,
scala.Serializable {
    private final transient Map<String, String> parameters;
    private final Option<StructType> userSpecifiedSchema;
    private final transient SQLContext sqlContext;
    private final Logger logger;
    private final Option<Object> timestamp;
    private final Option<Object> minTimestamp;
    private final Option<Object> maxTimestamp;
    private final Option<Object> maxVersions;
    private final Option<Object> mergeToLatest;
    private final String encoderClsName;
    private final transient BytesEncoder encoder;
    private final HBaseTableCatalog catalog;
    private final boolean isMapRDB;
    private final String configResources;
    private final boolean useHBaseContext;
    private final boolean usePushDownColumnFilter;
    private final boolean blockCacheEnable;
    private final int cacheSize;
    private final int batchNum;
    private final int bulkGetSize;
    private final HBaseContext hbaseContext;
    private final SerializableConfiguration wrappedConf;
    private final StructType schema;

    public static Option<Tuple2<Map<String, String>, Option<StructType>>> unapply(HBaseRelation hBaseRelation) {
        return HBaseRelation$.MODULE$.unapply(hBaseRelation);
    }

    public static HBaseRelation apply(Map<String, String> map, Option<StructType> option, SQLContext sQLContext) {
        return HBaseRelation$.MODULE$.apply(map, option, sQLContext);
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public Option<StructType> userSpecifiedSchema() {
        return this.userSpecifiedSchema;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public Logger logger() {
        return this.logger;
    }

    public Option<Object> timestamp() {
        return this.timestamp;
    }

    public Option<Object> minTimestamp() {
        return this.minTimestamp;
    }

    public Option<Object> maxTimestamp() {
        return this.maxTimestamp;
    }

    public Option<Object> maxVersions() {
        return this.maxVersions;
    }

    public Option<Object> mergeToLatest() {
        return this.mergeToLatest;
    }

    public String encoderClsName() {
        return this.encoderClsName;
    }

    public BytesEncoder encoder() {
        return this.encoder;
    }

    public HBaseTableCatalog catalog() {
        return this.catalog;
    }

    public String tableName() {
        return this.catalog().name();
    }

    public boolean isMapRDB() {
        return this.isMapRDB;
    }

    public String configResources() {
        return this.configResources;
    }

    public boolean useHBaseContext() {
        return this.useHBaseContext;
    }

    public boolean usePushDownColumnFilter() {
        return this.usePushDownColumnFilter;
    }

    public boolean blockCacheEnable() {
        return this.blockCacheEnable;
    }

    public int cacheSize() {
        return this.cacheSize;
    }

    public int batchNum() {
        return this.batchNum;
    }

    public int bulkGetSize() {
        return this.bulkGetSize;
    }

    public HBaseContext hbaseContext() {
        return this.hbaseContext;
    }

    public SerializableConfiguration wrappedConf() {
        return this.wrappedConf;
    }

    public Configuration hbaseConf() {
        return this.wrappedConf().value();
    }

    public StructType schema() {
        return this.schema;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createTable() {
        int numReg = BoxesRunTime.unboxToInt((Object)this.parameters().get((Object)HBaseTableCatalog$.MODULE$.newTable()).map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToInteger((int)HBaseRelation.$anonfun$createTable$1(x))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        byte[] startKey = Bytes.toBytes((String)((String)this.parameters().getOrElse((Object)HBaseTableCatalog$.MODULE$.regionStart(), (Function0 & Serializable & scala.Serializable)() -> HBaseTableCatalog$.MODULE$.defaultRegionStart())));
        byte[] endKey = Bytes.toBytes((String)((String)this.parameters().getOrElse((Object)HBaseTableCatalog$.MODULE$.regionEnd(), (Function0 & Serializable & scala.Serializable)() -> HBaseTableCatalog$.MODULE$.defaultRegionEnd())));
        if (numReg > 3) {
            TableName tName = TableName.valueOf((String)this.catalog().name());
            Iterable<String> cfs = this.catalog().getColumnFamilies();
            SmartConnection connection = HBaseConnectionCache$.MODULE$.getConnection(this.hbaseConf());
            Admin admin = connection.getAdmin();
            try {
                if (admin.isTableAvailable(tName)) return;
                HTableDescriptor tableDesc = new HTableDescriptor(tName);
                cfs.foreach((Function1 & Serializable & scala.Serializable)x -> {
                    HColumnDescriptor cf = new HColumnDescriptor(x.getBytes());
                    this.logger().debug(new StringBuilder(15).append("add family ").append((String)x).append(" to ").append(this.catalog().name()).toString());
                    this.maxVersions().foreach((Function1 & Serializable & scala.Serializable)x$1 -> cf.setMaxVersions(BoxesRunTime.unboxToInt((Object)x$1)));
                    return tableDesc.addFamily(cf);
                });
                byte[][] splitKeys = Bytes.split((byte[])startKey, (byte[])endKey, (int)numReg);
                admin.createTable(tableDesc, splitKeys);
                return;
            }
            finally {
                admin.close();
                connection.close();
            }
        } else {
            this.logger().info(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(70).append(HBaseTableCatalog$.MODULE$.newTable()).append("\n           |is not defined or no larger than 3, skip the create table").toString())).stripMargin());
        }
    }

    public void insert(Dataset<Row> data, boolean overwrite) {
        JobConf jobConfig = new JobConf(this.hbaseConf(), this.getClass());
        jobConfig.setOutputFormat(TableOutputFormat.class);
        jobConfig.set("hbase.mapred.outputtable", this.catalog().name());
        IntRef count = IntRef.create((int)0);
        Seq<Field> rkFields = this.catalog().getRowKey();
        Seq rkIdxedFields = (Seq)rkFields.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Field field = x0$1;
            Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)this.schema().fieldIndex(field.colName())), (Object)field);
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom());
        Tuple2[] colsIdxedFields = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.schema().fieldNames())).partition((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)HBaseRelation.$anonfun$insert$2(rkFields, x)))._2())).map((Function1 & Serializable & scala.Serializable)x -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)this.schema().fieldIndex(x)), (Object)this.catalog().getField((String)x)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        RDD rdd = data.rdd();
        RDD$.MODULE$.rddToPairRDDFunctions(rdd.map((Function1 & Serializable & scala.Serializable)x$14 -> this.convertToPut$1((Row)x$14, rkIdxedFields, colsIdxedFields, count), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(ImmutableBytesWritable.class), ClassTag$.MODULE$.apply(Put.class), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())).saveAsHadoopDataset(jobConfig);
    }

    public Seq<Tuple2<Field, Object>> getIndexedProjections(String[] requiredColumns) {
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredColumns)).map((Function1 & Serializable & scala.Serializable)x$15 -> this.catalog().sMap().getField((String)x$15), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Field.class))))).zipWithIndex(Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public Map<Field, Object> parseRowKey(byte[] row, Seq<Field> keyFields) {
        return ((TraversableOnce)((Tuple2)keyFields.foldLeft((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(state, field) -> {
            Tuple2 tuple2;
            int idx = state._1$mcI$sp();
            Seq parsed = (Seq)state._2();
            if (field.length() != -1) {
                Object value = Utils$.MODULE$.hbaseFieldToScalaType((Field)field, row, idx, field.length());
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)(idx + field.length())), parsed.$plus$plus((GenTraversableOnce)new .colon.colon((Object)new Tuple2(field, value), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom()));
            } else {
                Tuple2 tuple22;
                DataType dataType = field.dt();
                if (StringType$.MODULE$.equals(dataType)) {
                    Tuple2 tuple23;
                    int pos = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(row)).indexOf((Object)BoxesRunTime.boxToByte((byte)HBaseTableCatalog$.MODULE$.delimiter()), idx);
                    if (pos == -1 || pos > row.length) {
                        Object value = Utils$.MODULE$.hbaseFieldToScalaType((Field)field, row, idx, row.length);
                        tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)(row.length + 1)), parsed.$plus$plus((GenTraversableOnce)new .colon.colon((Object)new Tuple2(field, value), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom()));
                    } else {
                        Object value = Utils$.MODULE$.hbaseFieldToScalaType((Field)field, row, idx, pos - idx);
                        tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)pos), parsed.$plus$plus((GenTraversableOnce)new .colon.colon((Object)new Tuple2(field, value), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom()));
                    }
                    tuple22 = tuple23;
                } else {
                    tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)(row.length + 1)), parsed.$plus$plus((GenTraversableOnce)new .colon.colon((Object)new Tuple2(field, Utils$.MODULE$.hbaseFieldToScalaType((Field)field, row, idx, row.length)), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom()));
                }
                tuple2 = tuple22;
            }
            return tuple2;
        }))._2()).toMap(Predef$.MODULE$.$conforms());
    }

    public Set<Row> buildRows(Seq<Field> fields, Result result) {
        byte[] r = result.getRow();
        Map<Field, Object> keySeq = this.parseRowKey(r, this.catalog().getRowKey());
        Seq valueSeq = (Seq)((TraversableLike)fields.filter((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)HBaseRelation.$anonfun$buildRows$1(x$16)))).map((Function1 & Serializable & scala.Serializable)x -> {
            Buffer kvs = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(result.getColumnCells(Bytes.toBytes((String)x.cf()), Bytes.toBytes((String)x.col()))).asScala();
            return ((TraversableOnce)kvs.map((Function1 & Serializable & scala.Serializable)kv -> {
                byte[] v = CellUtil.cloneValue((Cell)kv);
                DataType dataType = x.dt();
                Object object = BinaryType$.MODULE$.equals(dataType) ? v : (Object)Utils$.MODULE$.hbaseFieldToScalaType((Field)x, v, 0, v.length);
                byte[] typedValue = object;
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)kv.getTimestamp()), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x), (Object)typedValue));
            }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }, Seq$.MODULE$.canBuildFrom());
        Set ts = (Set)valueSeq.foldLeft((Object)Predef$.MODULE$.Set().empty(), (Function2 & Serializable & scala.Serializable)(acc, map) -> (Set)acc.$plus$plus((GenTraversableOnce)map.keySet()));
        return (Set)((SetLike)ts.map((Function1 & Serializable & scala.Serializable)version -> keySeq.$plus$plus((GenTraversableOnce)((TraversableOnce)valueSeq.map((Function1 & Serializable & scala.Serializable)x$17 -> (Tuple2)x$17.apply((Object)BoxesRunTime.boxToLong((long)version)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())), Set$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)unioned -> Row$.MODULE$.fromSeq((Seq)fields.map((Function1 & Serializable & scala.Serializable)x$18 -> unioned.get(x$18).orNull(Predef$.MODULE$.$conforms()), Seq$.MODULE$.canBuildFrom())), Set$.MODULE$.canBuildFrom());
    }

    public Row buildRow(Seq<Field> fields, Result result) {
        byte[] r = result.getRow();
        Map<Field, Object> keySeq = this.parseRowKey(r, this.catalog().getRowKey());
        Map valueSeq = ((TraversableOnce)((TraversableLike)fields.filter((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)HBaseRelation.$anonfun$buildRow$1(x$19)))).map((Function1 & Serializable & scala.Serializable)x -> {
            Tuple2 tuple2;
            Cell kv = result.getColumnLatestCell(Bytes.toBytes((String)x.cf()), Bytes.toBytes((String)x.col()));
            if (kv == null || kv.getValueLength() == 0) {
                tuple2 = new Tuple2(x, null);
            } else {
                byte[] v = CellUtil.cloneValue((Cell)kv);
                DataType dataType = x.dt();
                Object object = BinaryType$.MODULE$.equals(dataType) ? v : (Object)Utils$.MODULE$.hbaseFieldToScalaType((Field)x, v, 0, v.length);
                Tuple2 tuple22 = new Tuple2(x, object);
                tuple2 = tuple22;
            }
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Map unionedRow = keySeq.$plus$plus((GenTraversableOnce)valueSeq);
        return Row$.MODULE$.fromSeq((Seq)fields.map((Function1 & Serializable & scala.Serializable)x$20 -> unionedRow.get(x$20).getOrElse((Function0 & Serializable & scala.Serializable)() -> null), Seq$.MODULE$.canBuildFrom()));
    }

    public RDD<Row> buildScan(String[] requiredColumns, Filter[] filters) {
        RDD resultRDD;
        block2: {
            RDD rdd;
            Tuple3<RowKeyFilter, DynamicLogicExpression, byte[][]> pushDownTuple = this.buildPushDownPredicatesResource(filters);
            RowKeyFilter pushDownRowKeyFilter = (RowKeyFilter)pushDownTuple._1();
            DynamicLogicExpression pushDownDynamicLogicExpression = (DynamicLogicExpression)pushDownTuple._2();
            byte[][] valueArray = (byte[][])pushDownTuple._3();
            if (!this.usePushDownColumnFilter()) {
                pushDownDynamicLogicExpression = null;
            }
            this.logger().debug(new StringBuilder(32).append("pushDownRowKeyFilter:           ").append(pushDownRowKeyFilter.ranges()).toString());
            if (pushDownDynamicLogicExpression != null) {
                this.logger().debug(new StringBuilder(32).append("pushDownDynamicLogicExpression: ").append(pushDownDynamicLogicExpression.toExpressionString()).toString());
            }
            this.logger().debug(new StringBuilder(32).append("valueArray:                     ").append(valueArray.length).toString());
            MutableList requiredQualifierDefinitionList = new MutableList();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredColumns)).foreach((Function1 & Serializable & scala.Serializable)c -> {
                Field field = this.catalog().getField((String)c);
                return requiredQualifierDefinitionList.$plus$eq((Object)field);
            });
            DefaultSourceStaticUtils$.MODULE$.populateLatestExecutionRules(pushDownRowKeyFilter, pushDownDynamicLogicExpression);
            ArrayList getList = new ArrayList();
            ArrayList rddList = new ArrayList();
            pushDownRowKeyFilter.points().foreach((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)HBaseRelation.$anonfun$buildScan$2(requiredQualifierDefinitionList, getList, p)));
            None$ pushDownFilterJava = this.usePushDownColumnFilter() && pushDownDynamicLogicExpression != null ? new Some((Object)new SparkSQLPushDownFilter(pushDownDynamicLogicExpression, valueArray, (MutableList<Field>)requiredQualifierDefinitionList, this.encoderClsName())) : None$.MODULE$;
            HBaseTableScanRDD hRdd = new HBaseTableScanRDD(this, this.hbaseContext(), (Option<SparkSQLPushDownFilter>)pushDownFilterJava, (Seq<Field>)requiredQualifierDefinitionList.seq());
            pushDownRowKeyFilter.points().foreach((Function1 & Serializable & scala.Serializable)x$21 -> {
                hRdd.addPoint(x$21);
                return BoxedUnit.UNIT;
            });
            pushDownRowKeyFilter.ranges().foreach((Function1 & Serializable & scala.Serializable)x$22 -> {
                hRdd.addRange(x$22);
                return BoxedUnit.UNIT;
            });
            RDD tmp = BoxesRunTime.unboxToBoolean((Object)this.mergeToLatest().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false)) ? hRdd.flatMap((Function1 & Serializable & scala.Serializable)r -> {
                Seq indexedFields = (Seq)this.getIndexedProjections(requiredColumns).map((Function1 & Serializable & scala.Serializable)x$23 -> (Field)x$23._1(), Seq$.MODULE$.canBuildFrom());
                return this.buildRows((Seq<Field>)indexedFields, (Result)r);
            }, ClassTag$.MODULE$.apply(Row.class)) : hRdd.map((Function1 & Serializable & scala.Serializable)r -> {
                Seq indexedFields = (Seq)this.getIndexedProjections(requiredColumns).map((Function1 & Serializable & scala.Serializable)x$24 -> (Field)x$24._1(), Seq$.MODULE$.canBuildFrom());
                return this.buildRow((Seq<Field>)indexedFields, (Result)r);
            }, ClassTag$.MODULE$.apply(Row.class));
            Object object = resultRDD = tmp.partitions().length > 0 ? tmp : null;
            if (resultRDD != null) break block2;
            Scan scan = new Scan();
            scan.setCacheBlocks(this.blockCacheEnable());
            scan.setBatch(this.batchNum());
            scan.setCaching(this.cacheSize());
            requiredQualifierDefinitionList.foreach((Function1 & Serializable & scala.Serializable)d -> scan.addColumn(d.cfBytes(), d.colBytes()));
            resultRDD = rdd = this.hbaseContext().hbaseRDD(TableName.valueOf((String)this.tableName()), scan).map((Function1 & Serializable & scala.Serializable)r -> {
                Seq indexedFields = (Seq)this.getIndexedProjections(requiredColumns).map((Function1 & Serializable & scala.Serializable)x$25 -> (Field)x$25._1(), Seq$.MODULE$.canBuildFrom());
                return this.buildRow((Seq<Field>)indexedFields, (Result)r._2());
            }, ClassTag$.MODULE$.apply(Row.class));
        }
        return resultRDD;
    }

    public Tuple3<RowKeyFilter, DynamicLogicExpression, byte[][]> buildPushDownPredicatesResource(Filter[] filters) {
        ObjectRef superRowKeyFilter = ObjectRef.create(null);
        MutableList queryValueList = new MutableList();
        ObjectRef superDynamicLogicExpression = ObjectRef.create(null);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filters)).foreach((Function1 & Serializable & scala.Serializable)f -> {
            Object object;
            RowKeyFilter rowKeyFilter = new RowKeyFilter(RowKeyFilter$.MODULE$.$lessinit$greater$default$1(), RowKeyFilter$.MODULE$.$lessinit$greater$default$2(), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4());
            DynamicLogicExpression logicExpression = this.transverseFilterTree(rowKeyFilter, (MutableList<byte[]>)queryValueList, (Filter)f);
            if ((DynamicLogicExpression)superDynamicLogicExpression$1.elem == null) {
                superDynamicLogicExpression$1.elem = logicExpression;
                superRowKeyFilter$1.elem = rowKeyFilter;
                object = BoxedUnit.UNIT;
            } else {
                superDynamicLogicExpression$1.elem = new AndLogicExpression((DynamicLogicExpression)superDynamicLogicExpression$1.elem, logicExpression);
                object = ((RowKeyFilter)superRowKeyFilter$1.elem).mergeIntersect(rowKeyFilter);
            }
            return object;
        });
        byte[][] queryValueArray = (byte[][])queryValueList.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        if ((RowKeyFilter)superRowKeyFilter.elem == null) {
            superRowKeyFilter.elem = new RowKeyFilter(RowKeyFilter$.MODULE$.$lessinit$greater$default$1(), RowKeyFilter$.MODULE$.$lessinit$greater$default$2(), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4());
        }
        return new Tuple3((Object)((RowKeyFilter)superRowKeyFilter.elem), (Object)((DynamicLogicExpression)superDynamicLogicExpression.elem), (Object)queryValueArray);
    }

    public DynamicLogicExpression transverseFilterTree(RowKeyFilter parentRowKeyFilter, MutableList<byte[]> valueArray, Filter filter) {
        DynamicLogicExpression dynamicLogicExpression;
        Filter filter2 = filter;
        if (filter2 instanceof EqualTo) {
            BoxedUnit boxedUnit;
            byte[] byArray;
            EqualTo equalTo = (EqualTo)filter2;
            String attr = equalTo.attribute();
            Object value = equalTo.value();
            Field field = this.catalog().getField(attr);
            Object object = value;
            byte[] byArray2 = object instanceof byte[] ? (byArray = (byte[])object) : DefaultSourceStaticUtils$.MODULE$.getByteValue(field, value.toString());
            byte[] byteValue = byArray2;
            if (field != null) {
                Object object2 = field.isRowKey() ? parentRowKeyFilter.mergeIntersect(new RowKeyFilter(byteValue, null, RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4())) : BoxedUnit.UNIT;
                boxedUnit = valueArray.$plus$eq((Object)byteValue);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            dynamicLogicExpression = new EqualLogicExpression(attr, valueArray.length() - 1, false);
        } else if (filter2 instanceof LessThan) {
            BoxedUnit boxedUnit;
            LessThan lessThan = (LessThan)filter2;
            String attr = lessThan.attribute();
            Object value = lessThan.value();
            Field field = this.catalog().getField(attr);
            if (field != null) {
                BoxedUnit boxedUnit2;
                if (field.isRowKey()) {
                    Option<BoundRanges> b = this.encoder().ranges(value);
                    BooleanRef inc = BooleanRef.create((boolean)false);
                    boxedUnit2 = b.map((Function1 & Serializable & scala.Serializable)x$26 -> (RowKeyFilter[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$26.less())).map((Function1 & Serializable & scala.Serializable)x -> {
                        void var2_2;
                        RowKeyFilter r = new RowKeyFilter(null, new ScanRange(x.upper(), inc$1.elem, x.low(), true), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4());
                        inc$1.elem = true;
                        return var2_2;
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RowKeyFilter.class)))).map((Function1 & Serializable & scala.Serializable)x -> (RowKeyFilter)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x)).reduce((Function2 & Serializable & scala.Serializable)(i, j) -> i.mergeUnion((RowKeyFilter)j))).map((Function1 & Serializable & scala.Serializable)x$27 -> parentRowKeyFilter.mergeIntersect((RowKeyFilter)x$27));
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                byte[] byteValue = this.encoder().encode(field.dt(), value);
                boxedUnit = valueArray.$plus$eq((Object)byteValue);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            dynamicLogicExpression = new LessThanLogicExpression(attr, valueArray.length() - 1);
        } else if (filter2 instanceof GreaterThan) {
            BoxedUnit boxedUnit;
            GreaterThan greaterThan = (GreaterThan)filter2;
            String attr = greaterThan.attribute();
            Object value = greaterThan.value();
            Field field = this.catalog().getField(attr);
            if (field != null) {
                BoxedUnit boxedUnit3;
                if (field.isRowKey()) {
                    Option<BoundRanges> b = this.encoder().ranges(value);
                    BooleanRef inc = BooleanRef.create((boolean)false);
                    boxedUnit3 = b.map((Function1 & Serializable & scala.Serializable)x$28 -> (RowKeyFilter[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$28.greater())).map((Function1 & Serializable & scala.Serializable)x -> {
                        void var2_2;
                        RowKeyFilter r = new RowKeyFilter(null, new ScanRange(x.upper(), true, x.low(), inc$2.elem), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4());
                        inc$2.elem = true;
                        return var2_2;
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RowKeyFilter.class)))).map((Function1 & Serializable & scala.Serializable)x -> (RowKeyFilter)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x)).reduce((Function2 & Serializable & scala.Serializable)(i, j) -> i.mergeUnion((RowKeyFilter)j))).map((Function1 & Serializable & scala.Serializable)x$29 -> parentRowKeyFilter.mergeIntersect((RowKeyFilter)x$29));
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                byte[] byteValue = this.encoder().encode(field.dt(), value);
                boxedUnit = valueArray.$plus$eq((Object)byteValue);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            dynamicLogicExpression = new GreaterThanLogicExpression(attr, valueArray.length() - 1);
        } else if (filter2 instanceof LessThanOrEqual) {
            BoxedUnit boxedUnit;
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter2;
            String attr = lessThanOrEqual.attribute();
            Object value = lessThanOrEqual.value();
            Field field = this.catalog().getField(attr);
            if (field != null) {
                BoxedUnit boxedUnit4;
                if (field.isRowKey()) {
                    Option<BoundRanges> b = this.encoder().ranges(value);
                    boxedUnit4 = b.map((Function1 & Serializable & scala.Serializable)x$30 -> (RowKeyFilter[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$30.less())).map((Function1 & Serializable & scala.Serializable)x -> new RowKeyFilter(null, new ScanRange(x.upper(), true, x.low(), true), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RowKeyFilter.class)))).map((Function1 & Serializable & scala.Serializable)x -> (RowKeyFilter)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x)).reduce((Function2 & Serializable & scala.Serializable)(i, j) -> i.mergeUnion((RowKeyFilter)j))).map((Function1 & Serializable & scala.Serializable)x$31 -> parentRowKeyFilter.mergeIntersect((RowKeyFilter)x$31));
                } else {
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                byte[] byteValue = this.encoder().encode(field.dt(), value);
                boxedUnit = valueArray.$plus$eq((Object)byteValue);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            dynamicLogicExpression = new LessThanOrEqualLogicExpression(attr, valueArray.length() - 1);
        } else if (filter2 instanceof GreaterThanOrEqual) {
            BoxedUnit boxedUnit;
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter2;
            String attr = greaterThanOrEqual.attribute();
            Object value = greaterThanOrEqual.value();
            Field field = this.catalog().getField(attr);
            if (field != null) {
                BoxedUnit boxedUnit5;
                if (field.isRowKey()) {
                    Option<BoundRanges> b = this.encoder().ranges(value);
                    boxedUnit5 = b.map((Function1 & Serializable & scala.Serializable)x$32 -> (RowKeyFilter[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$32.greater())).map((Function1 & Serializable & scala.Serializable)x -> new RowKeyFilter(null, new ScanRange(x.upper(), true, x.low(), true), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RowKeyFilter.class)))).map((Function1 & Serializable & scala.Serializable)x -> (RowKeyFilter)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x)).reduce((Function2 & Serializable & scala.Serializable)(i, j) -> i.mergeUnion((RowKeyFilter)j))).map((Function1 & Serializable & scala.Serializable)x$33 -> parentRowKeyFilter.mergeIntersect((RowKeyFilter)x$33));
                } else {
                    boxedUnit5 = BoxedUnit.UNIT;
                }
                byte[] byteValue = this.encoder().encode(field.dt(), value);
                boxedUnit = valueArray.$plus$eq((Object)byteValue);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            dynamicLogicExpression = new GreaterThanOrEqualLogicExpression(attr, valueArray.length() - 1);
        } else if (filter2 instanceof Or) {
            Or or = (Or)filter2;
            Filter left = or.left();
            Filter right = or.right();
            DynamicLogicExpression leftExpression = this.transverseFilterTree(parentRowKeyFilter, valueArray, left);
            RowKeyFilter rightSideRowKeyFilter = new RowKeyFilter(RowKeyFilter$.MODULE$.$lessinit$greater$default$1(), RowKeyFilter$.MODULE$.$lessinit$greater$default$2(), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4());
            DynamicLogicExpression rightExpression = this.transverseFilterTree(rightSideRowKeyFilter, valueArray, right);
            parentRowKeyFilter.mergeUnion(rightSideRowKeyFilter);
            dynamicLogicExpression = new OrLogicExpression(leftExpression, rightExpression);
        } else if (filter2 instanceof And) {
            And and = (And)filter2;
            Filter left = and.left();
            Filter right = and.right();
            DynamicLogicExpression leftExpression = this.transverseFilterTree(parentRowKeyFilter, valueArray, left);
            RowKeyFilter rightSideRowKeyFilter = new RowKeyFilter(RowKeyFilter$.MODULE$.$lessinit$greater$default$1(), RowKeyFilter$.MODULE$.$lessinit$greater$default$2(), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4());
            DynamicLogicExpression rightExpression = this.transverseFilterTree(rightSideRowKeyFilter, valueArray, right);
            parentRowKeyFilter.mergeIntersect(rightSideRowKeyFilter);
            dynamicLogicExpression = new AndLogicExpression(leftExpression, rightExpression);
        } else if (filter2 instanceof IsNull) {
            IsNull isNull = (IsNull)filter2;
            String attr = isNull.attribute();
            dynamicLogicExpression = new IsNullLogicExpression(attr, false);
        } else if (filter2 instanceof IsNotNull) {
            IsNotNull isNotNull = (IsNotNull)filter2;
            String attr = isNotNull.attribute();
            dynamicLogicExpression = new IsNullLogicExpression(attr, true);
        } else {
            dynamicLogicExpression = new PassThroughLogicExpression();
        }
        return dynamicLogicExpression;
    }

    public HBaseRelation copy(Map<String, String> parameters, Option<StructType> userSpecifiedSchema, SQLContext sqlContext) {
        return new HBaseRelation(parameters, userSpecifiedSchema, sqlContext);
    }

    public Map<String, String> copy$default$1() {
        return this.parameters();
    }

    public Option<StructType> copy$default$2() {
        return this.userSpecifiedSchema();
    }

    public String productPrefix() {
        return "HBaseRelation";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Map<String, String> map;
        int n = x$1;
        switch (n) {
            case 0: {
                map = this.parameters();
                break;
            }
            case 1: {
                map = this.userSpecifiedSchema();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return map;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HBaseRelation;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HBaseRelation)) return false;
        boolean bl = true;
        if (!bl) return false;
        HBaseRelation hBaseRelation = (HBaseRelation)((Object)x$1);
        Map<String, String> map = this.parameters();
        Map<String, String> map2 = hBaseRelation.parameters();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Option<StructType> option = this.userSpecifiedSchema();
        Option<StructType> option2 = hBaseRelation.userSpecifiedSchema();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!hBaseRelation.canEqual((Object)this)) return false;
        return true;
    }

    public static final /* synthetic */ long $anonfun$timestamp$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toLong();
    }

    public static final /* synthetic */ long $anonfun$minTimestamp$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toLong();
    }

    public static final /* synthetic */ long $anonfun$maxTimestamp$1(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).toLong();
    }

    public static final /* synthetic */ int $anonfun$maxVersions$1(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$mergeToLatest$1(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$useHBaseContext$1(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$blockCacheEnable$1(String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7)).toBoolean();
    }

    public static final /* synthetic */ int $anonfun$cacheSize$1(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).toInt();
    }

    public static final /* synthetic */ int $anonfun$batchNum$1(String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$9)).toInt();
    }

    public static final /* synthetic */ int $anonfun$bulkGetSize$1(String x$10) {
        return new StringOps(Predef$.MODULE$.augmentString(x$10)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$hbaseContext$1(String x$11) {
        return !x$11.isEmpty();
    }

    public static final /* synthetic */ int $anonfun$createTable$1(String x) {
        return new StringOps(Predef$.MODULE$.augmentString(x)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$insert$2(Seq rkFields$1, String x) {
        return ((SeqLike)rkFields$1.map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.colName(), Seq$.MODULE$.canBuildFrom())).contains((Object)x);
    }

    public static final /* synthetic */ int $anonfun$insert$6(int x0$2, byte[] x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$2), (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int x = tuple2._1$mcI$sp();
        byte[] y = (byte[])tuple2._2();
        int n = x + y.length;
        return n;
    }

    public static final /* synthetic */ void $anonfun$insert$7(byte[] rBytes$1, IntRef offset$1, byte[] x) {
        System.arraycopy(x, 0, rBytes$1, offset$1.elem, x.length);
        offset$1.elem += x.length;
    }

    public static final /* synthetic */ Put $anonfun$insert$9(byte[] rBytes$1, long x$13) {
        return new Put(rBytes$1, x$13);
    }

    private final Tuple2 convertToPut$1(Row row, Seq rkIdxedFields$1, Tuple2[] colsIdxedFields$1, IntRef count$1) {
        Seq rowBytes = (Seq)rkIdxedFields$1.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int x = tuple2._1$mcI$sp();
            Field y = (Field)tuple2._2();
            byte[] byArray = Utils$.MODULE$.toBytes(row.apply(x), y);
            return byArray;
        }, Seq$.MODULE$.canBuildFrom());
        int rLen = BoxesRunTime.unboxToInt((Object)rowBytes.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(x0$2, x1$1) -> BoxesRunTime.boxToInteger((int)HBaseRelation.$anonfun$insert$6(BoxesRunTime.unboxToInt((Object)x0$2), x1$1))));
        byte[] rBytes = new byte[rLen];
        IntRef offset = IntRef.create((int)0);
        rowBytes.foreach((Function1 & Serializable & scala.Serializable)x -> {
            HBaseRelation.$anonfun$insert$7(rBytes, offset, x);
            return BoxedUnit.UNIT;
        });
        Put put = (Put)this.timestamp().fold((Function0 & Serializable & scala.Serializable)() -> new Put(rBytes), (Function1 & Serializable & scala.Serializable)x$13 -> HBaseRelation.$anonfun$insert$9(rBytes, BoxesRunTime.unboxToLong((Object)x$13)));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])colsIdxedFields$1)).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int x = tuple2._1$mcI$sp();
            Field y = (Field)tuple2._2();
            byte[] b = Utils$.MODULE$.toBytes(row.apply(x), y);
            Put put = put.addColumn(Bytes.toBytes((String)y.cf()), Bytes.toBytes((String)y.col()), b);
            return put;
        });
        ++count$1.elem;
        return new Tuple2((Object)new ImmutableBytesWritable(), (Object)put);
    }

    public static final /* synthetic */ boolean $anonfun$buildRows$1(Field x$16) {
        return !x$16.isRowKey();
    }

    public static final /* synthetic */ boolean $anonfun$buildRow$1(Field x$19) {
        return !x$19.isRowKey();
    }

    public static final /* synthetic */ boolean $anonfun$buildScan$2(MutableList requiredQualifierDefinitionList$1, ArrayList getList$1, byte[] p) {
        Get get = new Get(p);
        requiredQualifierDefinitionList$1.foreach((Function1 & Serializable & scala.Serializable)d -> d.isRowKey() ? get.addColumn(d.cfBytes(), d.colBytes()) : BoxedUnit.UNIT);
        return getList$1.add(get);
    }

    public HBaseRelation(Map<String, String> parameters, Option<StructType> userSpecifiedSchema, SQLContext sqlContext) {
        HBaseContext hBaseContext;
        this.parameters = parameters;
        this.userSpecifiedSchema = userSpecifiedSchema;
        this.sqlContext = sqlContext;
        Product.$init$((Product)this);
        this.logger = LoggerFactory.getLogger(HBaseRelation.class);
        this.timestamp = parameters.get((Object)HBaseSparkConf$.MODULE$.TIMESTAMP()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)HBaseRelation.$anonfun$timestamp$1(x$1)));
        this.minTimestamp = parameters.get((Object)HBaseSparkConf$.MODULE$.MIN_TIMESTAMP()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)HBaseRelation.$anonfun$minTimestamp$1(x$2)));
        this.maxTimestamp = parameters.get((Object)HBaseSparkConf$.MODULE$.MAX_TIMESTAMP()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)HBaseRelation.$anonfun$maxTimestamp$1(x$3)));
        this.maxVersions = parameters.get((Object)HBaseSparkConf$.MODULE$.MAX_VERSIONS()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)HBaseRelation.$anonfun$maxVersions$1(x$4)));
        this.mergeToLatest = parameters.get((Object)HBaseSparkConf$.MODULE$.MERGE_TO_LATEST()).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)HBaseRelation.$anonfun$mergeToLatest$1(x$5)));
        this.encoderClsName = (String)parameters.getOrElse((Object)HBaseSparkConf$.MODULE$.ENCODER(), (Function0 & Serializable & scala.Serializable)() -> HBaseSparkConf$.MODULE$.defaultEncoder());
        this.encoder = JavaBytesEncoder$.MODULE$.create(this.encoderClsName());
        this.catalog = HBaseTableCatalog$.MODULE$.apply(parameters);
        this.isMapRDB = this.tableName().startsWith("/");
        this.configResources = (String)parameters.getOrElse((Object)HBaseSparkConf$.MODULE$.HBASE_CONFIG_RESOURCES_LOCATIONS(), (Function0 & Serializable & scala.Serializable)() -> "");
        this.useHBaseContext = parameters.get((Object)HBaseSparkConf$.MODULE$.USE_HBASE_CONTEXT()).forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)HBaseRelation.$anonfun$useHBaseContext$1(x$6)));
        this.usePushDownColumnFilter = new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)HBaseSparkConf$.MODULE$.PUSH_DOWN_COLUMN_FILTER(), (Function0 & Serializable & scala.Serializable)() -> this.isMapRDB() ? HBaseSparkConf$.MODULE$.maprDbDefaultPushDownColumnFilter() : HBaseSparkConf$.MODULE$.defaultPushDownColumnFilter()))).toBoolean();
        this.blockCacheEnable = BoxesRunTime.unboxToBoolean((Object)parameters.get((Object)HBaseSparkConf$.MODULE$.BLOCK_CACHE_ENABLE()).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)HBaseRelation.$anonfun$blockCacheEnable$1(x$7))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.sqlContext().sparkContext().getConf().getBoolean(HBaseSparkConf$.MODULE$.BLOCK_CACHE_ENABLE(), HBaseSparkConf$.MODULE$.defaultBlockCacheEnable())));
        this.cacheSize = BoxesRunTime.unboxToInt((Object)parameters.get((Object)HBaseSparkConf$.MODULE$.CACHE_SIZE()).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)HBaseRelation.$anonfun$cacheSize$1(x$8))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.sqlContext().sparkContext().getConf().getInt(HBaseSparkConf$.MODULE$.CACHE_SIZE(), HBaseSparkConf$.MODULE$.defaultCachingSize())));
        this.batchNum = BoxesRunTime.unboxToInt((Object)parameters.get((Object)HBaseSparkConf$.MODULE$.BATCH_NUM()).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)HBaseRelation.$anonfun$batchNum$1(x$9))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.sqlContext().sparkContext().getConf().getInt(HBaseSparkConf$.MODULE$.BATCH_NUM(), HBaseSparkConf$.MODULE$.defaultBatchNum())));
        this.bulkGetSize = BoxesRunTime.unboxToInt((Object)parameters.get((Object)HBaseSparkConf$.MODULE$.BULKGET_SIZE()).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)HBaseRelation.$anonfun$bulkGetSize$1(x$10))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.sqlContext().sparkContext().getConf().getInt(HBaseSparkConf$.MODULE$.BULKGET_SIZE(), HBaseSparkConf$.MODULE$.defaultBulkGetSize())));
        if (this.useHBaseContext() && LatestHBaseContextCache$.MODULE$.latest().isDefined()) {
            hBaseContext = (HBaseContext)LatestHBaseContextCache$.MODULE$.latest().get();
        } else {
            Configuration config = HBaseConfiguration.create();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.configResources().split(","))).filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)HBaseRelation.$anonfun$hbaseContext$1(x$11))))).foreach((Function1 & Serializable & scala.Serializable)r -> {
                config.addResource(r);
                return BoxedUnit.UNIT;
            });
            hBaseContext = new HBaseContext(sqlContext.sparkContext(), config, HBaseContext$.MODULE$.$lessinit$greater$default$3());
        }
        this.hbaseContext = hBaseContext;
        this.wrappedConf = new SerializableConfiguration(this.hbaseContext().config());
        this.schema = (StructType)userSpecifiedSchema.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.catalog().toDataType());
    }
}

