/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.spark.JavaHBaseContext;
import org.apache.hadoop.hbase.spark.example.hbasecontext.JavaHBaseBulkDeleteExample;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import scala.Tuple2;

@Category(value={MediumTests.class})
public class TestJavaHBaseContext
implements Serializable {
    private transient JavaSparkContext jsc;
    HBaseTestingUtility htu;
    protected static final Log LOG = LogFactory.getLog(TestJavaHBaseContext.class);
    byte[] tableName = Bytes.toBytes((String)"t1");
    byte[] columnFamily = Bytes.toBytes((String)"c");
    String columnFamilyStr = Bytes.toString((byte[])this.columnFamily);

    @Before
    public void setUp() {
        this.jsc = new JavaSparkContext("local", "JavaHBaseContextSuite");
        this.jsc.addJar("spark.jar");
        File tempDir = Files.createTempDir();
        tempDir.deleteOnExit();
        this.htu = HBaseTestingUtility.createLocalHTU();
        try {
            LOG.info((Object)"cleaning up test dir");
            this.htu.cleanupTestDir();
            LOG.info((Object)"starting minicluster");
            this.htu.startMiniZKCluster();
            this.htu.startMiniHBaseCluster(1, 1);
            LOG.info((Object)" - minicluster started");
            try {
                this.htu.deleteTable(TableName.valueOf((byte[])this.tableName));
            }
            catch (Exception e) {
                LOG.info((Object)(" - no table " + Bytes.toString((byte[])this.tableName) + " found"));
            }
            LOG.info((Object)(" - creating table " + Bytes.toString((byte[])this.tableName)));
            this.htu.createTable(TableName.valueOf((byte[])this.tableName), this.columnFamily);
            LOG.info((Object)" - created table");
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @After
    public void tearDown() {
        try {
            this.htu.deleteTable(TableName.valueOf((byte[])this.tableName));
            LOG.info((Object)"shuting down minicluster");
            this.htu.shutdownMiniHBaseCluster();
            this.htu.shutdownMiniZKCluster();
            LOG.info((Object)" - minicluster shut down");
            this.htu.cleanupTestDir();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.jsc.stop();
        this.jsc = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBulkPut() throws IOException {
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        list.add((CallSite)((Object)("1," + this.columnFamilyStr + ",a,1")));
        list.add((CallSite)((Object)("2," + this.columnFamilyStr + ",a,2")));
        list.add((CallSite)((Object)("3," + this.columnFamilyStr + ",a,3")));
        list.add((CallSite)((Object)("4," + this.columnFamilyStr + ",a,4")));
        list.add((CallSite)((Object)("5," + this.columnFamilyStr + ",a,5")));
        JavaRDD rdd = this.jsc.parallelize(list);
        Configuration conf = this.htu.getConfiguration();
        JavaHBaseContext hbaseContext = new JavaHBaseContext(this.jsc, conf);
        Connection conn = ConnectionFactory.createConnection((Configuration)conf);
        try (Table table = conn.getTable(TableName.valueOf((byte[])this.tableName));){
            ArrayList<Delete> deletes = new ArrayList<Delete>();
            for (int i = 1; i < 6; ++i) {
                deletes.add(new Delete(Bytes.toBytes((String)Integer.toString(i))));
            }
            table.delete(deletes);
        }
        hbaseContext.bulkPut(rdd, TableName.valueOf((byte[])this.tableName), (Function)new PutFunction());
        table = conn.getTable(TableName.valueOf((byte[])this.tableName));
        try {
            Result result1 = table.get(new Get(Bytes.toBytes((String)"1")));
            Assert.assertNotNull((String)"Row 1 should had been deleted", (Object)result1.getRow());
            Result result2 = table.get(new Get(Bytes.toBytes((String)"2")));
            Assert.assertNotNull((String)"Row 2 should had been deleted", (Object)result2.getRow());
            Result result3 = table.get(new Get(Bytes.toBytes((String)"3")));
            Assert.assertNotNull((String)"Row 3 should had been deleted", (Object)result3.getRow());
            Result result4 = table.get(new Get(Bytes.toBytes((String)"4")));
            Assert.assertNotNull((String)"Row 4 should had been deleted", (Object)result4.getRow());
            Result result5 = table.get(new Get(Bytes.toBytes((String)"5")));
            Assert.assertNotNull((String)"Row 5 should had been deleted", (Object)result5.getRow());
        }
        finally {
            table.close();
            conn.close();
        }
    }

    @Test
    public void testBulkDelete() throws IOException {
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        list.add(Bytes.toBytes((String)"1"));
        list.add(Bytes.toBytes((String)"2"));
        list.add(Bytes.toBytes((String)"3"));
        JavaRDD rdd = this.jsc.parallelize(list);
        Configuration conf = this.htu.getConfiguration();
        this.populateTableWithMockData(conf, TableName.valueOf((byte[])this.tableName));
        JavaHBaseContext hbaseContext = new JavaHBaseContext(this.jsc, conf);
        hbaseContext.bulkDelete(rdd, TableName.valueOf((byte[])this.tableName), (Function)new JavaHBaseBulkDeleteExample.DeleteFunction(), Integer.valueOf(2));
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
             Table table = conn.getTable(TableName.valueOf((byte[])this.tableName));){
            Result result1 = table.get(new Get(Bytes.toBytes((String)"1")));
            Assert.assertNull((String)"Row 1 should had been deleted", (Object)result1.getRow());
            Result result2 = table.get(new Get(Bytes.toBytes((String)"2")));
            Assert.assertNull((String)"Row 2 should had been deleted", (Object)result2.getRow());
            Result result3 = table.get(new Get(Bytes.toBytes((String)"3")));
            Assert.assertNull((String)"Row 3 should had been deleted", (Object)result3.getRow());
            Result result4 = table.get(new Get(Bytes.toBytes((String)"4")));
            Assert.assertNotNull((String)"Row 4 should had been deleted", (Object)result4.getRow());
            Result result5 = table.get(new Get(Bytes.toBytes((String)"5")));
            Assert.assertNotNull((String)"Row 5 should had been deleted", (Object)result5.getRow());
        }
    }

    @Test
    public void testDistributedScan() throws IOException {
        Configuration conf = this.htu.getConfiguration();
        this.populateTableWithMockData(conf, TableName.valueOf((byte[])this.tableName));
        JavaHBaseContext hbaseContext = new JavaHBaseContext(this.jsc, conf);
        Scan scan = new Scan();
        scan.setCaching(100);
        JavaRDD javaRdd = hbaseContext.hbaseRDD(TableName.valueOf((byte[])this.tableName), scan).map((Function)new ScanConvertFunction());
        List results = javaRdd.collect();
        Assert.assertEquals((long)results.size(), (long)5L);
    }

    @Test
    public void testBulkGet() throws IOException {
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        list.add(Bytes.toBytes((String)"1"));
        list.add(Bytes.toBytes((String)"2"));
        list.add(Bytes.toBytes((String)"3"));
        list.add(Bytes.toBytes((String)"4"));
        list.add(Bytes.toBytes((String)"5"));
        JavaRDD rdd = this.jsc.parallelize(list);
        Configuration conf = this.htu.getConfiguration();
        this.populateTableWithMockData(conf, TableName.valueOf((byte[])this.tableName));
        JavaHBaseContext hbaseContext = new JavaHBaseContext(this.jsc, conf);
        JavaRDD stringJavaRDD = hbaseContext.bulkGet(TableName.valueOf((byte[])this.tableName), Integer.valueOf(2), rdd, (Function)new GetFunction(), (Function)new ResultFunction());
        Assert.assertEquals((long)stringJavaRDD.count(), (long)5L);
    }

    private void populateTableWithMockData(Configuration conf, TableName tableName) throws IOException {
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
             Table table = conn.getTable(tableName);){
            ArrayList<Put> puts = new ArrayList<Put>();
            for (int i = 1; i < 6; ++i) {
                Put put = new Put(Bytes.toBytes((String)Integer.toString(i)));
                put.addColumn(this.columnFamily, this.columnFamily, this.columnFamily);
                puts.add(put);
            }
            table.put(puts);
        }
    }

    public static class ResultFunction
    implements Function<Result, String> {
        private static final long serialVersionUID = 1L;

        public String call(Result result) throws Exception {
            Iterator it = result.listCells().iterator();
            StringBuilder b = new StringBuilder();
            b.append(Bytes.toString((byte[])result.getRow())).append(":");
            while (it.hasNext()) {
                Cell cell = (Cell)it.next();
                String q = Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)cell));
                if ("counter".equals(q)) {
                    b.append("(").append(q).append(",").append(Bytes.toLong((byte[])CellUtil.cloneValue((Cell)cell))).append(")");
                    continue;
                }
                b.append("(").append(q).append(",").append(Bytes.toString((byte[])CellUtil.cloneValue((Cell)cell))).append(")");
            }
            return b.toString();
        }
    }

    public static class GetFunction
    implements Function<byte[], Get> {
        private static final long serialVersionUID = 1L;

        public Get call(byte[] v) throws Exception {
            return new Get(v);
        }
    }

    private static class ScanConvertFunction
    implements Function<Tuple2<ImmutableBytesWritable, Result>, String> {
        private ScanConvertFunction() {
        }

        public String call(Tuple2<ImmutableBytesWritable, Result> v1) throws Exception {
            return Bytes.toString((byte[])((ImmutableBytesWritable)v1._1()).copyBytes());
        }
    }

    public static class PutFunction
    implements Function<String, Put> {
        private static final long serialVersionUID = 1L;

        public Put call(String v) throws Exception {
            String[] cells = v.split(",");
            Put put = new Put(Bytes.toBytes((String)cells[0]));
            put.addColumn(Bytes.toBytes((String)cells[1]), Bytes.toBytes((String)cells[2]), Bytes.toBytes((String)cells[3]));
            return put;
        }
    }
}

