/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark;

import java.io.Serializable;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.spark.DefaultSourceStaticUtils$;
import org.apache.hadoop.hbase.spark.FilterRangeRecord;
import org.apache.hadoop.hbase.spark.FilterRangeRecord$;
import org.apache.hadoop.hbase.spark.HBaseContext;
import org.apache.hadoop.hbase.spark.HBaseContext$;
import org.apache.hadoop.hbase.spark.PartitionFilterSuite$;
import org.apache.hadoop.hbase.spark.datasources.HBaseSparkConf$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.datasources.hbase.HBaseTableCatalog$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.FunSuite;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00055d\u0001B\r\u001b\u0001\u0015BQA\r\u0001\u0005\u0002MBqA\u000e\u0001C\u0002\u0013\u0005q\u0007\u0003\u0004?\u0001\u0001\u0006I\u0001\u000f\u0005\b\u007f\u0001\u0001\r\u0011\"\u0001A\u0011\u001d1\u0005\u00011A\u0005\u0002\u001dCa\u0001\u0015\u0001!B\u0013\t\u0005bB+\u0001\u0001\u0004%\tA\u0016\u0005\b7\u0002\u0001\r\u0011\"\u0001]\u0011\u0019q\u0006\u0001)Q\u0005/\"9q\f\u0001a\u0001\n\u0003\u0001\u0007bB4\u0001\u0001\u0004%\t\u0001\u001b\u0005\u0007U\u0002\u0001\u000b\u0015B1\t\u000f-\u0004\u0001\u0019!C\u0001Y\"Aq\u0010\u0001a\u0001\n\u0003\t\t\u0001C\u0004\u0002\u0006\u0001\u0001\u000b\u0015B7\t\u000f\u0005\u001d\u0001\u0001\"\u0001\u0002\n!9\u0011q\u0004\u0001\u0005B\u0005\u0005\u0002bBA\u0012\u0001\u0011\u0005\u0013\u0011\u0005\u0005\b\u0003K\u0001A\u0011IA\u0011\u0011%\t9\u0003\u0001b\u0001\n\u0003\tI\u0003\u0003\u0005\u0002B\u0001\u0001\u000b\u0011BA\u0016\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003\u000bB\u0011\"a\u001a\u0001\u0005\u0004%\t!!\u001b\t\u0011\u0005-\u0004\u0001)A\u0005\u0003\u001f\u0011A\u0003U1si&$\u0018n\u001c8GS2$XM]*vSR,'BA\u000e\u001d\u0003\u0015\u0019\b/\u0019:l\u0015\tib$A\u0003iE\u0006\u001cXM\u0003\u0002 A\u00051\u0001.\u00193p_BT!!\t\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0013aA8sO\u000e\u00011\u0003\u0002\u0001'Y=\u0002\"a\n\u0016\u000e\u0003!R!!\u000b\u0012\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018BA\u0016)\u0005!1UO\\*vSR,\u0007CA\u0014.\u0013\tq\u0003F\u0001\nCK\u001a|'/Z!oI\u00063G/\u001a:FC\u000eD\u0007CA\u00141\u0013\t\t\u0004FA\tCK\u001a|'/Z!oI\u00063G/\u001a:BY2\fa\u0001P5oSRtD#\u0001\u001b\u0011\u0005U\u0002Q\"\u0001\u000e\u0002\r1|wmZ3s+\u0005A\u0004CA\u001d=\u001b\u0005Q$BA\u001e#\u0003\u0015\u0019HN\u001a\u001bk\u0013\ti$H\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!\u0003\t\u00198-F\u0001B!\t\u0011E)D\u0001D\u0015\tY\u0002%\u0003\u0002F\u0007\na1\u000b]1sW\u000e{g\u000e^3yi\u000611oY0%KF$\"\u0001\u0013(\u0011\u0005%cU\"\u0001&\u000b\u0003-\u000bQa]2bY\u0006L!!\u0014&\u0003\tUs\u0017\u000e\u001e\u0005\b\u001f\u0016\t\t\u00111\u0001B\u0003\rAH%M\u0001\u0004g\u000e\u0004\u0003F\u0001\u0004S!\tI5+\u0003\u0002U\u0015\nIAO]1og&,g\u000e^\u0001\n)\u0016\u001bFkX+U\u00132+\u0012a\u0016\t\u00031fk\u0011\u0001H\u0005\u00035r\u00111\u0003\u0013\"bg\u0016$Vm\u001d;j]\u001e,F/\u001b7jif\fQ\u0002V#T)~+F+\u0013'`I\u0015\fHC\u0001%^\u0011\u001dy\u0005\"!AA\u0002]\u000b!\u0002V#T)~+F+\u0013'!\u0003)\u0019\u0018\u000f\\\"p]R,\u0007\u0010^\u000b\u0002CB\u0011!-Z\u0007\u0002G*\u0011AmQ\u0001\u0004gFd\u0017B\u00014d\u0005)\u0019\u0016\u000bT\"p]R,\u0007\u0010^\u0001\u000fgFd7i\u001c8uKb$x\fJ3r)\tA\u0015\u000eC\u0004P\u0017\u0005\u0005\t\u0019A1\u0002\u0017M\fHnQ8oi\u0016DH\u000fI\u0001\u0003I\u001a,\u0012!\u001c\t\u0003]rt!a\u001c>\u000f\u0005ALhBA9y\u001d\t\u0011xO\u0004\u0002tm6\tAO\u0003\u0002vI\u00051AH]8pizJ\u0011aI\u0005\u0003C\tJ!a\u0007\u0011\n\u0005\u0011\u001c\u0015BA>d\u0003\u001d\u0001\u0018mY6bO\u0016L!! @\u0003\u0013\u0011\u000bG/\u0019$sC6,'BA>d\u0003\u0019!gm\u0018\u0013fcR\u0019\u0001*a\u0001\t\u000f=s\u0011\u0011!a\u0001[\u0006\u0019AM\u001a\u0011\u0002\u0017]LG\u000f[\"bi\u0006dwn\u001a\u000b\u0004[\u0006-\u0001bBA\u0007!\u0001\u0007\u0011qB\u0001\u0004G\u0006$\b\u0003BA\t\u00033qA!a\u0005\u0002\u0016A\u00111OS\u0005\u0004\u0003/Q\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002\u001c\u0005u!AB*ue&twMC\u0002\u0002\u0018)\u000b\u0011BY3g_J,\u0017\t\u001c7\u0015\u0003!\u000b\u0001\"\u00194uKJ\fE\u000e\\\u0001\u000bE\u00164wN]3FC\u000eD\u0017!\u0003:boJ+7/\u001e7u+\t\tY\u0003\u0005\u0004\u0002.\u0005]\u00121H\u0007\u0003\u0003_QA!!\r\u00024\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003kQ\u0015AC2pY2,7\r^5p]&!\u0011\u0011HA\u0018\u0005)Ie\u000eZ3yK\u0012\u001cV-\u001d\t\u0004k\u0005u\u0012bAA 5\t\tb)\u001b7uKJ\u0014\u0016M\\4f%\u0016\u001cwN\u001d3\u0002\u0015I\fwOU3tk2$\b%\u0001\u0007d_2dWm\u0019;U_N+G/\u0006\u0003\u0002H\u0005MC\u0003BA%\u0003K\u0002b!!\u0005\u0002L\u0005=\u0013\u0002BA'\u0003;\u00111aU3u!\u0011\t\t&a\u0015\r\u0001\u00119\u0011Q\u000b\fC\u0002\u0005]#!\u0001+\u0012\t\u0005e\u0013q\f\t\u0004\u0013\u0006m\u0013bAA/\u0015\n9aj\u001c;iS:<\u0007cA%\u0002b%\u0019\u00111\r&\u0003\u0007\u0005s\u0017\u0010C\u0003l-\u0001\u0007Q.A\u0004dCR\fGn\\4\u0016\u0005\u0005=\u0011\u0001C2bi\u0006dwn\u001a\u0011")
public class PartitionFilterSuite
extends FunSuite
implements BeforeAndAfterEach,
BeforeAndAfterAll {
    private final Logger logger;
    private transient SparkContext sc;
    private HBaseTestingUtility TEST_UTIL;
    private SQLContext sqlContext;
    private Dataset<Row> df;
    private final IndexedSeq<FilterRangeRecord> rawResult;
    private final String catalog;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    public /* synthetic */ Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.run$((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return FunSuiteLike.runTest$((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public void afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public Logger logger() {
        return this.logger;
    }

    public SparkContext sc() {
        return this.sc;
    }

    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    public HBaseTestingUtility TEST_UTIL() {
        return this.TEST_UTIL;
    }

    public void TEST_UTIL_$eq(HBaseTestingUtility x$1) {
        this.TEST_UTIL = x$1;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    public Dataset<Row> df() {
        return this.df;
    }

    public void df_$eq(Dataset<Row> x$1) {
        this.df = x$1;
    }

    public Dataset<Row> withCatalog(String cat) {
        return this.sqlContext().read().options((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HBaseTableCatalog$.MODULE$.tableCatalog()), (Object)cat)}))).format("org.apache.hadoop.hbase.spark").load();
    }

    public void beforeAll() {
        this.TEST_UTIL().startMiniCluster();
        SparkConf sparkConf = new SparkConf();
        sparkConf.set(HBaseSparkConf$.MODULE$.BLOCK_CACHE_ENABLE(), "true");
        sparkConf.set(HBaseSparkConf$.MODULE$.BATCH_NUM(), "100");
        sparkConf.set(HBaseSparkConf$.MODULE$.CACHE_SIZE(), "100");
        this.sc_$eq(new SparkContext("local", "test", sparkConf));
        new HBaseContext(this.sc(), this.TEST_UTIL().getConfiguration(), HBaseContext$.MODULE$.$lessinit$greater$default$3());
        this.sqlContext_$eq(new SQLContext(this.sc()));
    }

    public void afterAll() {
        this.logger().info("shutting down minicluster");
        this.TEST_UTIL().shutdownMiniCluster();
        this.sc().stop();
    }

    public void beforeEach() {
        DefaultSourceStaticUtils$.MODULE$.lastFiveExecutionRules().clear();
    }

    public IndexedSeq<FilterRangeRecord> rawResult() {
        return this.rawResult;
    }

    public <T> Set<T> collectToSet(Dataset<Row> df) {
        return ((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.collect())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getAs(0), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))).toSet();
    }

    public String catalog() {
        return this.catalog;
    }

    public static final /* synthetic */ boolean $anonfun$new$4(FilterRangeRecord x$2) {
        return x$2.intCol0() < 0;
    }

    public static final /* synthetic */ boolean $anonfun$new$7(FilterRangeRecord x$4) {
        return x$4.intCol4() < 0;
    }

    public static final /* synthetic */ boolean $anonfun$new$10(FilterRangeRecord x$6) {
        return x$6.doubleCol2() < 3.0;
    }

    public static final /* synthetic */ boolean $anonfun$new$13(FilterRangeRecord x$8) {
        return x$8.intCol0() <= -10;
    }

    public static final /* synthetic */ boolean $anonfun$new$16(FilterRangeRecord x$10) {
        return x$10.intCol0() <= -9;
    }

    public static final /* synthetic */ boolean $anonfun$new$19(FilterRangeRecord x$12) {
        return x$12.intCol0() >= -9;
    }

    public static final /* synthetic */ boolean $anonfun$new$22(FilterRangeRecord x$14) {
        return x$14.intCol0() >= 0;
    }

    public static final /* synthetic */ boolean $anonfun$new$25(FilterRangeRecord x$16) {
        return x$16.intCol0() > 10;
    }

    public static final /* synthetic */ boolean $anonfun$new$28(FilterRangeRecord x) {
        return x.intCol0() > -10 && x.intCol0() <= 10;
    }

    public static final /* synthetic */ boolean $anonfun$new$31(FilterRangeRecord x) {
        return x.intCol0() <= -10 || x.intCol0() > 10;
    }

    public static final /* synthetic */ boolean $anonfun$new$34(FilterRangeRecord x$20) {
        return x$20.intCol0() >= -100;
    }

    public PartitionFilterSuite() {
        BeforeAndAfterEach.$init$((BeforeAndAfterEach)this);
        BeforeAndAfterAll.$init$((BeforeAndAfterAll)this);
        this.logger = LoggerFactory.getLogger(PartitionFilterSuite.class);
        this.sc = null;
        this.TEST_UTIL = new HBaseTestingUtility();
        this.sqlContext = null;
        this.df = null;
        this.rawResult = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 32).map((Function1 & Serializable & scala.Serializable)i -> FilterRangeRecord$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.catalog = new StringOps(Predef$.MODULE$.augmentString("{\n                    |\"table\":{\"namespace\":\"default\", \"name\":\"rangeTable\"},\n                    |\"rowkey\":\"key\",\n                    |\"columns\":{\n                    |\"intCol0\":{\"cf\":\"rowkey\", \"col\":\"key\", \"type\":\"int\"},\n                    |\"boolCol1\":{\"cf\":\"cf1\", \"col\":\"boolCol1\", \"type\":\"boolean\"},\n                    |\"doubleCol2\":{\"cf\":\"cf2\", \"col\":\"doubleCol2\", \"type\":\"double\"},\n                    |\"floatCol3\":{\"cf\":\"cf3\", \"col\":\"floatCol3\", \"type\":\"float\"},\n                    |\"intCol4\":{\"cf\":\"cf4\", \"col\":\"intCol4\", \"type\":\"int\"},\n                    |\"longCol5\":{\"cf\":\"cf5\", \"col\":\"longCol5\", \"type\":\"bigint\"},\n                    |\"shortCol6\":{\"cf\":\"cf6\", \"col\":\"shortCol6\", \"type\":\"smallint\"},\n                    |\"stringCol7\":{\"cf\":\"cf7\", \"col\":\"stringCol7\", \"type\":\"string\"},\n                    |\"byteCol8\":{\"cf\":\"cf8\", \"col\":\"byteCol8\", \"type\":\"tinyint\"}\n                    |}\n                    |}")).stripMargin();
        this.test("populate rangeTable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SQLContext sql = this.sqlContext();
            SparkContext qual$1 = this.sc();
            IndexedSeq<FilterRangeRecord> x$1 = this.rawResult();
            int x$2 = qual$1.parallelize$default$2();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(PartitionFilterSuite.class.getClassLoader());
            public final class Org_apache_hadoop_hbase_spark_PartitionFilterSuite$$typecreator6$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.hadoop.hbase.spark.FilterRangeRecord").asType().toTypeConstructor();
                }

                public Org_apache_hadoop_hbase_spark_PartitionFilterSuite$$typecreator6$1(PartitionFilterSuite $outer) {
                }
            }
            sql.implicits().rddToDatasetHolder(qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(FilterRangeRecord.class)), sql.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hadoop_hbase_spark_PartitionFilterSuite$$typecreator6$1(null)))).toDF().write().options((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HBaseTableCatalog$.MODULE$.tableCatalog()), (Object)this.catalog()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HBaseTableCatalog$.MODULE$.newTable()), (Object)"5")}))).format("org.apache.hadoop.hbase.spark").save();
        }, new Position("PartitionFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
        this.test("rangeTable full query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Dataset<Row> df = this.withCatalog(this.catalog());
            df.show();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)df.count()));
            int $org_scalatest_assert_macro_right = 32;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PartitionFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
        }, new Position("PartitionFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        this.test("rangeTable rowkey less than 0", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SQLContext sql = this.sqlContext();
            Dataset<Row> df = this.withCatalog(this.catalog());
            Dataset s = df.filter(sql.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intCol0"}))).$((Seq)Nil$.MODULE$).$less((Object)BoxesRunTime.boxToInteger((int)0))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{sql.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intCol0"}))).$((Seq)Nil$.MODULE$)}));
            s.show();
            Set expected = ((TraversableOnce)((TraversableLike)this.rawResult().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)PartitionFilterSuite.$anonfun$new$4(x$2)))).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.intCol0()), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
            Set result = this.collectToSet((Dataset<Row>)s);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(expected);
            Set $org_scalatest_assert_macro_right = result;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PartitionFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
        }, new Position("PartitionFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
        this.test("rangeTable int col less than 0", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SQLContext sql = this.sqlContext();
            Dataset<Row> df = this.withCatalog(this.catalog());
            Dataset s = df.filter(sql.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intCol4"}))).$((Seq)Nil$.MODULE$).$less((Object)BoxesRunTime.boxToInteger((int)0))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{sql.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intCol4"}))).$((Seq)Nil$.MODULE$)}));
            s.show();
            Set expected = ((TraversableOnce)((TraversableLike)this.rawResult().filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)PartitionFilterSuite.$anonfun$new$7(x$4)))).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.intCol4()), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
            Set result = this.collectToSet((Dataset<Row>)s);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(expected);
            Set $org_scalatest_assert_macro_right = result;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PartitionFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
        }, new Position("PartitionFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
        this.test("rangeTable double col less than 0", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SQLContext sql = this.sqlContext();
            Dataset<Row> df = this.withCatalog(this.catalog());
            Dataset s = df.filter(sql.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"doubleCol2"}))).$((Seq)Nil$.MODULE$).$less((Object)BoxesRunTime.boxToDouble((double)3.0))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{sql.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"doubleCol2"}))).$((Seq)Nil$.MODULE$)}));
            s.show();
            Set expected = ((TraversableOnce)((TraversableLike)this.rawResult().filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)PartitionFilterSuite.$anonfun$new$10(x$6)))).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToDouble((double)x$7.doubleCol2()), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
            Set result = this.collectToSet((Dataset<Row>)s);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(expected);
            Set $org_scalatest_assert_macro_right = result;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PartitionFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243));
        }, new Position("PartitionFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
        this.test("rangeTable lessequal than -10", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SQLContext sql = this.sqlContext();
            Dataset<Row> df = this.withCatalog(this.catalog());
            Dataset s = df.filter(sql.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intCol0"}))).$((Seq)Nil$.MODULE$).$less$eq((Object)BoxesRunTime.boxToInteger((int)-10))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{sql.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intCol0"}))).$((Seq)Nil$.MODULE$)}));
            s.show();
            Set expected = ((TraversableOnce)((TraversableLike)this.rawResult().filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)PartitionFilterSuite.$anonfun$new$13(x$8)))).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.intCol0()), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
            Set result = this.collectToSet((Dataset<Row>)s);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(expected);
            Set $org_scalatest_assert_macro_right = result;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PartitionFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
        }, new Position("PartitionFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265));
        this.test("rangeTable lessequal than -9", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SQLContext sql = this.sqlContext();
            Dataset<Row> df = this.withCatalog(this.catalog());
            Dataset s = df.filter(sql.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intCol0"}))).$((Seq)Nil$.MODULE$).$less$eq((Object)BoxesRunTime.boxToInteger((int)-9))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{sql.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intCol0"}))).$((Seq)Nil$.MODULE$)}));
            s.show();
            Set expected = ((TraversableOnce)((TraversableLike)this.rawResult().filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)PartitionFilterSuite.$anonfun$new$16(x$10)))).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.intCol0()), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
            Set result = this.collectToSet((Dataset<Row>)s);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(expected);
            Set $org_scalatest_assert_macro_right = result;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PartitionFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 307));
        }, new Position("PartitionFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297));
        this.test("rangeTable greaterequal than -9", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SQLContext sql = this.sqlContext();
            Dataset<Row> df = this.withCatalog(this.catalog());
            Dataset s = df.filter(sql.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intCol0"}))).$((Seq)Nil$.MODULE$).$greater$eq((Object)BoxesRunTime.boxToInteger((int)-9))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{sql.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intCol0"}))).$((Seq)Nil$.MODULE$)}));
            s.show();
            Set expected = ((TraversableOnce)((TraversableLike)this.rawResult().filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)PartitionFilterSuite.$anonfun$new$19(x$12)))).map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)x$13.intCol0()), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
            Set result = this.collectToSet((Dataset<Row>)s);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(expected);
            Set $org_scalatest_assert_macro_right = result;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PartitionFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 347));
        }, new Position("PartitionFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 337));
        this.test("rangeTable greaterequal  than 0", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SQLContext sql = this.sqlContext();
            Dataset<Row> df = this.withCatalog(this.catalog());
            Dataset s = df.filter(sql.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intCol0"}))).$((Seq)Nil$.MODULE$).$greater$eq((Object)BoxesRunTime.boxToInteger((int)0))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{sql.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intCol0"}))).$((Seq)Nil$.MODULE$)}));
            s.show();
            Set expected = ((TraversableOnce)((TraversableLike)this.rawResult().filter((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)PartitionFilterSuite.$anonfun$new$22(x$14)))).map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToInteger((int)x$15.intCol0()), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
            Set result = this.collectToSet((Dataset<Row>)s);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(expected);
            Set $org_scalatest_assert_macro_right = result;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PartitionFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 383));
        }, new Position("PartitionFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 373));
        this.test("rangeTable greater than 10", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SQLContext sql = this.sqlContext();
            Dataset<Row> df = this.withCatalog(this.catalog());
            Dataset s = df.filter(sql.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intCol0"}))).$((Seq)Nil$.MODULE$).$greater((Object)BoxesRunTime.boxToInteger((int)10))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{sql.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intCol0"}))).$((Seq)Nil$.MODULE$)}));
            s.show();
            Set expected = ((TraversableOnce)((TraversableLike)this.rawResult().filter((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)PartitionFilterSuite.$anonfun$new$25(x$16)))).map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToInteger((int)x$17.intCol0()), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
            Set result = this.collectToSet((Dataset<Row>)s);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(expected);
            Set $org_scalatest_assert_macro_right = result;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PartitionFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 413));
        }, new Position("PartitionFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 403));
        this.test("rangeTable and", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SQLContext sql = this.sqlContext();
            Dataset<Row> df = this.withCatalog(this.catalog());
            Dataset s = df.filter(sql.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intCol0"}))).$((Seq)Nil$.MODULE$).$greater((Object)BoxesRunTime.boxToInteger((int)-10)).$amp$amp((Object)sql.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intCol0"}))).$((Seq)Nil$.MODULE$).$less$eq((Object)BoxesRunTime.boxToInteger((int)10)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{sql.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intCol0"}))).$((Seq)Nil$.MODULE$)}));
            s.show();
            Set expected = ((TraversableOnce)((TraversableLike)this.rawResult().filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)PartitionFilterSuite.$anonfun$new$28(x)))).map((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToInteger((int)x$18.intCol0()), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
            Set result = this.collectToSet((Dataset<Row>)s);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(expected);
            Set $org_scalatest_assert_macro_right = result;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PartitionFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 444));
        }, new Position("PartitionFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 434));
        this.test("or", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SQLContext sql = this.sqlContext();
            Dataset<Row> df = this.withCatalog(this.catalog());
            Dataset s = df.filter(sql.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intCol0"}))).$((Seq)Nil$.MODULE$).$less$eq((Object)BoxesRunTime.boxToInteger((int)-10)).$bar$bar((Object)sql.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intCol0"}))).$((Seq)Nil$.MODULE$).$greater((Object)BoxesRunTime.boxToInteger((int)10)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{sql.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intCol0"}))).$((Seq)Nil$.MODULE$)}));
            s.show();
            Set expected = ((TraversableOnce)((TraversableLike)this.rawResult().filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)PartitionFilterSuite.$anonfun$new$31(x)))).map((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToInteger((int)x$19.intCol0()), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
            Set result = this.collectToSet((Dataset<Row>)s);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(expected);
            Set $org_scalatest_assert_macro_right = result;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PartitionFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 485));
        }, new Position("PartitionFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 475));
        this.test("rangeTable all", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SQLContext sql = this.sqlContext();
            Dataset<Row> df = this.withCatalog(this.catalog());
            Dataset s = df.filter(sql.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intCol0"}))).$((Seq)Nil$.MODULE$).$greater$eq((Object)BoxesRunTime.boxToInteger((int)-100))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{sql.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intCol0"}))).$((Seq)Nil$.MODULE$)}));
            s.show();
            Set expected = ((TraversableOnce)((TraversableLike)this.rawResult().filter((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)PartitionFilterSuite.$anonfun$new$34(x$20)))).map((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToInteger((int)x$21.intCol0()), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
            Set result = this.collectToSet((Dataset<Row>)s);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(expected);
            Set $org_scalatest_assert_macro_right = result;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PartitionFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 525));
        }, new Position("PartitionFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 515));
    }
}

