/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.hadoop.hbase.spark.AndLogicExpression;
import org.apache.hadoop.hbase.spark.ByteArrayComparable;
import org.apache.hadoop.hbase.spark.ByteArrayComparable$;
import org.apache.hadoop.hbase.spark.DynamicLogicExpression;
import org.apache.hadoop.hbase.spark.DynamicLogicExpressionBuilder$;
import org.apache.hadoop.hbase.spark.EqualLogicExpression;
import org.apache.hadoop.hbase.spark.GreaterThanLogicExpression;
import org.apache.hadoop.hbase.spark.GreaterThanOrEqualLogicExpression;
import org.apache.hadoop.hbase.spark.LessThanLogicExpression;
import org.apache.hadoop.hbase.spark.LessThanOrEqualLogicExpression;
import org.apache.hadoop.hbase.spark.OrLogicExpression;
import org.apache.hadoop.hbase.spark.PassThroughLogicExpression;
import org.apache.hadoop.hbase.spark.datasources.BytesEncoder;
import org.apache.hadoop.hbase.spark.datasources.HBaseSparkConf$;
import org.apache.hadoop.hbase.spark.datasources.JavaBytesEncoder$;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.FunSuite;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001)2A\u0001B\u0003\u0001!!)Q\u0004\u0001C\u0001=!9\u0011\u0005\u0001b\u0001\n\u0003\u0011\u0003BB\u0015\u0001A\u0003%1EA\u000eEs:\fW.[2M_\u001eL7-\u0012=qe\u0016\u001c8/[8o'VLG/\u001a\u0006\u0003\r\u001d\tQa\u001d9be.T!\u0001C\u0005\u0002\u000b!\u0014\u0017m]3\u000b\u0005)Y\u0011A\u00025bI>|\u0007O\u0003\u0002\r\u001b\u00051\u0011\r]1dQ\u0016T\u0011AD\u0001\u0004_J<7\u0001A\n\u0005\u0001E9\"\u0004\u0005\u0002\u0013+5\t1C\u0003\u0002\u0015\u001b\u0005I1oY1mCR,7\u000f^\u0005\u0003-M\u0011\u0001BR;o'VLG/\u001a\t\u0003%aI!!G\n\u0003%\t+gm\u001c:f\u0003:$\u0017I\u001a;fe\u0016\u000b7\r\u001b\t\u0003%mI!\u0001H\n\u0003#\t+gm\u001c:f\u0003:$\u0017I\u001a;fe\u0006cG.\u0001\u0004=S:LGO\u0010\u000b\u0002?A\u0011\u0001\u0005A\u0007\u0002\u000b\u00059QM\\2pI\u0016\u0014X#A\u0012\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019*\u0011a\u00033bi\u0006\u001cx.\u001e:dKNL!\u0001K\u0013\u0003\u0019\tKH/Z:F]\u000e|G-\u001a:\u0002\u0011\u0015t7m\u001c3fe\u0002\u0002")
public class DynamicLogicExpressionSuite
extends FunSuite
implements BeforeAndAfterEach,
BeforeAndAfterAll {
    private final BytesEncoder encoder;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    public /* synthetic */ Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.run$((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void beforeAll() {
        BeforeAndAfterAll.beforeAll$((BeforeAndAfterAll)this);
    }

    public void afterAll() {
        BeforeAndAfterAll.afterAll$((BeforeAndAfterAll)this);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return FunSuiteLike.runTest$((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    public void afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public BytesEncoder encoder() {
        return this.encoder;
    }

    public DynamicLogicExpressionSuite() {
        BeforeAndAfterEach.$init$((BeforeAndAfterEach)this);
        BeforeAndAfterAll.$init$((BeforeAndAfterAll)this);
        this.encoder = JavaBytesEncoder$.MODULE$.create(HBaseSparkConf$.MODULE$.defaultEncoder());
        this.test("Basic And Test", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LessThanLogicExpression leftLogic = new LessThanLogicExpression("Col1", 0);
            leftLogic.setEncoder(this.encoder());
            GreaterThanLogicExpression rightLogic = new GreaterThanLogicExpression("Col1", 1);
            rightLogic.setEncoder(this.encoder());
            AndLogicExpression andLogic = new AndLogicExpression((DynamicLogicExpression)leftLogic, (DynamicLogicExpression)rightLogic);
            HashMap<String, ByteArrayComparable> columnToCurrentRowValueMap = new HashMap<String, ByteArrayComparable>();
            columnToCurrentRowValueMap.put("Col1", new ByteArrayComparable(Bytes.toBytes((int)10), ByteArrayComparable$.MODULE$.$lessinit$greater$default$2(), ByteArrayComparable$.MODULE$.$lessinit$greater$default$3()));
            byte[][] valueFromQueryValueArray = new byte[][]{this.encoder().encode((DataType)IntegerType$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)15)), this.encoder().encode((DataType)IntegerType$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)5))};
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(andLogic.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "andLogic.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
            valueFromQueryValueArray[0] = this.encoder().encode((DataType)IntegerType$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)10));
            valueFromQueryValueArray[1] = this.encoder().encode((DataType)IntegerType$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)5));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(andLogic.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "andLogic.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
            valueFromQueryValueArray[0] = this.encoder().encode((DataType)IntegerType$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)15));
            valueFromQueryValueArray[1] = this.encoder().encode((DataType)IntegerType$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)10));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(andLogic.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "andLogic.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
            String expressionString = andLogic.toExpressionString();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(expressionString.equals("( Col1 < 0 AND Col1 > 1 )"), "expressionString.equals(\"( Col1 < 0 AND Col1 > 1 )\")", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
            DynamicLogicExpression builtExpression = DynamicLogicExpressionBuilder$.MODULE$.build(expressionString, this.encoder());
            valueFromQueryValueArray[0] = this.encoder().encode((DataType)IntegerType$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)15));
            valueFromQueryValueArray[1] = this.encoder().encode((DataType)IntegerType$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)5));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(builtExpression.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "builtExpression.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            valueFromQueryValueArray[0] = this.encoder().encode((DataType)IntegerType$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)10));
            valueFromQueryValueArray[1] = this.encoder().encode((DataType)IntegerType$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)5));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(builtExpression.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "builtExpression.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
            valueFromQueryValueArray[0] = this.encoder().encode((DataType)IntegerType$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)15));
            valueFromQueryValueArray[1] = this.encoder().encode((DataType)IntegerType$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)10));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(builtExpression.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "builtExpression.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        }, new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
        this.test("Basic OR Test", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LessThanLogicExpression leftLogic = new LessThanLogicExpression("Col1", 0);
            leftLogic.setEncoder(this.encoder());
            GreaterThanLogicExpression rightLogic = new GreaterThanLogicExpression("Col1", 1);
            rightLogic.setEncoder(this.encoder());
            OrLogicExpression OrLogic = new OrLogicExpression((DynamicLogicExpression)leftLogic, (DynamicLogicExpression)rightLogic);
            HashMap<String, ByteArrayComparable> columnToCurrentRowValueMap = new HashMap<String, ByteArrayComparable>();
            columnToCurrentRowValueMap.put("Col1", new ByteArrayComparable(Bytes.toBytes((int)10), ByteArrayComparable$.MODULE$.$lessinit$greater$default$2(), ByteArrayComparable$.MODULE$.$lessinit$greater$default$3()));
            byte[][] valueFromQueryValueArray = new byte[][]{this.encoder().encode((DataType)IntegerType$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)15)), this.encoder().encode((DataType)IntegerType$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)5))};
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(OrLogic.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "OrLogic.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
            valueFromQueryValueArray[0] = this.encoder().encode((DataType)IntegerType$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)10));
            valueFromQueryValueArray[1] = this.encoder().encode((DataType)IntegerType$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)5));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(OrLogic.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "OrLogic.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
            valueFromQueryValueArray[0] = this.encoder().encode((DataType)IntegerType$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)15));
            valueFromQueryValueArray[1] = this.encoder().encode((DataType)IntegerType$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)10));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(OrLogic.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "OrLogic.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
            valueFromQueryValueArray[0] = this.encoder().encode((DataType)IntegerType$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)10));
            valueFromQueryValueArray[1] = this.encoder().encode((DataType)IntegerType$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)10));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(OrLogic.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "OrLogic.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
            String expressionString = OrLogic.toExpressionString();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(expressionString.equals("( Col1 < 0 OR Col1 > 1 )"), "expressionString.equals(\"( Col1 < 0 OR Col1 > 1 )\")", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
            DynamicLogicExpression builtExpression = DynamicLogicExpressionBuilder$.MODULE$.build(expressionString, this.encoder());
            valueFromQueryValueArray[0] = this.encoder().encode((DataType)IntegerType$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)15));
            valueFromQueryValueArray[1] = this.encoder().encode((DataType)IntegerType$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)5));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(builtExpression.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "builtExpression.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
            valueFromQueryValueArray[0] = this.encoder().encode((DataType)IntegerType$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)10));
            valueFromQueryValueArray[1] = this.encoder().encode((DataType)IntegerType$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)5));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(builtExpression.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "builtExpression.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
            valueFromQueryValueArray[0] = this.encoder().encode((DataType)IntegerType$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)15));
            valueFromQueryValueArray[1] = this.encoder().encode((DataType)IntegerType$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)10));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(builtExpression.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "builtExpression.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
            valueFromQueryValueArray[0] = this.encoder().encode((DataType)IntegerType$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)10));
            valueFromQueryValueArray[1] = this.encoder().encode((DataType)IntegerType$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)10));
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(builtExpression.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "builtExpression.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        }, new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        this.test("Basic Command Test", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            GreaterThanLogicExpression greaterLogic = new GreaterThanLogicExpression("Col1", 0);
            greaterLogic.setEncoder(this.encoder());
            GreaterThanOrEqualLogicExpression greaterAndEqualLogic = new GreaterThanOrEqualLogicExpression("Col1", 0);
            greaterAndEqualLogic.setEncoder(this.encoder());
            LessThanLogicExpression lessLogic = new LessThanLogicExpression("Col1", 0);
            lessLogic.setEncoder(this.encoder());
            LessThanOrEqualLogicExpression lessAndEqualLogic = new LessThanOrEqualLogicExpression("Col1", 0);
            lessAndEqualLogic.setEncoder(this.encoder());
            EqualLogicExpression equalLogic = new EqualLogicExpression("Col1", 0, false);
            EqualLogicExpression notEqualLogic = new EqualLogicExpression("Col1", 0, true);
            PassThroughLogicExpression passThrough = new PassThroughLogicExpression();
            HashMap<String, ByteArrayComparable> columnToCurrentRowValueMap = new HashMap<String, ByteArrayComparable>();
            columnToCurrentRowValueMap.put("Col1", new ByteArrayComparable(Bytes.toBytes((int)10), ByteArrayComparable$.MODULE$.$lessinit$greater$default$2(), ByteArrayComparable$.MODULE$.$lessinit$greater$default$3()));
            byte[][] valueFromQueryValueArray = new byte[][]{this.encoder().encode((DataType)IntegerType$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)10))};
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(greaterLogic.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "greaterLogic.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
            valueFromQueryValueArray[0] = this.encoder().encode((DataType)IntegerType$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)20));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(greaterLogic.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "greaterLogic.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
            valueFromQueryValueArray[0] = this.encoder().encode((DataType)IntegerType$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)5));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(greaterAndEqualLogic.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "greaterAndEqualLogic.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
            valueFromQueryValueArray[0] = this.encoder().encode((DataType)IntegerType$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)10));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(greaterAndEqualLogic.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "greaterAndEqualLogic.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
            valueFromQueryValueArray[0] = this.encoder().encode((DataType)IntegerType$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)20));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(greaterAndEqualLogic.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "greaterAndEqualLogic.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
            valueFromQueryValueArray[0] = this.encoder().encode((DataType)IntegerType$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)10));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(lessLogic.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "lessLogic.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
            valueFromQueryValueArray[0] = this.encoder().encode((DataType)IntegerType$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)5));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(lessLogic.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "lessLogic.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
            valueFromQueryValueArray[0] = this.encoder().encode((DataType)IntegerType$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)20));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(lessAndEqualLogic.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "lessAndEqualLogic.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
            valueFromQueryValueArray[0] = this.encoder().encode((DataType)IntegerType$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)20));
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(lessAndEqualLogic.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "lessAndEqualLogic.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
            valueFromQueryValueArray[0] = this.encoder().encode((DataType)IntegerType$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)10));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(lessAndEqualLogic.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "lessAndEqualLogic.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
            valueFromQueryValueArray[0] = Bytes.toBytes((int)10);
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(equalLogic.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "equalLogic.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
            valueFromQueryValueArray[0] = Bytes.toBytes((int)5);
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(equalLogic.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "equalLogic.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
            valueFromQueryValueArray[0] = Bytes.toBytes((int)10);
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(notEqualLogic.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "notEqualLogic.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
            valueFromQueryValueArray[0] = Bytes.toBytes((int)5);
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.simpleMacroBool(notEqualLogic.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "notEqualLogic.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
            valueFromQueryValueArray[0] = Bytes.toBytes((int)10);
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.simpleMacroBool(passThrough.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "passThrough.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
            valueFromQueryValueArray[0] = Bytes.toBytes((int)5);
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.simpleMacroBool(passThrough.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "passThrough.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
        }, new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
        this.test("Double Type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LessThanLogicExpression leftLogic = new LessThanLogicExpression("Col1", 0);
            leftLogic.setEncoder(this.encoder());
            GreaterThanLogicExpression rightLogic = new GreaterThanLogicExpression("Col1", 1);
            rightLogic.setEncoder(this.encoder());
            AndLogicExpression andLogic = new AndLogicExpression((DynamicLogicExpression)leftLogic, (DynamicLogicExpression)rightLogic);
            HashMap<String, ByteArrayComparable> columnToCurrentRowValueMap = new HashMap<String, ByteArrayComparable>();
            columnToCurrentRowValueMap.put("Col1", new ByteArrayComparable(Bytes.toBytes((double)-4.0), ByteArrayComparable$.MODULE$.$lessinit$greater$default$2(), ByteArrayComparable$.MODULE$.$lessinit$greater$default$3()));
            byte[][] valueFromQueryValueArray = new byte[][]{this.encoder().encode((DataType)DoubleType$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)15.0)), this.encoder().encode((DataType)DoubleType$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)-5.0))};
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(andLogic.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "andLogic.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
            valueFromQueryValueArray[0] = this.encoder().encode((DataType)DoubleType$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)10.0));
            valueFromQueryValueArray[1] = this.encoder().encode((DataType)DoubleType$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)-1.0));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(andLogic.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "andLogic.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
            valueFromQueryValueArray[0] = this.encoder().encode((DataType)DoubleType$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)-10.0));
            valueFromQueryValueArray[1] = this.encoder().encode((DataType)DoubleType$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)-20.0));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(andLogic.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "andLogic.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
            String expressionString = andLogic.toExpressionString();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(expressionString.equals("( Col1 < 0 AND Col1 > 1 )"), "expressionString.equals(\"( Col1 < 0 AND Col1 > 1 )\")", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225));
            DynamicLogicExpression builtExpression = DynamicLogicExpressionBuilder$.MODULE$.build(expressionString, this.encoder());
            valueFromQueryValueArray[0] = this.encoder().encode((DataType)DoubleType$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)15.0));
            valueFromQueryValueArray[1] = this.encoder().encode((DataType)DoubleType$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)-5.0));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(builtExpression.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "builtExpression.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
            valueFromQueryValueArray[0] = this.encoder().encode((DataType)DoubleType$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)10.0));
            valueFromQueryValueArray[1] = this.encoder().encode((DataType)DoubleType$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)-1.0));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(builtExpression.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "builtExpression.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
            valueFromQueryValueArray[0] = this.encoder().encode((DataType)DoubleType$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)-10.0));
            valueFromQueryValueArray[1] = this.encoder().encode((DataType)DoubleType$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)-20.0));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(builtExpression.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "builtExpression.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
        }, new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
        this.test("Float Type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LessThanLogicExpression leftLogic = new LessThanLogicExpression("Col1", 0);
            leftLogic.setEncoder(this.encoder());
            GreaterThanLogicExpression rightLogic = new GreaterThanLogicExpression("Col1", 1);
            rightLogic.setEncoder(this.encoder());
            AndLogicExpression andLogic = new AndLogicExpression((DynamicLogicExpression)leftLogic, (DynamicLogicExpression)rightLogic);
            HashMap<String, ByteArrayComparable> columnToCurrentRowValueMap = new HashMap<String, ByteArrayComparable>();
            columnToCurrentRowValueMap.put("Col1", new ByteArrayComparable(Bytes.toBytes((float)-4.0f), ByteArrayComparable$.MODULE$.$lessinit$greater$default$2(), ByteArrayComparable$.MODULE$.$lessinit$greater$default$3()));
            byte[][] valueFromQueryValueArray = new byte[][]{this.encoder().encode((DataType)FloatType$.MODULE$, (Object)BoxesRunTime.boxToFloat((float)15.0f)), this.encoder().encode((DataType)FloatType$.MODULE$, (Object)BoxesRunTime.boxToFloat((float)-5.0f))};
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(andLogic.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "andLogic.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
            valueFromQueryValueArray[0] = this.encoder().encode((DataType)FloatType$.MODULE$, (Object)BoxesRunTime.boxToFloat((float)10.0f));
            valueFromQueryValueArray[1] = this.encoder().encode((DataType)FloatType$.MODULE$, (Object)BoxesRunTime.boxToFloat((float)-1.0f));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(andLogic.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "andLogic.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
            valueFromQueryValueArray[0] = this.encoder().encode((DataType)FloatType$.MODULE$, (Object)BoxesRunTime.boxToFloat((float)-10.0f));
            valueFromQueryValueArray[1] = this.encoder().encode((DataType)FloatType$.MODULE$, (Object)BoxesRunTime.boxToFloat((float)-20.0f));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(andLogic.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "andLogic.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
            String expressionString = andLogic.toExpressionString();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(expressionString.equals("( Col1 < 0 AND Col1 > 1 )"), "expressionString.equals(\"( Col1 < 0 AND Col1 > 1 )\")", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
            DynamicLogicExpression builtExpression = DynamicLogicExpressionBuilder$.MODULE$.build(expressionString, this.encoder());
            valueFromQueryValueArray[0] = this.encoder().encode((DataType)FloatType$.MODULE$, (Object)BoxesRunTime.boxToFloat((float)15.0f));
            valueFromQueryValueArray[1] = this.encoder().encode((DataType)FloatType$.MODULE$, (Object)BoxesRunTime.boxToFloat((float)-5.0f));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(builtExpression.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "builtExpression.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
            valueFromQueryValueArray[0] = this.encoder().encode((DataType)FloatType$.MODULE$, (Object)BoxesRunTime.boxToFloat((float)10.0f));
            valueFromQueryValueArray[1] = this.encoder().encode((DataType)FloatType$.MODULE$, (Object)BoxesRunTime.boxToFloat((float)-1.0f));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(builtExpression.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "builtExpression.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
            valueFromQueryValueArray[0] = this.encoder().encode((DataType)FloatType$.MODULE$, (Object)BoxesRunTime.boxToFloat((float)-10.0f));
            valueFromQueryValueArray[1] = this.encoder().encode((DataType)FloatType$.MODULE$, (Object)BoxesRunTime.boxToFloat((float)-20.0f));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(builtExpression.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "builtExpression.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
        }, new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
        this.test("String Type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LessThanLogicExpression leftLogic = new LessThanLogicExpression("Col1", 0);
            leftLogic.setEncoder(this.encoder());
            GreaterThanLogicExpression rightLogic = new GreaterThanLogicExpression("Col1", 1);
            rightLogic.setEncoder(this.encoder());
            AndLogicExpression andLogic = new AndLogicExpression((DynamicLogicExpression)leftLogic, (DynamicLogicExpression)rightLogic);
            HashMap<String, ByteArrayComparable> columnToCurrentRowValueMap = new HashMap<String, ByteArrayComparable>();
            columnToCurrentRowValueMap.put("Col1", new ByteArrayComparable(Bytes.toBytes((String)"row005"), ByteArrayComparable$.MODULE$.$lessinit$greater$default$2(), ByteArrayComparable$.MODULE$.$lessinit$greater$default$3()));
            byte[][] valueFromQueryValueArray = new byte[][]{this.encoder().encode((DataType)StringType$.MODULE$, (Object)"row015"), this.encoder().encode((DataType)StringType$.MODULE$, (Object)"row000")};
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(andLogic.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "andLogic.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 295));
            valueFromQueryValueArray[0] = this.encoder().encode((DataType)StringType$.MODULE$, (Object)"row004");
            valueFromQueryValueArray[1] = this.encoder().encode((DataType)StringType$.MODULE$, (Object)"row000");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(andLogic.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "andLogic.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299));
            valueFromQueryValueArray[0] = this.encoder().encode((DataType)StringType$.MODULE$, (Object)"row020");
            valueFromQueryValueArray[1] = this.encoder().encode((DataType)StringType$.MODULE$, (Object)"row010");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(andLogic.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "andLogic.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 303));
            String expressionString = andLogic.toExpressionString();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(expressionString.equals("( Col1 < 0 AND Col1 > 1 )"), "expressionString.equals(\"( Col1 < 0 AND Col1 > 1 )\")", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 307));
            DynamicLogicExpression builtExpression = DynamicLogicExpressionBuilder$.MODULE$.build(expressionString, this.encoder());
            valueFromQueryValueArray[0] = this.encoder().encode((DataType)StringType$.MODULE$, (Object)"row015");
            valueFromQueryValueArray[1] = this.encoder().encode((DataType)StringType$.MODULE$, (Object)"row000");
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(builtExpression.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "builtExpression.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 312));
            valueFromQueryValueArray[0] = this.encoder().encode((DataType)StringType$.MODULE$, (Object)"row004");
            valueFromQueryValueArray[1] = this.encoder().encode((DataType)StringType$.MODULE$, (Object)"row000");
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(builtExpression.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "builtExpression.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 316));
            valueFromQueryValueArray[0] = this.encoder().encode((DataType)StringType$.MODULE$, (Object)"row020");
            valueFromQueryValueArray[1] = this.encoder().encode((DataType)StringType$.MODULE$, (Object)"row010");
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(builtExpression.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "builtExpression.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
        }, new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
        this.test("Boolean Type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LessThanLogicExpression leftLogic = new LessThanLogicExpression("Col1", 0);
            leftLogic.setEncoder(this.encoder());
            GreaterThanLogicExpression rightLogic = new GreaterThanLogicExpression("Col1", 1);
            rightLogic.setEncoder(this.encoder());
            HashMap<String, ByteArrayComparable> columnToCurrentRowValueMap = new HashMap<String, ByteArrayComparable>();
            columnToCurrentRowValueMap.put("Col1", new ByteArrayComparable(Bytes.toBytes((boolean)false), ByteArrayComparable$.MODULE$.$lessinit$greater$default$2(), ByteArrayComparable$.MODULE$.$lessinit$greater$default$3()));
            byte[][] valueFromQueryValueArray = new byte[][]{this.encoder().encode((DataType)BooleanType$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)true)), this.encoder().encode((DataType)BooleanType$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)false))};
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(leftLogic.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "leftLogic.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 335));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(rightLogic.execute(columnToCurrentRowValueMap, (byte[][])valueFromQueryValueArray), "rightLogic.execute(columnToCurrentRowValueMap, valueFromQueryValueArray)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
        }, new Position("DynamicLogicExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 323));
    }
}

