/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.spark.HBaseContext;
import org.apache.hadoop.hbase.spark.HBaseContext$;
import org.apache.hadoop.hbase.spark.HBaseRDDFunctions$;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.rdd.RDD;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.FunSuite;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.MutableList;
import scala.collection.mutable.MutableList$;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u00194A\u0001E\t\u00019!)\u0011\u0006\u0001C\u0001U!9Q\u0006\u0001b\u0001\n\u0003q\u0003BB\u001b\u0001A\u0003%q\u0006C\u00047\u0001\u0001\u0007I\u0011A\u001c\t\u000fu\u0002\u0001\u0019!C\u0001}!1q\t\u0001Q!\naBq\u0001\u0014\u0001A\u0002\u0013\u0005Q\nC\u0004S\u0001\u0001\u0007I\u0011A*\t\rU\u0003\u0001\u0015)\u0003O\u0011\u001d1\u0006A1A\u0005\u0002]Ca\u0001\u0019\u0001!\u0002\u0013A\u0006bB1\u0001\u0005\u0004%\ta\u0016\u0005\u0007E\u0002\u0001\u000b\u0011\u0002-\t\u000b\r\u0004A\u0011\t3\t\u000b\u0015\u0004A\u0011\t3\u0003-!\u0013\u0015m]3S\t\u00123UO\\2uS>t7oU;ji\u0016T!AE\n\u0002\u000bM\u0004\u0018M]6\u000b\u0005Q)\u0012!\u00025cCN,'B\u0001\f\u0018\u0003\u0019A\u0017\rZ8pa*\u0011\u0001$G\u0001\u0007CB\f7\r[3\u000b\u0003i\t1a\u001c:h\u0007\u0001\u0019B\u0001A\u000f$MA\u0011a$I\u0007\u0002?)\u0011\u0001%G\u0001\ng\u000e\fG.\u0019;fgRL!AI\u0010\u0003\u0011\u0019+hnU;ji\u0016\u0004\"A\b\u0013\n\u0005\u0015z\"A\u0005\"fM>\u0014X-\u00118e\u0003\u001a$XM]#bG\"\u0004\"AH\u0014\n\u0005!z\"!\u0005\"fM>\u0014X-\u00118e\u0003\u001a$XM]!mY\u00061A(\u001b8jiz\"\u0012a\u000b\t\u0003Y\u0001i\u0011!E\u0001\u0007Y><w-\u001a:\u0016\u0003=\u0002\"\u0001M\u001a\u000e\u0003ER!AM\r\u0002\u000bMdg\r\u000e6\n\u0005Q\n$A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002\u0005M\u001cW#\u0001\u001d\u0011\u0005eZT\"\u0001\u001e\u000b\u0005I9\u0012B\u0001\u001f;\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0003\u0019\u00198m\u0018\u0013fcR\u0011q(\u0012\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0002\u0005\u0006)1oY1mC&\u0011A)\u0011\u0002\u0005+:LG\u000fC\u0004G\u000b\u0005\u0005\t\u0019\u0001\u001d\u0002\u0007a$\u0013'A\u0002tG\u0002B#AB%\u0011\u0005\u0001S\u0015BA&B\u0005%!(/\u00198tS\u0016tG/A\u0005U\u000bN#v,\u0016+J\u0019V\ta\n\u0005\u0002P!6\t1#\u0003\u0002R'\t\u0019\u0002JQ1tKR+7\u000f^5oOV#\u0018\u000e\\5us\u0006iA+R*U?V#\u0016\nT0%KF$\"a\u0010+\t\u000f\u0019C\u0011\u0011!a\u0001\u001d\u0006QA+R*U?V#\u0016\n\u0014\u0011\u0002\u0013Q\f'\r\\3OC6,W#\u0001-\u0011\u0005esV\"\u0001.\u000b\u0005mc\u0016\u0001\u00027b]\u001eT\u0011!X\u0001\u0005U\u00064\u0018-\u0003\u0002`5\n11\u000b\u001e:j]\u001e\f!\u0002^1cY\u0016t\u0015-\\3!\u00031\u0019w\u000e\\;n]\u001a\u000bW.\u001b7z\u00035\u0019w\u000e\\;n]\u001a\u000bW.\u001b7zA\u0005I!-\u001a4pe\u0016\fE\u000e\u001c\u000b\u0002\u007f\u0005A\u0011M\u001a;fe\u0006cG\u000e")
public class HBaseRDDFunctionsSuite
extends FunSuite
implements BeforeAndAfterEach,
BeforeAndAfterAll {
    private final Logger logger;
    private transient SparkContext sc;
    private HBaseTestingUtility TEST_UTIL;
    private final String tableName;
    private final String columnFamily;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    public /* synthetic */ Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.run$((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return FunSuiteLike.runTest$((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    public void afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public Logger logger() {
        return this.logger;
    }

    public SparkContext sc() {
        return this.sc;
    }

    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    public HBaseTestingUtility TEST_UTIL() {
        return this.TEST_UTIL;
    }

    public void TEST_UTIL_$eq(HBaseTestingUtility x$1) {
        this.TEST_UTIL = x$1;
    }

    public String tableName() {
        return this.tableName;
    }

    public String columnFamily() {
        return this.columnFamily;
    }

    public void beforeAll() {
        this.TEST_UTIL().startMiniCluster();
        this.logger().info(" - minicluster started");
        try {
            this.TEST_UTIL().deleteTable(TableName.valueOf((String)this.tableName()));
        }
        catch (Exception e) {
            this.logger().info(new java.lang.StringBuilder(18).append(" - no table ").append(this.tableName()).append(" found").toString());
        }
        this.logger().info(new java.lang.StringBuilder(18).append(" - creating table ").append(this.tableName()).toString());
        this.TEST_UTIL().createTable(TableName.valueOf((String)this.tableName()), Bytes.toBytes((String)this.columnFamily()));
        this.logger().info(" - created table");
        this.sc_$eq(new SparkContext("local", "test", SparkContext$.MODULE$.$lessinit$greater$default$3(), SparkContext$.MODULE$.$lessinit$greater$default$4(), SparkContext$.MODULE$.$lessinit$greater$default$5()));
    }

    public void afterAll() {
        this.TEST_UTIL().deleteTable(TableName.valueOf((String)this.tableName()));
        this.logger().info("shuting down minicluster");
        this.TEST_UTIL().shutdownMiniCluster();
        this.sc().stop();
    }

    public static final /* synthetic */ void $anonfun$new$14(BufferedMutator bufferedMutator$1, Tuple2 putRecord) {
        Put put = new Put((byte[])putRecord._1());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])putRecord._2())).foreach((Function1 & Serializable & scala.Serializable)putValue -> put.addColumn((byte[])putValue._1(), (byte[])putValue._2(), (byte[])putValue._3()));
        bufferedMutator$1.mutate((Mutation)put);
    }

    public static final /* synthetic */ void $anonfun$new$13(Iterator it, Connection conn) {
        BufferedMutator bufferedMutator = conn.getBufferedMutator(TableName.valueOf((String)"t1"));
        it.foreach((Function1 & Serializable & scala.Serializable)putRecord -> {
            HBaseRDDFunctionsSuite.$anonfun$new$14(bufferedMutator, putRecord);
            return BoxedUnit.UNIT;
        });
        bufferedMutator.flush();
        bufferedMutator.close();
    }

    public HBaseRDDFunctionsSuite() {
        BeforeAndAfterEach.$init$((BeforeAndAfterEach)this);
        BeforeAndAfterAll.$init$((BeforeAndAfterAll)this);
        this.logger = LoggerFactory.getLogger(HBaseRDDFunctionsSuite.class);
        this.sc = null;
        this.TEST_UTIL = new HBaseTestingUtility();
        this.tableName = "t1";
        this.columnFamily = "c";
        this.test("bulkput to test HBase client", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            Configuration config = this.TEST_UTIL().getConfiguration();
            SparkContext qual$1 = this.sc();
            WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)Bytes.toBytes((String)"1"), (Object)new Tuple3[]{new Tuple3((Object)Bytes.toBytes((String)this.columnFamily()), (Object)Bytes.toBytes((String)"a"), (Object)Bytes.toBytes((String)"foo1"))}), new Tuple2((Object)Bytes.toBytes((String)"2"), (Object)new Tuple3[]{new Tuple3((Object)Bytes.toBytes((String)this.columnFamily()), (Object)Bytes.toBytes((String)"b"), (Object)Bytes.toBytes((String)"foo2"))}), new Tuple2((Object)Bytes.toBytes((String)"3"), (Object)new Tuple3[]{new Tuple3((Object)Bytes.toBytes((String)this.columnFamily()), (Object)Bytes.toBytes((String)"c"), (Object)Bytes.toBytes((String)"foo3"))}), new Tuple2((Object)Bytes.toBytes((String)"4"), (Object)new Tuple3[]{new Tuple3((Object)Bytes.toBytes((String)this.columnFamily()), (Object)Bytes.toBytes((String)"d"), (Object)Bytes.toBytes((String)"foo"))}), new Tuple2((Object)Bytes.toBytes((String)"5"), (Object)new Tuple3[]{new Tuple3((Object)Bytes.toBytes((String)this.columnFamily()), (Object)Bytes.toBytes((String)"e"), (Object)Bytes.toBytes((String)"bar"))})});
            int x$2 = qual$1.parallelize$default$2();
            RDD rdd = qual$1.parallelize((Seq)x$1, x$2, ClassTag$.MODULE$.apply(Tuple2.class));
            HBaseContext hbaseContext = new HBaseContext(this.sc(), config, HBaseContext$.MODULE$.$lessinit$greater$default$3());
            HBaseRDDFunctions$.MODULE$.GenericHBaseRDDFunctions(rdd).hbaseBulkPut(hbaseContext, TableName.valueOf((String)this.tableName()), (Function1 & Serializable & scala.Serializable)putRecord -> {
                void var1_1;
                Put put = new Put((byte[])putRecord._1());
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])putRecord._2())).foreach((Function1 & Serializable & scala.Serializable)putValue -> put.addColumn((byte[])putValue._1(), (byte[])putValue._2(), (byte[])putValue._3()));
                return var1_1;
            });
            Connection connection = ConnectionFactory.createConnection((Configuration)config);
            Table table = connection.getTable(TableName.valueOf((String)"t1"));
            try {
                String foo5;
                String foo4;
                String foo3;
                String foo2;
                String foo1;
                String $org_scalatest_assert_macro_left = foo1 = Bytes.toString((byte[])CellUtil.cloneValue((Cell)table.get(new Get(Bytes.toBytes((String)"1"))).getColumnLatestCell(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"))));
                String $org_scalatest_assert_macro_right = "foo1";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseRDDFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
                String $org_scalatest_assert_macro_left2 = foo2 = Bytes.toString((byte[])CellUtil.cloneValue((Cell)table.get(new Get(Bytes.toBytes((String)"2"))).getColumnLatestCell(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"b"))));
                String $org_scalatest_assert_macro_right2 = "foo2";
                String string3 = $org_scalatest_assert_macro_left2;
                String string4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseRDDFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
                String $org_scalatest_assert_macro_left3 = foo3 = Bytes.toString((byte[])CellUtil.cloneValue((Cell)table.get(new Get(Bytes.toBytes((String)"3"))).getColumnLatestCell(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"c"))));
                String $org_scalatest_assert_macro_right3 = "foo3";
                String string5 = $org_scalatest_assert_macro_left3;
                String string6 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseRDDFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
                String $org_scalatest_assert_macro_left4 = foo4 = Bytes.toString((byte[])CellUtil.cloneValue((Cell)table.get(new Get(Bytes.toBytes((String)"4"))).getColumnLatestCell(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"d"))));
                String $org_scalatest_assert_macro_right4 = "foo";
                String string7 = $org_scalatest_assert_macro_left4;
                String string8 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseRDDFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
                String $org_scalatest_assert_macro_left5 = foo5 = Bytes.toString((byte[])CellUtil.cloneValue((Cell)table.get(new Get(Bytes.toBytes((String)"5"))).getColumnLatestCell(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"e"))));
                String $org_scalatest_assert_macro_right5 = "bar";
                String string9 = $org_scalatest_assert_macro_left5;
                String string10 = $org_scalatest_assert_macro_right5;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(string9 != null ? !string9.equals(string10) : string10 != null), Prettifier$.MODULE$.default());
                assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseRDDFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
            }
            finally {
                table.close();
                connection.close();
            }
            return assertion;
        }, new Position("HBaseRDDFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        this.test("bulkDelete to test HBase client", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            Configuration config = this.TEST_UTIL().getConfiguration();
            Connection connection = ConnectionFactory.createConnection((Configuration)config);
            Table table = connection.getTable(TableName.valueOf((String)"t1"));
            try {
                Put put = new Put(Bytes.toBytes((String)"delete1"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"foo1"));
                table.put(put);
                put = new Put(Bytes.toBytes((String)"delete2"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"foo2"));
                table.put(put);
                put = new Put(Bytes.toBytes((String)"delete3"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"foo3"));
                table.put(put);
                SparkContext qual$2 = this.sc();
                WrappedArray x$3 = Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{Bytes.toBytes((String)"delete1"), Bytes.toBytes((String)"delete3")});
                int x$4 = qual$2.parallelize$default$2();
                RDD rdd = qual$2.parallelize((Seq)x$3, x$4, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
                HBaseContext hbaseContext = new HBaseContext(this.sc(), config, HBaseContext$.MODULE$.$lessinit$greater$default$3());
                HBaseRDDFunctions$.MODULE$.GenericHBaseRDDFunctions(rdd).hbaseBulkDelete(hbaseContext, TableName.valueOf((String)this.tableName()), (Function1 & Serializable & scala.Serializable)putRecord -> new Delete(putRecord), 4);
                Cell $org_scalatest_assert_macro_left = table.get(new Get(Bytes.toBytes((String)"delete1"))).getColumnLatestCell(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"));
                Object $org_scalatest_assert_macro_right = null;
                Cell cell = $org_scalatest_assert_macro_left;
                Object var13_12 = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", null, !(cell != null ? !cell.equals(var13_12) : var13_12 != null), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseRDDFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
                Cell $org_scalatest_assert_macro_left2 = table.get(new Get(Bytes.toBytes((String)"delete3"))).getColumnLatestCell(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"));
                Object $org_scalatest_assert_macro_right2 = null;
                Cell cell2 = $org_scalatest_assert_macro_left2;
                Object var17_16 = null;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", null, !(cell2 != null ? !cell2.equals(var17_16) : var17_16 != null), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseRDDFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)table.get(new Get(Bytes.toBytes((String)"delete2"))).getColumnLatestCell(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a")))).equals("foo2"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(table.get(new org.apache.hadoop.hbase.client.Get(org.apache.hadoop.hbase.util.Bytes.toBytes(\"delete2\"))).getColumnLatestCell(org.apache.hadoop.hbase.util.Bytes.toBytes(HBaseRDDFunctionsSuite.this.columnFamily), org.apache.hadoop.hbase.util.Bytes.toBytes(\"a\")))).equals(\"foo2\")", Prettifier$.MODULE$.default());
                assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseRDDFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
            }
            finally {
                table.close();
                connection.close();
            }
            return assertion;
        }, new Position("HBaseRDDFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        this.test("bulkGet to test HBase client", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String[] getArray;
            Configuration config = this.TEST_UTIL().getConfiguration();
            Connection connection = ConnectionFactory.createConnection((Configuration)config);
            Table table = connection.getTable(TableName.valueOf((String)"t1"));
            try {
                Put put = new Put(Bytes.toBytes((String)"get1"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"foo1"));
                table.put(put);
                put = new Put(Bytes.toBytes((String)"get2"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"foo2"));
                table.put(put);
                put = new Put(Bytes.toBytes((String)"get3"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"foo3"));
                table.put(put);
            }
            finally {
                table.close();
                connection.close();
            }
            SparkContext qual$3 = this.sc();
            WrappedArray x$5 = Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{Bytes.toBytes((String)"get1"), Bytes.toBytes((String)"get2"), Bytes.toBytes((String)"get3"), Bytes.toBytes((String)"get4")});
            int x$6 = qual$3.parallelize$default$2();
            RDD rdd = qual$3.parallelize((Seq)x$5, x$6, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
            HBaseContext hbaseContext = new HBaseContext(this.sc(), config, HBaseContext$.MODULE$.$lessinit$greater$default$3());
            RDD getRdd = HBaseRDDFunctions$.MODULE$.GenericHBaseRDDFunctions(rdd).hbaseBulkGet(hbaseContext, TableName.valueOf((String)this.tableName()), 2, (Function1 & Serializable & scala.Serializable)record -> new Get(record), (Function1 & Serializable & scala.Serializable)result -> {
                String string;
                if (result.listCells() != null) {
                    java.util.Iterator it = result.listCells().iterator();
                    StringBuilder B = new StringBuilder();
                    B.append(new java.lang.StringBuilder(1).append(Bytes.toString((byte[])result.getRow())).append(":").toString());
                    while (it.hasNext()) {
                        Cell cell = (Cell)it.next();
                        String q = Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)cell));
                        StringBuilder stringBuilder = q.equals("counter") ? B.append(new java.lang.StringBuilder(3).append("(").append(q).append(",").append(Bytes.toLong((byte[])CellUtil.cloneValue((Cell)cell))).append(")").toString()) : B.append(new java.lang.StringBuilder(3).append("(").append(q).append(",").append(Bytes.toString((byte[])CellUtil.cloneValue((Cell)cell))).append(")").toString());
                    }
                    string = String.valueOf(B.toString());
                } else {
                    string = "";
                }
                return string;
            }, ClassTag$.MODULE$.apply(String.class));
            String[] $org_scalatest_assert_macro_left = getArray = (String[])getRdd.collect();
            int $org_scalatest_assert_macro_right = 4;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseRDDFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
            Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])getArray);
            String $org_scalatest_assert_macro_right2 = "get1:(a,foo1)";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "contains", (Object)$org_scalatest_assert_macro_right2, new ArrayOps.ofRef($org_scalatest_assert_macro_left2).contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseRDDFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
            Object[] $org_scalatest_assert_macro_left3 = Predef$.MODULE$.refArrayOps((Object[])getArray);
            String $org_scalatest_assert_macro_right3 = "get2:(a,foo2)";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left3), "contains", (Object)$org_scalatest_assert_macro_right3, new ArrayOps.ofRef($org_scalatest_assert_macro_left3).contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseRDDFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
            Object[] $org_scalatest_assert_macro_left4 = Predef$.MODULE$.refArrayOps((Object[])getArray);
            String $org_scalatest_assert_macro_right4 = "get3:(a,foo3)";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left4), "contains", (Object)$org_scalatest_assert_macro_right4, new ArrayOps.ofRef($org_scalatest_assert_macro_left4).contains((Object)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseRDDFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
        }, new Position("HBaseRDDFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
        this.test("bulkGet default converter to test HBase client", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String[] getArray;
            Configuration config = this.TEST_UTIL().getConfiguration();
            Connection connection = ConnectionFactory.createConnection((Configuration)config);
            Table table = connection.getTable(TableName.valueOf((String)"t1"));
            try {
                Put put = new Put(Bytes.toBytes((String)"get1"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"foo1"));
                table.put(put);
                put = new Put(Bytes.toBytes((String)"get2"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"foo2"));
                table.put(put);
                put = new Put(Bytes.toBytes((String)"get3"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"foo3"));
                table.put(put);
            }
            finally {
                table.close();
                connection.close();
            }
            SparkContext qual$4 = this.sc();
            WrappedArray x$7 = Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{Bytes.toBytes((String)"get1"), Bytes.toBytes((String)"get2"), Bytes.toBytes((String)"get3"), Bytes.toBytes((String)"get4")});
            int x$8 = qual$4.parallelize$default$2();
            RDD rdd = qual$4.parallelize((Seq)x$7, x$8, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
            HBaseContext hbaseContext = new HBaseContext(this.sc(), config, HBaseContext$.MODULE$.$lessinit$greater$default$3());
            RDD getRdd = HBaseRDDFunctions$.MODULE$.GenericHBaseRDDFunctions(rdd).hbaseBulkGet(hbaseContext, TableName.valueOf((String)"t1"), 2, (Function1 & Serializable & scala.Serializable)record -> new Get(record)).map((Function1 & Serializable & scala.Serializable)row -> {
                String string;
                if (row != null && ((Result)row._2()).listCells() != null) {
                    java.util.Iterator it = ((Result)row._2()).listCells().iterator();
                    StringBuilder B = new StringBuilder();
                    B.append(new java.lang.StringBuilder(1).append(Bytes.toString((byte[])((Result)row._2()).getRow())).append(":").toString());
                    while (it.hasNext()) {
                        Cell cell = (Cell)it.next();
                        String q = Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)cell));
                        StringBuilder stringBuilder = q.equals("counter") ? B.append(new java.lang.StringBuilder(3).append("(").append(q).append(",").append(Bytes.toLong((byte[])CellUtil.cloneValue((Cell)cell))).append(")").toString()) : B.append(new java.lang.StringBuilder(3).append("(").append(q).append(",").append(Bytes.toString((byte[])CellUtil.cloneValue((Cell)cell))).append(")").toString());
                    }
                    string = String.valueOf(B.toString());
                } else {
                    string = "";
                }
                return string;
            }, ClassTag$.MODULE$.apply(String.class));
            String[] $org_scalatest_assert_macro_left = getArray = (String[])getRdd.collect();
            int $org_scalatest_assert_macro_right = 4;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseRDDFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
            Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])getArray);
            String $org_scalatest_assert_macro_right2 = "get1:(a,foo1)";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "contains", (Object)$org_scalatest_assert_macro_right2, new ArrayOps.ofRef($org_scalatest_assert_macro_left2).contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseRDDFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
            Object[] $org_scalatest_assert_macro_left3 = Predef$.MODULE$.refArrayOps((Object[])getArray);
            String $org_scalatest_assert_macro_right3 = "get2:(a,foo2)";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left3), "contains", (Object)$org_scalatest_assert_macro_right3, new ArrayOps.ofRef($org_scalatest_assert_macro_left3).contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseRDDFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
            Object[] $org_scalatest_assert_macro_left4 = Predef$.MODULE$.refArrayOps((Object[])getArray);
            String $org_scalatest_assert_macro_right4 = "get3:(a,foo3)";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left4), "contains", (Object)$org_scalatest_assert_macro_right4, new ArrayOps.ofRef($org_scalatest_assert_macro_left4).contains((Object)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseRDDFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
        }, new Position("HBaseRDDFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 222));
        this.test("foreachPartition with puts to test HBase client", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            Configuration config = this.TEST_UTIL().getConfiguration();
            SparkContext qual$5 = this.sc();
            WrappedArray x$9 = Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)Bytes.toBytes((String)"1foreach"), (Object)new Tuple3[]{new Tuple3((Object)Bytes.toBytes((String)this.columnFamily()), (Object)Bytes.toBytes((String)"a"), (Object)Bytes.toBytes((String)"foo1"))}), new Tuple2((Object)Bytes.toBytes((String)"2foreach"), (Object)new Tuple3[]{new Tuple3((Object)Bytes.toBytes((String)this.columnFamily()), (Object)Bytes.toBytes((String)"b"), (Object)Bytes.toBytes((String)"foo2"))}), new Tuple2((Object)Bytes.toBytes((String)"3foreach"), (Object)new Tuple3[]{new Tuple3((Object)Bytes.toBytes((String)this.columnFamily()), (Object)Bytes.toBytes((String)"c"), (Object)Bytes.toBytes((String)"foo3"))}), new Tuple2((Object)Bytes.toBytes((String)"4foreach"), (Object)new Tuple3[]{new Tuple3((Object)Bytes.toBytes((String)this.columnFamily()), (Object)Bytes.toBytes((String)"d"), (Object)Bytes.toBytes((String)"foo"))}), new Tuple2((Object)Bytes.toBytes((String)"5foreach"), (Object)new Tuple3[]{new Tuple3((Object)Bytes.toBytes((String)this.columnFamily()), (Object)Bytes.toBytes((String)"e"), (Object)Bytes.toBytes((String)"bar"))})});
            int x$10 = qual$5.parallelize$default$2();
            RDD rdd = qual$5.parallelize((Seq)x$9, x$10, ClassTag$.MODULE$.apply(Tuple2.class));
            HBaseContext hbaseContext = new HBaseContext(this.sc(), config, HBaseContext$.MODULE$.$lessinit$greater$default$3());
            HBaseRDDFunctions$.MODULE$.GenericHBaseRDDFunctions(rdd).hbaseForeachPartition(hbaseContext, (Function2 & Serializable & scala.Serializable)(it, conn) -> {
                HBaseRDDFunctionsSuite.$anonfun$new$13(it, conn);
                return BoxedUnit.UNIT;
            });
            Connection connection = ConnectionFactory.createConnection((Configuration)config);
            Table table = connection.getTable(TableName.valueOf((String)"t1"));
            try {
                String foo5;
                String foo4;
                String foo3;
                String foo2;
                String foo1;
                String $org_scalatest_assert_macro_left = foo1 = Bytes.toString((byte[])CellUtil.cloneValue((Cell)table.get(new Get(Bytes.toBytes((String)"1foreach"))).getColumnLatestCell(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"))));
                String $org_scalatest_assert_macro_right = "foo1";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseRDDFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
                String $org_scalatest_assert_macro_left2 = foo2 = Bytes.toString((byte[])CellUtil.cloneValue((Cell)table.get(new Get(Bytes.toBytes((String)"2foreach"))).getColumnLatestCell(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"b"))));
                String $org_scalatest_assert_macro_right2 = "foo2";
                String string3 = $org_scalatest_assert_macro_left2;
                String string4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseRDDFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
                String $org_scalatest_assert_macro_left3 = foo3 = Bytes.toString((byte[])CellUtil.cloneValue((Cell)table.get(new Get(Bytes.toBytes((String)"3foreach"))).getColumnLatestCell(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"c"))));
                String $org_scalatest_assert_macro_right3 = "foo3";
                String string5 = $org_scalatest_assert_macro_left3;
                String string6 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseRDDFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
                String $org_scalatest_assert_macro_left4 = foo4 = Bytes.toString((byte[])CellUtil.cloneValue((Cell)table.get(new Get(Bytes.toBytes((String)"4foreach"))).getColumnLatestCell(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"d"))));
                String $org_scalatest_assert_macro_right4 = "foo";
                String string7 = $org_scalatest_assert_macro_left4;
                String string8 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseRDDFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 326));
                String $org_scalatest_assert_macro_left5 = foo5 = Bytes.toString((byte[])CellUtil.cloneValue((Cell)table.get(new Get(Bytes.toBytes((String)"5"))).getColumnLatestCell(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"e"))));
                String $org_scalatest_assert_macro_right5 = "bar";
                String string9 = $org_scalatest_assert_macro_left5;
                String string10 = $org_scalatest_assert_macro_right5;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(string9 != null ? !string9.equals(string10) : string10 != null), Prettifier$.MODULE$.default());
                assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseRDDFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 330));
            }
            finally {
                table.close();
                connection.close();
            }
            return assertion;
        }, new Position("HBaseRDDFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
        this.test("mapPartitions with Get from test HBase client", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String[] getArray;
            Configuration config = this.TEST_UTIL().getConfiguration();
            Connection connection = ConnectionFactory.createConnection((Configuration)config);
            Table table = connection.getTable(TableName.valueOf((String)"t1"));
            try {
                Put put = new Put(Bytes.toBytes((String)"get1"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"foo1"));
                table.put(put);
                put = new Put(Bytes.toBytes((String)"get2"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"foo2"));
                table.put(put);
                put = new Put(Bytes.toBytes((String)"get3"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"foo3"));
                table.put(put);
            }
            finally {
                table.close();
                connection.close();
            }
            SparkContext qual$6 = this.sc();
            WrappedArray x$11 = Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{Bytes.toBytes((String)"get1"), Bytes.toBytes((String)"get2"), Bytes.toBytes((String)"get3"), Bytes.toBytes((String)"get4")});
            int x$12 = qual$6.parallelize$default$2();
            RDD rdd = qual$6.parallelize((Seq)x$11, x$12, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
            HBaseContext hbaseContext = new HBaseContext(this.sc(), config, HBaseContext$.MODULE$.$lessinit$greater$default$3());
            RDD getRdd = HBaseRDDFunctions$.MODULE$.GenericHBaseRDDFunctions(rdd).hbaseMapPartitions(hbaseContext, (Function2 & Serializable & scala.Serializable)(it, conn) -> {
                Table table = conn.getTable(TableName.valueOf((String)"t1"));
                ObjectRef res = ObjectRef.create((Object)((MutableList)MutableList$.MODULE$.apply((Seq)Nil$.MODULE$)));
                it.foreach((Function1 & Serializable & scala.Serializable)r -> {
                    MutableList mutableList;
                    Get get = new Get(r);
                    Result result = table.get(get);
                    if (result.listCells() != null) {
                        java.util.Iterator it = result.listCells().iterator();
                        StringBuilder B = new StringBuilder();
                        B.append(new java.lang.StringBuilder(1).append(Bytes.toString((byte[])result.getRow())).append(":").toString());
                        while (it.hasNext()) {
                            Cell cell = (Cell)it.next();
                            String q = Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)cell));
                            StringBuilder stringBuilder = q.equals("counter") ? B.append(new java.lang.StringBuilder(3).append("(").append(q).append(",").append(Bytes.toLong((byte[])CellUtil.cloneValue((Cell)cell))).append(")").toString()) : B.append(new java.lang.StringBuilder(3).append("(").append(q).append(",").append(Bytes.toString((byte[])CellUtil.cloneValue((Cell)cell))).append(")").toString());
                        }
                        mutableList = ((MutableList)res$1.elem).$plus$eq((Object)String.valueOf(B.toString()));
                    } else {
                        mutableList = ((MutableList)res$1.elem).$plus$eq((Object)"");
                    }
                    return mutableList;
                });
                return ((MutableList)res.elem).iterator();
            }, ClassTag$.MODULE$.apply(String.class));
            String[] $org_scalatest_assert_macro_left = getArray = (String[])getRdd.collect();
            int $org_scalatest_assert_macro_right = 4;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseRDDFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 397));
            Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])getArray);
            String $org_scalatest_assert_macro_right2 = "get1:(a,foo1)";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "contains", (Object)$org_scalatest_assert_macro_right2, new ArrayOps.ofRef($org_scalatest_assert_macro_left2).contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseRDDFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 398));
            Object[] $org_scalatest_assert_macro_left3 = Predef$.MODULE$.refArrayOps((Object[])getArray);
            String $org_scalatest_assert_macro_right3 = "get2:(a,foo2)";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left3), "contains", (Object)$org_scalatest_assert_macro_right3, new ArrayOps.ofRef($org_scalatest_assert_macro_left3).contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseRDDFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 399));
            Object[] $org_scalatest_assert_macro_left4 = Predef$.MODULE$.refArrayOps((Object[])getArray);
            String $org_scalatest_assert_macro_right4 = "get3:(a,foo3)";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left4), "contains", (Object)$org_scalatest_assert_macro_right4, new ArrayOps.ofRef($org_scalatest_assert_macro_left4).contains((Object)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseRDDFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 400));
        }, new Position("HBaseRDDFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 337));
    }
}

