/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.spark.DefaultSourceSuite;
import org.apache.hadoop.hbase.spark.HBaseContext;
import org.apache.hadoop.hbase.spark.HBaseContext$;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.rdd.RDD;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.FunSuite;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u00194A\u0001E\t\u00019!)\u0011\u0006\u0001C\u0001U!9Q\u0006\u0001b\u0001\n\u0003q\u0003BB\u001b\u0001A\u0003%q\u0006C\u00047\u0001\u0001\u0007I\u0011A\u001c\t\u000fu\u0002\u0001\u0019!C\u0001}!1q\t\u0001Q!\naBq\u0001\u0014\u0001A\u0002\u0013\u0005Q\nC\u0004S\u0001\u0001\u0007I\u0011A*\t\rU\u0003\u0001\u0015)\u0003O\u0011\u001d1\u0006A1A\u0005\u0002]Ca\u0001\u0019\u0001!\u0002\u0013A\u0006bB1\u0001\u0005\u0004%\ta\u0016\u0005\u0007E\u0002\u0001\u000b\u0011\u0002-\t\u000b\r\u0004A\u0011\t3\t\u000b\u0015\u0004A\u0011\t3\u0003#!\u0013\u0015m]3D_:$X\r\u001f;Tk&$XM\u0003\u0002\u0013'\u0005)1\u000f]1sW*\u0011A#F\u0001\u0006Q\n\f7/\u001a\u0006\u0003-]\ta\u0001[1e_>\u0004(B\u0001\r\u001a\u0003\u0019\t\u0007/Y2iK*\t!$A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001;\r2\u0003C\u0001\u0010\"\u001b\u0005y\"B\u0001\u0011\u001a\u0003%\u00198-\u00197bi\u0016\u001cH/\u0003\u0002#?\tAa)\u001e8Tk&$X\r\u0005\u0002\u001fI%\u0011Qe\b\u0002\u0013\u0005\u00164wN]3B]\u0012\fe\r^3s\u000b\u0006\u001c\u0007\u000e\u0005\u0002\u001fO%\u0011\u0001f\b\u0002\u0012\u0005\u00164wN]3B]\u0012\fe\r^3s\u00032d\u0017A\u0002\u001fj]&$h\bF\u0001,!\ta\u0003!D\u0001\u0012\u0003\u0019awnZ4feV\tq\u0006\u0005\u00021g5\t\u0011G\u0003\u000233\u0005)1\u000f\u001c45U&\u0011A'\r\u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u0005\u00111oY\u000b\u0002qA\u0011\u0011hO\u0007\u0002u)\u0011!cF\u0005\u0003yi\u0012Ab\u00159be.\u001cuN\u001c;fqR\faa]2`I\u0015\fHCA F!\t\u00015)D\u0001B\u0015\u0005\u0011\u0015!B:dC2\f\u0017B\u0001#B\u0005\u0011)f.\u001b;\t\u000f\u0019+\u0011\u0011!a\u0001q\u0005\u0019\u0001\u0010J\u0019\u0002\u0007M\u001c\u0007\u0005\u000b\u0002\u0007\u0013B\u0011\u0001IS\u0005\u0003\u0017\u0006\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u0013Q+5\u000bV0V)&cU#\u0001(\u0011\u0005=\u0003V\"A\n\n\u0005E\u001b\"a\u0005%CCN,G+Z:uS:<W\u000b^5mSRL\u0018!\u0004+F'R{V\u000bV%M?\u0012*\u0017\u000f\u0006\u0002@)\"9a\tCA\u0001\u0002\u0004q\u0015A\u0003+F'R{V\u000bV%MA\u0005IA/\u00192mK:\u000bW.Z\u000b\u00021B\u0011\u0011LX\u0007\u00025*\u00111\fX\u0001\u0005Y\u0006twMC\u0001^\u0003\u0011Q\u0017M^1\n\u0005}S&AB*ue&tw-\u0001\u0006uC\ndWMT1nK\u0002\nAbY8mk6tg)Y7jYf\fQbY8mk6tg)Y7jYf\u0004\u0013!\u00032fM>\u0014X-\u00117m)\u0005y\u0014\u0001C1gi\u0016\u0014\u0018\t\u001c7")
public class HBaseContextSuite
extends FunSuite
implements BeforeAndAfterEach,
BeforeAndAfterAll {
    private final Logger logger;
    private transient SparkContext sc;
    private HBaseTestingUtility TEST_UTIL;
    private final String tableName;
    private final String columnFamily;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    public /* synthetic */ Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.run$((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return FunSuiteLike.runTest$((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    public void afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public Logger logger() {
        return this.logger;
    }

    public SparkContext sc() {
        return this.sc;
    }

    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    public HBaseTestingUtility TEST_UTIL() {
        return this.TEST_UTIL;
    }

    public void TEST_UTIL_$eq(HBaseTestingUtility x$1) {
        this.TEST_UTIL = x$1;
    }

    public String tableName() {
        return this.tableName;
    }

    public String columnFamily() {
        return this.columnFamily;
    }

    public void beforeAll() {
        this.TEST_UTIL().startMiniCluster();
        this.logger().info(" - minicluster started");
        try {
            this.TEST_UTIL().deleteTable(TableName.valueOf((String)this.tableName()));
        }
        catch (Exception e) {
            this.logger().info(new java.lang.StringBuilder(18).append(" - no table ").append(this.tableName()).append(" found").toString());
        }
        this.logger().info(new java.lang.StringBuilder(18).append(" - creating table ").append(this.tableName()).toString());
        this.TEST_UTIL().createTable(TableName.valueOf((String)this.tableName()), Bytes.toBytes((String)this.columnFamily()));
        this.logger().info(" - created table");
        scala.collection.immutable.Map envMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"Xmx", (Object)"512m")}));
        this.sc_$eq(new SparkContext("local", "test", null, (Seq)Nil$.MODULE$, (Map)envMap));
    }

    public void afterAll() {
        this.logger().info("shuting down minicluster");
        this.TEST_UTIL().shutdownMiniCluster();
        this.logger().info(" - minicluster shut down");
        this.TEST_UTIL().cleanupTestDir();
        this.sc().stop();
    }

    public static final /* synthetic */ void $anonfun$new$16(IntRef nullCounter$1, IntRef noValueCounter$1, String r) {
        block1: {
            block0: {
                if (!"null".equals(r)) break block0;
                ++nullCounter$1.elem;
                break block1;
            }
            if (!"noValue".equals(r)) break block1;
            ++noValueCounter$1.elem;
        }
    }

    public HBaseContextSuite() {
        BeforeAndAfterEach.$init$((BeforeAndAfterEach)this);
        BeforeAndAfterAll.$init$((BeforeAndAfterAll)this);
        this.logger = LoggerFactory.getLogger(DefaultSourceSuite.class);
        this.sc = null;
        this.TEST_UTIL = new HBaseTestingUtility();
        this.tableName = "t1";
        this.columnFamily = "c";
        this.test("bulkput to test HBase client", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            Configuration config = this.TEST_UTIL().getConfiguration();
            SparkContext qual$1 = this.sc();
            WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)Bytes.toBytes((String)"1"), (Object)new Tuple3[]{new Tuple3((Object)Bytes.toBytes((String)this.columnFamily()), (Object)Bytes.toBytes((String)"a"), (Object)Bytes.toBytes((String)"foo1"))}), new Tuple2((Object)Bytes.toBytes((String)"2"), (Object)new Tuple3[]{new Tuple3((Object)Bytes.toBytes((String)this.columnFamily()), (Object)Bytes.toBytes((String)"b"), (Object)Bytes.toBytes((String)"foo2"))}), new Tuple2((Object)Bytes.toBytes((String)"3"), (Object)new Tuple3[]{new Tuple3((Object)Bytes.toBytes((String)this.columnFamily()), (Object)Bytes.toBytes((String)"c"), (Object)Bytes.toBytes((String)"foo3"))}), new Tuple2((Object)Bytes.toBytes((String)"4"), (Object)new Tuple3[]{new Tuple3((Object)Bytes.toBytes((String)this.columnFamily()), (Object)Bytes.toBytes((String)"d"), (Object)Bytes.toBytes((String)"foo"))}), new Tuple2((Object)Bytes.toBytes((String)"5"), (Object)new Tuple3[]{new Tuple3((Object)Bytes.toBytes((String)this.columnFamily()), (Object)Bytes.toBytes((String)"e"), (Object)Bytes.toBytes((String)"bar"))})});
            int x$2 = qual$1.parallelize$default$2();
            RDD rdd = qual$1.parallelize((Seq)x$1, x$2, ClassTag$.MODULE$.apply(Tuple2.class));
            HBaseContext hbaseContext = new HBaseContext(this.sc(), config, HBaseContext$.MODULE$.$lessinit$greater$default$3());
            hbaseContext.bulkPut(rdd, TableName.valueOf((String)this.tableName()), (Function1 & Serializable & scala.Serializable)putRecord -> {
                void var1_1;
                Put put = new Put((byte[])putRecord._1());
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])putRecord._2())).foreach((Function1 & Serializable & scala.Serializable)putValue -> put.addColumn((byte[])putValue._1(), (byte[])putValue._2(), (byte[])putValue._3()));
                return var1_1;
            });
            Connection connection = ConnectionFactory.createConnection((Configuration)config);
            Table table = connection.getTable(TableName.valueOf((String)"t1"));
            try {
                String foo5;
                String foo4;
                String foo3;
                String foo2;
                String foo1;
                String $org_scalatest_assert_macro_left = foo1 = Bytes.toString((byte[])CellUtil.cloneValue((Cell)table.get(new Get(Bytes.toBytes((String)"1"))).getColumnLatestCell(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"))));
                String $org_scalatest_assert_macro_right = "foo1";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
                String $org_scalatest_assert_macro_left2 = foo2 = Bytes.toString((byte[])CellUtil.cloneValue((Cell)table.get(new Get(Bytes.toBytes((String)"2"))).getColumnLatestCell(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"b"))));
                String $org_scalatest_assert_macro_right2 = "foo2";
                String string3 = $org_scalatest_assert_macro_left2;
                String string4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
                String $org_scalatest_assert_macro_left3 = foo3 = Bytes.toString((byte[])CellUtil.cloneValue((Cell)table.get(new Get(Bytes.toBytes((String)"3"))).getColumnLatestCell(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"c"))));
                String $org_scalatest_assert_macro_right3 = "foo3";
                String string5 = $org_scalatest_assert_macro_left3;
                String string6 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
                String $org_scalatest_assert_macro_left4 = foo4 = Bytes.toString((byte[])CellUtil.cloneValue((Cell)table.get(new Get(Bytes.toBytes((String)"4"))).getColumnLatestCell(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"d"))));
                String $org_scalatest_assert_macro_right4 = "foo";
                String string7 = $org_scalatest_assert_macro_left4;
                String string8 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
                String $org_scalatest_assert_macro_left5 = foo5 = Bytes.toString((byte[])CellUtil.cloneValue((Cell)table.get(new Get(Bytes.toBytes((String)"5"))).getColumnLatestCell(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"e"))));
                String $org_scalatest_assert_macro_right5 = "bar";
                String string9 = $org_scalatest_assert_macro_left5;
                String string10 = $org_scalatest_assert_macro_right5;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(string9 != null ? !string9.equals(string10) : string10 != null), Prettifier$.MODULE$.default());
                assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
            }
            finally {
                table.close();
                connection.close();
            }
            return assertion;
        }, new Position("HBaseContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        this.test("bulkDelete to test HBase client", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            Configuration config = this.TEST_UTIL().getConfiguration();
            Connection connection = ConnectionFactory.createConnection((Configuration)config);
            Table table = connection.getTable(TableName.valueOf((String)"t1"));
            try {
                Put put = new Put(Bytes.toBytes((String)"delete1"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"foo1"));
                table.put(put);
                put = new Put(Bytes.toBytes((String)"delete2"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"foo2"));
                table.put(put);
                put = new Put(Bytes.toBytes((String)"delete3"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"foo3"));
                table.put(put);
                SparkContext qual$2 = this.sc();
                WrappedArray x$3 = Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{Bytes.toBytes((String)"delete1"), Bytes.toBytes((String)"delete3")});
                int x$4 = qual$2.parallelize$default$2();
                RDD rdd = qual$2.parallelize((Seq)x$3, x$4, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
                HBaseContext hbaseContext = new HBaseContext(this.sc(), config, HBaseContext$.MODULE$.$lessinit$greater$default$3());
                hbaseContext.bulkDelete(rdd, TableName.valueOf((String)this.tableName()), (Function1 & Serializable & scala.Serializable)putRecord -> new Delete(putRecord), Predef$.MODULE$.int2Integer(4));
                Cell $org_scalatest_assert_macro_left = table.get(new Get(Bytes.toBytes((String)"delete1"))).getColumnLatestCell(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"));
                Object $org_scalatest_assert_macro_right = null;
                Cell cell = $org_scalatest_assert_macro_left;
                Object var13_12 = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", null, !(cell != null ? !cell.equals(var13_12) : var13_12 != null), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
                Cell $org_scalatest_assert_macro_left2 = table.get(new Get(Bytes.toBytes((String)"delete3"))).getColumnLatestCell(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"));
                Object $org_scalatest_assert_macro_right2 = null;
                Cell cell2 = $org_scalatest_assert_macro_left2;
                Object var17_16 = null;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", null, !(cell2 != null ? !cell2.equals(var17_16) : var17_16 != null), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)table.get(new Get(Bytes.toBytes((String)"delete2"))).getColumnLatestCell(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a")))).equals("foo2"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(table.get(new org.apache.hadoop.hbase.client.Get(org.apache.hadoop.hbase.util.Bytes.toBytes(\"delete2\"))).getColumnLatestCell(org.apache.hadoop.hbase.util.Bytes.toBytes(HBaseContextSuite.this.columnFamily), org.apache.hadoop.hbase.util.Bytes.toBytes(\"a\")))).equals(\"foo2\")", Prettifier$.MODULE$.default());
                assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
            }
            finally {
                table.close();
                connection.close();
            }
            return assertion;
        }, new Position("HBaseContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
        this.test("bulkGet to test HBase client", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String[] getArray;
            Configuration config = this.TEST_UTIL().getConfiguration();
            Connection connection = ConnectionFactory.createConnection((Configuration)config);
            Table table = connection.getTable(TableName.valueOf((String)"t1"));
            try {
                Put put = new Put(Bytes.toBytes((String)"get1"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"foo1"));
                table.put(put);
                put = new Put(Bytes.toBytes((String)"get2"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"foo2"));
                table.put(put);
                put = new Put(Bytes.toBytes((String)"get3"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"foo3"));
                table.put(put);
            }
            finally {
                table.close();
                connection.close();
            }
            SparkContext qual$3 = this.sc();
            WrappedArray x$5 = Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{Bytes.toBytes((String)"get1"), Bytes.toBytes((String)"get2"), Bytes.toBytes((String)"get3"), Bytes.toBytes((String)"get4")});
            int x$6 = qual$3.parallelize$default$2();
            RDD rdd = qual$3.parallelize((Seq)x$5, x$6, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
            HBaseContext hbaseContext = new HBaseContext(this.sc(), config, HBaseContext$.MODULE$.$lessinit$greater$default$3());
            RDD getRdd = hbaseContext.bulkGet(TableName.valueOf((String)this.tableName()), Predef$.MODULE$.int2Integer(2), rdd, (Function1 & Serializable & scala.Serializable)record -> new Get(record), (Function1 & Serializable & scala.Serializable)result -> {
                String string;
                if (result.listCells() != null) {
                    Iterator it = result.listCells().iterator();
                    StringBuilder B = new StringBuilder();
                    B.append(new java.lang.StringBuilder(1).append(Bytes.toString((byte[])result.getRow())).append(":").toString());
                    while (it.hasNext()) {
                        Cell cell = (Cell)it.next();
                        String q = Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)cell));
                        StringBuilder stringBuilder = q.equals("counter") ? B.append(new java.lang.StringBuilder(3).append("(").append(q).append(",").append(Bytes.toLong((byte[])CellUtil.cloneValue((Cell)cell))).append(")").toString()) : B.append(new java.lang.StringBuilder(3).append("(").append(q).append(",").append(Bytes.toString((byte[])CellUtil.cloneValue((Cell)cell))).append(")").toString());
                    }
                    string = String.valueOf(B.toString());
                } else {
                    string = "";
                }
                return string;
            }, ClassTag$.MODULE$.apply(String.class));
            String[] $org_scalatest_assert_macro_left = getArray = (String[])getRdd.collect();
            int $org_scalatest_assert_macro_right = 4;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
            Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])getArray);
            String $org_scalatest_assert_macro_right2 = "get1:(a,foo1)";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "contains", (Object)$org_scalatest_assert_macro_right2, new ArrayOps.ofRef($org_scalatest_assert_macro_left2).contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
            Object[] $org_scalatest_assert_macro_left3 = Predef$.MODULE$.refArrayOps((Object[])getArray);
            String $org_scalatest_assert_macro_right3 = "get2:(a,foo2)";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left3), "contains", (Object)$org_scalatest_assert_macro_right3, new ArrayOps.ofRef($org_scalatest_assert_macro_left3).contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
            Object[] $org_scalatest_assert_macro_left4 = Predef$.MODULE$.refArrayOps((Object[])getArray);
            String $org_scalatest_assert_macro_right4 = "get3:(a,foo3)";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left4), "contains", (Object)$org_scalatest_assert_macro_right4, new ArrayOps.ofRef($org_scalatest_assert_macro_left4).contains((Object)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
        }, new Position("HBaseContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
        this.test("BulkGet failure test: bad table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Configuration config = this.TEST_UTIL().getConfiguration();
            SparkContext qual$4 = this.sc();
            WrappedArray x$7 = Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{Bytes.toBytes((String)"get1"), Bytes.toBytes((String)"get2"), Bytes.toBytes((String)"get3"), Bytes.toBytes((String)"get4")});
            int x$8 = qual$4.parallelize$default$2();
            RDD rdd = qual$4.parallelize((Seq)x$7, x$8, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
            HBaseContext hbaseContext = new HBaseContext(this.sc(), config, HBaseContext$.MODULE$.$lessinit$greater$default$3());
            return (SparkException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> {
                try {
                    RDD getRdd = hbaseContext.bulkGet(TableName.valueOf((String)"badTableName"), Predef$.MODULE$.int2Integer(2), rdd, (Function1 & Serializable & scala.Serializable)record -> new Get(record), (Function1 & Serializable & scala.Serializable)result -> "1", ClassTag$.MODULE$.apply(String.class));
                    getRdd.collect();
                    throw this.fail("We should have failed and not reached this line", new Position("HBaseContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
                }
                catch (SparkException ex) {
                    String $org_scalatest_assert_macro_left = ex.getMessage();
                    String $org_scalatest_assert_macro_right = "org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException";
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
                    throw ex;
                }
            }, ClassTag$.MODULE$.apply(SparkException.class), new Position("HBaseContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228))));
        }, new Position("HBaseContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
        this.test("BulkGet failure test: bad column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Configuration config = this.TEST_UTIL().getConfiguration();
            Connection connection = ConnectionFactory.createConnection((Configuration)config);
            Table table = connection.getTable(TableName.valueOf((String)"t1"));
            try {
                Put put = new Put(Bytes.toBytes((String)"get1"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"foo1"));
                table.put(put);
                put = new Put(Bytes.toBytes((String)"get2"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"foo2"));
                table.put(put);
                put = new Put(Bytes.toBytes((String)"get3"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"foo3"));
                table.put(put);
            }
            finally {
                table.close();
                connection.close();
            }
            SparkContext qual$5 = this.sc();
            WrappedArray x$9 = Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{Bytes.toBytes((String)"get1"), Bytes.toBytes((String)"get2"), Bytes.toBytes((String)"get3"), Bytes.toBytes((String)"get4")});
            int x$10 = qual$5.parallelize$default$2();
            RDD rdd = qual$5.parallelize((Seq)x$9, x$10, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
            HBaseContext hbaseContext = new HBaseContext(this.sc(), config, HBaseContext$.MODULE$.$lessinit$greater$default$3());
            RDD getRdd = hbaseContext.bulkGet(TableName.valueOf((String)this.tableName()), Predef$.MODULE$.int2Integer(2), rdd, (Function1 & Serializable & scala.Serializable)record -> new Get(record), (Function1 & Serializable & scala.Serializable)result -> {
                Cell cellValue;
                return result.listCells() != null ? ((cellValue = result.getColumnLatestCell(Bytes.toBytes((String)"c"), Bytes.toBytes((String)"bad_column"))) == null ? "null" : "bad") : "noValue";
            }, ClassTag$.MODULE$.apply(String.class));
            IntRef nullCounter = IntRef.create((int)0);
            IntRef noValueCounter = IntRef.create((int)0);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])getRdd.collect())).foreach((Function1 & Serializable & scala.Serializable)r -> {
                HBaseContextSuite.$anonfun$new$16(nullCounter, noValueCounter, r);
                return BoxedUnit.UNIT;
            });
            int $org_scalatest_assert_macro_left = nullCounter.elem;
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 301));
            int $org_scalatest_assert_macro_left2 = noValueCounter.elem;
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 302));
        }, new Position("HBaseContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253));
        this.test("distributedScan to test HBase client", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            Configuration config = this.TEST_UTIL().getConfiguration();
            Connection connection = ConnectionFactory.createConnection((Configuration)config);
            Table table = connection.getTable(TableName.valueOf((String)"t1"));
            try {
                Put put = new Put(Bytes.toBytes((String)"scan1"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"foo1"));
                table.put(put);
                put = new Put(Bytes.toBytes((String)"scan2"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"foo2"));
                table.put(put);
                put = new Put(Bytes.toBytes((String)"scan3"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"foo3"));
                table.put(put);
                put = new Put(Bytes.toBytes((String)"scan4"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"foo3"));
                table.put(put);
                put = new Put(Bytes.toBytes((String)"scan5"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"foo3"));
                table.put(put);
            }
            finally {
                table.close();
                connection.close();
            }
            HBaseContext hbaseContext = new HBaseContext(this.sc(), config, HBaseContext$.MODULE$.$lessinit$greater$default$3());
            Scan scan = new Scan();
            scan.setCaching(100);
            scan.setStartRow(Bytes.toBytes((String)"scan2"));
            scan.setStopRow(Bytes.toBytes((String)"scan4_"));
            RDD scanRdd = hbaseContext.hbaseRDD(TableName.valueOf((String)this.tableName()), scan);
            try {
                byte[][] scanList;
                byte[][] $org_scalatest_assert_macro_left = scanList = (byte[][])scanRdd.map((Function1 & Serializable & scala.Serializable)r -> ((ImmutableBytesWritable)r._1()).copyBytes(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))).collect();
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                boxedUnit = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HBaseContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        }, new Position("HBaseContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 305));
    }
}

