/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.datasources.hbase;

import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.hbase.spark.AvroSerdes$;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.spark.sql.datasources.hbase.Field;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;

public final class Utils$ {
    public static Utils$ MODULE$;

    static {
        new Utils$();
    }

    public Object hbaseFieldToScalaType(Field f, byte[] src, int offset, int length) {
        Object object;
        if (f.exeSchema().isDefined()) {
            GenericRecord m = AvroSerdes$.MODULE$.deserialize(src, (Schema)f.exeSchema().get());
            Option n = f.avroToCatalyst().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.apply((Object)m));
            object = n.get();
        } else {
            Object object2;
            DataType dataType = f.dt();
            if (BooleanType$.MODULE$.equals(dataType)) {
                object2 = BoxesRunTime.boxToBoolean((boolean)this.toBoolean(src, offset));
            } else if (ByteType$.MODULE$.equals(dataType)) {
                object2 = BoxesRunTime.boxToByte((byte)src[offset]);
            } else if (DoubleType$.MODULE$.equals(dataType)) {
                object2 = BoxesRunTime.boxToDouble((double)Bytes.toDouble((byte[])src, (int)offset));
            } else if (FloatType$.MODULE$.equals(dataType)) {
                object2 = BoxesRunTime.boxToFloat((float)Bytes.toFloat((byte[])src, (int)offset));
            } else if (IntegerType$.MODULE$.equals(dataType)) {
                object2 = BoxesRunTime.boxToInteger((int)Bytes.toInt((byte[])src, (int)offset));
            } else {
                boolean bl = LongType$.MODULE$.equals(dataType) ? true : TimestampType$.MODULE$.equals(dataType);
                if (bl) {
                    object2 = BoxesRunTime.boxToLong((long)Bytes.toLong((byte[])src, (int)offset));
                } else if (ShortType$.MODULE$.equals(dataType)) {
                    object2 = BoxesRunTime.boxToShort((short)Bytes.toShort((byte[])src, (int)offset));
                } else if (StringType$.MODULE$.equals(dataType)) {
                    object2 = Bytes.toString((byte[])src, (int)offset, (int)length);
                } else if (BinaryType$.MODULE$.equals(dataType)) {
                    byte[] newArray = new byte[length];
                    System.arraycopy(src, offset, newArray, 0, length);
                    object2 = newArray;
                } else {
                    throw new Exception(new StringBuilder(22).append("unsupported data type ").append(f.dt()).toString());
                }
            }
            object = object2;
        }
        return object;
    }

    public byte[] toBytes(Object input, Field field) {
        byte[] byArray;
        if (field.schema().isDefined()) {
            Object record = field.catalystToAvro().apply(input);
            byArray = AvroSerdes$.MODULE$.serialize(record, (Schema)field.schema().get());
        } else {
            byte[] byArray2;
            Object object = input;
            if (object instanceof Boolean) {
                boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                byArray2 = Bytes.toBytes((boolean)bl);
            } else if (object instanceof Byte) {
                byte by = BoxesRunTime.unboxToByte((Object)object);
                byArray2 = new byte[]{by};
            } else if (object instanceof byte[]) {
                byte[] byArray3 = (byte[])object;
                byArray2 = byArray3;
            } else if (object instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object);
                byArray2 = Bytes.toBytes((double)d);
            } else if (object instanceof Float) {
                float f = BoxesRunTime.unboxToFloat((Object)object);
                byArray2 = Bytes.toBytes((float)f);
            } else if (object instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)object);
                byArray2 = Bytes.toBytes((int)n);
            } else if (object instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object);
                byArray2 = Bytes.toBytes((long)l);
            } else if (object instanceof Short) {
                short s = BoxesRunTime.unboxToShort((Object)object);
                byArray2 = Bytes.toBytes((short)s);
            } else if (object instanceof UTF8String) {
                UTF8String uTF8String = (UTF8String)object;
                byArray2 = uTF8String.getBytes();
            } else if (object instanceof String) {
                String string = (String)object;
                byArray2 = Bytes.toBytes((String)string);
            } else {
                throw new Exception(new StringBuilder(22).append("unsupported data type ").append(field.dt()).toString());
            }
            byArray = byArray2;
        }
        return byArray;
    }

    public boolean toBoolean(byte[] input, int offset) {
        return input[offset] != 0;
    }

    public UTF8String toUTF8String(byte[] input, int offset, int length) {
        return UTF8String.fromBytes((byte[])((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(input)).slice(offset, offset + length)));
    }

    private Utils$() {
        MODULE$ = this;
    }
}

