/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.regionserver.compactions.Compactor;

@InterfaceAudience.Private
public abstract class AbstractMultiFileWriter
implements Compactor.CellSink {
    private static final Log LOG = LogFactory.getLog(AbstractMultiFileWriter.class);
    protected WriterFactory writerFactory;
    protected StoreScanner sourceScanner;

    public void init(StoreScanner sourceScanner, WriterFactory factory) {
        this.writerFactory = factory;
        this.sourceScanner = sourceScanner;
    }

    public List<Path> commitWriters(long maxSeqId, boolean majorCompaction) throws IOException {
        return this.commitWriters(maxSeqId, majorCompaction, Collections.emptySet());
    }

    public List<Path> commitWriters(long maxSeqId, boolean majorCompaction, Collection<StoreFile> storeFiles) throws IOException {
        this.preCommitWriters();
        Collection<StoreFile.Writer> writers = this.writers();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Commit " + writers.size() + " writers, maxSeqId=" + maxSeqId + ", majorCompaction=" + majorCompaction));
        }
        ArrayList<Path> paths = new ArrayList<Path>();
        for (StoreFile.Writer writer : writers) {
            if (writer == null) continue;
            writer.appendMetadata(maxSeqId, majorCompaction, storeFiles);
            this.preCloseWriter(writer);
            paths.add(writer.getPath());
            writer.close();
        }
        return paths;
    }

    public List<Path> abortWriters() {
        ArrayList<Path> paths = new ArrayList<Path>();
        for (StoreFile.Writer writer : this.writers()) {
            try {
                if (writer == null) continue;
                paths.add(writer.getPath());
                writer.close();
            }
            catch (Exception ex) {
                LOG.error((Object)"Failed to close the writer after an unfinished compaction.", (Throwable)ex);
            }
        }
        return paths;
    }

    protected abstract Collection<StoreFile.Writer> writers();

    protected void preCommitWriters() throws IOException {
    }

    protected void preCloseWriter(StoreFile.Writer writer) throws IOException {
    }

    public static interface WriterFactory {
        public StoreFile.Writer createWriter() throws IOException;
    }
}

