/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.CorruptedSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, SmallTests.class})
public class TestSnapshotManifest {
    private final Log LOG = LogFactory.getLog(this.getClass());
    private static final String TABLE_NAME_STR = "testSnapshotManifest";
    private static final TableName TABLE_NAME = TableName.valueOf((String)"testSnapshotManifest");
    private static final int TEST_NUM_REGIONS = 16000;
    private static final int TEST_NUM_REGIONFILES = 1000000;
    private static HBaseTestingUtility TEST_UTIL;
    private Configuration conf;
    private FileSystem fs;
    private Path rootDir;
    private Path snapshotDir;
    private HBaseProtos.SnapshotDescription snapshotDesc;
    private SnapshotTestingUtils.SnapshotMock.SnapshotBuilder builder;

    @Before
    public void setup() throws Exception {
        TEST_UTIL = HBaseTestingUtility.createLocalHTU();
        this.rootDir = TEST_UTIL.getDataTestDir(TABLE_NAME_STR);
        this.fs = TEST_UTIL.getTestFileSystem();
        this.conf = TEST_UTIL.getConfiguration();
        SnapshotTestingUtils.SnapshotMock snapshotMock = new SnapshotTestingUtils.SnapshotMock(this.conf, this.fs, this.rootDir);
        this.builder = snapshotMock.createSnapshotV2("snapshot", TABLE_NAME_STR, 0);
        this.snapshotDir = this.builder.commit();
        this.snapshotDesc = this.builder.getSnapshotDescription();
    }

    @After
    public void tearDown() throws Exception {
        this.fs.delete(this.rootDir, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadSnapshotManifest() throws IOException {
        Path p = this.createDataManifest();
        try {
            SnapshotManifest.open((Configuration)this.conf, (FileSystem)this.fs, (Path)this.snapshotDir, (HBaseProtos.SnapshotDescription)this.snapshotDesc);
            Assert.fail((String)"fail to test snapshot manifest because message size is too small.");
        }
        catch (CorruptedSnapshotException cse) {
            try {
                this.conf.setInt("snapshot.manifest.size.limit", 0x8000000);
                SnapshotManifest.open((Configuration)this.conf, (FileSystem)this.fs, (Path)this.snapshotDir, (HBaseProtos.SnapshotDescription)this.snapshotDesc);
                this.LOG.info((Object)"open snapshot manifest succeed.");
            }
            catch (CorruptedSnapshotException cse2) {
                Assert.fail((String)"fail to take snapshot because Manifest proto-message too large.");
            }
        }
        finally {
            this.fs.delete(p, false);
        }
    }

    @Test
    public void testReadSnapshotRegionManifest() throws IOException {
        this.fs.delete(new Path(this.snapshotDir, "data.manifest"), true);
        Path regionPath = this.createRegionManifest();
        try {
            this.conf.setInt("snapshot.manifest.size.limit", 0x8000000);
            SnapshotManifest.open((Configuration)this.conf, (FileSystem)this.fs, (Path)this.snapshotDir, (HBaseProtos.SnapshotDescription)this.snapshotDesc);
        }
        catch (CorruptedSnapshotException e) {
            Assert.fail((String)"fail to test snapshot manifest because region message size is too small.");
        }
        finally {
            this.fs.delete(regionPath, false);
        }
    }

    private Path createDataManifest() throws IOException {
        SnapshotProtos.SnapshotDataManifest.Builder dataManifestBuilder = SnapshotProtos.SnapshotDataManifest.newBuilder();
        byte[] startKey = null;
        byte[] stopKey = null;
        for (int i = 1; i <= 16000; ++i) {
            stopKey = Bytes.toBytes((String)String.format("%016d", i));
            HRegionInfo regionInfo = new HRegionInfo(TABLE_NAME, startKey, stopKey, false);
            SnapshotProtos.SnapshotRegionManifest.Builder dataRegionManifestBuilder = SnapshotProtos.SnapshotRegionManifest.newBuilder();
            for (HColumnDescriptor hcd : this.builder.getTableDescriptor().getFamilies()) {
                SnapshotProtos.SnapshotRegionManifest.FamilyFiles.Builder family = SnapshotProtos.SnapshotRegionManifest.FamilyFiles.newBuilder();
                family.setFamilyName(ByteStringer.wrap((byte[])hcd.getName()));
                for (int j = 0; j < 100; ++j) {
                    SnapshotProtos.SnapshotRegionManifest.StoreFile.Builder sfManifest = SnapshotProtos.SnapshotRegionManifest.StoreFile.newBuilder();
                    sfManifest.setName(String.format("%032d", i));
                    sfManifest.setFileSize((long)((1 + i) * (1 + i) * 1024));
                    family.addStoreFiles(sfManifest.build());
                }
                dataRegionManifestBuilder.addFamilyFiles(family.build());
            }
            dataRegionManifestBuilder.setRegionInfo(HRegionInfo.convert((HRegionInfo)regionInfo));
            dataManifestBuilder.addRegionManifests(dataRegionManifestBuilder.build());
            startKey = stopKey;
        }
        dataManifestBuilder.setTableSchema(this.builder.getTableDescriptor().convert());
        SnapshotProtos.SnapshotDataManifest dataManifest = dataManifestBuilder.build();
        return this.writeDataManifest(dataManifest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path createRegionManifest() throws IOException {
        byte[] startKey = Bytes.toBytes((String)"AAAAAA");
        byte[] stopKey = Bytes.toBytes((String)"BBBBBB");
        HRegionInfo regionInfo = new HRegionInfo(TABLE_NAME, startKey, stopKey, false);
        SnapshotProtos.SnapshotRegionManifest.Builder dataRegionManifestBuilder = SnapshotProtos.SnapshotRegionManifest.newBuilder();
        dataRegionManifestBuilder.setRegionInfo(HRegionInfo.convert((HRegionInfo)regionInfo));
        for (HColumnDescriptor hcd : this.builder.getTableDescriptor().getFamilies()) {
            SnapshotProtos.SnapshotRegionManifest.FamilyFiles.Builder family = SnapshotProtos.SnapshotRegionManifest.FamilyFiles.newBuilder();
            family.setFamilyName(ByteStringer.wrap((byte[])hcd.getName()));
            for (int j = 0; j < 1000000; ++j) {
                SnapshotProtos.SnapshotRegionManifest.StoreFile.Builder sfManifest = SnapshotProtos.SnapshotRegionManifest.StoreFile.newBuilder();
                sfManifest.setName(String.format("%064d", j));
                sfManifest.setFileSize((long)(j * 1024));
                family.addStoreFiles(sfManifest.build());
            }
            dataRegionManifestBuilder.addFamilyFiles(family.build());
        }
        SnapshotProtos.SnapshotRegionManifest manifest = dataRegionManifestBuilder.build();
        Path regionPath = new Path(this.snapshotDir, "region-manifest." + regionInfo.getEncodedName());
        try (FSDataOutputStream stream = this.fs.create(regionPath);){
            manifest.writeTo((OutputStream)stream);
        }
        return regionPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path writeDataManifest(SnapshotProtos.SnapshotDataManifest manifest) throws IOException {
        Path dataRegionPath = new Path(this.snapshotDir, "data.manifest");
        try (FSDataOutputStream stream = this.fs.create(dataRegionPath);){
            manifest.writeTo((OutputStream)stream);
        }
        return dataRegionPath;
    }
}

