/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.wal.TestLogRolling;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestLogRollPeriod {
    private static final Log LOG = LogFactory.getLog(TestLogRolling.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final long LOG_ROLL_PERIOD = 4000L;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.regionsever.info.port", -1);
        TEST_UTIL.getConfiguration().setLong("hbase.regionserver.logroll.period", 4000L);
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoEdits() throws Exception {
        TableName tableName = TableName.valueOf((String)"TestLogRollPeriodNoEdits");
        TEST_UTIL.createTable(tableName, "cf");
        try (HTable table = new HTable(TEST_UTIL.getConfiguration(), tableName);){
            HRegionServer server = TEST_UTIL.getRSForFirstRegionInTable(tableName);
            WAL log = server.getWAL(null);
            this.checkMinLogRolls(log, 5);
        }
        finally {
            TEST_UTIL.deleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testWithEdits() throws Exception {
        TableName tableName = TableName.valueOf((String)"TestLogRollPeriodWithEdits");
        String family = "cf";
        TEST_UTIL.createTable(tableName, "cf");
        try {
            HRegionServer server = TEST_UTIL.getRSForFirstRegionInTable(tableName);
            WAL log = server.getWAL(null);
            HTable table = new HTable(TEST_UTIL.getConfiguration(), tableName);
            Thread writerThread = new Thread("writer", (Table)table){
                final /* synthetic */ Table val$table;
                {
                    this.val$table = table;
                    super(arg0);
                }

                @Override
                public void run() {
                    try {
                        long row = 0L;
                        while (!1.interrupted()) {
                            Put p = new Put(Bytes.toBytes((String)String.format("row%d", row)));
                            p.add(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"col"), Bytes.toBytes((long)row));
                            this.val$table.put(p);
                            ++row;
                            Thread.sleep(250L);
                        }
                    }
                    catch (Exception e) {
                        LOG.warn((Object)e);
                    }
                }
            };
            try {
                writerThread.start();
                this.checkMinLogRolls(log, 5);
            }
            finally {
                writerThread.interrupt();
                writerThread.join();
                table.close();
            }
        }
        finally {
            TEST_UTIL.deleteTable(tableName);
        }
    }

    private void checkMinLogRolls(WAL log, int minRolls) throws Exception {
        final ArrayList paths = new ArrayList();
        log.registerWALActionsListener((WALActionsListener)new WALActionsListener.Base(){

            public void postLogRoll(Path oldFile, Path newFile) {
                LOG.debug((Object)("postLogRoll: oldFile=" + oldFile + " newFile=" + newFile));
                paths.add(newFile);
            }
        });
        long wtime = System.currentTimeMillis();
        Thread.sleep((long)(minRolls + 1) * 4000L);
        int NUM_RETRIES = 1 + 8 * (minRolls - paths.size());
        for (int retry = 0; paths.size() < minRolls && retry < NUM_RETRIES; ++retry) {
            Thread.sleep(1000L);
        }
        wtime = System.currentTimeMillis() - wtime;
        LOG.info((Object)String.format("got %d rolls after %dms (%dms each) - expected at least %d rolls", paths.size(), wtime, wtime / (long)paths.size(), minRolls));
        Assert.assertFalse((paths.size() < minRolls ? 1 : 0) != 0);
    }
}

