/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.RegionTransition;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TestReplicasClient;
import org.apache.hadoop.hbase.coordination.SplitTransactionCoordination;
import org.apache.hadoop.hbase.coordination.ZKSplitTransactionCoordination;
import org.apache.hadoop.hbase.coordination.ZkCloseRegionCoordination;
import org.apache.hadoop.hbase.coordination.ZkCoordinatedStateManager;
import org.apache.hadoop.hbase.coordination.ZkOpenRegionCoordination;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.regionserver.RegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.SplitTransactionImpl;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.regionserver.throttle.NoLimitThroughputController;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestSplitTransactionOnCluster {
    private static final Log LOG = LogFactory.getLog(TestSplitTransactionOnCluster.class);
    private HBaseAdmin admin = null;
    private MiniHBaseCluster cluster = null;
    private static Configuration conf;
    private static final int NB_SERVERS = 3;
    private static CountDownLatch latch;
    private static volatile boolean secondSplit;
    private static volatile boolean callRollBack;
    private static volatile boolean firstSplitCompleted;
    private static boolean useZKForAssignment;
    static final HBaseTestingUtility TESTING_UTIL;

    static void setupOnce() throws Exception {
        TESTING_UTIL.getConfiguration().setInt("hbase.balancer.period", 60000);
        useZKForAssignment = TESTING_UTIL.getConfiguration().getBoolean("hbase.assignment.usezk", true);
        TESTING_UTIL.startMiniCluster(3);
    }

    @BeforeClass
    public static void before() throws Exception {
        conf = TESTING_UTIL.getConfiguration();
        conf.setBoolean("hbase.assignment.usezk", true);
        TestSplitTransactionOnCluster.setupOnce();
    }

    @AfterClass
    public static void after() throws Exception {
        TESTING_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() throws IOException {
        TESTING_UTIL.ensureSomeNonStoppedRegionServersAvailable(3);
        this.admin = new HBaseAdmin(TESTING_UTIL.getConfiguration());
        this.cluster = TESTING_UTIL.getMiniHBaseCluster();
    }

    @After
    public void tearDown() throws Exception {
        this.admin.close();
    }

    private HRegionInfo getAndCheckSingleTableRegion(List<HRegion> regions) throws IOException, InterruptedException {
        Assert.assertEquals((long)1L, (long)regions.size());
        HRegionInfo hri = regions.get(0).getRegionInfo();
        TESTING_UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().waitOnRegionToClearRegionsInTransition(hri, 600000L);
        return hri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testShouldFailSplitIfZNodeDoesNotExistDueToPrevRollBack() throws Exception {
        TableName tableName = TableName.valueOf((String)"testShouldFailSplitIfZNodeDoesNotExistDueToPrevRollBack");
        if (!useZKForAssignment) {
            return;
        }
        try {
            HTable t = this.createTableAndWait(tableName, Bytes.toBytes((String)"cf"));
            List<HRegion> regions = this.cluster.getRegions(tableName);
            HRegionInfo hri = this.getAndCheckSingleTableRegion(regions);
            int regionServerIndex = this.cluster.getServerWith(regions.get(0).getRegionInfo().getRegionName());
            final HRegionServer regionServer = this.cluster.getRegionServer(regionServerIndex);
            this.insertData(tableName, this.admin, (Table)t);
            t.close();
            this.admin.setBalancerRunning(false, true);
            this.cluster.getMaster().setCatalogJanitorEnabled(false);
            final HRegion region = this.findSplittableRegion(regions);
            Assert.assertTrue((String)"not able to find a splittable region", (region != null ? 1 : 0) != 0);
            MockedCoordinatedStateManager cp = new MockedCoordinatedStateManager();
            cp.initialize((Server)regionServer, region);
            cp.start();
            regionServer.csm = cp;
            new Thread(){

                @Override
                public void run() {
                    MockedSplitTransaction st = null;
                    st = new MockedSplitTransaction(region, Bytes.toBytes((String)"row2"));
                    try {
                        st.prepare();
                        st.execute((Server)regionServer, (RegionServerServices)regionServer);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }.start();
            for (int i = 0; !callRollBack && i < 100; ++i) {
                Thread.sleep(100L);
            }
            Assert.assertTrue((String)"Waited too long for rollback", (boolean)callRollBack);
            MockedSplitTransaction st = new MockedSplitTransaction(region, Bytes.toBytes((String)"row3"));
            try {
                secondSplit = true;
                region.initialize();
                st.prepare();
                st.execute((Server)regionServer, (RegionServerServices)regionServer);
            }
            catch (IOException e) {
                LOG.debug((Object)("Rollback started :" + e.getMessage()));
                st.rollback((Server)regionServer, (RegionServerServices)regionServer);
            }
            for (int i = 0; !firstSplitCompleted && i < 100; ++i) {
                Thread.sleep(100L);
            }
            Assert.assertTrue((String)"fist split did not complete", (boolean)firstSplitCompleted);
            RegionStates regionStates = this.cluster.getMaster().getAssignmentManager().getRegionStates();
            for (int i = 0; regionStates.isRegionInTransition(hri) && i < 100; ++i) {
                Thread.sleep(100L);
            }
            Assert.assertFalse((String)"region still in transition", (boolean)regionStates.isRegionInTransition(hri));
            List onlineRegions = regionServer.getOnlineRegions(tableName);
            Assert.assertEquals((String)"The parent region should be splitted", (long)2L, (long)onlineRegions.size());
            List regionsOfTable = this.cluster.getMaster().getAssignmentManager().getRegionStates().getRegionsOfTable(tableName);
            Assert.assertEquals((String)"No of regions in master", (long)2L, (long)regionsOfTable.size());
        }
        finally {
            this.admin.setBalancerRunning(true, false);
            secondSplit = false;
            firstSplitCompleted = false;
            callRollBack = false;
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            TESTING_UTIL.deleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testRITStateForRollback() throws Exception {
        TableName tableName = TableName.valueOf((String)"testRITStateForRollback");
        try {
            HTable t = this.createTableAndWait(tableName, Bytes.toBytes((String)"cf"));
            List<HRegion> regions = this.cluster.getRegions(tableName);
            HRegionInfo hri = this.getAndCheckSingleTableRegion(regions);
            this.insertData(tableName, this.admin, (Table)t);
            t.close();
            this.admin.setBalancerRunning(false, true);
            this.cluster.getMaster().setCatalogJanitorEnabled(false);
            HRegion region = this.findSplittableRegion(regions);
            Assert.assertTrue((String)"not able to find a splittable region", (region != null ? 1 : 0) != 0);
            region.getCoprocessorHost().load(FailingSplitRegionObserver.class, 0x3FFFFFFF, region.getBaseConf());
            this.admin.split(region.getRegionInfo().getRegionName(), new byte[]{42});
            FailingSplitRegionObserver observer = (FailingSplitRegionObserver)region.getCoprocessorHost().findCoprocessor(FailingSplitRegionObserver.class.getName());
            Assert.assertNotNull((Object)((Object)observer));
            observer.latch.await();
            LOG.info((Object)"Waiting for region to come out of RIT");
            TESTING_UTIL.waitUntilNoRegionsInTransition(60000L);
        }
        finally {
            this.admin.setBalancerRunning(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            TESTING_UTIL.deleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testSplitFailedCompactionAndSplit() throws Exception {
        TableName tableName = TableName.valueOf((String)"testSplitFailedCompactionAndSplit");
        Configuration conf = TESTING_UTIL.getConfiguration();
        try {
            HBaseAdmin admin = new HBaseAdmin(conf);
            HTableDescriptor htd = new HTableDescriptor(tableName);
            byte[] cf = Bytes.toBytes((String)"cf");
            htd.addFamily(new HColumnDescriptor(cf));
            admin.createTable(htd);
            for (int i = 0; this.cluster.getRegions(tableName).size() == 0 && i < 100; ++i) {
                Thread.sleep(100L);
            }
            Assert.assertEquals((long)1L, (long)this.cluster.getRegions(tableName).size());
            HRegion region = this.cluster.getRegions(tableName).get(0);
            Store store = region.getStore(cf);
            int regionServerIndex = this.cluster.getServerWith(region.getRegionInfo().getRegionName());
            HRegionServer regionServer = this.cluster.getRegionServer(regionServerIndex);
            HTable t = new HTable(conf, tableName);
            this.insertData(tableName, admin, (Table)t);
            this.insertData(tableName, admin, (Table)t);
            int fileNum = store.getStorefiles().size();
            store.triggerMajorCompaction();
            CompactionContext cc = store.requestCompaction();
            Assert.assertNotNull((Object)cc);
            Assert.assertEquals((long)2L, (long)((List)region.close(false).get(cf)).size());
            region.initialize();
            Assert.assertFalse((boolean)region.compact(cc, store, (ThroughputController)NoLimitThroughputController.INSTANCE));
            Assert.assertTrue((fileNum > store.getStorefiles().size() ? 1 : 0) != 0);
            SplitTransactionImpl st = new SplitTransactionImpl((Region)region, Bytes.toBytes((String)"row3"));
            Assert.assertTrue((boolean)st.prepare());
            st.execute((Server)regionServer, (RegionServerServices)regionServer);
            LOG.info((Object)"Waiting for region to come out of RIT");
            TESTING_UTIL.waitFor(60000L, 1000L, new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    RegionStates regionStates = TestSplitTransactionOnCluster.this.cluster.getMaster().getAssignmentManager().getRegionStates();
                    return !regionStates.isRegionsInTransition();
                }
            });
            Assert.assertEquals((long)2L, (long)this.cluster.getRegions(tableName).size());
        }
        finally {
            TESTING_UTIL.deleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testSplitIsRolledBackOnSplitFailure() throws Exception {
        final TableName tableName = TableName.valueOf((String)"testSplitIsRolledBackOnSplitFailure");
        HTable t = this.createTableAndWait(tableName, HConstants.CATALOG_FAMILY);
        List<HRegion> regions = this.cluster.getRegions(tableName);
        final HRegionInfo hri = this.getAndCheckSingleTableRegion(regions);
        this.admin.setBalancerRunning(false, true);
        this.cluster.getMaster().setCatalogJanitorEnabled(false);
        int serverIndex = this.ensureTableRegionNotOnSameServerAsMeta((Admin)this.admin, hri);
        try {
            TESTING_UTIL.loadTable((Table)t, HConstants.CATALOG_FAMILY, false);
            HRegionServer server = this.cluster.getRegionServer(serverIndex);
            this.printOutRegions(server, "Initial regions: ");
            int regionCount = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)server.getRSRpcServices()).size();
            AssignmentManager.setTestSkipSplitHandling((boolean)true);
            this.split(hri, server, regionCount);
            ZooKeeperWatcher zkw = TESTING_UTIL.getZooKeeperWatcher();
            String path = ZKAssign.getNodeName((ZooKeeperWatcher)zkw, (String)hri.getEncodedName());
            RegionTransition rt = null;
            Stat stats = null;
            for (int i = 0; i < 100; ++i) {
                stats = zkw.getRecoverableZooKeeper().exists(path, false);
                rt = RegionTransition.parseFrom((byte[])ZKAssign.getData((ZooKeeperWatcher)zkw, (String)hri.getEncodedName()));
                if (rt.getEventType().equals((Object)EventType.RS_ZK_REGION_SPLIT)) break;
                Thread.sleep(100L);
            }
            LOG.info((Object)("EPHEMERAL NODE BEFORE SERVER ABORT, path=" + path + ", stats=" + stats));
            Assert.assertTrue((boolean)rt.getEventType().equals((Object)EventType.RS_ZK_REGION_SPLIT));
            this.abortServerAndWaitForProcessingToComplete(serverIndex);
            this.waitUntilRegionServerDead();
            TESTING_UTIL.waitUntilNoRegionsInTransition();
            TESTING_UTIL.waitFor(60000L, new Waiter.Predicate<Exception>(){

                public boolean evaluate() {
                    for (HRegion region : TestSplitTransactionOnCluster.this.cluster.getRegions(tableName)) {
                        if (Bytes.equals((byte[])region.getRegionInfo().getRegionName(), (byte[])hri.getRegionName())) {
                            return true;
                        }
                        LOG.debug((Object)("Wait for some more time, online region: " + region));
                    }
                    return false;
                }
            });
            RegionStates regionStates = this.cluster.getMaster().getAssignmentManager().getRegionStates();
            Assert.assertTrue((String)"Parent region should be online", (boolean)regionStates.isRegionOnline(hri));
            List tableRegions = MetaTableAccessor.getTableRegions((ZooKeeperWatcher)zkw, (Connection)this.cluster.getMaster().getConnection(), (TableName)tableName);
            Assert.assertEquals((String)("Only parent region should be present, but we have: " + tableRegions), (long)1L, (long)tableRegions.size());
            Path tableDir = FSUtils.getTableDir((Path)FSUtils.getRootDir((Configuration)conf), (TableName)tableName);
            List regionDirs = FSUtils.getRegionDirs((FileSystem)this.cluster.getMaster().getFileSystem(), (Path)tableDir);
            Assert.assertEquals((String)("Only one region dir should be present, we have, dirs: " + regionDirs), (long)1L, (long)regionDirs.size());
            Assert.assertTrue((String)("Region dir doesn't belong to region: " + hri + " dir: " + regionDirs), (boolean)((Path)regionDirs.get(0)).getName().endsWith(hri.getEncodedName()));
        }
        finally {
            AssignmentManager.setTestSkipSplitHandling((boolean)false);
            this.admin.setBalancerRunning(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            this.cluster.startRegionServer();
            t.close();
            TESTING_UTIL.deleteTable(tableName);
        }
    }

    private void abortServerAndWaitForProcessingToComplete(int serverIndex) throws Exception {
        final HMaster master = TESTING_UTIL.getMiniHBaseCluster().getMaster();
        this.cluster.abortRegionServer(serverIndex);
        TESTING_UTIL.waitFor(60000L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return master.getServerManager().areDeadServersInProgress();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testExistingZnodeBlocksSplitAndWeRollback() throws IOException, InterruptedException, KeeperException.NodeExistsException, KeeperException, ServiceException {
        TableName tableName = TableName.valueOf((String)"testExistingZnodeBlocksSplitAndWeRollback");
        HTable t = this.createTableAndWait(tableName, HConstants.CATALOG_FAMILY);
        List<HRegion> regions = this.cluster.getRegions(tableName);
        HRegionInfo hri = this.getAndCheckSingleTableRegion(regions);
        int tableRegionIndex = this.ensureTableRegionNotOnSameServerAsMeta((Admin)this.admin, hri);
        RegionStates regionStates = this.cluster.getMaster().getAssignmentManager().getRegionStates();
        this.admin.setBalancerRunning(false, true);
        this.cluster.getMaster().setCatalogJanitorEnabled(false);
        try {
            TESTING_UTIL.loadTable((Table)t, HConstants.CATALOG_FAMILY, false);
            HRegionServer server = this.cluster.getRegionServer(tableRegionIndex);
            this.printOutRegions(server, "Initial regions: ");
            int regionCount = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)server.getRSRpcServices()).size();
            ServerName fakedServer = ServerName.valueOf((String)"any.old.server", (int)1234, (long)-1L);
            if (useZKForAssignment) {
                ZKAssign.createNodeClosing((ZooKeeperWatcher)TESTING_UTIL.getZooKeeperWatcher(), (HRegionInfo)hri, (ServerName)fakedServer);
            } else {
                regionStates.updateRegionState(hri, RegionState.State.CLOSING);
            }
            this.admin.split(hri.getRegionNameAsString());
            this.admin.split(hri.getRegionNameAsString());
            this.admin.split(hri.getRegionNameAsString());
            for (int i = 0; i < 10; ++i) {
                Thread.sleep(100L);
                Assert.assertEquals((long)regionCount, (long)ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)server.getRSRpcServices()).size());
            }
            if (useZKForAssignment) {
                ZKAssign.deleteClosingNode((ZooKeeperWatcher)TESTING_UTIL.getZooKeeperWatcher(), (HRegionInfo)hri, (ServerName)fakedServer);
            } else {
                regionStates.regionOnline(hri, server.getServerName());
            }
            this.split(hri, server, regionCount);
            this.checkAndGetDaughters(tableName);
        }
        finally {
            this.admin.setBalancerRunning(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testShutdownFixupWhenDaughterHasSplit() throws IOException, InterruptedException, ServiceException {
        TableName tableName = TableName.valueOf((String)"testShutdownFixupWhenDaughterHasSplit");
        HTable t = this.createTableAndWait(tableName, HConstants.CATALOG_FAMILY);
        List<HRegion> regions = this.cluster.getRegions(tableName);
        HRegionInfo hri = this.getAndCheckSingleTableRegion(regions);
        int tableRegionIndex = this.ensureTableRegionNotOnSameServerAsMeta((Admin)this.admin, hri);
        this.admin.setBalancerRunning(false, true);
        this.cluster.getMaster().setCatalogJanitorEnabled(false);
        try {
            TESTING_UTIL.loadTable((Table)t, HConstants.CATALOG_FAMILY);
            HRegionServer server = this.cluster.getRegionServer(tableRegionIndex);
            this.printOutRegions(server, "Initial regions: ");
            int regionCount = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)server.getRSRpcServices()).size();
            this.split(hri, server, regionCount);
            List<HRegion> daughters = this.checkAndGetDaughters(tableName);
            regionCount = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)server.getRSRpcServices()).size();
            HRegionInfo daughter = daughters.get(0).getRegionInfo();
            LOG.info((Object)("Daughter we are going to split: " + daughter));
            this.admin.compact(daughter.getRegionName());
            RetryCounter retrier = new RetryCounter(30, 1L, TimeUnit.SECONDS);
            while (AdminProtos.GetRegionInfoResponse.CompactionState.NONE != this.admin.getCompactionStateForRegion(daughter.getRegionName()) && retrier.shouldRetry()) {
                retrier.sleepUntilNextRetry();
            }
            daughters = this.cluster.getRegions(tableName);
            HRegion daughterRegion = null;
            for (HRegion r : daughters) {
                if (!r.getRegionInfo().equals((Object)daughter)) continue;
                daughterRegion = r;
                ((Store)r.getStores().get(0)).closeAndArchiveCompactedFiles();
                LOG.info((Object)("Found matching HRI: " + daughterRegion));
                break;
            }
            Assert.assertTrue((daughterRegion != null ? 1 : 0) != 0);
            for (int i = 0; i < 100 && daughterRegion.hasReferences(); ++i) {
                Threads.sleep((long)100L);
            }
            Assert.assertFalse((String)"Waiting for reference to be compacted", (boolean)daughterRegion.hasReferences());
            LOG.info((Object)("Daughter hri before split (has been compacted): " + daughter));
            this.split(daughter, server, regionCount);
            daughters = this.cluster.getRegions(tableName);
            for (HRegion d : daughters) {
                LOG.info((Object)("Regions before crash: " + d));
            }
            this.cluster.abortRegionServer(tableRegionIndex);
            this.waitUntilRegionServerDead();
            this.awaitDaughters(tableName, daughters.size());
            regions = this.cluster.getRegions(tableName);
            for (HRegion d : daughters) {
                LOG.info((Object)("Regions after crash: " + d));
            }
            Assert.assertEquals((long)daughters.size(), (long)regions.size());
            for (HRegion r : regions) {
                LOG.info((Object)("Regions post crash " + r));
                Assert.assertTrue((String)("Missing region post crash " + r), (boolean)daughters.contains(r));
            }
        }
        finally {
            this.admin.setBalancerRunning(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testSplitShouldNotThrowNPEEvenARegionHasEmptySplitFiles() throws Exception {
        TableName userTableName = TableName.valueOf((String)"testSplitShouldNotThrowNPEEvenARegionHasEmptySplitFiles");
        HTableDescriptor htd = new HTableDescriptor(userTableName);
        HColumnDescriptor hcd = new HColumnDescriptor("col");
        htd.addFamily(hcd);
        this.admin.createTable(htd);
        try (HTable table = new HTable(TESTING_UTIL.getConfiguration(), userTableName);){
            Put p;
            for (int i = 0; i <= 5; ++i) {
                String row = "row" + i;
                p = new Put(row.getBytes());
                String val = "Val" + i;
                p.add("col".getBytes(), "ql".getBytes(), val.getBytes());
                table.put(p);
                this.admin.flush(userTableName.getName());
                Delete d = new Delete(row.getBytes());
                table.delete(d);
                this.admin.flush(userTableName.getName());
            }
            this.admin.majorCompact(userTableName.getName());
            List regionsOfTable = TESTING_UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getRegionsOfTable(userTableName);
            HRegionInfo hRegionInfo = (HRegionInfo)regionsOfTable.get(0);
            p = new Put("row6".getBytes());
            p.add("col".getBytes(), "ql".getBytes(), "val".getBytes());
            table.put(p);
            p = new Put("row7".getBytes());
            p.add("col".getBytes(), "ql".getBytes(), "val".getBytes());
            table.put(p);
            p = new Put("row8".getBytes());
            p.add("col".getBytes(), "ql".getBytes(), "val".getBytes());
            table.put(p);
            this.admin.flush(userTableName.getName());
            this.admin.split(hRegionInfo.getRegionName(), "row7".getBytes());
            regionsOfTable = TESTING_UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getRegionsOfTable(userTableName);
            while (regionsOfTable.size() != 2) {
                Thread.sleep(2000L);
                regionsOfTable = TESTING_UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getRegionsOfTable(userTableName);
            }
            Assert.assertEquals((long)2L, (long)regionsOfTable.size());
            Scan s = new Scan();
            ResultScanner scanner = table.getScanner(s);
            int mainTableCount = 0;
            Result rr = scanner.next();
            while (rr != null) {
                ++mainTableCount;
                rr = scanner.next();
            }
            Assert.assertEquals((long)3L, (long)mainTableCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=400000L)
    public void testMasterRestartWhenSplittingIsPartial() throws IOException, InterruptedException, KeeperException.NodeExistsException, KeeperException, DeserializationException, ServiceException {
        TableName tableName = TableName.valueOf((String)"testMasterRestartWhenSplittingIsPartial");
        if (!useZKForAssignment) {
            return;
        }
        HTable t = this.createTableAndWait(tableName, HConstants.CATALOG_FAMILY);
        List<HRegion> regions = this.cluster.getRegions(tableName);
        HRegionInfo hri = this.getAndCheckSingleTableRegion(regions);
        int tableRegionIndex = this.ensureTableRegionNotOnSameServerAsMeta((Admin)this.admin, hri);
        this.admin.setBalancerRunning(false, true);
        this.cluster.getMaster().setCatalogJanitorEnabled(false);
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(t.getConfiguration(), "testMasterRestartWhenSplittingIsPartial", (Abortable)new UselessTestAbortable());
        try {
            TESTING_UTIL.loadTable((Table)t, HConstants.CATALOG_FAMILY, false);
            HRegionServer server = this.cluster.getRegionServer(tableRegionIndex);
            this.printOutRegions(server, "Initial regions: ");
            AssignmentManager.setTestSkipSplitHandling((boolean)true);
            this.admin.split(hri.getRegionNameAsString());
            this.checkAndGetDaughters(tableName);
            String path = ZKAssign.getNodeName((ZooKeeperWatcher)zkw, (String)hri.getEncodedName());
            Stat stats = zkw.getRecoverableZooKeeper().exists(path, false);
            LOG.info((Object)("EPHEMERAL NODE BEFORE SERVER ABORT, path=" + path + ", stats=" + stats));
            byte[] bytes = ZKAssign.getData((ZooKeeperWatcher)zkw, (String)hri.getEncodedName());
            RegionTransition rtd = RegionTransition.parseFrom((byte[])bytes);
            Assert.assertTrue((rtd.getEventType().equals((Object)EventType.RS_ZK_REGION_SPLIT) || rtd.getEventType().equals((Object)EventType.RS_ZK_REGION_SPLITTING) ? 1 : 0) != 0);
            MockMasterWithoutCatalogJanitor master = this.abortAndWaitForMaster();
            this.admin = new HBaseAdmin(TESTING_UTIL.getConfiguration());
            hri.setOffline(true);
            hri.setSplit(true);
            ServerName regionServerOfRegion = master.getAssignmentManager().getRegionStates().getRegionServerOfRegion(hri);
            Assert.assertTrue((regionServerOfRegion != null ? 1 : 0) != 0);
            AssignmentManager.setTestSkipSplitHandling((boolean)false);
            String node = ZKAssign.getNodeName((ZooKeeperWatcher)zkw, (String)hri.getEncodedName());
            Stat stat = new Stat();
            byte[] data = ZKUtil.getDataNoWatch((ZooKeeperWatcher)zkw, (String)node, (Stat)stat);
            for (int i = 0; data != null && i < 60; ++i) {
                Thread.sleep(1000L);
                data = ZKUtil.getDataNoWatch((ZooKeeperWatcher)zkw, (String)node, (Stat)stat);
            }
            Assert.assertNull((String)("Waited too long for ZK node to be removed: " + node), (Object)data);
            RegionStates regionStates = master.getAssignmentManager().getRegionStates();
            Assert.assertTrue((String)"Split parent should be in SPLIT state", (boolean)regionStates.isRegionInState(hri, new RegionState.State[]{RegionState.State.SPLIT}));
            regionServerOfRegion = regionStates.getRegionServerOfRegion(hri);
            Assert.assertTrue((regionServerOfRegion == null ? 1 : 0) != 0);
        }
        finally {
            AssignmentManager.setTestSkipSplitHandling((boolean)false);
            this.admin.setBalancerRunning(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            t.close();
            zkw.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testMasterRestartAtRegionSplitPendingCatalogJanitor() throws IOException, InterruptedException, KeeperException.NodeExistsException, KeeperException, ServiceException {
        TableName tableName = TableName.valueOf((String)"testMasterRestartAtRegionSplitPendingCatalogJanitor");
        HTable t = this.createTableAndWait(tableName, HConstants.CATALOG_FAMILY);
        List<HRegion> regions = this.cluster.getRegions(tableName);
        HRegionInfo hri = this.getAndCheckSingleTableRegion(regions);
        int tableRegionIndex = this.ensureTableRegionNotOnSameServerAsMeta((Admin)this.admin, hri);
        this.admin.setBalancerRunning(false, true);
        this.cluster.getMaster().setCatalogJanitorEnabled(false);
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(t.getConfiguration(), "testMasterRestartAtRegionSplitPendingCatalogJanitor", (Abortable)new UselessTestAbortable());
        try {
            TESTING_UTIL.loadTable((Table)t, HConstants.CATALOG_FAMILY, false);
            HRegionServer server = this.cluster.getRegionServer(tableRegionIndex);
            this.printOutRegions(server, "Initial regions: ");
            this.admin.split(hri.getRegionNameAsString());
            this.checkAndGetDaughters(tableName);
            String path = ZKAssign.getNodeName((ZooKeeperWatcher)zkw, (String)hri.getEncodedName());
            Stat stats = zkw.getRecoverableZooKeeper().exists(path, false);
            LOG.info((Object)("EPHEMERAL NODE BEFORE SERVER ABORT, path=" + path + ", stats=" + stats));
            String node = ZKAssign.getNodeName((ZooKeeperWatcher)zkw, (String)hri.getEncodedName());
            Stat stat = new Stat();
            byte[] data = ZKUtil.getDataNoWatch((ZooKeeperWatcher)zkw, (String)node, (Stat)stat);
            for (int i = 0; data != null && i < 60; ++i) {
                Thread.sleep(1000L);
                data = ZKUtil.getDataNoWatch((ZooKeeperWatcher)zkw, (String)node, (Stat)stat);
            }
            Assert.assertNull((String)("Waited too long for ZK node to be removed: " + node), (Object)data);
            MockMasterWithoutCatalogJanitor master = this.abortAndWaitForMaster();
            this.admin = new HBaseAdmin(TESTING_UTIL.getConfiguration());
            hri.setOffline(true);
            hri.setSplit(true);
            RegionStates regionStates = master.getAssignmentManager().getRegionStates();
            Assert.assertTrue((String)"Split parent should be in SPLIT state", (boolean)regionStates.isRegionInState(hri, new RegionState.State[]{RegionState.State.SPLIT}));
            ServerName regionServerOfRegion = regionStates.getRegionServerOfRegion(hri);
            Assert.assertTrue((regionServerOfRegion == null ? 1 : 0) != 0);
        }
        finally {
            this.admin.setBalancerRunning(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            t.close();
            zkw.close();
        }
    }

    @Test(timeout=60000L)
    public void testSplitBeforeSettingSplittingInZK() throws Exception, InterruptedException, KeeperException {
        this.testSplitBeforeSettingSplittingInZKInternals();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testTableExistsIfTheSpecifiedTableRegionIsSplitParent() throws Exception {
        ZooKeeperWatcher zkw = HBaseTestingUtility.getZooKeeperWatcher(TESTING_UTIL);
        TableName tableName = TableName.valueOf((String)"testTableExistsIfTheSpecifiedTableRegionIsSplitParent");
        HTable t = this.createTableAndWait(tableName, Bytes.toBytes((String)"cf"));
        List<HRegion> regions = null;
        try {
            regions = this.cluster.getRegions(tableName);
            int regionServerIndex = this.cluster.getServerWith(regions.get(0).getRegionInfo().getRegionName());
            HRegionServer regionServer = this.cluster.getRegionServer(regionServerIndex);
            this.insertData(tableName, this.admin, (Table)t);
            this.admin.setBalancerRunning(false, true);
            this.cluster.getMaster().setCatalogJanitorEnabled(false);
            boolean tableExists = MetaTableAccessor.tableExists((Connection)regionServer.getConnection(), (TableName)tableName);
            Assert.assertEquals((String)"The specified table should present.", (Object)true, (Object)tableExists);
            HRegion region = this.findSplittableRegion(regions);
            Assert.assertTrue((String)"not able to find a splittable region", (region != null ? 1 : 0) != 0);
            SplitTransactionImpl st = new SplitTransactionImpl((Region)region, Bytes.toBytes((String)"row2"));
            try {
                st.prepare();
                st.createDaughters((Server)regionServer, (RegionServerServices)regionServer, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            tableExists = MetaTableAccessor.tableExists((Connection)regionServer.getConnection(), (TableName)tableName);
            Assert.assertEquals((String)"The specified table should present.", (Object)true, (Object)tableExists);
            Set rit = this.cluster.getMaster().getAssignmentManager().getRegionStates().getRegionsInTransition();
            Assert.assertTrue((rit.size() == 3 ? 1 : 0) != 0);
            this.cluster.getMaster().getAssignmentManager().regionOffline(st.getFirstDaughter());
            this.cluster.getMaster().getAssignmentManager().regionOffline(st.getSecondDaughter());
            this.cluster.getMaster().getAssignmentManager().regionOffline(region.getRegionInfo());
            rit = this.cluster.getMaster().getAssignmentManager().getRegionStates().getRegionsInTransition();
            Assert.assertTrue((rit.size() == 0 ? 1 : 0) != 0);
        }
        finally {
            this.admin.setBalancerRunning(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            t.close();
            TESTING_UTIL.deleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitWithRegionReplicas() throws Exception {
        List<HRegion> oldRegions;
        ZooKeeperWatcher zkw = HBaseTestingUtility.getZooKeeperWatcher(TESTING_UTIL);
        TableName tableName = TableName.valueOf((String)"foobar");
        HTableDescriptor htd = TESTING_UTIL.createTableDescriptor("foobar");
        htd.setRegionReplication(2);
        htd.addCoprocessor(TestReplicasClient.SlowMeCopro.class.getName());
        HTable t = TESTING_UTIL.createTable(htd, (byte[][])new byte[][]{Bytes.toBytes((String)"cf")}, TESTING_UTIL.getConfiguration());
        do {
            oldRegions = this.cluster.getRegions(tableName);
            Thread.sleep(10L);
        } while (oldRegions.size() != 2);
        for (HRegion h : oldRegions) {
            LOG.debug((Object)("OLDREGION " + h.getRegionInfo()));
        }
        try {
            List<HRegion> newRegions;
            int regionServerIndex = this.cluster.getServerWith(oldRegions.get(0).getRegionInfo().getRegionName());
            HRegionServer regionServer = this.cluster.getRegionServer(regionServerIndex);
            this.insertData(tableName, this.admin, (Table)t);
            this.admin.setBalancerRunning(false, true);
            this.cluster.getMaster().setCatalogJanitorEnabled(false);
            boolean tableExists = MetaTableAccessor.tableExists((Connection)regionServer.getConnection(), (TableName)tableName);
            Assert.assertEquals((String)"The specified table should be present.", (Object)true, (Object)tableExists);
            HRegion region = this.findSplittableRegion(oldRegions);
            regionServerIndex = this.cluster.getServerWith(region.getRegionInfo().getRegionName());
            regionServer = this.cluster.getRegionServer(regionServerIndex);
            Assert.assertTrue((String)"not able to find a splittable region", (region != null ? 1 : 0) != 0);
            String node = ZKAssign.getNodeName((ZooKeeperWatcher)regionServer.getZooKeeper(), (String)region.getRegionInfo().getEncodedName());
            regionServer.getZooKeeper().sync(node);
            SplitTransactionImpl st = new SplitTransactionImpl((Region)region, Bytes.toBytes((String)"row2"));
            try {
                st.prepare();
                st.execute((Server)regionServer, (RegionServerServices)regionServer);
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail((String)("Split execution should have succeeded with no exceptions thrown " + e));
            }
            do {
                newRegions = this.cluster.getRegions(tableName);
                for (HRegion h : newRegions) {
                    LOG.debug((Object)("NEWREGION " + h.getRegionInfo()));
                }
                Thread.sleep(1000L);
            } while (newRegions.contains(oldRegions.get(0)) || newRegions.contains(oldRegions.get(1)) || newRegions.size() != 4);
            tableExists = MetaTableAccessor.tableExists((Connection)regionServer.getConnection(), (TableName)tableName);
            Assert.assertEquals((String)"The specified table should be present.", (Object)true, (Object)tableExists);
            byte[] b1 = "row1".getBytes();
            Get g = new Get(b1);
            g.setConsistency(Consistency.STRONG);
            Result r = t.get(g);
            Assert.assertFalse((boolean)r.isStale());
            LOG.info((Object)"exists stale after flush done");
            TestReplicasClient.SlowMeCopro.getPrimaryCdl().set(new CountDownLatch(1));
            g = new Get(b1);
            g.setConsistency(Consistency.TIMELINE);
            r = t.get(g);
            Assert.assertTrue((boolean)r.isStale());
            TestReplicasClient.SlowMeCopro.getPrimaryCdl().get().countDown();
        }
        finally {
            TestReplicasClient.SlowMeCopro.getPrimaryCdl().get().countDown();
            this.admin.setBalancerRunning(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            t.close();
        }
    }

    private void insertData(TableName tableName, HBaseAdmin admin, Table t) throws IOException, InterruptedException {
        Put p = new Put(Bytes.toBytes((String)"row1"));
        p.add(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"1"));
        t.put(p);
        p = new Put(Bytes.toBytes((String)"row2"));
        p.add(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"2"));
        t.put(p);
        p = new Put(Bytes.toBytes((String)"row3"));
        p.add(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"3"));
        t.put(p);
        p = new Put(Bytes.toBytes((String)"row4"));
        p.add(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"4"));
        t.put(p);
        admin.flush(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testSplitRegionWithNoStoreFiles() throws Exception {
        TableName tableName = TableName.valueOf((String)"testSplitRegionWithNoStoreFiles");
        this.createTableAndWait(tableName, HConstants.CATALOG_FAMILY);
        List<HRegion> regions = this.cluster.getRegions(tableName);
        HRegionInfo hri = this.getAndCheckSingleTableRegion(regions);
        this.ensureTableRegionNotOnSameServerAsMeta((Admin)this.admin, hri);
        int regionServerIndex = this.cluster.getServerWith(regions.get(0).getRegionInfo().getRegionName());
        HRegionServer regionServer = this.cluster.getRegionServer(regionServerIndex);
        this.admin.setBalancerRunning(false, true);
        this.cluster.getMaster().setCatalogJanitorEnabled(false);
        try {
            this.printOutRegions(regionServer, "Initial regions: ");
            Configuration conf = this.cluster.getConfiguration();
            HBaseFsck.debugLsr((Configuration)conf, (Path)new Path("/"));
            Path rootDir = FSUtils.getRootDir((Configuration)conf);
            DistributedFileSystem fs = TESTING_UTIL.getDFSCluster().getFileSystem();
            Map storefiles = FSUtils.getTableStoreFilePathMap(null, (FileSystem)fs, (Path)rootDir, (TableName)tableName);
            Assert.assertEquals((String)("Expected nothing but found " + storefiles.toString()), (long)storefiles.size(), (long)0L);
            regions = this.cluster.getRegions(tableName);
            HRegion region = this.findSplittableRegion(regions);
            Assert.assertTrue((String)"not able to find a splittable region", (region != null ? 1 : 0) != 0);
            MockedSplitTransaction st = new MockedSplitTransaction(region, Bytes.toBytes((String)"row2"));
            try {
                st.prepare();
                st.execute((Server)regionServer, (RegionServerServices)regionServer);
            }
            catch (IOException e) {
                Assert.fail((String)"Split execution should have succeeded with no exceptions thrown");
            }
            List<HRegion> daughters = this.cluster.getRegions(tableName);
            Assert.assertTrue((daughters.size() == 2 ? 1 : 0) != 0);
            HBaseFsck.debugLsr((Configuration)conf, (Path)new Path("/"));
            Map storefilesAfter = FSUtils.getTableStoreFilePathMap(null, (FileSystem)fs, (Path)rootDir, (TableName)tableName);
            Assert.assertEquals((String)("Expected nothing but found " + storefilesAfter.toString()), (long)storefilesAfter.size(), (long)0L);
            hri = region.getRegionInfo();
            AssignmentManager am = this.cluster.getMaster().getAssignmentManager();
            RegionStates regionStates = am.getRegionStates();
            long start = EnvironmentEdgeManager.currentTime();
            while (!regionStates.isRegionInState(hri, new RegionState.State[]{RegionState.State.SPLIT})) {
                Assert.assertFalse((String)"Timed out in waiting split parent to be in state SPLIT", (EnvironmentEdgeManager.currentTime() - start > 60000L ? 1 : 0) != 0);
                Thread.sleep(500L);
            }
            am.assign(hri, true, true);
            Assert.assertFalse((String)"Split region can't be assigned", (boolean)regionStates.isRegionInTransition(hri));
            Assert.assertTrue((boolean)regionStates.isRegionInState(hri, new RegionState.State[]{RegionState.State.SPLIT}));
            am.unassign(hri, true, null);
            Assert.assertFalse((String)"Split region can't be unassigned", (boolean)regionStates.isRegionInTransition(hri));
            Assert.assertTrue((boolean)regionStates.isRegionInState(hri, new RegionState.State[]{RegionState.State.SPLIT}));
        }
        finally {
            this.admin.setBalancerRunning(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testSplitHooksBeforeAndAfterPONR() throws Exception {
        TableName firstTable = TableName.valueOf((String)"testSplitHooksBeforeAndAfterPONR_1");
        TableName secondTable = TableName.valueOf((String)"testSplitHooksBeforeAndAfterPONR_2");
        HColumnDescriptor hcd = new HColumnDescriptor("cf");
        HTableDescriptor desc = new HTableDescriptor(firstTable);
        desc.addCoprocessor(MockedRegionObserver.class.getName());
        desc.addFamily(hcd);
        this.admin.createTable(desc);
        TESTING_UTIL.waitUntilAllRegionsAssigned(firstTable);
        desc = new HTableDescriptor(secondTable);
        desc.addFamily(hcd);
        this.admin.createTable(desc);
        TESTING_UTIL.waitUntilAllRegionsAssigned(secondTable);
        List<HRegion> firstTableRegions = this.cluster.getRegions(firstTable);
        List<HRegion> secondTableRegions = this.cluster.getRegions(secondTable);
        if (firstTableRegions.size() == 0 || secondTableRegions.size() == 0) {
            Assert.fail((String)"Each table should have at least one region.");
        }
        ServerName serverName = this.cluster.getServerHoldingRegion(firstTable, firstTableRegions.get(0).getRegionInfo().getRegionName());
        this.admin.move(secondTableRegions.get(0).getRegionInfo().getEncodedNameAsBytes(), Bytes.toBytes((String)serverName.getServerName()));
        HTable table1 = null;
        HTable table2 = null;
        try {
            table1 = new HTable(TESTING_UTIL.getConfiguration(), firstTable);
            table2 = new HTable(TESTING_UTIL.getConfiguration(), firstTable);
            this.insertData(firstTable, this.admin, (Table)table1);
            this.insertData(secondTable, this.admin, (Table)table2);
            this.admin.split(firstTable, "row2".getBytes());
            firstTableRegions = this.cluster.getRegions(firstTable);
            while (firstTableRegions.size() != 2) {
                Thread.sleep(1000L);
                firstTableRegions = this.cluster.getRegions(firstTable);
            }
            Assert.assertEquals((String)"Number of regions after split should be 2.", (long)2L, (long)firstTableRegions.size());
            secondTableRegions = this.cluster.getRegions(secondTable);
            Assert.assertEquals((String)"Number of regions after split should be 2.", (long)2L, (long)secondTableRegions.size());
        }
        finally {
            if (table1 != null) {
                table1.close();
            }
            if (table2 != null) {
                table2.close();
            }
            TESTING_UTIL.deleteTable(firstTable);
            TESTING_UTIL.deleteTable(secondTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSplitBeforeSettingSplittingInZKInternals() throws Exception {
        TableName tableName = TableName.valueOf((String)"testSplitBeforeSettingSplittingInZK");
        try {
            this.createTableAndWait(tableName, Bytes.toBytes((String)"cf"));
            List<HRegion> regions = this.awaitTableRegions(tableName);
            Assert.assertTrue((String)"Table not online", (this.cluster.getRegions(tableName).size() != 0 ? 1 : 0) != 0);
            int regionServerIndex = this.cluster.getServerWith(regions.get(0).getRegionInfo().getRegionName());
            HRegionServer regionServer = this.cluster.getRegionServer(regionServerIndex);
            HRegion region = this.findSplittableRegion(regions);
            Assert.assertTrue((String)"not able to find a splittable region", (region != null ? 1 : 0) != 0);
            MockedSplitTransaction st = new MockedSplitTransaction(region, Bytes.toBytes((String)"row2")){

                public PairOfSameType<Region> stepsBeforePONR(Server server, RegionServerServices services, boolean testing) throws IOException {
                    throw new SplittingNodeCreationFailedException();
                }
            };
            String node = ZKAssign.getNodeName((ZooKeeperWatcher)regionServer.getZooKeeper(), (String)region.getRegionInfo().getEncodedName());
            regionServer.getZooKeeper().sync(node);
            for (int i = 0; i < 100; ++i) {
                if (ZKUtil.checkExists((ZooKeeperWatcher)regionServer.getZooKeeper(), (String)node) == -1) continue;
                Thread.sleep(100L);
            }
            try {
                st.prepare();
                st.execute((Server)regionServer, (RegionServerServices)regionServer);
            }
            catch (IOException e) {
                Assert.assertTrue((String)"Should be instance of CreateSplittingNodeFailedException", (boolean)(e instanceof SplittingNodeCreationFailedException));
                node = ZKAssign.getNodeName((ZooKeeperWatcher)regionServer.getZooKeeper(), (String)region.getRegionInfo().getEncodedName());
                Assert.assertTrue((ZKUtil.checkExists((ZooKeeperWatcher)regionServer.getZooKeeper(), (String)node) == -1 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)st.rollback((Server)regionServer, (RegionServerServices)regionServer));
                Assert.assertTrue((ZKUtil.checkExists((ZooKeeperWatcher)regionServer.getZooKeeper(), (String)node) == -1 ? 1 : 0) != 0);
            }
        }
        finally {
            TESTING_UTIL.deleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStoreFileReferenceCreationWhenSplitPolicySaysToSkipRangeCheck() throws Exception {
        TableName tableName = TableName.valueOf((String)"testStoreFileReferenceCreationWhenSplitPolicySaysToSkipRangeCheck");
        try {
            HTableDescriptor htd = new HTableDescriptor(tableName);
            htd.addFamily(new HColumnDescriptor("f"));
            htd.addFamily(new HColumnDescriptor("i_f"));
            htd.setRegionSplitPolicyClassName(CustomSplitPolicy.class.getName());
            this.admin.createTable(htd);
            List<HRegion> regions = this.awaitTableRegions(tableName);
            HRegion region = regions.get(0);
            for (int i = 3; i < 9; ++i) {
                Put p = new Put(Bytes.toBytes((String)("row" + i)));
                p.add(Bytes.toBytes((String)"f"), Bytes.toBytes((String)"q"), Bytes.toBytes((String)("value" + i)));
                p.add(Bytes.toBytes((String)"i_f"), Bytes.toBytes((String)"q"), Bytes.toBytes((String)("value" + i)));
                region.put(p);
            }
            region.flush(true);
            Store store = region.getStore(Bytes.toBytes((String)"f"));
            Collection storefiles = store.getStorefiles();
            Assert.assertEquals((long)storefiles.size(), (long)1L);
            Assert.assertFalse((boolean)region.hasReferences());
            Path referencePath = region.getRegionFileSystem().splitStoreFile(region.getRegionInfo(), "f", (StoreFile)storefiles.iterator().next(), Bytes.toBytes((String)"row1"), false, region.getSplitPolicy());
            Assert.assertNull((Object)referencePath);
            referencePath = region.getRegionFileSystem().splitStoreFile(region.getRegionInfo(), "i_f", (StoreFile)storefiles.iterator().next(), Bytes.toBytes((String)"row1"), false, region.getSplitPolicy());
            Assert.assertNotNull((Object)referencePath);
        }
        finally {
            TESTING_UTIL.deleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testFailedSplit() throws Exception {
        TableName tableName = TableName.valueOf((String)"testFailedSplit");
        byte[] colFamily = Bytes.toBytes((String)"info");
        TESTING_UTIL.createTable(tableName, colFamily);
        Connection connection = ConnectionFactory.createConnection((Configuration)TESTING_UTIL.getConfiguration());
        HTable table = (HTable)connection.getTable(tableName);
        try {
            TESTING_UTIL.loadTable((Table)table, colFamily);
            List regions = TESTING_UTIL.getHBaseAdmin().getTableRegions(tableName);
            Assert.assertTrue((regions.size() == 1 ? 1 : 0) != 0);
            HRegion actualRegion = this.cluster.getRegions(tableName).get(0);
            actualRegion.getCoprocessorHost().load(FailingSplitRegionObserver.class, 0x3FFFFFFF, actualRegion.getBaseConf());
            this.admin.split(tableName);
            FailingSplitRegionObserver observer = (FailingSplitRegionObserver)actualRegion.getCoprocessorHost().findCoprocessor(FailingSplitRegionObserver.class.getName());
            Assert.assertNotNull((Object)((Object)observer));
            observer.latch.await();
            observer.postSplit.await();
            LOG.info((Object)("Waiting for region to come out of RIT: " + actualRegion));
            TESTING_UTIL.waitFor(60000L, 1000L, new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    RegionStates regionStates = TestSplitTransactionOnCluster.this.cluster.getMaster().getAssignmentManager().getRegionStates();
                    return !regionStates.isRegionsInTransition();
                }
            });
            regions = TESTING_UTIL.getHBaseAdmin().getTableRegions(tableName);
            Assert.assertTrue((regions.size() == 1 ? 1 : 0) != 0);
            RegionStates regionStates = this.cluster.getMaster().getAssignmentManager().getRegionStates();
            Set rit = regionStates.getRegionsInTransition();
            Assert.assertTrue((rit.size() == 0 ? 1 : 0) != 0);
        }
        finally {
            table.close();
            connection.close();
            TESTING_UTIL.deleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testSSHCleanupDaugtherRegionsOfAbortedSplit() throws Exception {
        TableName table = TableName.valueOf((String)"testSSHCleanupDaugtherRegionsOfAbortedSplit");
        try {
            HTableDescriptor desc = new HTableDescriptor(table);
            desc.addFamily(new HColumnDescriptor(Bytes.toBytes((String)"f")));
            this.admin.createTable(desc);
            HTable hTable = new HTable(this.cluster.getConfiguration(), desc.getTableName());
            for (int i = 1; i < 5; ++i) {
                Put p1 = new Put(("r" + i).getBytes());
                p1.add(Bytes.toBytes((String)"f"), "q1".getBytes(), "v".getBytes());
                hTable.put(p1);
            }
            this.admin.flush(desc.getTableName());
            List<HRegion> regions = this.cluster.getRegions(desc.getTableName());
            int serverWith = this.cluster.getServerWith(regions.get(0).getRegionInfo().getRegionName());
            HRegionServer regionServer = this.cluster.getRegionServer(serverWith);
            this.cluster.getServerWith(regions.get(0).getRegionInfo().getRegionName());
            SplitTransactionImpl st = new SplitTransactionImpl((Region)regions.get(0), Bytes.toBytes((String)"r3"));
            st.prepare();
            st.stepsBeforePONR((Server)regionServer, (RegionServerServices)regionServer, false);
            Path tableDir = FSUtils.getTableDir((Path)this.cluster.getMaster().getMasterFileSystem().getRootDir(), (TableName)desc.getTableName());
            tableDir.getFileSystem(this.cluster.getConfiguration());
            List regionDirs = FSUtils.getRegionDirs((FileSystem)tableDir.getFileSystem(this.cluster.getConfiguration()), (Path)tableDir);
            Assert.assertEquals((long)3L, (long)regionDirs.size());
            this.cluster.startRegionServer();
            regionServer.kill();
            this.cluster.getRegionServerThreads().get(serverWith).join();
            TESTING_UTIL.waitFor(60000L, 1000L, new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    return !TestSplitTransactionOnCluster.this.cluster.getMaster().getServerManager().areDeadServersInProgress();
                }
            });
            TESTING_UTIL.waitFor(60000L, 1000L, new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    return !TestSplitTransactionOnCluster.this.cluster.getMaster().getAssignmentManager().getRegionStates().isRegionsInTransition();
                }
            });
            regionDirs = FSUtils.getRegionDirs((FileSystem)tableDir.getFileSystem(this.cluster.getConfiguration()), (Path)tableDir);
            Assert.assertEquals((long)1L, (long)regionDirs.size());
        }
        finally {
            TESTING_UTIL.deleteTable(table);
        }
    }

    private HRegion findSplittableRegion(List<HRegion> regions) throws InterruptedException {
        for (int i = 0; i < 5; ++i) {
            for (HRegion r : regions) {
                if (!r.isSplittable() || r.getRegionInfo().getReplicaId() != 0) continue;
                return r;
            }
            Thread.sleep(100L);
        }
        return null;
    }

    private List<HRegion> checkAndGetDaughters(TableName tableName) throws InterruptedException {
        List<HRegion> daughters = null;
        for (int i = 0; i < 100 && (daughters = this.cluster.getRegions(tableName)).size() < 2; ++i) {
            Thread.sleep(100L);
        }
        Assert.assertTrue((daughters.size() >= 2 ? 1 : 0) != 0);
        return daughters;
    }

    private MockMasterWithoutCatalogJanitor abortAndWaitForMaster() throws IOException, InterruptedException {
        this.cluster.abortMaster(0);
        this.cluster.waitOnMaster(0);
        this.cluster.getConfiguration().setClass("hbase.master.impl", MockMasterWithoutCatalogJanitor.class, HMaster.class);
        MockMasterWithoutCatalogJanitor master = null;
        master = (MockMasterWithoutCatalogJanitor)this.cluster.startMaster().getMaster();
        this.cluster.waitForActiveAndReadyMaster();
        return master;
    }

    private void split(HRegionInfo hri, HRegionServer server, int regionCount) throws IOException, InterruptedException {
        block3: {
            this.admin.split(hri.getRegionNameAsString());
            try {
                for (int i = 0; ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)server.getRSRpcServices()).size() <= regionCount && i < 300; ++i) {
                    LOG.debug((Object)"Waiting on region to split");
                    Thread.sleep(100L);
                }
                Assert.assertFalse((String)"Waited too long for split", (ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)server.getRSRpcServices()).size() <= regionCount ? 1 : 0) != 0);
            }
            catch (RegionServerStoppedException e) {
                if (!useZKForAssignment) break block3;
                LOG.error((Object)e);
                throw e;
            }
        }
    }

    private int ensureTableRegionNotOnSameServerAsMeta(Admin admin, HRegionInfo hri) throws IOException, MasterNotRunningException, ZooKeeperConnectionException, InterruptedException {
        int metaServerIndex = this.cluster.getServerWithMeta();
        Assert.assertTrue((metaServerIndex != -1 ? 1 : 0) != 0);
        HRegionServer metaRegionServer = this.cluster.getRegionServer(metaServerIndex);
        int tableRegionIndex = this.cluster.getServerWith(hri.getRegionName());
        Assert.assertTrue((tableRegionIndex != -1 ? 1 : 0) != 0);
        HRegionServer tableRegionServer = this.cluster.getRegionServer(tableRegionIndex);
        if (metaRegionServer.getServerName().equals((Object)tableRegionServer.getServerName())) {
            HRegionServer hrs = this.getOtherRegionServer(this.cluster, metaRegionServer);
            Assert.assertNotNull((Object)hrs);
            Assert.assertNotNull((Object)hri);
            LOG.info((Object)("Moving " + hri.getRegionNameAsString() + " from " + metaRegionServer.getServerName() + " to " + hrs.getServerName() + "; metaServerIndex=" + metaServerIndex));
            admin.move(hri.getEncodedNameAsBytes(), Bytes.toBytes((String)hrs.getServerName().toString()));
        }
        for (int i = 0; i < 20 && ((tableRegionIndex = this.cluster.getServerWith(hri.getRegionName())) == -1 || tableRegionIndex == metaServerIndex); ++i) {
            LOG.debug((Object)("Waiting on region move off the hbase:meta server; current index " + tableRegionIndex + " and metaServerIndex=" + metaServerIndex));
            Thread.sleep(1000L);
        }
        Assert.assertTrue((String)"Region not moved off hbase:meta server", (tableRegionIndex != -1 && tableRegionIndex != metaServerIndex ? 1 : 0) != 0);
        tableRegionIndex = this.cluster.getServerWith(hri.getRegionName());
        Assert.assertTrue((tableRegionIndex != -1 ? 1 : 0) != 0);
        Assert.assertNotSame((Object)metaServerIndex, (Object)tableRegionIndex);
        return tableRegionIndex;
    }

    private HRegionServer getOtherRegionServer(MiniHBaseCluster cluster, HRegionServer notThisOne) {
        for (JVMClusterUtil.RegionServerThread rst : cluster.getRegionServerThreads()) {
            HRegionServer hrs = rst.getRegionServer();
            if (hrs.getServerName().equals((Object)notThisOne.getServerName()) || hrs.isStopping() || hrs.isStopped()) continue;
            return hrs;
        }
        return null;
    }

    private void printOutRegions(HRegionServer hrs, String prefix) throws IOException {
        List regions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)hrs.getRSRpcServices());
        for (HRegionInfo region : regions) {
            LOG.info((Object)(prefix + region.getRegionNameAsString()));
        }
    }

    private void waitUntilRegionServerDead() throws InterruptedException, IOException {
        for (int i = 0; this.cluster.getMaster().getClusterStatus().getServers().size() > 3 && i < 100; ++i) {
            LOG.info((Object)"Waiting on server to go down");
            Thread.sleep(100L);
        }
        Assert.assertFalse((String)"Waited too long for RS to die", (this.cluster.getMaster().getClusterStatus().getServers().size() > 3 ? 1 : 0) != 0);
    }

    private void awaitDaughters(TableName tableName, int numDaughters) throws InterruptedException {
        for (int i = 0; this.cluster.getRegions(tableName).size() < numDaughters && i < 60; ++i) {
            LOG.info((Object)"Waiting for repair to happen");
            Thread.sleep(1000L);
        }
        if (this.cluster.getRegions(tableName).size() < numDaughters) {
            Assert.fail((String)"Waiting too long for daughter regions");
        }
    }

    private List<HRegion> awaitTableRegions(TableName tableName) throws InterruptedException {
        List<HRegion> regions = null;
        for (int i = 0; i < 100 && (regions = this.cluster.getRegions(tableName)).size() <= 0; ++i) {
            Thread.sleep(100L);
        }
        return regions;
    }

    private HTable createTableAndWait(TableName tableName, byte[] cf) throws IOException, InterruptedException {
        HTable t = TESTING_UTIL.createTable(tableName, cf);
        this.awaitTableRegions(tableName);
        Assert.assertTrue((String)("Table not online: " + tableName), (this.cluster.getRegions(tableName).size() != 0 ? 1 : 0) != 0);
        return t;
    }

    static {
        latch = new CountDownLatch(1);
        secondSplit = false;
        callRollBack = false;
        firstSplitCompleted = false;
        TESTING_UTIL = new HBaseTestingUtility();
    }

    static class CustomSplitPolicy
    extends RegionSplitPolicy {
        CustomSplitPolicy() {
        }

        protected boolean shouldSplit() {
            return true;
        }

        public boolean skipStoreFileRangeCheck(String familyName) {
            return familyName.startsWith("i_");
        }
    }

    public static class MockedRegionObserver
    extends BaseRegionObserver {
        private SplitTransactionImpl st = null;
        private PairOfSameType<Region> daughterRegions = null;

        public void preSplitBeforePONR(ObserverContext<RegionCoprocessorEnvironment> ctx, byte[] splitKey, List<Mutation> metaEntries) throws IOException {
            RegionCoprocessorEnvironment environment = (RegionCoprocessorEnvironment)ctx.getEnvironment();
            HRegionServer rs = (HRegionServer)environment.getRegionServerServices();
            List onlineRegions = rs.getOnlineRegions(TableName.valueOf((String)"testSplitHooksBeforeAndAfterPONR_2"));
            Region region = (Region)onlineRegions.get(0);
            for (Region r : onlineRegions) {
                if (!r.getRegionInfo().containsRow(splitKey)) continue;
                region = r;
                break;
            }
            this.st = new SplitTransactionImpl((Region)((HRegion)region), splitKey);
            if (!this.st.prepare()) {
                LOG.error((Object)("Prepare for the table " + region.getTableDesc().getNameAsString() + " failed. So returning null. "));
                ctx.bypass();
                return;
            }
            ((HRegion)region).forceSplit(splitKey);
            this.daughterRegions = this.st.stepsBeforePONR((Server)rs, (RegionServerServices)rs, false);
            HRegionInfo copyOfParent = new HRegionInfo(region.getRegionInfo());
            copyOfParent.setOffline(true);
            copyOfParent.setSplit(true);
            Put putParent = MetaTableAccessor.makePutFromRegionInfo((HRegionInfo)copyOfParent);
            MetaTableAccessor.addDaughtersToPut((Put)putParent, (HRegionInfo)((Region)this.daughterRegions.getFirst()).getRegionInfo(), (HRegionInfo)((Region)this.daughterRegions.getSecond()).getRegionInfo());
            metaEntries.add((Mutation)putParent);
            Put putA = MetaTableAccessor.makePutFromRegionInfo((HRegionInfo)((Region)this.daughterRegions.getFirst()).getRegionInfo());
            Put putB = MetaTableAccessor.makePutFromRegionInfo((HRegionInfo)((Region)this.daughterRegions.getSecond()).getRegionInfo());
            this.st.addLocation(putA, rs.getServerName(), 1L);
            this.st.addLocation(putB, rs.getServerName(), 1L);
            metaEntries.add((Mutation)putA);
            metaEntries.add((Mutation)putB);
        }

        public void preSplitAfterPONR(ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
            RegionCoprocessorEnvironment environment = (RegionCoprocessorEnvironment)ctx.getEnvironment();
            HRegionServer rs = (HRegionServer)environment.getRegionServerServices();
            this.st.stepsAfterPONR((Server)rs, (RegionServerServices)rs, this.daughterRegions, null);
        }
    }

    private static class SplittingNodeCreationFailedException
    extends IOException {
        private static final long serialVersionUID = 1652404976265623004L;
    }

    public static class MockMasterWithoutCatalogJanitor
    extends HMaster {
        public MockMasterWithoutCatalogJanitor(Configuration conf, CoordinatedStateManager cp) throws IOException, KeeperException, InterruptedException {
            super(conf, cp);
        }
    }

    public static class MockedSplitTransactionCoordination
    extends ZKSplitTransactionCoordination {
        private HRegion currentRegion;

        public MockedSplitTransactionCoordination(CoordinatedStateManager coordinationProvider, ZooKeeperWatcher watcher, HRegion region) {
            super(coordinationProvider, watcher);
            this.currentRegion = region;
        }

        public void completeSplitTransaction(RegionServerServices services, Region a, Region b, SplitTransactionCoordination.SplitTransactionDetails std, Region parent) throws IOException {
            if (this.currentRegion.getRegionInfo().getTable().getNameAsString().equals("testShouldFailSplitIfZNodeDoesNotExistDueToPrevRollBack")) {
                try {
                    if (!secondSplit) {
                        callRollBack = true;
                        latch.await();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            super.completeSplitTransaction(services, a, b, std, parent);
            if (this.currentRegion.getRegionInfo().getTable().getNameAsString().equals("testShouldFailSplitIfZNodeDoesNotExistDueToPrevRollBack")) {
                firstSplitCompleted = true;
            }
        }
    }

    public static class MockedSplitTransaction
    extends SplitTransactionImpl {
        private HRegion currentRegion;

        public MockedSplitTransaction(HRegion region, byte[] splitrow) {
            super((Region)region, splitrow);
            this.currentRegion = region;
        }

        public boolean rollback(Server server, RegionServerServices services) throws IOException {
            if (this.currentRegion.getRegionInfo().getTable().getNameAsString().equals("testShouldFailSplitIfZNodeDoesNotExistDueToPrevRollBack") && secondSplit) {
                super.rollback(server, services);
                latch.countDown();
                return true;
            }
            return super.rollback(server, services);
        }
    }

    public static class MockedCoordinatedStateManager
    extends ZkCoordinatedStateManager {
        public void initialize(Server server, HRegion region) {
            this.server = server;
            this.watcher = server.getZooKeeper();
            this.splitTransactionCoordination = new MockedSplitTransactionCoordination((CoordinatedStateManager)this, this.watcher, region);
            this.closeRegionCoordination = new ZkCloseRegionCoordination((CoordinatedStateManager)this, this.watcher);
            this.openRegionCoordination = new ZkOpenRegionCoordination((CoordinatedStateManager)this, this.watcher);
        }
    }

    static class UselessTestAbortable
    implements Abortable {
        boolean aborted = false;

        UselessTestAbortable() {
        }

        public void abort(String why, Throwable e) {
            LOG.warn((Object)("ABORTED (But nothing to abort): why=" + why), e);
            this.aborted = true;
        }

        public boolean isAborted() {
            return this.aborted;
        }
    }

    public static class FailingSplitRegionObserver
    extends BaseRegionObserver {
        volatile CountDownLatch latch;
        volatile CountDownLatch postSplit;

        public void start(CoprocessorEnvironment e) throws IOException {
            this.latch = new CountDownLatch(1);
            this.postSplit = new CountDownLatch(1);
        }

        public void preSplitBeforePONR(ObserverContext<RegionCoprocessorEnvironment> ctx, byte[] splitKey, List<Mutation> metaEntries) throws IOException {
            this.latch.countDown();
            LOG.info((Object)"Causing rollback of region split");
            throw new IOException("Causing rollback of region split");
        }

        public void postCompleteSplit(ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
            this.postSplit.countDown();
            LOG.info((Object)"postCompleteSplit called");
        }
    }
}

