/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.RegionTransition;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.exceptions.MergeRegionException;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.regionserver.CompactedHFilesDischarger;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.util.StringUtils;
import org.apache.zookeeper.data.Stat;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestRegionMergeTransactionOnCluster {
    private static final Log LOG = LogFactory.getLog(TestRegionMergeTransactionOnCluster.class);
    private static final int NB_SERVERS = 3;
    private static final byte[] FAMILYNAME = Bytes.toBytes((String)"fam");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"q");
    private static byte[] ROW = Bytes.toBytes((String)"testRow");
    private static final int INITIAL_REGION_NUM = 10;
    private static final int ROWSIZE = 200;
    private static byte[][] ROWS = TestRegionMergeTransactionOnCluster.makeN(ROW, 200);
    private static int waitTime = 60000;
    static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static HMaster master;
    private static Admin admin;
    static MiniHBaseCluster cluster;
    static Configuration conf;

    static void setupOnce() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.hfile.compaction.discharger.interval", Integer.MAX_VALUE);
        TEST_UTIL.startMiniCluster(3);
        cluster = TEST_UTIL.getHBaseCluster();
        master = cluster.getMaster();
        master.balanceSwitch(false);
        admin = TEST_UTIL.getHBaseAdmin();
    }

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.assignment.usezk", true);
        TestRegionMergeTransactionOnCluster.setupOnce();
    }

    @AfterClass
    public static void afterAllTests() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testWholesomeMerge() throws Exception {
        LOG.info((Object)"Starting testWholesomeMerge");
        TableName tableName = TableName.valueOf((String)"testWholesomeMerge");
        Table table = this.createTableAndLoadData(master, tableName);
        this.mergeRegionsAndVerifyRegionNum(master, tableName, 0, 1, 9);
        PairOfSameType<HRegionInfo> mergedRegions = this.mergeRegionsAndVerifyRegionNum(master, tableName, 1, 2, 8);
        this.verifyRowCount(table, 200);
        HRegionInfo hri = RandomUtils.nextBoolean() ? (HRegionInfo)mergedRegions.getFirst() : (HRegionInfo)mergedRegions.getSecond();
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        AssignmentManager am = cluster.getMaster().getAssignmentManager();
        RegionStates regionStates = am.getRegionStates();
        long start = EnvironmentEdgeManager.currentTime();
        while (!regionStates.isRegionInState(hri, new RegionState.State[]{RegionState.State.MERGED})) {
            Assert.assertFalse((String)"Timed out in waiting one merged region to be in state MERGED", (EnvironmentEdgeManager.currentTime() - start > 60000L ? 1 : 0) != 0);
            Thread.sleep(500L);
        }
        am.assign(hri, true, true);
        Assert.assertFalse((String)"Merged region can't be assigned", (boolean)regionStates.isRegionInTransition(hri));
        Assert.assertTrue((boolean)regionStates.isRegionInState(hri, new RegionState.State[]{RegionState.State.MERGED}));
        am.unassign(hri, true, null);
        Assert.assertFalse((String)"Merged region can't be unassigned", (boolean)regionStates.isRegionInTransition(hri));
        Assert.assertTrue((boolean)regionStates.isRegionInState(hri, new RegionState.State[]{RegionState.State.MERGED}));
        table.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCleanMergeReference() throws Exception {
        LOG.info((Object)"Starting testCleanMergeReference");
        admin.enableCatalogJanitor(false);
        try {
            int cleaned;
            TableName tableName = TableName.valueOf((String)"testCleanMergeReference");
            Table table = this.createTableAndLoadData(master, tableName);
            this.mergeRegionsAndVerifyRegionNum(master, tableName, 0, 1, 9);
            this.verifyRowCount(table, 200);
            table.close();
            List tableRegions = MetaTableAccessor.getTableRegionsAndLocations((ZooKeeperWatcher)master.getZooKeeper(), (Connection)master.getConnection(), (TableName)tableName);
            HRegionInfo mergedRegionInfo = (HRegionInfo)((Pair)tableRegions.get(0)).getFirst();
            HTableDescriptor tableDescriptor = master.getTableDescriptors().get(tableName);
            Result mergedRegionResult = MetaTableAccessor.getRegionResult((Connection)master.getConnection(), (byte[])mergedRegionInfo.getRegionName());
            Assert.assertTrue((mergedRegionResult.getValue(HConstants.CATALOG_FAMILY, HConstants.MERGEA_QUALIFIER) != null ? 1 : 0) != 0);
            Assert.assertTrue((mergedRegionResult.getValue(HConstants.CATALOG_FAMILY, HConstants.MERGEB_QUALIFIER) != null ? 1 : 0) != 0);
            HRegionInfo regionA = HRegionInfo.getHRegionInfo((Result)mergedRegionResult, (byte[])HConstants.MERGEA_QUALIFIER);
            HRegionInfo regionB = HRegionInfo.getHRegionInfo((Result)mergedRegionResult, (byte[])HConstants.MERGEB_QUALIFIER);
            FileSystem fs = master.getMasterFileSystem().getFileSystem();
            Path rootDir = master.getMasterFileSystem().getRootDir();
            Path tabledir = FSUtils.getTableDir((Path)rootDir, (TableName)mergedRegionInfo.getTable());
            Path regionAdir = new Path(tabledir, regionA.getEncodedName());
            Path regionBdir = new Path(tabledir, regionB.getEncodedName());
            Assert.assertTrue((boolean)fs.exists(regionAdir));
            Assert.assertTrue((boolean)fs.exists(regionBdir));
            HColumnDescriptor[] columnFamilies = tableDescriptor.getColumnFamilies();
            HRegionFileSystem hrfs = new HRegionFileSystem(TEST_UTIL.getConfiguration(), fs, tabledir, mergedRegionInfo);
            int count = 0;
            for (HColumnDescriptor hColumnDescriptor : columnFamilies) {
                count += hrfs.getStoreFiles(hColumnDescriptor.getName()).size();
            }
            admin.compactRegion(mergedRegionInfo.getRegionName());
            long timeout = System.currentTimeMillis() + (long)waitTime;
            int newcount = 0;
            while (System.currentTimeMillis() < timeout) {
                for (HColumnDescriptor colFamily : columnFamilies) {
                    newcount += hrfs.getStoreFiles(colFamily.getName()).size();
                }
                if (newcount > count && admin.getCompactionState(tableName) == AdminProtos.GetRegionInfoResponse.CompactionState.NONE) break;
                Thread.sleep(50L);
            }
            Assert.assertTrue((newcount > count ? 1 : 0) != 0);
            List<JVMClusterUtil.RegionServerThread> list = TEST_UTIL.getHBaseCluster().getRegionServerThreads();
            for (JVMClusterUtil.RegionServerThread rs : list) {
                CompactedHFilesDischarger cleaner = new CompactedHFilesDischarger(100, null, (RegionServerServices)rs.getRegionServer(), false);
                cleaner.chore();
                Thread.sleep(1000L);
            }
            int newcount1 = 0;
            while (System.currentTimeMillis() < timeout) {
                for (HColumnDescriptor colFamily : columnFamilies) {
                    newcount1 += hrfs.getStoreFiles(colFamily.getName()).size();
                }
                if (newcount1 <= 1) break;
                Thread.sleep(50L);
            }
            Assert.assertTrue(((cleaned = admin.runCatalogScan()) > 0 ? 1 : 0) != 0);
            Assert.assertFalse((boolean)fs.exists(regionAdir));
            Assert.assertFalse((boolean)fs.exists(regionBdir));
            mergedRegionResult = MetaTableAccessor.getRegionResult((Connection)master.getConnection(), (byte[])mergedRegionInfo.getRegionName());
            Assert.assertFalse((mergedRegionResult.getValue(HConstants.CATALOG_FAMILY, HConstants.MERGEA_QUALIFIER) != null ? 1 : 0) != 0);
            Assert.assertFalse((mergedRegionResult.getValue(HConstants.CATALOG_FAMILY, HConstants.MERGEB_QUALIFIER) != null ? 1 : 0) != 0);
        }
        finally {
            admin.enableCatalogJanitor(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMerge() throws Exception {
        LOG.info((Object)"Starting testMerge");
        TableName tableName = TableName.valueOf((String)"testMerge");
        try {
            Table table = this.createTableAndLoadData(master, tableName);
            RegionStates regionStates = master.getAssignmentManager().getRegionStates();
            List regions = regionStates.getRegionsOfTable(tableName);
            HRegionInfo a = (HRegionInfo)regions.get(0);
            HRegionInfo b = (HRegionInfo)regions.get(1);
            regionStates.regionOffline(a);
            try {
                admin.mergeRegions(a.getEncodedNameAsBytes(), b.getEncodedNameAsBytes(), false);
                Assert.fail((String)"Offline regions should not be able to merge");
            }
            catch (IOException ie) {
                System.out.println(ie);
                Assert.assertTrue((String)"Exception should mention regions not online", (StringUtils.stringifyException((Throwable)ie).contains("regions not online") && ie instanceof MergeRegionException ? 1 : 0) != 0);
            }
            try {
                admin.mergeRegions(b.getEncodedNameAsBytes(), b.getEncodedNameAsBytes(), true);
                Assert.fail((String)"A region should not be able to merge with itself, even forcifully");
            }
            catch (IOException ie) {
                Assert.assertTrue((String)"Exception should mention regions not online", (StringUtils.stringifyException((Throwable)ie).contains("region to itself") && ie instanceof MergeRegionException ? 1 : 0) != 0);
            }
            try {
                admin.mergeRegions(Bytes.toBytes((String)"-f1"), Bytes.toBytes((String)"-f2"), true);
                Assert.fail((String)"Unknown region could not be merged");
            }
            catch (IOException ie) {
                Assert.assertTrue((String)"UnknownRegionException should be thrown", (boolean)(ie instanceof UnknownRegionException));
            }
            table.close();
        }
        finally {
            TEST_UTIL.deleteTable(tableName);
        }
    }

    @Test
    public void testMergeWithReplicas() throws Exception {
        TableName tableName = TableName.valueOf((String)"testMergeWithReplicas");
        this.createTableAndLoadData(master, tableName, 5, 2);
        List initialRegionToServers = MetaTableAccessor.getTableRegionsAndLocations((ZooKeeperWatcher)master.getZooKeeper(), (Connection)master.getConnection(), (TableName)tableName);
        PairOfSameType<HRegionInfo> mergedRegions = this.mergeRegionsAndVerifyRegionNum(master, tableName, 0, 2, 8);
        List currentRegionToServers = MetaTableAccessor.getTableRegionsAndLocations((ZooKeeperWatcher)master.getZooKeeper(), (Connection)master.getConnection(), (TableName)tableName);
        ArrayList<HRegionInfo> initialRegions = new ArrayList<HRegionInfo>();
        for (Pair p : initialRegionToServers) {
            initialRegions.add((HRegionInfo)p.getFirst());
        }
        ArrayList<HRegionInfo> currentRegions = new ArrayList<HRegionInfo>();
        for (Pair p : currentRegionToServers) {
            currentRegions.add((HRegionInfo)p.getFirst());
        }
        Assert.assertTrue((boolean)initialRegions.contains(mergedRegions.getFirst()));
        Assert.assertTrue((boolean)initialRegions.contains(RegionReplicaUtil.getRegionInfoForReplica((HRegionInfo)((HRegionInfo)mergedRegions.getFirst()), (int)1)));
        Assert.assertTrue((boolean)initialRegions.contains(mergedRegions.getSecond()));
        Assert.assertTrue((boolean)initialRegions.contains(RegionReplicaUtil.getRegionInfoForReplica((HRegionInfo)((HRegionInfo)mergedRegions.getSecond()), (int)1)));
        Assert.assertTrue((!initialRegions.contains(currentRegions.get(0)) ? 1 : 0) != 0);
        Assert.assertTrue((!initialRegions.contains(RegionReplicaUtil.getRegionInfoForReplica((HRegionInfo)((HRegionInfo)currentRegions.get(0)), (int)1)) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)currentRegions.contains(RegionReplicaUtil.getRegionInfoForReplica((HRegionInfo)((HRegionInfo)currentRegions.get(0)), (int)1)));
        Assert.assertTrue((!currentRegions.contains(RegionReplicaUtil.getRegionInfoForReplica((HRegionInfo)((HRegionInfo)mergedRegions.getFirst()), (int)1)) ? 1 : 0) != 0);
        Assert.assertTrue((!currentRegions.contains(RegionReplicaUtil.getRegionInfoForReplica((HRegionInfo)((HRegionInfo)mergedRegions.getSecond()), (int)1)) ? 1 : 0) != 0);
    }

    private PairOfSameType<HRegionInfo> mergeRegionsAndVerifyRegionNum(HMaster master, TableName tablename, int regionAnum, int regionBnum, int expectedRegionNum) throws Exception {
        PairOfSameType<HRegionInfo> mergedRegions = this.requestMergeRegion(master, tablename, regionAnum, regionBnum);
        this.waitAndVerifyRegionNum(master, tablename, expectedRegionNum);
        return mergedRegions;
    }

    private PairOfSameType<HRegionInfo> requestMergeRegion(HMaster master, TableName tablename, int regionAnum, int regionBnum) throws Exception {
        List tableRegions = MetaTableAccessor.getTableRegionsAndLocations((ZooKeeperWatcher)master.getZooKeeper(), (Connection)master.getConnection(), (TableName)tablename);
        HRegionInfo regionA = (HRegionInfo)((Pair)tableRegions.get(regionAnum)).getFirst();
        HRegionInfo regionB = (HRegionInfo)((Pair)tableRegions.get(regionBnum)).getFirst();
        TEST_UTIL.getHBaseAdmin().mergeRegions(regionA.getEncodedNameAsBytes(), regionB.getEncodedNameAsBytes(), false);
        return new PairOfSameType((Object)regionA, (Object)regionB);
    }

    private void waitAndVerifyRegionNum(HMaster master, TableName tablename, int expectedRegionNum) throws Exception {
        List tableRegionsInMeta;
        long timeout = System.currentTimeMillis() + (long)waitTime;
        while (System.currentTimeMillis() < timeout) {
            tableRegionsInMeta = MetaTableAccessor.getTableRegionsAndLocations((ZooKeeperWatcher)master.getZooKeeper(), (Connection)master.getConnection(), (TableName)tablename);
            List tableRegionsInMaster = master.getAssignmentManager().getRegionStates().getRegionsOfTable(tablename);
            if (tableRegionsInMeta.size() == expectedRegionNum && tableRegionsInMaster.size() == expectedRegionNum) break;
            Thread.sleep(250L);
        }
        tableRegionsInMeta = MetaTableAccessor.getTableRegionsAndLocations((ZooKeeperWatcher)master.getZooKeeper(), (Connection)master.getConnection(), (TableName)tablename);
        LOG.info((Object)("Regions after merge:" + Joiner.on((char)',').join((Iterable)tableRegionsInMeta)));
        Assert.assertEquals((long)expectedRegionNum, (long)tableRegionsInMeta.size());
    }

    private Table createTableAndLoadData(HMaster master, TableName tablename) throws Exception {
        return this.createTableAndLoadData(master, tablename, 10, 1);
    }

    private Table createTableAndLoadData(HMaster master, TableName tablename, int numRegions, int replication) throws Exception {
        List tableRegions;
        Assert.assertTrue((String)("ROWSIZE must > numregions:" + numRegions), (200 > numRegions ? 1 : 0) != 0);
        byte[][] splitRows = new byte[numRegions - 1][];
        for (int i = 0; i < splitRows.length; ++i) {
            splitRows[i] = ROWS[(i + 1) * 200 / numRegions];
        }
        HTable table = TEST_UTIL.createTable(tablename, FAMILYNAME, (byte[][])splitRows);
        if (replication > 1) {
            HBaseTestingUtility.setReplicas(admin, tablename, replication);
        }
        this.loadData((Table)table);
        this.verifyRowCount((Table)table, 200);
        long timeout = System.currentTimeMillis() + (long)waitTime;
        while (System.currentTimeMillis() < timeout && (tableRegions = MetaTableAccessor.getTableRegionsAndLocations((ZooKeeperWatcher)master.getZooKeeper(), (Connection)master.getConnection(), (TableName)tablename)).size() != numRegions * replication) {
            Thread.sleep(250L);
        }
        tableRegions = MetaTableAccessor.getTableRegionsAndLocations((ZooKeeperWatcher)master.getZooKeeper(), (Connection)master.getConnection(), (TableName)tablename);
        LOG.info((Object)("Regions after load: " + Joiner.on((char)',').join((Iterable)tableRegions)));
        Assert.assertEquals((long)(numRegions * replication), (long)tableRegions.size());
        return table;
    }

    private static byte[][] makeN(byte[] base, int n) {
        byte[][] ret = new byte[n][];
        for (int i = 0; i < n; ++i) {
            ret[i] = Bytes.add((byte[])base, (byte[])Bytes.toBytes((String)String.format("%04d", i)));
        }
        return ret;
    }

    private void loadData(Table table) throws IOException {
        for (int i = 0; i < 200; ++i) {
            Put put = new Put(ROWS[i]);
            put.add(FAMILYNAME, QUALIFIER, Bytes.toBytes((int)i));
            table.put(put);
        }
    }

    private void verifyRowCount(Table table, int expectedRegionNum) throws IOException {
        ResultScanner scanner = table.getScanner(new Scan());
        int rowCount = 0;
        while (scanner.next() != null) {
            ++rowCount;
        }
        Assert.assertEquals((long)expectedRegionNum, (long)rowCount);
        scanner.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testMergeIsRolledBackOnMergeFailure() throws Exception {
        final RegionStates regionStates = master.getAssignmentManager().getRegionStates();
        final ZooKeeperWatcher zkw = TEST_UTIL.getZooKeeperWatcher();
        final TableName tableName = TableName.valueOf((String)"testMergeIsRolledBackOnMergeFailure");
        this.createTableAndLoadData(master, tableName, 2, 1);
        List<HRegion> regions = cluster.getRegions(tableName);
        Assert.assertEquals((String)("Table shudn't have more than 2 regions, " + regions), (long)2L, (long)regions.size());
        HRegionInfo regionA = regions.get(0).getRegionInfo();
        HRegionInfo regionB = regions.get(1).getRegionInfo();
        admin.setBalancerRunning(false, true);
        master.setCatalogJanitorEnabled(false);
        HRegionServer regionServer = cluster.startRegionServer().getRegionServer();
        this.moveRegionToServer(regionA, regionServer);
        this.moveRegionToServer(regionB, regionServer);
        int serverIndex = cluster.getServerWith(regionA.getRegionName());
        TEST_UTIL.compact(tableName, true);
        try {
            this.printOutRegions(regionServer, "Initial regions: ");
            AssignmentManager.setTestSkipMergeHandling((boolean)true);
            admin.mergeRegions(regionA.getRegionName(), regionB.getRegionName(), false);
            TEST_UTIL.waitFor(60000L, new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    return ((List)regionStates.getRegionByStateOfTable(tableName).get(RegionState.State.MERGING_NEW)).size() > 0;
                }
            });
            List mergedRegions = (List)regionStates.getRegionByStateOfTable(tableName).get(RegionState.State.MERGING_NEW);
            Assert.assertEquals((String)"Only one region should be in MERGING_NEW state", (long)1L, (long)mergedRegions.size());
            final HRegionInfo merge = (HRegionInfo)mergedRegions.get(0);
            final String path = ZKAssign.getNodeName((ZooKeeperWatcher)zkw, (String)merge.getEncodedName());
            TEST_UTIL.waitFor(60000L, new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    Stat stats = zkw.getRecoverableZooKeeper().exists(path, false);
                    RegionTransition rt = RegionTransition.parseFrom((byte[])ZKAssign.getData((ZooKeeperWatcher)zkw, (String)merge.getEncodedName()));
                    return stats != null && rt.getEventType().equals((Object)EventType.RS_ZK_REGION_MERGED);
                }
            });
            this.abortServerAndWaitForProcessingToComplete(serverIndex);
            this.waitUntilRegionServerDead();
            TEST_UTIL.waitUntilNoRegionsInTransition();
            TEST_UTIL.waitFor(60000L, new Waiter.Predicate<Exception>(){

                public boolean evaluate() {
                    return cluster.getRegions(tableName).size() == 2;
                }
            });
            List tableRegions = MetaTableAccessor.getTableRegions((ZooKeeperWatcher)zkw, (Connection)cluster.getMaster().getConnection(), (TableName)tableName);
            Assert.assertEquals((String)("Only parent regions should be present, but we have: " + tableRegions), (long)2L, (long)tableRegions.size());
            Assert.assertTrue((String)("Merge A not present? " + regionA), (boolean)tableRegions.contains(regionA));
            Assert.assertTrue((String)("Merge B not present? " + regionB), (boolean)tableRegions.contains(regionB));
            Assert.assertTrue((String)("region should be online, " + regionA), (boolean)regionStates.isRegionOnline(regionA));
            Assert.assertTrue((String)("region should be online, " + regionB), (boolean)regionStates.isRegionOnline(regionB));
            Path tableDir = FSUtils.getTableDir((Path)FSUtils.getRootDir((Configuration)conf), (TableName)tableName);
            List regionDirs = FSUtils.getRegionDirs((FileSystem)cluster.getMaster().getFileSystem(), (Path)tableDir);
            Assert.assertEquals((String)("Only two region dir should be present, we have, dirs: " + regionDirs), (long)2L, (long)regionDirs.size());
            Assert.assertTrue((String)("Region dir doesn't belong to region: " + regionA + " dir: " + regionDirs), (((Path)regionDirs.get(0)).getName().endsWith(regionA.getEncodedName()) || ((Path)regionDirs.get(1)).getName().endsWith(regionA.getEncodedName()) ? 1 : 0) != 0);
            Assert.assertTrue((String)("Region dir doesn't belong to region: " + regionB + " dir: " + regionDirs), (((Path)regionDirs.get(0)).getName().endsWith(regionB.getEncodedName()) || ((Path)regionDirs.get(1)).getName().endsWith(regionB.getEncodedName()) ? 1 : 0) != 0);
            Stat stat = zkw.getRecoverableZooKeeper().exists(path, false);
            Assert.assertNull((String)("Merged znode shouldn't exist, but we have stat: " + stat), (Object)stat);
        }
        finally {
            AssignmentManager.setTestSkipMergeHandling((boolean)false);
            admin.setBalancerRunning(true, false);
            master.setCatalogJanitorEnabled(true);
            TEST_UTIL.deleteTable(tableName);
        }
    }

    private void moveRegionToServer(final HRegionInfo region, final HRegionServer rs) throws Exception {
        admin.move(region.getEncodedNameAsBytes(), rs.getServerName().toString().getBytes());
        TEST_UTIL.waitUntilNoRegionsInTransition();
        TEST_UTIL.waitFor(60000L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return rs.getOnlineRegion(region.getRegionName()) != null;
            }
        });
    }

    private void waitUntilRegionServerDead() throws InterruptedException, IOException {
        for (int i = 0; cluster.getMaster().getClusterStatus().getServers().size() > 3 && i < 100; ++i) {
            LOG.info((Object)"Waiting on server to go down");
            Thread.sleep(100L);
        }
        Assert.assertFalse((String)"Waited too long for RS to die", (cluster.getMaster().getClusterStatus().getServers().size() > 3 ? 1 : 0) != 0);
    }

    private void printOutRegions(HRegionServer hrs, String prefix) throws IOException {
        List regions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)hrs.getRSRpcServices());
        for (HRegionInfo region : regions) {
            LOG.info((Object)(prefix + region.getRegionNameAsString()));
        }
    }

    private void abortServerAndWaitForProcessingToComplete(int serverIndex) throws Exception {
        final HMaster master = TEST_UTIL.getMiniHBaseCluster().getMaster();
        cluster.abortRegionServer(serverIndex);
        TEST_UTIL.waitFor(60000L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return master.getServerManager().areDeadServersInProgress();
            }
        });
    }
}

