/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.ProcedureInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.constraint.ConstraintException;
import org.apache.hadoop.hbase.master.procedure.CreateNamespaceProcedure;
import org.apache.hadoop.hbase.master.procedure.DeleteNamespaceProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestDeleteNamespaceProcedure {
    private static final Log LOG = LogFactory.getLog(TestDeleteNamespaceProcedure.class);
    protected static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    private static void setupConf(Configuration conf) {
        conf.setInt("hbase.master.procedure.threads", 1);
    }

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestDeleteNamespaceProcedure.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn((Object)"failure shutting down cluster", (Throwable)e);
        }
    }

    @Before
    public void setup() throws Exception {
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(this.getMasterProcedureExecutor(), (boolean)false);
    }

    @After
    public void tearDown() throws Exception {
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(this.getMasterProcedureExecutor(), (boolean)false);
        for (HTableDescriptor htd : UTIL.getHBaseAdmin().listTables()) {
            LOG.info((Object)("Tear down, remove table=" + htd.getTableName()));
            UTIL.deleteTable(htd.getTableName());
        }
    }

    @Test(timeout=60000L)
    public void testDeleteNamespace() throws Exception {
        String namespaceName = "testDeleteNamespace";
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        this.createNamespaceForTesting("testDeleteNamespace");
        long procId = procExec.submitProcedure((Procedure)new DeleteNamespaceProcedure((MasterProcedureEnv)procExec.getEnvironment(), "testDeleteNamespace"));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
        TestDeleteNamespaceProcedure.validateNamespaceNotExist("testDeleteNamespace");
    }

    @Test(timeout=60000L)
    public void testDeleteNonExistNamespace() throws Exception {
        String namespaceName = "testDeleteNonExistNamespace";
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        TestDeleteNamespaceProcedure.validateNamespaceNotExist("testDeleteNonExistNamespace");
        long procId = procExec.submitProcedure((Procedure)new DeleteNamespaceProcedure((MasterProcedureEnv)procExec.getEnvironment(), "testDeleteNonExistNamespace"));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        ProcedureInfo result = procExec.getResult(procId);
        Assert.assertTrue((boolean)result.isFailed());
        LOG.debug((Object)("Delete namespace failed with exception: " + result.getExceptionFullMessage()));
        Assert.assertTrue((boolean)(ProcedureTestingUtility.getExceptionCause((ProcedureInfo)result) instanceof NamespaceNotFoundException));
    }

    @Test(timeout=60000L)
    public void testDeleteSystemNamespace() throws Exception {
        String namespaceName = NamespaceDescriptor.SYSTEM_NAMESPACE.getName();
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        long procId = procExec.submitProcedure((Procedure)new DeleteNamespaceProcedure((MasterProcedureEnv)procExec.getEnvironment(), namespaceName));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        ProcedureInfo result = procExec.getResult(procId);
        Assert.assertTrue((boolean)result.isFailed());
        LOG.debug((Object)("Delete namespace failed with exception: " + result.getExceptionFullMessage()));
        Assert.assertTrue((boolean)(ProcedureTestingUtility.getExceptionCause((ProcedureInfo)result) instanceof ConstraintException));
    }

    @Test(timeout=60000L)
    public void testDeleteNonEmptyNamespace() throws Exception {
        String namespaceName = "testDeleteNonExistNamespace";
        TableName tableName = TableName.valueOf((String)"testDeleteNonExistNamespace:t1");
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        this.createNamespaceForTesting("testDeleteNonExistNamespace");
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "f1");
        long procId = procExec.submitProcedure((Procedure)new DeleteNamespaceProcedure((MasterProcedureEnv)procExec.getEnvironment(), "testDeleteNonExistNamespace"));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        ProcedureInfo result = procExec.getResult(procId);
        Assert.assertTrue((boolean)result.isFailed());
        LOG.debug((Object)("Delete namespace failed with exception: " + result.getExceptionFullMessage()));
        Assert.assertTrue((boolean)(ProcedureTestingUtility.getExceptionCause((ProcedureInfo)result) instanceof ConstraintException));
    }

    @Test(timeout=60000L)
    public void testRecoveryAndDoubleExecution() throws Exception {
        String namespaceName = "testRecoveryAndDoubleExecution";
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        this.createNamespaceForTesting("testRecoveryAndDoubleExecution");
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure((Procedure)new DeleteNamespaceProcedure((MasterProcedureEnv)procExec.getEnvironment(), "testRecoveryAndDoubleExecution"));
        int numberOfSteps = MasterProcedureProtos.DeleteNamespaceState.values().length;
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId, numberOfSteps, MasterProcedureProtos.DeleteNamespaceState.values());
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
        TestDeleteNamespaceProcedure.validateNamespaceNotExist("testRecoveryAndDoubleExecution");
    }

    @Test(timeout=60000L)
    public void testRollbackAndDoubleExecution() throws Exception {
        String namespaceName = "testRollbackAndDoubleExecution";
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        this.createNamespaceForTesting("testRollbackAndDoubleExecution");
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure((Procedure)new DeleteNamespaceProcedure((MasterProcedureEnv)procExec.getEnvironment(), "testRollbackAndDoubleExecution"));
        int numberOfSteps = MasterProcedureProtos.DeleteNamespaceState.values().length - 2;
        MasterProcedureTestingUtility.testRollbackAndDoubleExecution(procExec, procId, numberOfSteps, MasterProcedureProtos.DeleteNamespaceState.values());
        NamespaceDescriptor createdNsDescriptor = UTIL.getHBaseAdmin().getNamespaceDescriptor("testRollbackAndDoubleExecution");
        Assert.assertNotNull((Object)createdNsDescriptor);
    }

    private ProcedureExecutor<MasterProcedureEnv> getMasterProcedureExecutor() {
        return UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor();
    }

    private void createNamespaceForTesting(String namespaceName) throws Exception {
        NamespaceDescriptor nsd = NamespaceDescriptor.create((String)namespaceName).build();
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        long procId = procExec.submitProcedure((Procedure)new CreateNamespaceProcedure((MasterProcedureEnv)procExec.getEnvironment(), nsd));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
    }

    public static void validateNamespaceNotExist(String nsName) throws IOException {
        try {
            NamespaceDescriptor nsDescriptor = UTIL.getHBaseAdmin().getNamespaceDescriptor(nsName);
            Assert.assertNull((Object)nsDescriptor);
        }
        catch (NamespaceNotFoundException namespaceNotFoundException) {
            // empty catch block
        }
    }
}

