// Autogenerated Jamon implementation
// /data/jenkins/workspace/ch-1.4.14-mapr-mep-9.4.1-fy25-q3/mapr-hbase-1.4.14/dl/mapr-hbase-1.4.14/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/regionserver/RegionListTmpl.jamon

package org.apache.hadoop.hbase.tmpl.regionserver;

// 24, 9
import java.util.*;
// 25, 9
import org.apache.commons.lang.time.FastDateFormat;
// 26, 9
import org.apache.hadoop.hbase.regionserver.HRegionServer;
// 27, 9
import org.apache.hadoop.hbase.util.Bytes;
// 28, 9
import org.apache.hadoop.hbase.HRegionInfo;
// 29, 9
import org.apache.hadoop.hbase.regionserver.Region;
// 30, 9
import org.apache.hadoop.hbase.ServerName;
// 31, 9
import org.apache.hadoop.hbase.HBaseConfiguration;
// 32, 9
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
// 33, 9
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos.ServerInfo;
// 34, 9
import org.apache.hadoop.hbase.protobuf.generated.ClusterStatusProtos.RegionLoad;
// 35, 9
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
// 36, 9
import org.apache.hadoop.hbase.regionserver.MetricsRegionWrapper;
// 37, 9
import org.apache.hadoop.util.StringUtils.TraditionalBinaryPrefix;

public class RegionListTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl.Intf

{
  private final HRegionServer regionServer;
  private final List<HRegionInfo> onlineRegions;
  protected static org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl.ImplData p_implData)
  {
    return p_implData;
  }
  public RegionListTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    regionServer = p_implData.getRegionServer();
    onlineRegions = p_implData.getOnlineRegions();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 39, 1
    if ((onlineRegions != null && onlineRegions.size() > 0) )
    {
      // 39, 60
      jamonWriter.write("\n\n    ");
      // 41, 5
      
        Collections.sort(onlineRegions);
    
      // 45, 5
      jamonWriter.write("<div class=\"tabbable\">\n        <ul class=\"nav nav-pills\">\n            <li class=\"active\"><a href=\"#tab_regionBaseInfo\" data-toggle=\"tab\">Base Info</a> </li>\n            <li><a href=\"#tab_regionRequestStats\" data-toggle=\"tab\">Request metrics</a></li>\n            <li class=\"\"><a href=\"#tab_regionStoreStats\" data-toggle=\"tab\">Storefile Metrics</a></li>\n            <li class=\"\"><a href=\"#tab_regionMemstoreStats\" data-toggle=\"tab\">Memstore Metrics</a></li>\n            <li class=\"\"><a href=\"#tab_regionCompactStats\" data-toggle=\"tab\">Compaction Metrics</a></li>\n        </ul>\n        <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n            <div class=\"tab-pane active\" id=\"tab_regionBaseInfo\">\n                ");
      // 55, 17
      {
        // 55, 17
        __jamon_innerUnit__baseInfo(jamonWriter, onlineRegions);
      }
      // 55, 63
      jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_regionRequestStats\">\n                ");
      // 58, 17
      {
        // 58, 17
        __jamon_innerUnit__requestStats(jamonWriter, onlineRegions);
      }
      // 58, 67
      jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_regionStoreStats\">\n                ");
      // 61, 17
      {
        // 61, 17
        __jamon_innerUnit__storeStats(jamonWriter, onlineRegions);
      }
      // 61, 65
      jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_regionMemstoreStats\">\n                ");
      // 64, 17
      {
        // 64, 17
        __jamon_innerUnit__memstoreStats(jamonWriter, onlineRegions);
      }
      // 64, 68
      jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_regionCompactStats\">\n                ");
      // 67, 17
      {
        // 67, 17
        __jamon_innerUnit__compactStats(jamonWriter, onlineRegions);
      }
      // 67, 67
      jamonWriter.write("\n            </div>\n        </div>\n    </div>\n    <p>Region names are made of the containing table's name, a comma,\n    the start key, a comma, and a randomly generated region id.  To illustrate,\n    the region named\n    <em>domains,apache.org,5464829424211263407</em> is party to the table\n    <em>domains</em>, has an id of <em>5464829424211263407</em> and the first key\n    in the region is <em>apache.org</em>.  The <em>hbase:meta</em> 'table' is an internal\n    system table (or a 'catalog' table in db-speak).\n    The hbase:meta table keeps a list of all regions in the system. The empty key is used to denote\n    table start and table end.  A region with an empty start key is the first region in a table.\n    If a region has both an empty start key and an empty end key, it's the only region in the\n    table. See <a href=\"http://hbase.org\">HBase Home</a> for further explication.<p>\n");
    }
    // 82, 1
    else
    {
      // 82, 8
      jamonWriter.write("\n    <p>Not serving regions</p>\n");
    }
    // 84, 7
    jamonWriter.write("\n\n");
  }
  
  
  // 86, 1
  private void __jamon_innerUnit__baseInfo(final java.io.Writer jamonWriter, final List<HRegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 90, 5
    jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <th>Region Name</th>\n            <th>Start Key</th>\n            <th>End Key</th>\n            <th>ReplicaID</th>\n        </tr>\n\n        ");
    // 98, 9
    for (HRegionInfo r: onlineRegions )
    {
      // 98, 46
      jamonWriter.write("\n        <tr>\n            <td><a href=\"region.jsp?name=");
      // 100, 42
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getEncodedName()), jamonWriter);
      // 100, 66
      jamonWriter.write("\">\n              ");
      // 101, 15
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getRegionNameAsString()), jamonWriter);
      // 101, 46
      jamonWriter.write("</a>\n            </td>\n            <td>");
      // 103, 17
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(Bytes.toStringBinary(r.getStartKey())), jamonWriter);
      // 103, 60
      jamonWriter.write("</td>\n            <td>");
      // 104, 17
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(Bytes.toStringBinary(r.getEndKey())), jamonWriter);
      // 104, 58
      jamonWriter.write("</td>\n            <td>");
      // 105, 17
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getReplicaId()), jamonWriter);
      // 105, 39
      jamonWriter.write("</td>\n        </tr>\n        ");
    }
    // 107, 16
    jamonWriter.write("\n    </table>\n");
  }
  
  
  // 141, 1
  private void __jamon_innerUnit__storeStats(final java.io.Writer jamonWriter, final List<HRegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 145, 5
    jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <th>Region Name</th>\n            <th>Num. Stores</th>\n            <th>Num. Storefiles</th>\n            <th>Storefile Size Uncompressed</th>\n            <th>Storefile Size</th>\n            <th>Index Size</th>\n            <th>Bloom Size</th>\n            <th>Data Locality</th>\n        </tr>\n\n        ");
    // 157, 9
    for (HRegionInfo r: onlineRegions )
    {
      // 157, 46
      jamonWriter.write("\n\n        <tr>\n        ");
      // 160, 9
      
            RegionLoad load = regionServer.createRegionLoad(r.getEncodedName());
        
      // 163, 13
      jamonWriter.write("<td><a href=\"region.jsp?name=");
      // 163, 42
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getEncodedName()), jamonWriter);
      // 163, 66
      jamonWriter.write("\">\n              ");
      // 164, 15
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getRegionNameAsString()), jamonWriter);
      // 164, 46
      jamonWriter.write("</a>\n            </td>\n            ");
      // 166, 13
      if (load != null )
      {
        // 166, 33
        jamonWriter.write("\n            <td>");
        // 167, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getStores()), jamonWriter);
        // 167, 39
        jamonWriter.write("</td>\n            <td>");
        // 168, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getStorefiles()), jamonWriter);
        // 168, 43
        jamonWriter.write("</td>\n            <td>");
        // 169, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(load.getStoreUncompressedSizeMB()
                * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
        // 170, 64
        jamonWriter.write("</td>\n            <td>");
        // 171, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(load.getStorefileSizeMB()
                * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
        // 172, 65
        jamonWriter.write("</td>\n            <td>");
        // 173, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(load.getTotalStaticIndexSizeKB()
                * TraditionalBinaryPrefix.KILO.value, "B", 1)), jamonWriter);
        // 174, 65
        jamonWriter.write("</td>\n            <td>");
        // 175, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(load.getTotalStaticBloomSizeKB()
                * TraditionalBinaryPrefix.KILO.value, "B", 1)), jamonWriter);
        // 176, 65
        jamonWriter.write("</td>\n            <td>");
        // 177, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getDataLocality()), jamonWriter);
        // 177, 45
        jamonWriter.write("</td>\n            ");
      }
      // 178, 19
      jamonWriter.write("\n        </tr>\n        ");
    }
    // 180, 16
    jamonWriter.write("\n    </table>\n");
  }
  
  
  // 111, 1
  private void __jamon_innerUnit__requestStats(final java.io.Writer jamonWriter, final List<HRegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 115, 5
    jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <th>Region Name</th>\n            <th>Read Request Count</th>\n            <th>Write Request Count</th>\n        </tr>\n\n        ");
    // 122, 9
    for (HRegionInfo r: onlineRegions )
    {
      // 122, 46
      jamonWriter.write("\n\n        <tr>\n        ");
      // 125, 9
      
            RegionLoad load = regionServer.createRegionLoad(r.getEncodedName());
        
      // 128, 13
      jamonWriter.write("<td><a href=\"region.jsp?name=");
      // 128, 42
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getEncodedName()), jamonWriter);
      // 128, 66
      jamonWriter.write("\">\n              ");
      // 129, 15
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getRegionNameAsString()), jamonWriter);
      // 129, 46
      jamonWriter.write("</a>\n            </td>\n            ");
      // 131, 13
      if (load != null )
      {
        // 131, 33
        jamonWriter.write("\n            <td>");
        // 132, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getReadRequestsCount()), jamonWriter);
        // 132, 50
        jamonWriter.write("</td>\n            <td>");
        // 133, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getWriteRequestsCount()), jamonWriter);
        // 133, 51
        jamonWriter.write("</td>\n            ");
      }
      // 134, 19
      jamonWriter.write("\n        </tr>\n        ");
    }
    // 136, 16
    jamonWriter.write("\n    </table>\n");
  }
  
  
  // 230, 1
  private void __jamon_innerUnit__memstoreStats(final java.io.Writer jamonWriter, final List<HRegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 234, 5
    jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <th>Region Name</th>\n            <th>Memstore Size</th>\n        </tr>\n\n        ");
    // 240, 9
    for (HRegionInfo r: onlineRegions )
    {
      // 240, 46
      jamonWriter.write("\n\n        <tr>\n        ");
      // 243, 9
      
            RegionLoad load = regionServer.createRegionLoad(r.getEncodedName());
        
      // 246, 13
      jamonWriter.write("<td><a href=\"region.jsp?name=");
      // 246, 42
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getEncodedName()), jamonWriter);
      // 246, 66
      jamonWriter.write("\">\n              ");
      // 247, 15
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getRegionNameAsString()), jamonWriter);
      // 247, 46
      jamonWriter.write("</a>\n            </td>\n            ");
      // 249, 13
      if (load != null )
      {
        // 249, 33
        jamonWriter.write("\n            <td>");
        // 250, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(
                load.getMemstoreSizeMB() * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
        // 251, 90
        jamonWriter.write("</td>\n            ");
      }
      // 252, 19
      jamonWriter.write("\n        </tr>\n        ");
    }
    // 254, 16
    jamonWriter.write("\n    </table>\n");
  }
  
  
  // 185, 1
  private void __jamon_innerUnit__compactStats(final java.io.Writer jamonWriter, final List<HRegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 189, 5
    jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <th>Region Name</th>\n            <th>Num. Compacting KVs</th>\n            <th>Num. Compacted KVs</th>\n            <th>Compaction Progress</th>\n            <th>Last Major Compaction</th>\n        </tr>\n\n        ");
    // 198, 9
    for (HRegionInfo r: onlineRegions )
    {
      // 198, 46
      jamonWriter.write("\n\n        <tr>\n        ");
      // 201, 9
      
            RegionLoad load = regionServer.createRegionLoad(r.getEncodedName());
            String percentDone = "";
            String compactTime = "";
            if  (load != null) {
              if (load.getTotalCompactingKVs() > 0) {
                percentDone = String.format("%.2f", 100 *
                    ((float) load.getCurrentCompactedKVs() / load.getTotalCompactingKVs())) + "%";
              }
              if (load.getLastMajorCompactionTs() > 0) {
                FastDateFormat fdf = FastDateFormat.getInstance("yyyy-MM-dd HH:mm ZZ");
                compactTime = fdf.format(load.getLastMajorCompactionTs());
              }
            }
        
      // 216, 13
      jamonWriter.write("<td><a href=\"region.jsp?name=");
      // 216, 42
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getEncodedName()), jamonWriter);
      // 216, 66
      jamonWriter.write("\">\n              ");
      // 217, 15
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getRegionNameAsString()), jamonWriter);
      // 217, 46
      jamonWriter.write("</a>\n            </td>\n            ");
      // 219, 13
      if (load != null )
      {
        // 219, 33
        jamonWriter.write("\n            <td>");
        // 220, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getTotalCompactingKVs()), jamonWriter);
        // 220, 51
        jamonWriter.write("</td>\n            <td>");
        // 221, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getCurrentCompactedKVs()), jamonWriter);
        // 221, 52
        jamonWriter.write("</td>\n            <td>");
        // 222, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(percentDone), jamonWriter);
        // 222, 34
        jamonWriter.write("</td>\n            <td>");
        // 223, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(compactTime), jamonWriter);
        // 223, 34
        jamonWriter.write("</td>\n            ");
      }
      // 224, 19
      jamonWriter.write("\n        </tr>\n        ");
    }
    // 226, 16
    jamonWriter.write("\n    </table>\n");
  }
  
  
}
