// Autogenerated Jamon implementation
// /data/jenkins/workspace/ch-1.4.14-mapr-mep-9.4.1-fy25-q3/mapr-hbase-1.4.14/dl/mapr-hbase-1.4.14/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/master/RegionServerListTmpl.jamon

package org.apache.hadoop.hbase.tmpl.master;

// 27, 9
import java.util.*;
// 28, 9
import org.apache.hadoop.hbase.master.HMaster;
// 29, 9
import org.apache.hadoop.hbase.ServerLoad;
// 30, 9
import org.apache.hadoop.hbase.ServerName;
// 31, 9
import org.apache.hadoop.hbase.client.HBaseAdmin;
// 32, 9
import org.apache.hadoop.hbase.client.HConnectionManager;
// 33, 9
import org.apache.hadoop.hbase.HTableDescriptor;
// 34, 9
import org.apache.hadoop.hbase.HBaseConfiguration;
// 35, 9
import org.apache.hadoop.hbase.util.VersionInfo;
// 36, 9
import org.apache.hadoop.util.StringUtils.TraditionalBinaryPrefix;

public class RegionServerListTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl.Intf

{
  private final HMaster master;
  private final List<ServerName> servers;
  protected static org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl.ImplData p_implData)
  {
    if(! p_implData.getServers__IsNotDefault())
    {
      p_implData.setServers(null);
    }
    return p_implData;
  }
  public RegionServerListTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    master = p_implData.getMaster();
    servers = p_implData.getServers();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 40, 1
    if ((servers != null && servers.size() > 0))
    {
      // 40, 47
      jamonWriter.write("\n\n");
      // 42, 1
      
ServerName [] serverNames = servers.toArray(new ServerName[servers.size()]);
Arrays.sort(serverNames);

      // 47, 1
      jamonWriter.write("<div class=\"tabbable\">\n    <ul class=\"nav nav-pills\">\n        <li class=\"active\"><a href=\"#tab_baseStats\" data-toggle=\"tab\">Base Stats</a></li>\n        <li class=\"\"><a href=\"#tab_memoryStats\" data-toggle=\"tab\">Memory</a></li>\n        <li class=\"\"><a href=\"#tab_requestStats\" data-toggle=\"tab\">Requests</a></li>\n        <li class=\"\"><a href=\"#tab_storeStats\" data-toggle=\"tab\">Storefiles</a></li>\n        <li class=\"\"><a href=\"#tab_compactStas\" data-toggle=\"tab\">Compactions</a></li>\n    </ul>\n    <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n        <div class=\"tab-pane active\" id=\"tab_baseStats\">\n            ");
      // 57, 13
      {
        // 57, 13
        __jamon_innerUnit__baseStats(jamonWriter, serverNames);
      }
      // 57, 56
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_memoryStats\">\n            ");
      // 60, 13
      {
        // 60, 13
        __jamon_innerUnit__memoryStats(jamonWriter, serverNames);
      }
      // 60, 58
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_requestStats\">\n            ");
      // 63, 13
      {
        // 63, 13
        __jamon_innerUnit__requestStats(jamonWriter, serverNames);
      }
      // 63, 59
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_storeStats\">\n            ");
      // 66, 13
      {
        // 66, 13
        __jamon_innerUnit__storeStats(jamonWriter, serverNames);
      }
      // 66, 57
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_compactStas\">\n            ");
      // 69, 13
      {
        // 69, 13
        __jamon_innerUnit__compactionStats(jamonWriter, serverNames);
      }
      // 69, 62
      jamonWriter.write("\n        </div>\n    </div>\n</div>\n\n");
    }
    // 74, 7
    jamonWriter.write("\n\n");
  }
  
  
  // 322, 1
  private void __jamon_innerUnit__serverNameLink(final java.io.Writer jamonWriter, final ServerName serverName, final ServerLoad serverLoad)
    throws java.io.IOException
  {
    // 327, 9
    
        int infoPort = master.getRegionServerInfoPort(serverName);
        String url = "//" + serverName.getHostname() + ":" + infoPort + "/rs-status";
        
    // 332, 9
    if (infoPort > 0)
    {
      // 332, 28
      jamonWriter.write("\n            <a href=\"");
      // 333, 22
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(url), jamonWriter);
      // 333, 31
      jamonWriter.write("\">");
      // 333, 33
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(serverName.getServerName()), jamonWriter);
      // 333, 65
      jamonWriter.write("</a>\n        ");
    }
    // 334, 9
    else
    {
      // 334, 16
      jamonWriter.write("\n            ");
      // 335, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(serverName.getServerName()), jamonWriter);
      // 335, 45
      jamonWriter.write("\n        ");
    }
    // 336, 15
    jamonWriter.write("\n");
  }
  
  
  // 228, 1
  private void __jamon_innerUnit__storeStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 232, 1
    jamonWriter.write("<table id=\"storeStatsTable\" class=\"tablesorter table table-striped\">\n<thead>\n<tr>\n    <th>ServerName</th>\n    <th>Num. Stores</th>\n    <th>Num. Storefiles</th>\n    <th>Storefile Size Uncompressed</th>\n    <th>Storefile Size</th>\n    <th>Index Size</th>\n    <th>Bloom Size</th>\n</tr>\n</thead>\n<tbody>\n");
    // 245, 1
    
for (ServerName serverName: serverNames) {

ServerLoad sl = master.getServerManager().getLoad(serverName);
if (sl != null) {

    // 251, 1
    jamonWriter.write("<tr>\n<td>");
    // 252, 5
    {
      // 252, 5
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName, sl);
    }
    // 252, 66
    jamonWriter.write("</td>\n<td>");
    // 253, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getStores()), jamonWriter);
    // 253, 25
    jamonWriter.write("</td>\n<td>");
    // 254, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getStorefiles()), jamonWriter);
    // 254, 29
    jamonWriter.write("</td>\n<td>");
    // 255, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(
  sl.getStoreUncompressedSizeMB() * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
    // 256, 83
    jamonWriter.write("</td>\n<td>");
    // 257, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(sl.getStorefileSizeInMB()
  * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
    // 258, 51
    jamonWriter.write("</td>\n<td>");
    // 259, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(sl.getTotalStaticIndexSizeKB()
  * TraditionalBinaryPrefix.KILO.value, "B", 1)), jamonWriter);
    // 260, 51
    jamonWriter.write("</td>\n<td>");
    // 261, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(sl.getTotalStaticBloomSizeKB()
  * TraditionalBinaryPrefix.KILO.value, "B", 1)), jamonWriter);
    // 262, 51
    jamonWriter.write("</td>\n</tr>\n");
    // 264, 1
    
        }  else {
        
    // 267, 1
    {
      // 267, 1
      __jamon_innerUnit__emptyStat(jamonWriter, serverName);
    }
    // 267, 40
    jamonWriter.write("\n");
    // 268, 1
    
    }
}

    // 272, 1
    jamonWriter.write("</tbody>\n</table>\n");
  }
  
  
  // 189, 1
  private void __jamon_innerUnit__requestStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 193, 1
    jamonWriter.write("<table id=\"requestStatsTable\" class=\"tablesorter table table-striped\">\n<thead>\n<tr>\n    <th>ServerName</th>\n    <th>Request Per Second</th>\n    <th>Read Request Count</th>\n    <th>Write Request Count</th>\n</tr>\n</thead>\n<tbody>\n");
    // 203, 1
    
for (ServerName serverName: serverNames) {

ServerLoad sl = master.getServerManager().getLoad(serverName);
if (sl != null) {

    // 209, 1
    jamonWriter.write("<tr>\n<td>");
    // 210, 5
    {
      // 210, 5
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName, sl);
    }
    // 210, 66
    jamonWriter.write("</td>\n<td>");
    // 211, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%.0f", sl.getRequestsPerSecond())), jamonWriter);
    // 211, 59
    jamonWriter.write("</td>\n<td>");
    // 212, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getReadRequestsCount()), jamonWriter);
    // 212, 36
    jamonWriter.write("</td>\n<td>");
    // 213, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getWriteRequestsCount()), jamonWriter);
    // 213, 37
    jamonWriter.write("</td>\n</tr>\n");
    // 215, 1
    
        }  else {
        
    // 218, 1
    {
      // 218, 1
      __jamon_innerUnit__emptyStat(jamonWriter, serverName);
    }
    // 218, 40
    jamonWriter.write("\n");
    // 219, 1
    
        }
}

    // 223, 1
    jamonWriter.write("</tbody>\n</table>\n");
  }
  
  
  // 145, 1
  private void __jamon_innerUnit__memoryStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 149, 1
    jamonWriter.write("<table id=\"memoryStatsTable\" class=\"tablesorter table table-striped\">\n<thead>\n<tr>\n    <th>ServerName</th>\n    <th>Used Heap</th>\n    <th>Max Heap</th>\n    <th>Memstore Size</th>\n\n</tr>\n</thead>\n<tbody>\n");
    // 160, 1
    
for (ServerName serverName: serverNames) {

    ServerLoad sl = master.getServerManager().getLoad(serverName);
    if (sl != null) {

    // 166, 1
    jamonWriter.write("<tr>\n    <td>");
    // 167, 9
    {
      // 167, 9
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName, sl);
    }
    // 167, 70
    jamonWriter.write("</td>\n    <td>");
    // 168, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(sl.getUsedHeapMB()
      * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
    // 169, 55
    jamonWriter.write("</td>\n    <td>");
    // 170, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(sl.getMaxHeapMB()
      * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
    // 171, 55
    jamonWriter.write("</td>\n    <td>");
    // 172, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(sl.getMemstoreSizeInMB()
      * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
    // 173, 55
    jamonWriter.write("</td>\n\n</tr>\n");
    // 176, 1
    
        }  else {

    // 179, 1
    {
      // 179, 1
      __jamon_innerUnit__emptyStat(jamonWriter, serverName);
    }
    // 179, 40
    jamonWriter.write("\n");
    // 180, 1
    
        }
}

    // 184, 1
    jamonWriter.write("</tbody>\n</table>\n");
  }
  
  
  // 276, 1
  private void __jamon_innerUnit__compactionStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 280, 1
    jamonWriter.write("<table id=\"compactionStatsTable\" class=\"tablesorter table table-striped\">\n<thead>\n<tr>\n    <th>ServerName</th>\n    <th>Num. Compacting KVs</th>\n    <th>Num. Compacted KVs</th>\n    <th>Remaining KVs</th>\n    <th>Compaction Progress</th>\n</tr>\n</thead>\n<tbody>\n");
    // 291, 1
    
for (ServerName serverName: serverNames) {

ServerLoad sl = master.getServerManager().getLoad(serverName);
if (sl != null) {
String percentDone = "";
if  (sl.getTotalCompactingKVs() > 0) {
     percentDone = String.format("%.2f", 100 *
        ((float) sl.getCurrentCompactedKVs() / sl.getTotalCompactingKVs())) + "%";
}

    // 302, 1
    jamonWriter.write("<tr>\n<td>");
    // 303, 5
    {
      // 303, 5
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName, sl);
    }
    // 303, 66
    jamonWriter.write("</td>\n<td>");
    // 304, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getTotalCompactingKVs()), jamonWriter);
    // 304, 37
    jamonWriter.write("</td>\n<td>");
    // 305, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getCurrentCompactedKVs()), jamonWriter);
    // 305, 38
    jamonWriter.write("</td>\n<td>");
    // 306, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getTotalCompactingKVs() - sl.getCurrentCompactedKVs()), jamonWriter);
    // 306, 67
    jamonWriter.write("</td>\n<td>");
    // 307, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(percentDone), jamonWriter);
    // 307, 22
    jamonWriter.write("</td>\n</tr>\n");
    // 309, 1
    
        }  else {
        
    // 312, 1
    {
      // 312, 1
      __jamon_innerUnit__emptyStat(jamonWriter, serverName);
    }
    // 312, 40
    jamonWriter.write("\n");
    // 313, 1
    
    }
}

    // 317, 1
    jamonWriter.write("</tbody>\n</table>\n");
  }
  
  
  // 76, 1
  private void __jamon_innerUnit__baseStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 80, 1
    jamonWriter.write("<table id=\"baseStatsTable\" class=\"tablesorter table table-striped\">\n<thead>\n<tr>\n    <th>ServerName</th>\n    <th>Start time</th>\n    <th>Last contact</th>\n    <th>Version</th>\n    <th>Requests Per Second</th>\n    <th>Num. Regions</th>\n</tr>\n</thead>\n<tbody> \n");
    // 92, 1
    
    int totalRegions = 0;
    int totalRequests = 0;
    int inconsistentNodeNum = 0;
    String masterVersion = VersionInfo.getVersion();
    for (ServerName serverName: serverNames) {

    ServerLoad sl = master.getServerManager().getLoad(serverName);
    String version = master.getRegionServerVersion(serverName);
    if (!masterVersion.equals(version)) {
        inconsistentNodeNum ++;
    }
    
    double requestsPerSecond = 0.0;
    int numRegionsOnline = 0;
    long lastContact = 0;

    if (sl != null) {
        requestsPerSecond = sl.getRequestsPerSecond();
        numRegionsOnline = sl.getNumberOfRegions();
        totalRegions += sl.getNumberOfRegions();
        // Is this correct?  Adding a rate to a measure.
        totalRequests += sl.getNumberOfRequests();
        lastContact = (System.currentTimeMillis() - sl.getReportTime())/1000;
    }
    long startcode = serverName.getStartcode();

    // 119, 1
    jamonWriter.write("<tr>\n    <td>");
    // 120, 9
    {
      // 120, 9
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName, sl);
    }
    // 120, 70
    jamonWriter.write("</td>\n    <td>");
    // 121, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(new Date(startcode)), jamonWriter);
    // 121, 34
    jamonWriter.write("</td>\n    <td>");
    // 122, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(lastContact, "s", 1)), jamonWriter);
    // 122, 71
    jamonWriter.write("</td>\n    <td>");
    // 123, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(version), jamonWriter);
    // 123, 22
    jamonWriter.write("</td>\n    <td>");
    // 124, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%.0f", requestsPerSecond)), jamonWriter);
    // 124, 55
    jamonWriter.write("</td>\n    <td>");
    // 125, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(numRegionsOnline), jamonWriter);
    // 125, 31
    jamonWriter.write("</td>\n</tr>\n");
    // 127, 1
    
}

    // 130, 1
    jamonWriter.write("</tbody> \n<tr><td>Total:");
    // 131, 15
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(servers.size()), jamonWriter);
    // 131, 35
    jamonWriter.write("</td>\n<td></td>\n<td></td>\n");
    // 134, 1
    if (inconsistentNodeNum > 0)
    {
      // 134, 31
      jamonWriter.write("\n  <td style=\"color:red;\">");
      // 135, 26
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(inconsistentNodeNum), jamonWriter);
      // 135, 51
      jamonWriter.write(" nodes with inconsistent version</td>\n");
    }
    // 136, 1
    else
    {
      // 136, 8
      jamonWriter.write("\n   <td></td>\n");
    }
    // 138, 7
    jamonWriter.write("\n<td>");
    // 139, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalRequests), jamonWriter);
    // 139, 24
    jamonWriter.write("</td>\n<td>");
    // 140, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalRegions), jamonWriter);
    // 140, 23
    jamonWriter.write("</td>\n</tr>\n</table>\n");
  }
  
  
  // 339, 1
  private void __jamon_innerUnit__emptyStat(final java.io.Writer jamonWriter, final ServerName serverName)
    throws java.io.IOException
  {
    // 343, 5
    jamonWriter.write("<tr>\n    <td>");
    // 344, 9
    {
      // 344, 9
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName, null);
    }
    // 344, 72
    jamonWriter.write("</td>\n    <td></td>\n    <td></td>\n    <td></td>\n    <td></td>\n    <td></td>\n    <td></td>\n    </tr>\n");
  }
  
  
}
