/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.IdReadWriteLock;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestIdReadWriteLock {
    private static final Log LOG = LogFactory.getLog(TestIdReadWriteLock.class);
    private static final int NUM_IDS = 16;
    private static final int NUM_THREADS = 128;
    private static final int NUM_SECONDS = 15;
    private IdReadWriteLock idLock = new IdReadWriteLock();
    private Map<Long, String> idOwner = new ConcurrentHashMap<Long, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testMultipleClients() throws Exception {
        ExecutorService exec = Executors.newFixedThreadPool(128);
        try {
            int i;
            ExecutorCompletionService<Boolean> ecs = new ExecutorCompletionService<Boolean>(exec);
            for (i = 0; i < 128; ++i) {
                ecs.submit(new IdLockTestThread("client_" + i));
            }
            for (i = 0; i < 128; ++i) {
                Future result = ecs.take();
                Assert.assertTrue((boolean)((Boolean)result.get()));
            }
            int entryPoolSize = this.idLock.purgeAndGetEntryPoolSize();
            LOG.debug((Object)("Size of entry pool after gc and purge: " + entryPoolSize));
            Assert.assertEquals((long)0L, (long)entryPoolSize);
        }
        finally {
            exec.shutdown();
            exec.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        }
    }

    private class IdLockTestThread
    implements Callable<Boolean> {
        private String clientId;

        public IdLockTestThread(String clientId) {
            this.clientId = clientId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            Thread.currentThread().setName(this.clientId);
            Random rand = new Random();
            long endTime = System.currentTimeMillis() + 15000L;
            while (System.currentTimeMillis() < endTime) {
                long id = rand.nextInt(16);
                boolean readLock = rand.nextBoolean();
                ReentrantReadWriteLock readWriteLock = TestIdReadWriteLock.this.idLock.getLock(id);
                Lock lock = readLock ? readWriteLock.readLock() : readWriteLock.writeLock();
                try {
                    lock.lock();
                    int sleepMs = 1 + rand.nextInt(4);
                    String owner = TestIdReadWriteLock.this.idOwner.get(id);
                    if (owner != null && LOG.isDebugEnabled()) {
                        LOG.debug((Object)((readLock ? "Read" : "Write") + "lock of Id " + id + " already taken by " + owner + ", we are " + this.clientId));
                    }
                    TestIdReadWriteLock.this.idOwner.put(id, this.clientId);
                    Thread.sleep(sleepMs);
                    TestIdReadWriteLock.this.idOwner.remove(id);
                    lock.unlock();
                }
                catch (Throwable throwable) {
                    lock.unlock();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Release " + (readLock ? "Read" : "Write") + " lock of Id" + id + ", we are " + this.clientId));
                    }
                    throw throwable;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Release " + (readLock ? "Read" : "Write") + " lock of Id" + id + ", we are " + this.clientId));
            }
            return true;
        }
    }
}

